/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.auditLog;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogExportState;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogFileHandler;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class NIAuditLogExportServer
implements Runnable {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$auditLog$NIAuditLogExportServer == null ? (class$com$ibm$storage$ess$ni$auditLog$NIAuditLogExportServer = NIAuditLogExportServer.class$("com.ibm.storage.ess.ni.auditLog.NIAuditLogExportServer")) : class$com$ibm$storage$ess$ni$auditLog$NIAuditLogExportServer);
    private static NIAuditLogExportServer classInstance = null;
    private static int PORT = 1755;
    private static Charset charset = Charset.forName("US-ASCII");
    private static CharsetEncoder encoder = charset.newEncoder();
    private static CharsetDecoder decoder = charset.newDecoder();
    private static ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
    Selector selector = null;
    ServerSocketChannel channel = null;
    private NIAuditLogFileHandler logFileHandler = NIAuditLogFileHandler.getInstance();
    private List keys = Collections.synchronizedList(new ArrayList());
    private Thread threadInstance = new Thread((Runnable)this, (class$com$ibm$storage$ess$ni$auditLog$NIAuditLogExportServer == null ? (class$com$ibm$storage$ess$ni$auditLog$NIAuditLogExportServer = NIAuditLogExportServer.class$("com.ibm.storage.ess.ni.auditLog.NIAuditLogExportServer")) : class$com$ibm$storage$ess$ni$auditLog$NIAuditLogExportServer).getName());
    public static final String KEY_GENERATION_ERROR = "KEY_ERROR";
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$auditLog$NIAuditLogExportServer;

    public static NIAuditLogExportServer getInstance() {
        if (classInstance == null) {
            classInstance = new NIAuditLogExportServer();
        } else if (!classInstance.isRunning()) {
            classInstance.restart();
        }
        return classInstance;
    }

    private NIAuditLogExportServer() {
        this.threadInstance.start();
    }

    public String generateKey() {
        String string;
        int n = 0;
        while (this.keys.contains(string = String.valueOf(Math.random())) || ++n > 100) {
        }
        if (n > 100) {
            string = KEY_GENERATION_ERROR;
        } else {
            this.keys.add(string);
        }
        return string;
    }

    private void addKey(String string) {
        this.keys.add(string);
    }

    private boolean isRunning() {
        return this.threadInstance.isAlive();
    }

    private void restart() {
        logger.debug_general("Restarting audit log export server");
        this.threadInstance.interrupt();
        this.keys.clear();
        this.threadInstance.start();
    }

    public void run() {
        logger.enter(this.getClass().getName(), "run");
        SelectionKey selectionKey = null;
        try {
            this.selector = SelectorProvider.provider().openSelector();
            this.channel = NIAuditLogExportServer.createServerSocketChannel(InetAddress.getLocalHost(), PORT);
            selectionKey = this.channel.register(this.selector, 16);
            boolean bl = true;
            while (bl) {
                if (this.selector.select() <= 0) continue;
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    selectionKey = iterator.next();
                    if (selectionKey.isAcceptable()) {
                        this.accept(selectionKey);
                    } else if (selectionKey.isReadable()) {
                        this.read(selectionKey);
                    } else if (selectionKey.isWritable()) {
                        this.write(selectionKey);
                    }
                    iterator.remove();
                }
            }
            this.selector.close();
            this.channel.close();
        }
        catch (IOException iOException) {
            logger.error("The audit log export server has encountered an error: " + iOException);
            logger.throwable((Throwable)iOException);
        }
        logger.enter(this.getClass().getName(), "run");
    }

    private void accept(SelectionKey selectionKey) {
        logger.enter(this.getClass().getName(), "accept");
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
        try {
            SocketChannel socketChannel = serverSocketChannel.accept();
            socketChannel.configureBlocking(false);
            SelectionKey selectionKey2 = socketChannel.register(this.selector, 1);
            selectionKey2.attach(new NIAuditLogExportState(0));
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
        logger.exit(this.getClass().getName(), "accept");
    }

    private void read(SelectionKey selectionKey) {
        block13: {
            logger.enter(this.getClass().getName(), "read");
            SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
            if (selectionKey.isValid() && socketChannel.isOpen()) {
                buffer.clear();
                NIAuditLogExportState nIAuditLogExportState = (NIAuditLogExportState)selectionKey.attachment();
                if (nIAuditLogExportState.getState() == 0) {
                    try {
                        int n = socketChannel.read(buffer);
                        buffer.flip();
                        String string = decoder.decode(buffer).toString();
                        logger.debug_detailed("Read " + n + " bytes from client, key = " + string);
                        if (this.keys.contains(string)) {
                            logger.debug_general("Key is valid, client [" + socketChannel + "] accepted");
                            this.keys.remove(string);
                            nIAuditLogExportState.setKey(string);
                            nIAuditLogExportState.setState(2);
                            selectionKey.interestOps(4);
                            break block13;
                        }
                        logger.debug_general("Key is invalid, disconnecting client [" + socketChannel + "]");
                        socketChannel.close();
                    }
                    catch (IOException iOException) {
                        try {
                            socketChannel.close();
                        }
                        catch (IOException iOException2) {}
                    }
                } else if (nIAuditLogExportState.getState() == 3) {
                    try {
                        int n = socketChannel.read(buffer);
                        buffer.flip();
                        logger.debug_detailed("Read " + n + " bytes from client, text = " + decoder.decode(buffer).toString());
                        nIAuditLogExportState.setState(4);
                        selectionKey.interestOps(4);
                    }
                    catch (IOException iOException) {
                        try {
                            socketChannel.close();
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        logger.exit(this.getClass().getName(), "read");
    }

    private void write(SelectionKey selectionKey) {
        logger.enter(this.getClass().getName(), "write");
        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
        if (selectionKey.isValid() && socketChannel.isOpen()) {
            buffer.clear();
            NIAuditLogExportState nIAuditLogExportState = (NIAuditLogExportState)selectionKey.attachment();
            if (nIAuditLogExportState.getState() == 2) {
                try {
                    encoder.encode(CharBuffer.wrap("VALIDATED"), buffer, false);
                    buffer.flip();
                    socketChannel.write(buffer);
                    nIAuditLogExportState.setState(3);
                    selectionKey.interestOps(1);
                }
                catch (IOException iOException) {
                    try {
                        socketChannel.close();
                        selectionKey.attach(null);
                    }
                    catch (IOException iOException2) {}
                }
            } else if (nIAuditLogExportState.getState() == 4) {
                try {
                    FileChannel fileChannel = nIAuditLogExportState.getFileChannel();
                    if (fileChannel == null) {
                        File file = new File(this.logFileHandler.getFilePath(), nIAuditLogExportState.getKey());
                        this.logFileHandler.compressFile(file);
                        fileChannel = new FileInputStream(file).getChannel();
                        nIAuditLogExportState.setFileChannel(fileChannel);
                        nIAuditLogExportState.setCompressedFile(file);
                        file.deleteOnExit();
                        logger.debug_detailed("Created compressed file: " + file);
                    }
                    long l = fileChannel.transferTo(fileChannel.position(), NIAuditLogExportState.CHUNK_SIZE, socketChannel);
                    fileChannel.position(fileChannel.position() + l);
                    logger.debug_detailed("--> Sending chunks of file: position: " + l + " , file position: " + fileChannel.position());
                    if (fileChannel.position() >= fileChannel.size()) {
                        fileChannel.close();
                        selectionKey.attach(null);
                        socketChannel.close();
                        nIAuditLogExportState.getCompressedFile().delete();
                    }
                }
                catch (IOException iOException) {
                    try {
                        socketChannel.close();
                        selectionKey.attach(null);
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                }
            }
        }
        logger.exit(this.getClass().getName(), "accept");
    }

    public int getPort() {
        return PORT;
    }

    private static ServerSocketChannel createServerSocketChannel(InetAddress inetAddress, int n) throws IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.configureBlocking(false);
        serverSocketChannel.socket().bind(new InetSocketAddress(inetAddress, n));
        return serverSocketChannel;
    }

    public static void main(String[] stringArray) {
        NIAuditLogExportServer nIAuditLogExportServer = NIAuditLogExportServer.getInstance();
        System.out.println("Generated key: " + nIAuditLogExportServer.generateKey());
        nIAuditLogExportServer.addKey("key");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

