/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.auditLog;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.results.auditLog.NIAuditLogEntry;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogEntryFormatter;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogEntryImpl;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogTable;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogUtil;
import com.ibm.storage.ess.ni.emailer.NIEmailerClient;
import com.ibm.storage.ess.ni.logging.NIFileHandler;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;

public class NIAuditLogFileHandler {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$auditLog$NIAuditLogProcessor == null ? (class$com$ibm$storage$ess$ni$auditLog$NIAuditLogProcessor = NIAuditLogFileHandler.class$("com.ibm.storage.ess.ni.auditLog.NIAuditLogProcessor")) : class$com$ibm$storage$ess$ni$auditLog$NIAuditLogProcessor);
    private static final String FILE_NAME = "audit.log";
    private static final String AUDIT_LOG_PROPERTY = "AuditLogFileProperty";
    private static final int DEFAULT_FILE_SIZE = 0x3200000;
    private static final String fileSeparator = "/";
    private long maxFileSize = 0x3200000L;
    private long fileSize;
    private PrintStream out = null;
    private File outputFile = null;
    private boolean configured = false;
    private String fullFileName = null;
    private String fileName = "audit.log";
    private String filePath;
    private static boolean alert60FullNotified = false;
    private static boolean alert75FullNotified = false;
    private static final double TRIM_FACTOR = 0.5;
    private NIAuditLogTable auditLogTable = NIAuditLogTable.getInstance();
    private static NIAuditLogFileHandler fileHandler = null;
    private static final int TRIM_BUFFER_SIZE = 1024;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$auditLog$NIAuditLogProcessor;

    private NIAuditLogFileHandler() {
        this.setFileName();
    }

    public static NIAuditLogFileHandler getInstance() {
        if (fileHandler == null) {
            fileHandler = new NIAuditLogFileHandler();
        }
        return fileHandler;
    }

    private void setFileName() {
        this.fullFileName = System.getProperty(AUDIT_LOG_PROPERTY);
        if (this.fullFileName != null) {
            this.fileName = this.fullFileName.substring(this.fullFileName.lastIndexOf(fileSeparator) + 1);
            this.filePath = this.fullFileName.substring(0, this.fullFileName.lastIndexOf(fileSeparator) + 1);
        } else {
            Vector vector = NIFileHandler.getHandlers();
            String string = ((NIFileHandler)((Object)vector.elementAt(0))).getFilename();
            this.filePath = string.substring(0, string.lastIndexOf(fileSeparator) + 1);
            StringBuffer stringBuffer = new StringBuffer(this.filePath);
            stringBuffer.append(this.fileName);
            this.fullFileName = stringBuffer.toString();
        }
    }

    private void configure() {
        if (this.fullFileName == null) {
            return;
        }
        try {
            this.outputFile = new File(this.fullFileName).getAbsoluteFile();
            this.fileSize = this.outputFile.length();
            File file = this.outputFile.getParentFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            this.out = new PrintStream(new FileOutputStream(this.fullFileName, true));
            this.configured = true;
        }
        catch (IOException iOException) {
            this.configured = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim(boolean bl) {
        RandomAccessFile randomAccessFile = null;
        RandomAccessFile randomAccessFile2 = null;
        byte[] byArray = new byte[1024];
        if (!this.configured) {
            this.configure();
        }
        File file = this.outputFile;
        synchronized (file) {
            this.fileSize = this.outputFile.length();
            if (bl || this.fileSize > this.maxFileSize) {
                logger.debug_general("Trimming file " + this.fileName + ", size was " + this.fileSize + " bytes");
                long l = (long)((double)(this.fileSize - this.maxFileSize) + 0.5 * (double)this.maxFileSize);
                try {
                    randomAccessFile = new RandomAccessFile(this.outputFile, "r");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.error("Error: file not found when trying to open " + this.fileName + " for reading");
                    logger.throwable((Throwable)fileNotFoundException);
                    return;
                }
                try {
                    randomAccessFile2 = new RandomAccessFile(this.outputFile, "rw");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.error("Error: file not found when trying to open " + this.fileName + " for reading");
                    logger.error("Error: this should never happen since we were just able to find it for reading");
                    logger.throwable((Throwable)fileNotFoundException);
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                        logger.error("Error: exception caught when closing the reader for " + this.fileName + " while aborting");
                        logger.throwable((Throwable)iOException);
                    }
                    return;
                }
                try {
                    randomAccessFile.seek(l);
                    int n = randomAccessFile.read(byArray, 0, 1024);
                    while (n > 0) {
                        randomAccessFile2.write(byArray, 0, n);
                        n = randomAccessFile.read(byArray, 0, 1024);
                    }
                }
                catch (IOException iOException) {
                    logger.error("Error: IOException while trimming.... file " + this.fileName + " may be inconsistent");
                    logger.throwable((Throwable)iOException);
                }
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    logger.error("Error: IOException when closing the reader for " + this.fileName);
                    logger.throwable((Throwable)iOException);
                }
                try {
                    this.fileSize = randomAccessFile2.getFilePointer();
                    randomAccessFile2.setLength(this.fileSize);
                }
                catch (IOException iOException) {
                    logger.error("Error: IOException while truncating the file " + this.fileName);
                    logger.throwable((Throwable)iOException);
                }
                try {
                    randomAccessFile2.close();
                }
                catch (IOException iOException) {
                    logger.error("Error: IOException when closing the writer for " + this.fileName);
                    logger.throwable((Throwable)iOException);
                }
                randomAccessFile = null;
                randomAccessFile2 = null;
            }
            logger.debug_general("Trimming file " + this.fileName + " completed, size reduced to " + this.fileSize + "bytes");
            this.fileSize = this.outputFile.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(String string) {
        NIAuditLogEntry nIAuditLogEntry = null;
        if (!this.configured) {
            this.configure();
        }
        File file = this.outputFile;
        synchronized (file) {
            try {
                long l = string.length();
                if (this.fileSize + l > this.maxFileSize) {
                    this.trim(true);
                    alert60FullNotified = false;
                    alert75FullNotified = false;
                    nIAuditLogEntry = this.createAlertEntry("1202");
                } else if ((double)this.fileSize > (double)this.maxFileSize * 0.75 && !alert75FullNotified) {
                    nIAuditLogEntry = this.createAlertEntry("1201");
                    alert75FullNotified = true;
                    alert60FullNotified = true;
                } else if ((double)this.fileSize > (double)this.maxFileSize * 0.6 && !alert60FullNotified) {
                    nIAuditLogEntry = this.createAlertEntry("1200");
                    alert60FullNotified = true;
                }
                this.out.println(string);
                if (nIAuditLogEntry != null) {
                    String string2 = nIAuditLogEntry.toString();
                    this.out.println(string2);
                    this.fileSize += (long)string2.length();
                    this.sendEmailAlert(nIAuditLogEntry);
                }
                this.fileSize += l;
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
            }
        }
    }

    public void output(NIAuditLogEntry nIAuditLogEntry) {
        this.output(NIAuditLogEntryFormatter.formatEntry(nIAuditLogEntry));
    }

    private NIAuditLogEntry createAlertEntry(String string) {
        NIAuditLogEntryImpl nIAuditLogEntryImpl = new NIAuditLogEntryImpl();
        nIAuditLogEntryImpl.setLogLocation(NIAuditLogUtil.getLogLocation());
        nIAuditLogEntryImpl.setStaticFields(this.auditLogTable.getEntry(string));
        return nIAuditLogEntryImpl;
    }

    private void sendEmailAlert(NIAuditLogEntry nIAuditLogEntry) {
        NIEmailerClient.getInstance().send(nIAuditLogEntry.getIDText(), "");
        logger.debug_general("NIAuditLog alert sent: " + nIAuditLogEntry.getIDText());
    }

    String getFilePath() {
        return this.filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compressFile(File file) throws IOException {
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(file));
        File file2 = this.outputFile;
        synchronized (file2) {
            int n;
            FileInputStream fileInputStream = new FileInputStream(this.outputFile);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) > 0) {
                gZIPOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            gZIPOutputStream.finish();
            gZIPOutputStream.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

