/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIArraySite;
import com.ibm.storage.ess.ni.application.resource.NIArraySiteConfiguration;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIStorageDeviceFRU;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor;
import com.ibm.storage.ess.ni.constants.NIConfigurationConstants;
import com.ibm.storage.ess.ni.constants.NIMachineTypeModel;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIArraySize;
import com.ibm.storage.ess.ni.option.config.NIArraySize4DDM;
import com.ibm.storage.ess.ni.option.config.NIArraySize8DDM;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import com.ibm.storage.ess.ni.option.config.NIRaidType10;
import com.ibm.storage.ess.ni.option.config.NIRaidType5;
import com.ibm.storage.ess.ni.resource.NIArrayImpl;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import com.ibm.storage.ess.ni.services.NIPhysicalConfigurationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class NIConfigurationAdvisorArray {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor = NIConfigurationAdvisorArray.class$("com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor);
    private NILogicalConfigurationService logicalService = null;
    private NIPhysicalConfigurationService physicalService = null;
    private NIConfigurationAdvisor advisor = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor;

    protected NIConfigurationAdvisorArray(NIConfigurationAdvisor nIConfigurationAdvisor) {
        this.advisor = nIConfigurationAdvisor;
        this.logicalService = this.advisor.getLogicalService();
        this.physicalService = this.advisor.getPhysicalService();
    }

    protected List getAvailableArraySites(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        String string = nIESSID.getType();
        List list = null;
        if (string.equals("2107")) {
            list = this.getAvailableArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, NIArraySize8DDM.Option, 0, 0);
        } else if (string.equals("1750")) {
            list = this.getAvailableArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, NIArraySize4DDM.Option, 0, 0);
        }
        return list;
    }

    protected List getAvailablePrimaryArraySites(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Vector vector = new Vector(this.getAvailableArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, NIArraySize4DDM.Option, 0, 0));
        return vector;
    }

    protected List getAvailableSecondaryArraySites(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySite nIArraySite) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Vector vector = new Vector();
        ArrayList arrayList = new ArrayList();
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(nIESSID.getType(), nIESS.getModel());
        int n = nIMachineTypeModel.getMaxDAPairs();
        List list = this.advisor.getConfigurableArraySites(nIArraySiteArray, nIStorageDeviceFRUArray);
        NIArraySite[] nIArraySiteArray2 = list.toArray(new NIArraySite[0]);
        Vector vector2 = Math.abs(nIArraySite.getDiskCapacity() - 500000) < 20000 ? this.getCompatibleArraySites(nIESSID, nIArraySiteArray2, nIArraySite.getDiskCapacity(), nIArraySite.getDiskRPM()) : this.getCompatibleArraySites(nIESSID, nIArraySiteArray2, 0, 0);
        NIArraySite[] nIArraySiteArray3 = vector2.toArray(new NIArraySite[0]);
        Hashtable hashtable = new Hashtable();
        if (nIArraySiteArray3.length > 0) {
            hashtable = this.advisor.createDAPairTableForSites(nIArraySiteArray3, n);
        }
        if (hashtable.size() > 0) {
            Integer n2 = new Integer(nIArraySite.getDeviceAdapterPair());
            vector = (Vector)hashtable.get(n2);
            NIArraySite[] nIArraySiteArray4 = vector.toArray(new NIArraySite[0]);
            arrayList = new ArrayList(this.getAvailableSecondaryArraySites(nIArraySiteArray4, nIRaidType, nIArraySite));
        }
        return arrayList;
    }

    private List getArraysOnLoopList(NIESSID nIESSID, NIArraySite nIArraySite, List list) throws NIUnavailableServerException, NIUnsupportedException, NIUnauthorizedServerException, NIServerException {
        ArrayList<NIArraySite> arrayList = new ArrayList<NIArraySite>();
        NIConfigQueryResult nIConfigQueryResult = this.physicalService.getStorageDeviceFRUs(nIESSID);
        if (nIConfigQueryResult.getCode() == 0) {
            List list2 = nIConfigQueryResult.getResourceList();
            HashMap<NIArraySiteID, NIStorageDeviceFRU> hashMap = new HashMap<NIArraySiteID, NIStorageDeviceFRU>(list2.size());
            int n = 0;
            while (n < list2.size()) {
                NIStorageDeviceFRU nIStorageDeviceFRU = (NIStorageDeviceFRU)list2.get(n);
                hashMap.put(nIStorageDeviceFRU.getArraySite(), nIStorageDeviceFRU);
                ++n;
            }
            int n2 = ((NIStorageDeviceFRU)hashMap.get((NIArraySiteID)nIArraySite.getID())).getDualLoop();
            int n3 = 0;
            while (n3 < list.size()) {
                NIArraySite nIArraySite2 = (NIArraySite)list.get(n3);
                NIArraySiteID nIArraySiteID = (NIArraySiteID)nIArraySite2.getID();
                int n4 = ((NIStorageDeviceFRU)hashMap.get(nIArraySiteID)).getDualLoop();
                if (n4 == n2) {
                    arrayList.add(nIArraySite2);
                }
                ++n3;
            }
        }
        return arrayList;
    }

    protected List getFutureArray(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, int n, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Vector vector = new Vector(this.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, NIArraySize8DDM.Option, n, n2, n3));
        return vector;
    }

    protected List getFutureArray(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySize nIArraySize, int n, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Object object;
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(nIESSID.getType(), nIESS.getModel());
        int n4 = nIMachineTypeModel.getMaxDAPairs();
        int n5 = nIMachineTypeModel.getNumDDMsPerSite();
        Vector vector = new Vector(this.advisor.getConfigurableArraySites(nIArraySiteArray, nIStorageDeviceFRUArray));
        NIArraySite[] nIArraySiteArray2 = vector.toArray(new NIArraySite[0]);
        Hashtable hashtable = new Hashtable();
        Vector vector2 = new Vector();
        if (nIArraySiteArray.length > 0) {
            vector2 = this.getCompatibleArraySites(nIESSID, nIArraySiteArray2, n2, n3);
        }
        if (vector2.size() > 0) {
            object = vector2.toArray(new NIArraySite[0]);
            hashtable = this.advisor.createDAPairTableForSites((NIArraySite[])object, n4);
        }
        object = new Vector();
        if (nIArraySize instanceof NIArraySize8DDM) {
            if (n5 == 8) {
                object = new Vector(this.getArraysToCreateUsing1Site(nIESSID, hashtable, n4, nIRaidType, n, NIArraySize8DDM.Option));
            } else if (n5 == 4) {
                object = new Vector(this.getArraysToCreateUsing2Sites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, hashtable, n4, nIRaidType, n, NIArraySize4DDM.Option));
            }
        } else if (nIArraySize instanceof NIArraySize4DDM) {
            object = new Vector(this.getArraysToCreateUsing1Site(nIESSID, hashtable, n4, nIRaidType, n, NIArraySize4DDM.Option));
        }
        return object;
    }

    protected NIArray getFutureArray(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySite nIArraySite) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIArray nIArray = this.getFutureArray(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySite, null);
        return nIArray;
    }

    protected NIArray getFutureArray(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySite nIArraySite, NIArraySite nIArraySite2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(">>>Number of sites: " + nIArraySiteArray.length);
        stringBuffer.append(">>>Number of ddms: " + nIStorageDeviceFRUArray.length);
        logger.debug_general(stringBuffer.toString());
        Vector vector = new Vector(this.advisor.getConfigurableArraySiteIDs(nIArraySiteArray, nIStorageDeviceFRUArray));
        NIArrayImpl nIArrayImpl = null;
        NIArraySiteID nIArraySiteID = (NIArraySiteID)nIArraySite.getID();
        if (nIArraySiteID.getESS().equals(nIESSID) && nIArraySite.getArraySiteStatus() == 1 && vector.contains(nIArraySiteID)) {
            if (nIArraySite2 != null) {
                NIArraySiteID nIArraySiteID2 = (NIArraySiteID)nIArraySite2.getID();
                if (nIArraySiteID2.getESS().equals(nIESSID) && nIArraySite2.getArraySiteStatus() == 1 && vector.contains(nIArraySiteID2)) {
                    NIArraySiteID[] nIArraySiteIDArray = new NIArraySiteID[]{(NIArraySiteID)nIArraySite.getID(), (NIArraySiteID)nIArraySite2.getID()};
                    nIArrayImpl = new NIArrayImpl(new NIArrayID(((NIArraySiteID)nIArraySite.getID()).getESS(), 0), null, null, nIRaidType, null, nIArraySiteIDArray, nIArraySite.getDeviceAdapterPair(), nIArraySite.getDiskCapacity(), 0, "", 0, nIArraySite.getDiskClass(), 1, 0, 0);
                }
            } else {
                nIArrayImpl = new NIArrayImpl(new NIArrayID(((NIArraySiteID)nIArraySite.getID()).getESS(), 0), null, null, nIRaidType, null, new NIArraySiteID[]{(NIArraySiteID)nIArraySite.getID()}, nIArraySite.getDeviceAdapterPair(), nIArraySite.getDiskCapacity(), 0, "", 0, nIArraySite.getDiskClass(), 1, 0, 0);
            }
        }
        return nIArrayImpl;
    }

    protected int getMaxAvailableArrays(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n3 = this.getMaxAvailableArrays(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, NIArraySize8DDM.Option, n, n2);
        return n3;
    }

    protected int getMaxAvailableArrays(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySize nIArraySize, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        Vector vector = new Vector(this.getAvailableArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, nIRaidType, nIArraySize, n, n2));
        String string = nIESSID.getType();
        int n3 = 0;
        if (nIArraySize instanceof NIArraySize8DDM && string.equals("2107") || nIArraySize instanceof NIArraySize4DDM && string.equals("1750")) {
            n3 = vector.size();
        } else if (nIArraySize instanceof NIArraySize8DDM && string.equals("1750")) {
            n3 = vector.size() / 2;
        }
        return n3;
    }

    protected int getMaxAvailableArrays(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIArraySize nIArraySize) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        String string = nIESSID.getType();
        int n = 0;
        Vector vector = new Vector(this.getAvailableArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, NIRaidType5.Option, nIArraySize, 0, 0));
        if (nIArraySize instanceof NIArraySize8DDM && string.equals("2107") || nIArraySize instanceof NIArraySize4DDM && string.equals("1750")) {
            n = vector.size();
        } else if (nIArraySize instanceof NIArraySize8DDM && string.equals("1750")) {
            n = vector.size() / 2;
        }
        int n2 = 0;
        Vector vector2 = new Vector(this.getAvailableArraySites(nIESS, nIArraySiteArray, nIStorageDeviceFRUArray, NIRaidType10.Option, nIArraySize, 0, 0));
        if (nIArraySize instanceof NIArraySize8DDM && string.equals("2107") || nIArraySize instanceof NIArraySize4DDM && string.equals("1750")) {
            n2 = vector.size();
        } else if (nIArraySize instanceof NIArraySize8DDM && string.equals("1750")) {
            n2 = vector.size() / 2;
        }
        int n3 = Math.max(n, n2);
        return n3;
    }

    protected int[] getNextArrayNumber(NIESS nIESS, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n2;
        int n3;
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(nIESSID.getType(), nIESS.getModel());
        int n4 = nIMachineTypeModel.getMaxNumArrays();
        int[] nArray = new int[]{};
        int[] nArray2 = new int[]{};
        if (n > 0) {
            nArray2 = new int[n];
        }
        int n5 = this.getMaxArrayNumber(nIESS);
        int[] nArray3 = new int[n5];
        Arrays.fill(nArray3, -1);
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.logicalService.getArrays(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            List list = nIConfigQueryResult.getResourceList();
            n3 = list.size();
            if (list != null) {
                n2 = 0;
                while (n2 < n3) {
                    int n6;
                    nArray3[n6] = n6 = ((NIArrayID)((NIArray)list.get(n2)).getID()).getArrayNumber();
                    ++n2;
                }
            }
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        int n7 = 0;
        n3 = 0;
        n2 = 0;
        while (n7 < n && n3 < n4) {
            if (nArray3[n3] == -1) {
                nArray2[n2] = n3;
                ++n2;
                ++n7;
            }
            ++n3;
        }
        if (n7 < n) {
            return nArray;
        }
        return nArray2;
    }

    protected double getTotalStorageGB(NIArray nIArray, NIExtentType nIExtentType) throws NIParameterInvalidCAException, NIUnknownCAException {
        double d = 0.0;
        int n = 0;
        long l = nIArray.getDiskCapacity();
        NIRaidType nIRaidType = nIArray.getRaidType();
        double d2 = nIExtentType instanceof NIExtentTypeFB ? 1.0 : 0.88104;
        NIESSID nIESSID = ((NIArrayID)nIArray.getID()).getESS();
        NIArraySiteConfiguration[] nIArraySiteConfigurationArray = nIArray.getArraySiteConfiguration();
        if (nIArraySiteConfigurationArray != null) {
            int n2 = nIArraySiteConfigurationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                n += this.getTotalExtents(nIESSID, nIRaidType, nIArraySiteConfigurationArray[n3], nIExtentType, l);
                ++n3;
            }
        }
        d = (double)n * d2;
        return d;
    }

    protected long getArrayExtents(NIArray nIArray, NIExtentType nIExtentType) throws NIParameterInvalidCAException, NIUnknownCAException {
        long l = 0L;
        long l2 = nIArray.getDiskCapacity();
        NIRaidType nIRaidType = nIArray.getRaidType();
        NIESSID nIESSID = ((NIArrayID)nIArray.getID()).getESS();
        NIArraySiteConfiguration[] nIArraySiteConfigurationArray = nIArray.getArraySiteConfiguration();
        if (nIArraySiteConfigurationArray != null) {
            int n = nIArraySiteConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                l += (long)this.getTotalExtents(nIESSID, nIRaidType, nIArraySiteConfigurationArray[n2], nIExtentType, l2);
                ++n2;
            }
        }
        return l;
    }

    private int getTotalExtents(NIESSID nIESSID, NIRaidType nIRaidType, NIArraySiteConfiguration nIArraySiteConfiguration, NIExtentType nIExtentType, long l) throws NIUnknownCAException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n = nIArraySiteConfiguration.getNumParity();
        n2 = nIArraySiteConfiguration.getNumSpares();
        n3 = nIArraySiteConfiguration.getNumDDMs();
        String string = nIESSID.getType();
        int n5 = 0;
        if (Math.abs(l - 73000L) < 20000L) {
            n5 = 0;
        } else if (Math.abs(l - 146000L) < 20000L) {
            n5 = 1;
        } else if (Math.abs(l - 300000L) < 20000L) {
            n5 = 2;
        } else if (Math.abs(l - 450000L) < 20000L) {
            n5 = 4;
        } else if (Math.abs(l - 500000L) < 20000L) {
            n5 = 3;
        }
        int n6 = 2;
        if (string.equals("2107") || n3 == 8) {
            if (nIRaidType instanceof NIRaidType5 && n == 1) {
                if (n2 == 1) {
                    n6 = 2;
                } else if (n2 == 0) {
                    n6 = 3;
                }
            } else if (nIRaidType instanceof NIRaidType10 && n == 0) {
                if (n2 == 2) {
                    n6 = 0;
                } else if (n2 == 0) {
                    n6 = 1;
                }
            }
        } else if (string.equals("1750")) {
            if (nIRaidType instanceof NIRaidType5 && n == 1) {
                if (n2 == 1) {
                    n6 = 4;
                } else if (n2 == 0) {
                    n6 = 5;
                }
            } else if (nIRaidType instanceof NIRaidType10) {
                if (n2 == 0) {
                    n6 = 6;
                } else if (n2 == 2) {
                    n6 = 7;
                }
            }
        }
        n4 = nIExtentType instanceof NIExtentTypeCKD ? (string.equals("2107") ? NIConfigurationConstants.EXTENTS_IN_CKD_ARRAY_2107[n5][n6] : NIConfigurationConstants.EXTENTS_IN_CKD_ARRAY_1750[n5][n6]) : (string.equals("2107") ? NIConfigurationConstants.EXTENTS_IN_FB_ARRAY_2107[n5][n6] : NIConfigurationConstants.EXTENTS_IN_FB_ARRAY_1750[n5][n6]);
        return n4;
    }

    private int getMaxArrayNumber(NIESS nIESS) {
        int n = 0;
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        String string = nIESSID.getType();
        String string2 = nIESS.getModel();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(string, string2);
        n = nIMachineTypeModel.getMaxNumSites();
        return n;
    }

    private List getArraysToCreateUsing1Site(NIESSID nIESSID, Hashtable hashtable, int n, NIRaidType nIRaidType, int n2, NIArraySize nIArraySize) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n3;
        Vector<NIArraySiteID> vector = new Vector<NIArraySiteID>();
        int n4 = 0;
        Vector<NIArrayImpl> vector2 = new Vector<NIArrayImpl>();
        if (hashtable != null && hashtable.size() > 0) {
            int n5 = 0;
            n3 = 0;
            while (n3 < n) {
                Vector vector3 = (Vector)hashtable.get(new Integer(n3));
                if (vector3.size() > n5) {
                    n5 = vector3.size();
                }
                ++n3;
            }
            int n6 = 0;
            while (n6 < n5 && n4 < n2) {
                int n7 = 0;
                while (n7 < n && n4 < n2) {
                    NIArraySite nIArraySite;
                    NIArraySiteID nIArraySiteID;
                    Vector vector4 = (Vector)hashtable.get(new Integer(n7));
                    if (vector4 != null && vector4.size() > n6 && !vector.contains(nIArraySiteID = (NIArraySiteID)(nIArraySite = (NIArraySite)vector4.elementAt(n6)).getID())) {
                        NIArrayImpl nIArrayImpl = new NIArrayImpl(new NIArrayID(((NIArraySiteID)nIArraySite.getID()).getESS(), 0), null, null, nIRaidType, null, new NIArraySiteID[]{(NIArraySiteID)nIArraySite.getID()}, nIArraySite.getDeviceAdapterPair(), 0, 0, "", 0, nIArraySite.getDiskClass(), 1, 0, 0);
                        vector2.add(nIArrayImpl);
                        vector.add(nIArraySiteID);
                        ++n4;
                    }
                    ++n7;
                }
                ++n6;
            }
        }
        if (n4 < n2) {
            vector2 = new Vector();
        }
        StringBuffer stringBuffer = new StringBuffer();
        n3 = vector2.size();
        stringBuffer.append("getArraysToCreateUsing1Site() return value: " + n3 + " arrays");
        logger.debug_general(stringBuffer.toString());
        return vector2;
    }

    private List getArraysToCreateUsing2Sites(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, Hashtable hashtable, int n, NIRaidType nIRaidType, int n2, NIArraySize nIArraySize) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n3;
        Vector<NIResourceID> vector = new Vector<NIResourceID>();
        Vector<NIResourceID> vector2 = new Vector<NIResourceID>();
        int n4 = 0;
        Vector<NIArrayImpl> vector3 = new Vector<NIArrayImpl>();
        if (hashtable != null && hashtable.size() > 0) {
            int n5 = 0;
            n3 = 0;
            while (n3 < n) {
                Vector vector4 = (Vector)hashtable.get(new Integer(n3));
                if (vector4.size() > n5) {
                    n5 = vector4.size();
                }
                ++n3;
            }
            int n6 = 0;
            while (n6 < n5 && n4 < n2) {
                int n7 = 0;
                while (n7 < n && n4 < n2) {
                    Vector vector5 = (Vector)hashtable.get(new Integer(n7));
                    if (vector5 != null && vector5.size() > n6 + 1) {
                        int n8 = vector5.size() - n6;
                        NIArraySite[] nIArraySiteArray2 = new NIArraySite[n8];
                        int n9 = 0;
                        while (n9 < n8) {
                            nIArraySiteArray2[n9] = (NIArraySite)vector5.get(n6 + n9);
                            ++n9;
                        }
                        Vector vector6 = new Vector(this.getAvailablePrimaryArraySites(nIESS, nIArraySiteArray2, nIStorageDeviceFRUArray, nIRaidType));
                        int n10 = 0;
                        while (n10 < vector6.size()) {
                            NIArraySite nIArraySite = (NIArraySite)vector6.get(n10);
                            if (!vector.contains(nIArraySite.getID()) && !vector2.contains(nIArraySite.getID())) {
                                Vector vector7 = new Vector(this.getAvailableSecondaryArraySites(nIArraySiteArray2, nIRaidType, nIArraySite));
                                int n11 = vector7.size();
                                NIArraySite nIArraySite2 = null;
                                int n12 = 0;
                                while (n12 < n11) {
                                    nIArraySite2 = (NIArraySite)vector7.get(n12);
                                    if (!vector.contains(nIArraySite2.getID()) && !vector2.contains(nIArraySite2.getID())) break;
                                    nIArraySite2 = null;
                                    ++n12;
                                }
                                if (nIArraySite2 != null) {
                                    vector.add(nIArraySite.getID());
                                    vector2.add(nIArraySite2.getID());
                                    NIArraySiteID[] nIArraySiteIDArray = new NIArraySiteID[]{(NIArraySiteID)nIArraySite.getID(), (NIArraySiteID)nIArraySite2.getID()};
                                    NIArrayImpl nIArrayImpl = new NIArrayImpl(new NIArrayID(((NIArraySiteID)nIArraySite.getID()).getESS(), 0), null, null, nIRaidType, null, nIArraySiteIDArray, nIArraySite.getDeviceAdapterPair(), 0, 0, "", 0, nIArraySite.getDiskClass(), 1, 0, 0);
                                    vector3.add(nIArrayImpl);
                                    ++n4;
                                    break;
                                }
                            }
                            ++n10;
                        }
                    }
                    ++n7;
                }
                ++n6;
            }
        }
        if (n4 < n2) {
            vector3 = new Vector();
        }
        StringBuffer stringBuffer = new StringBuffer();
        n3 = vector3.size();
        stringBuffer.append("getArraysToCreateUsing2Sites() return value: " + n3 + " arrays");
        logger.debug_general(stringBuffer.toString());
        return vector3;
    }

    private List getAvailableSecondaryArraySites(NIArraySite[] nIArraySiteArray, NIRaidType nIRaidType, NIArraySite nIArraySite) throws NIParameterInvalidCAException {
        Vector<NIArraySite> vector = new Vector<NIArraySite>();
        int n = 0;
        while (n < nIArraySiteArray.length) {
            NIArraySite nIArraySite2 = nIArraySiteArray[n];
            if (!nIArraySite2.getID().equals(nIArraySite.getID())) {
                int n2 = nIArraySite.getDiskCapacity();
                int n3 = nIArraySite.getDiskRPM();
                if (Math.abs(nIArraySite2.getDiskCapacity() - n2) < 20000 && Math.abs(nIArraySite2.getDiskRPM() - n3) < 1500 && nIArraySite.getDualLoop() == nIArraySite2.getDualLoop()) {
                    vector.add(nIArraySite2);
                }
            }
            ++n;
        }
        return vector;
    }

    private List getAvailableArraySites(NIESS nIESS, NIArraySite[] nIArraySiteArray, NIStorageDeviceFRU[] nIStorageDeviceFRUArray, NIRaidType nIRaidType, NIArraySize nIArraySize, int n, int n2) throws NIParameterInvalidCAException {
        Vector vector;
        NIArraySite[] nIArraySiteArray2;
        Hashtable hashtable;
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        String string = nIESSID.getType();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(string, nIESS.getModel());
        int n3 = nIMachineTypeModel.getMaxDAPairs();
        Vector<NIArraySite> vector2 = new Vector<NIArraySite>();
        Vector<NIResourceID> vector3 = new Vector<NIResourceID>();
        List list = this.advisor.getConfigurableArraySites(nIArraySiteArray, nIStorageDeviceFRUArray);
        NIArraySite[] nIArraySiteArray3 = list.toArray(new NIArraySite[0]);
        if ((nIRaidType instanceof NIRaidType5 || nIRaidType instanceof NIRaidType10) && (hashtable = this.advisor.createDAPairTableForSites(nIArraySiteArray2 = (vector = this.getCompatibleArraySites(nIESSID, nIArraySiteArray3, n, n2)).toArray(new NIArraySite[0]), n3)) != null && hashtable.size() > 0) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                Vector vector4 = (Vector)hashtable.get(new Integer(n5));
                if (vector4.size() > n4) {
                    n4 = vector4.size();
                }
                ++n5;
            }
            int n6 = 0;
            while (n6 < n4) {
                int n7 = 0;
                while (n7 < n3) {
                    NIArraySite nIArraySite;
                    Vector vector5 = (Vector)hashtable.get(new Integer(n7));
                    NIArraySite[] nIArraySiteArray4 = vector5.toArray(new NIArraySite[0]);
                    if (vector5 != null && vector5.size() > n6 && !vector3.contains((nIArraySite = (NIArraySite)vector5.elementAt(n6)).getID())) {
                        Vector vector6;
                        if (string.equals("2107") || string.equals("1750") && nIArraySize instanceof NIArraySize4DDM) {
                            vector2.add(nIArraySite);
                            vector3.add(nIArraySite.getID());
                        } else if (string.equals("1750") && nIArraySize instanceof NIArraySize8DDM && (vector6 = new Vector(this.getAvailableSecondaryArraySites(nIArraySiteArray4, nIRaidType, nIArraySite))).size() > 0) {
                            vector2.add(nIArraySite);
                            vector3.add(nIArraySite.getID());
                        }
                    }
                    ++n7;
                }
                ++n6;
            }
        }
        return vector2;
    }

    private Vector getCompatibleArraySites(NIESSID nIESSID, NIArraySite[] nIArraySiteArray, int n, int n2) throws NIParameterInvalidCAException {
        Serializable serializable;
        Vector<NIArraySite> vector = new Vector<NIArraySite>();
        int n3 = 0;
        while (n3 < nIArraySiteArray.length) {
            NIArraySite nIArraySite = nIArraySiteArray[n3];
            if (!((NIArraySiteID)nIArraySite.getID()).getESS().equals(nIESSID)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("EssIDs don't match");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException(nIESSID, "EssIDs don't match");
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < nIArraySiteArray.length) {
            serializable = nIArraySiteArray[n4];
            if (n != 0 && n2 != 0) {
                if (Math.abs(serializable.getDiskCapacity() - n) < 20000 && Math.abs(serializable.getDiskRPM() - n2) < 1500) {
                    vector.add(nIArraySiteArray[n4]);
                }
            } else {
                vector.add(nIArraySiteArray[n4]);
            }
            ++n4;
        }
        serializable = new StringBuffer();
        int n5 = vector.size();
        ((StringBuffer)serializable).append("getCompatibleSites() return value: " + n5 + " sites");
        logger.debug_general(((StringBuffer)serializable).toString());
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

