/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIArraySite;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIExtentAvailabilityResult;
import com.ibm.storage.ess.ni.ca.NIAvailableSite;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorArray;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorExtentPool;
import com.ibm.storage.ess.ni.ca.NIExpressArray;
import com.ibm.storage.ess.ni.ca.NIExtentPoolData;
import com.ibm.storage.ess.ni.constants.NIConfigurationConstants;
import com.ibm.storage.ess.ni.constants.NIMachineTypeModel;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import com.ibm.storage.ess.ni.option.config.NIRaidType10;
import com.ibm.storage.ess.ni.option.config.NIRaidType5;
import com.ibm.storage.ess.ni.resource.NIExtentPoolImpl;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class NIConfigurationAdvisorExpressCommon {
    private NIConfigurationAdvisor ca = null;
    private NIConfigurationAdvisorExtentPool epca = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor = NIConfigurationAdvisorExpressCommon.class$("com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor);
    public static final int UNDEFINED_POOL_NUMBER = -1;
    private NILogicalConfigurationService logicalService = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor;

    protected NIConfigurationAdvisorExpressCommon(NIConfigurationAdvisor nIConfigurationAdvisor) {
        this.ca = nIConfigurationAdvisor;
        this.epca = new NIConfigurationAdvisorExtentPool(nIConfigurationAdvisor);
        this.logicalService = this.ca.getLogicalService();
    }

    protected double getExpressTotalAvailableCapacityGB(NIESS nIESS, NIRaidType nIRaidType, NIExtentType nIExtentType) throws NIUnavailableServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException, NIServerException {
        double d = 0.0;
        double d2 = 0.0;
        if (nIESS == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIESS is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESS, "Null Parameter");
        }
        if (nIExtentType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIExtentType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentType, "Null Parameter");
        }
        if (nIRaidType == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NIRaidType is null.  Throwing invalid parameter exception.");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIRaidType, "Null Parameter");
        }
        try {
            d = this.ca.getAvailableStorageGBForFutureExtentPool(nIESS, nIExtentType, nIRaidType, true);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(exception.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException();
        }
        NIConfigQueryResult nIConfigQueryResult = null;
        List list = null;
        try {
            nIConfigQueryResult = this.logicalService.getExtentPools((NIESSID)nIESS.getID());
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        if (list != null) {
            long l = 0L;
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                NIExtentPool nIExtentPool = (NIExtentPool)list.get(n2);
                NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
                List list2 = this.ca.getRaidTypesInExtentPool(nIExtentPoolID);
                NIRaidType nIRaidType2 = null;
                if (list2.size() > 0) {
                    nIRaidType2 = (NIRaidType)list2.get(0);
                }
                if (nIExtentPool.getExtentType().equals(nIExtentType) && list2.size() == 1 && nIRaidType2.equals(nIRaidType)) {
                    NIExtentAvailabilityResult nIExtentAvailabilityResult = this.logicalService.queryExtentAvailability(nIExtentPoolID);
                    boolean bl = false;
                    if (nIExtentAvailabilityResult.getCode() != 0) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Query Failure queryExtentAvailability " + nIExtentAvailabilityResult.getCode());
                        logger.debug_general(stringBuffer.toString());
                        throw new NIQueryFailureCAException(stringBuffer.toString());
                    }
                    if (nIExtentAvailabilityResult.getNumAvailableExtents() > 0) {
                        l += (long)nIExtentAvailabilityResult.getNumAvailableExtents();
                    }
                }
                ++n2;
            }
            d2 = this.ca.convertExtentsToBinaryGB(l, nIExtentType);
        }
        logger.debug_general("Available storage in future extent pools: " + d + " GB");
        logger.debug_general("Available storage in existing extent pools: " + d2 + " GB");
        return d + d2;
    }

    /*
     * Unable to fully structure code
     */
    protected List getExpressExtentPools(NIESS var1_1, NIRaidType var2_2, NIExtentType var3_3, double var4_4) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        block16: {
            var6_5 = (NIESSID)var1_1.getID();
            var7_6 = new Vector<Comparable<StringBuffer>>();
            var8_7 = this.ca.convertBinaryGBToExtents(var4_4, var3_3);
            var10_8 = 0L;
            var12_9 = null;
            try {
                var12_9 = this.getExtentPoolDataFromFutureExtent(var1_1, var3_3, var2_2, var8_7);
                break block16;
            }
            catch (Exception var13_10) {
                NIConfigurationAdvisorExpressCommon.logger.debug_general(var13_10.toString());
                var14_12 = 0;
                ** while (var14_12 < var13_10.getStackTrace().length)
            }
lbl-1000:
            // 1 sources

            {
                NIConfigurationAdvisorExpressCommon.logger.debug_detailed(var13_10.getStackTrace()[var14_12].toString());
                ++var14_12;
                continue;
            }
        }
        var13_11 = 0;
        while (var12_9 != null && var13_11 < var12_9.length) {
            var7_6.add(var12_9[var13_11]);
            var10_8 += var12_9[var13_11].getNumExtents();
            ++var13_11;
        }
        if (var8_7 > var10_8) {
            var14_13 = var8_7 - var10_8;
            var16_14 = null;
            var17_15 = null;
            try {
                var16_14 = this.logicalService.getExtentPools(var6_5);
            }
            catch (NullPointerException var18_16) {
                var19_19 = new StringBuffer();
                var19_19.append(var18_16.toString());
                NIConfigurationAdvisorExpressCommon.logger.debug_general(var19_19.toString());
                throw new NIUnknownCAException(var18_16.toString());
            }
            if (var16_14.getCode() == 0 && var16_14.getResourceList() != null) {
                var17_15 = var16_14.getResourceList();
            } else if (var16_14.getCode() != 0) {
                var18_17 = new StringBuffer();
                var18_17.append("Query Failure");
                NIConfigurationAdvisorExpressCommon.logger.debug_general(var18_17.toString());
                throw new NIQueryFailureCAException("Query Failure");
            }
            if (var17_15 != null) {
                var18_18 = 0L;
                var20_20 = var17_15.size();
                var21_21 = 0;
                while (var21_21 < var20_20) {
                    var22_22 = (NIExtentPool)var17_15.get(var21_21);
                    var23_23 = (NIExtentPoolID)var22_22.getID();
                    var24_24 = this.ca.getRaidTypesInExtentPool(var23_23);
                    var25_25 = null;
                    if (var24_24.size() > 0) {
                        var25_25 = (NIRaidType)var24_24.get(0);
                    }
                    if (var22_22.getExtentType().equals(var3_3) && var24_24.size() == 1 && var25_25.equals(var2_2)) {
                        var26_26 = this.logicalService.queryExtentAvailability(var23_23);
                        var27_27 = false;
                        if (var26_26.getCode() != 0) {
                            var28_28 = new StringBuffer();
                            var28_28.append("Query Failure queryExtentAvailability " + var26_26.getCode());
                            NIConfigurationAdvisorExpressCommon.logger.debug_general(var28_28.toString());
                            throw new NIQueryFailureCAException(var28_28.toString());
                        }
                        if (var26_26.getNumAvailableExtents() > 0) {
                            var28_28 = new NIExtentPoolData(var22_22, var2_2);
                            var28_28.setExisting(true);
                            var28_28.setNumExtents(var26_26.getNumAvailableExtents());
                            var18_18 += (long)var26_26.getNumAvailableExtents();
                            var7_6.add(var28_28);
                        }
                        if (var18_18 >= var14_13) break;
                    }
                    ++var21_21;
                }
            }
        }
        return var7_6;
    }

    private NIExtentPoolData[] getExtentPoolDataFromFutureExtent(NIESS nIESS, NIExtentType nIExtentType, NIRaidType nIRaidType, long l) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n;
        Object object;
        int n2;
        int n3;
        Cloneable cloneable;
        logger.debug_general("Entering getExtentPoolDataFromFutureExtent()");
        int n4 = NILogicalConfigurationService.LSS_GROUPS.length;
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        NIConfigurationAdvisorArray nIConfigurationAdvisorArray = new NIConfigurationAdvisorArray(this.ca);
        NIExtentPool[] nIExtentPoolArray = new NIExtentPool[n4];
        int n5 = this.determineBestServer((NIESSID)nIESS.getID());
        int n6 = 0;
        while (n6 < n4) {
            int n7 = (n6 + n5) % n4;
            if (this.getNumAvailAddrs((NIESSID)nIESS.getID(), nIExtentType, n7) <= 0) {
                n7 = (n7 + 1) % n4;
            }
            nIExtentPoolArray[n6] = this.getFutureExtentPool(nIESS, n7, "ExpressPool", nIExtentType);
            ++n6;
        }
        NIArraySite[] nIArraySiteArray = this.ca.getImageArraySites(nIESSID);
        NIArray[] nIArrayArray = this.ca.getImageArrays(nIESSID);
        List list = this.getRanksForExtentPool(nIESS, nIExtentPoolArray, nIExtentType, nIRaidType, l, nIConfigurationAdvisorArray);
        long l2 = 0L;
        long[] lArray = new long[n4];
        Arrays.fill(lArray, 0L);
        int n8 = list.size();
        int n9 = 0;
        while (n9 < n8) {
            NIRank nIRank = (NIRank)list.get(n9);
            NIArrayID[] nIArrayIDArray = nIRank.getArrayIDs();
            cloneable = new Vector();
            int n10 = 0;
            while (n10 < nIArrayIDArray.length) {
                n3 = 0;
                while (n3 < nIArrayArray.length) {
                    NIArrayID nIArrayID = (NIArrayID)nIArrayArray[n3].getID();
                    if (nIArrayID.equals(nIArrayIDArray[n10])) {
                        ((Vector)cloneable).add(nIArrayArray[n3]);
                        break;
                    }
                    ++n3;
                }
                ++n10;
            }
            n3 = ((Vector)cloneable).size();
            int n11 = 0;
            while (n11 < n3) {
                NIArray nIArray = (NIArray)((Vector)cloneable).get(n11);
                long l3 = nIConfigurationAdvisorArray.getArrayExtents(nIArray, nIExtentType);
                l2 += l3;
                int n12 = (n9 + 1) % n4;
                lArray[n12] = lArray[n12] + l3;
                ++n11;
            }
            ++n9;
        }
        long l4 = l - l2;
        cloneable = new HashMap();
        List list2 = new Vector();
        if (l4 > 0L) {
            int n13;
            NIAvailableSite[] nIAvailableSiteArray;
            n3 = this.ca.convertExtentsToIntBinaryGB(l4, nIExtentType);
            NIExtentPoolID nIExtentPoolID = new NIExtentPoolID((NIESSID)nIESS.getID(), -1);
            list2 = this.ca.getFutureArraysForExtentPool(nIESS, nIExtentPoolID, nIExtentType, nIRaidType, false, n3, l4, false, true);
            int n14 = list2.size();
            ArrayList<NIAvailableSite> arrayList = new ArrayList<NIAvailableSite>();
            n2 = 0;
            while (n2 < n14) {
                nIAvailableSiteArray = (NIAvailableSite[])list2.get(n2);
                object = nIAvailableSiteArray.getArraySites();
                Vector vector = new Vector();
                n13 = 0;
                while (n13 < ((Object)object).length) {
                    int n15 = 0;
                    while (n15 < nIArraySiteArray.length) {
                        NIArraySiteID nIArraySiteID = (NIArraySiteID)nIArraySiteArray[n15].getID();
                        if (nIArraySiteID.equals(object[n13])) {
                            arrayList.add(new NIAvailableSite(nIArraySiteArray[n15]));
                            break;
                        }
                        ++n15;
                    }
                    ++n13;
                }
                ++n2;
            }
            nIAvailableSiteArray = arrayList.toArray(new NIAvailableSite[0]);
            object = new NIMachineTypeModel(nIESSID.getType(), nIESS.getModel());
            n = ((NIMachineTypeModel)object).getMaxDAPairs();
            nIAvailableSiteArray = this.epca.getFutureArrayCapacities(nIESSID, nIRaidType, nIExtentType, nIAvailableSiteArray, nIArrayArray, n);
            n13 = 0;
            while (n13 < nIAvailableSiteArray.length) {
                l2 += (long)nIAvailableSiteArray[n13].getEffectiveCapacity();
                ((HashMap)cloneable).put((NIArraySiteID)nIAvailableSiteArray[n13].getID(), new Integer(nIAvailableSiteArray[n13].getEffectiveCapacity()));
                ++n13;
            }
        }
        int[] nArray = new int[n4];
        NIExtentPoolData[] nIExtentPoolDataArray = new NIExtentPoolData[n4];
        int n16 = 0;
        while (n16 < nIExtentPoolArray.length && nIExtentPoolArray[n16] != null) {
            nIExtentPoolDataArray[n16] = new NIExtentPoolData(nIExtentPoolArray[n16], nIRaidType);
            nIExtentPoolDataArray[n16].setExisting(false);
            nIExtentPoolDataArray[n16].setFutureArraysForExtentPoolData(new ArrayList());
            nIExtentPoolDataArray[n16].setFutureRanksForExtentPoolData(new ArrayList());
            nArray[n16] = 0;
            ++n16;
        }
        int n17 = list2.size();
        n = 0;
        while (n < n17) {
            object = (NIArraySiteID[])list2.get(n);
            NIExpressArray nIExpressArray = new NIExpressArray((NIArray)object);
            n2 = 0;
            while (n2 < object.getArraySites().length) {
                int n18 = n % 2;
                nArray[n18] = nArray[n18] + (Integer)((HashMap)cloneable).get(object.getArraySites()[n2]);
                nIExpressArray.setEffectiveCapacity(nIExpressArray.getEffectiveCapacity() + (Integer)((HashMap)cloneable).get(object.getArraySites()[n2]));
                ++n2;
            }
            nIExtentPoolDataArray[n % 2].getFutureArraysForExtentPoolData().add(nIExpressArray);
            ++n;
        }
        int n19 = 0;
        while (n19 < n8) {
            nIExtentPoolDataArray[(n19 + 1) % 2].getFutureRanksForExtentPoolData().add(list.get(n19));
            ++n19;
        }
        ArrayList<NIExtentPoolData> arrayList = new ArrayList<NIExtentPoolData>();
        int n20 = 0;
        while (n20 < nIExtentPoolArray.length) {
            int n21 = n20;
            nArray[n21] = (int)((long)nArray[n21] + lArray[n20]);
            nIExtentPoolDataArray[n20].setNumExtents(nArray[n20]);
            logger.debug_general(">>>Future ExtentPool: " + nIExtentPoolDataArray[n20].toString());
            if (nIExtentPoolDataArray[n20].getNumExtents() > 0L) {
                arrayList.add(nIExtentPoolDataArray[n20]);
            } else {
                logger.debug_general(">>>Previous future pool NOT added because it is not needed");
            }
            ++n20;
        }
        logger.debug_general("Exiting getExtentPoolDataFromFutureExtent()");
        return arrayList.toArray(new NIExtentPoolData[0]);
    }

    protected List getExpressUpdatedVolumes(NIVolume[] nIVolumeArray, NIExtentPoolData nIExtentPoolData, NIExtentPoolID nIExtentPoolID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIVolume nIVolume;
        int n;
        int n2;
        Vector<NIVolume> vector;
        NIExtentPoolID nIExtentPoolID2 = nIExtentPoolData.getExtentPoolID();
        Vector<NIVolumeID> vector2 = new Vector<NIVolumeID>();
        if (nIExtentPoolID2.equals(nIExtentPoolID)) {
            vector = new Vector(nIExtentPoolData.getFutureVolumesForExtentPoolData());
            n2 = vector.size();
            n = 0;
            while (n < n2) {
                nIVolume = (NIVolume)vector.get(n);
                vector2.add((NIVolumeID)nIVolume.getID());
                ++n;
            }
        }
        vector = new Vector<NIVolume>();
        if (vector2.size() > 0) {
            n2 = nIVolumeArray.length;
            n = 0;
            while (n < n2) {
                nIVolume = nIVolumeArray[n];
                NIVolumeID nIVolumeID = (NIVolumeID)nIVolume.getID();
                if (vector2.contains(nIVolumeID)) {
                    vector.add(nIVolume);
                }
                ++n;
            }
        }
        return vector;
    }

    protected NIExtentPool getExpressFutureExtentPool(NIESSID nIESSID, NIExtentPoolData nIExtentPoolData) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException, NIParameterInvalidCAException {
        NIExtentPool nIExtentPool = nIExtentPoolData.getExtentPool();
        NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)nIExtentPool.getID();
        boolean bl = false;
        if (nIESSID.equals(nIExtentPoolID.getESS())) {
            bl = true;
        }
        NIExtentPool nIExtentPool2 = null;
        if (bl) {
            nIExtentPool2 = nIExtentPool;
        }
        return nIExtentPool2;
    }

    private int determineBestServer(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int[] nArray = new int[]{0, 0};
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        NIRank[] nIRankArray = this.ca.getImageRanks(nIESSID);
        n = 0;
        while (n < nIRankArray.length) {
            n3 = nIRankArray[n].getRankGroup();
            if (n3 != -1) {
                int n4 = n3;
                nArray[n4] = (int)((long)nArray[n4] + nIRankArray[n].getNumExtents());
            }
            ++n;
        }
        if (nArray[1] < nArray[0]) {
            n2 = 1;
        }
        return n2;
    }

    private int getNumAvailAddrs(NIESSID nIESSID, NIExtentType nIExtentType, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        int n2;
        int[] nArray = new int[2];
        int n3 = NILogicalConfigurationService.LSS_GROUPS.length;
        NILogicalConfigurationService nILogicalConfigurationService = this.ca.getLogicalService();
        Arrays.fill(nArray, 0);
        try {
            List list = this.getResources(nILogicalConfigurationService.getLogicalSubsystems(nIESSID));
            int n4 = list.size();
            int n5 = 0;
            while (n5 < n4) {
                NILSS nILSS = (NILSS)list.get(n5);
                NILSSID nILSSID = (NILSSID)nILSS.getID();
                if (nILSSID.getLSSNumber() % n3 == n) {
                    int n6 = nILSSID.getLSSNumber() / 16;
                    if (nILSS.getDeviceType() instanceof NIDeviceTypeCKD && nIExtentType instanceof NIExtentTypeCKD || nILSS.getDeviceType() instanceof NIDeviceTypeFB && nIExtentType instanceof NIExtentTypeFB) {
                        int n7 = n6;
                        nArray[n7] = nArray[n7] + this.getResources(nILogicalConfigurationService.getVolumes(nILSSID)).size();
                    } else {
                        int n8 = n6;
                        nArray[n8] = nArray[n8] + 256;
                    }
                }
                ++n5;
            }
            n2 = 0;
            int n9 = NIConfigurationConstants.MAX_VOLUMES_PER_ESS_1750 / 2 / NILogicalConfigurationService.LSS_GROUPS.length;
            n5 = 0;
            while (n5 < nArray.length) {
                n2 += n9 - nArray[n5];
                ++n5;
            }
        }
        catch (Exception exception) {
            logger.debug_general(exception.toString());
            throw new NIUnknownCAException(exception.toString());
        }
        return n2;
    }

    private List getResources(NIConfigQueryResult nIConfigQueryResult) throws NIQueryFailureCAException {
        List list = null;
        if (nIConfigQueryResult.getCode() == 0) {
            list = nIConfigQueryResult == null || nIConfigQueryResult.getResourceList() == null ? new ArrayList() : nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            logger.debug_general("Query Failure");
            logger.debug_general("Return code is " + Long.toHexString(nIConfigQueryResult.getCode()));
            throw new NIQueryFailureCAException("Query Failure");
        }
        return list;
    }

    private NIExtentPool getFutureExtentPool(NIESS nIESS, int n, String string, NIExtentType nIExtentType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        int n2 = this.getNextExtentPoolNumber(nIESS, n);
        NIExtentPoolImpl nIExtentPoolImpl = new NIExtentPoolImpl(new NIExtentPoolID(nIESSID, n2), n, nIExtentType, string + n2, 0, 0, 0L, false, 1.0f, 0.0f, 0);
        return nIExtentPoolImpl;
    }

    private int getNextExtentPoolNumber(NIESS nIESS, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n2;
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(nIESSID.getType(), nIESS.getModel());
        int n3 = nIMachineTypeModel.getMaxNumExtPools();
        int n4 = -1;
        int[] nArray = new int[n3];
        Arrays.fill(nArray, -1);
        List list = null;
        NIConfigQueryResult nIConfigQueryResult = this.logicalService.getExtentPools(nIESSID);
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        int n5 = 0;
        while (n5 < list.size()) {
            nArray[n2] = n2 = ((NIExtentPoolID)((NIExtentPool)list.get(n5)).getID()).getExtentPoolNumber();
            ++n5;
        }
        n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == -1) {
                boolean bl;
                boolean bl2 = bl = n2 % 2 == 0;
                if (n == 0 && bl) {
                    n4 = n2;
                    break;
                }
                if (n == 1 && !bl) {
                    n4 = n2;
                    break;
                }
            }
            ++n2;
        }
        return n4;
    }

    private List getRanksForExtentPool(NIESS nIESS, NIExtentPool[] nIExtentPoolArray, NIExtentType nIExtentType, NIRaidType nIRaidType, long l, NIConfigurationAdvisorArray nIConfigurationAdvisorArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Hashtable hashtable;
        long l2;
        Serializable serializable;
        NIExtentPoolID[] nIExtentPoolIDArray;
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(nIESSID.getType(), nIESS.getModel());
        int n = nIMachineTypeModel.getMaxDAPairs();
        long l3 = 0L;
        Vector vector = new Vector();
        Vector<Serializable> vector2 = new Vector<Serializable>();
        if (nIExtentPoolArray == null) {
            nIExtentPoolIDArray = new NIExtentPoolID[]{null};
        } else {
            nIExtentPoolIDArray = new NIExtentPoolID[nIExtentPoolArray.length];
            int n2 = 0;
            while (n2 < nIExtentPoolArray.length) {
                nIExtentPoolIDArray[n2] = (NIExtentPoolID)nIExtentPoolArray[n2].getID();
                ++n2;
            }
        }
        Vector vector3 = new Vector();
        NIArray[] nIArrayArray = this.ca.getImageArrays(nIESSID);
        NIRank[] nIRankArray = this.ca.getImageRanks(nIESSID);
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this.ca);
        List list = nIConfigurationAdvisorExtentPool.getExistingRanksForExtentPool(nIESS, null, nIExtentType, nIRaidType, l, nIArrayArray, nIRankArray, true);
        int n3 = list.size();
        long l4 = 0L;
        int n4 = 0;
        while (n4 < n3) {
            serializable = (NIRank)list.get(n4);
            l2 = serializable.getNumExtents();
            l4 += l2;
            l3 += l2;
            vector2.add(serializable);
            ++n4;
        }
        serializable = new StringBuffer();
        ((StringBuffer)serializable).append("getRanksForExtentPool() total capacity of existing ranks: " + l4 + " extents");
        logger.debug_general(((StringBuffer)serializable).toString());
        l2 = 0L;
        if (l3 < l && (hashtable = nIConfigurationAdvisorExtentPool.createDAPairTableForArrays(nIArrayArray, n)) != null && hashtable.size() > 0) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < n) {
                Vector vector4 = (Vector)hashtable.get(new Integer(n6));
                if (vector4.size() > n5) {
                    n5 = vector4.size();
                }
                ++n6;
            }
            int n7 = 0;
            while (n7 < n5 && l3 < l) {
                int n8 = 0;
                while (n8 < n && l3 < l) {
                    Vector vector5 = (Vector)hashtable.get(new Integer(n8));
                    if (vector5 != null && vector5.size() > n7) {
                        NIArray nIArray = (NIArray)vector5.elementAt(n7);
                        NIArrayID nIArrayID = (NIArrayID)nIArray.getID();
                        if (nIArray.getArrayStatus() == 1 && nIArray.getRaidType().equals(nIRaidType) && !vector3.contains(nIArrayID)) {
                            long l5 = nIConfigurationAdvisorArray.getArrayExtents(nIArray, nIExtentType);
                            l2 += l5;
                            l3 += l5;
                            NIRank nIRank = this.ca.getFutureRank(nIESSID, nIArray, nIExtentType, null);
                            vector2.add(nIRank);
                        }
                    }
                    ++n8;
                }
                ++n7;
            }
        }
        serializable = new StringBuffer();
        ((StringBuffer)serializable).append("getRanksForExtentPool() total capacity of existing unassigned arrays: " + l2 + " extents");
        logger.debug_general(((StringBuffer)serializable).toString());
        return vector2;
    }

    protected int getArrayCapacity(NIArray nIArray, String string, NIExtentType nIExtentType, boolean bl) {
        int n;
        long l = nIArray.getDiskCapacity();
        NIRaidType nIRaidType = nIArray.getRaidType();
        int n2 = 0;
        int n3 = 0;
        while (n3 < nIArray.getArraySites().length) {
            List list = null;
            try {
                list = this.logicalService.getArraySites(nIArray.getArraySites()).getResourceList();
            }
            catch (NIUnavailableServerException nIUnavailableServerException) {
                logger.debug_general("WARNING: returning 0 exception getting arraysites");
                nIUnavailableServerException.printStackTrace();
                return 0;
            }
            catch (NIUnsupportedException nIUnsupportedException) {
                logger.debug_general("WARNING: returning 0 exception getting arraysites");
                nIUnsupportedException.printStackTrace();
                return 0;
            }
            catch (NIUnauthorizedServerException nIUnauthorizedServerException) {
                logger.debug_general("WARNING: returning 0 exception getting arraysites");
                nIUnauthorizedServerException.printStackTrace();
                return 0;
            }
            catch (NIServerException nIServerException) {
                logger.debug_general("WARNING: returning 0 exception getting arraysites");
                nIServerException.printStackTrace();
                return 0;
            }
            if (list != null) {
                n = 0;
                while (n < list.size()) {
                    n2 += ((NIArraySite)list.get(n)).getRequiredSpares();
                    ++n;
                }
            } else {
                logger.debug_general("WARNING: returning 0 no array sites found");
                return 0;
            }
            ++n3;
        }
        int n4 = 0;
        if (Math.abs(l - 73000L) < 20000L) {
            n4 = 0;
        } else if (Math.abs(l - 146000L) < 20000L) {
            n4 = 1;
        } else if (Math.abs(l - 300000L) < 20000L) {
            n4 = 2;
        } else if (Math.abs(l - 450000L) < 20000L) {
            n4 = 4;
        } else if (Math.abs(l - 500000L) < 20000L) {
            n4 = 3;
        }
        n = 2;
        if (string.equals("2107") || bl) {
            if (nIRaidType instanceof NIRaidType5) {
                if (n2 == 1) {
                    n = 2;
                } else if (n2 == 0) {
                    n = 3;
                }
            } else if (nIRaidType instanceof NIRaidType10) {
                if (n2 == 2) {
                    n = 0;
                } else if (n2 == 0) {
                    n = 1;
                }
            }
        } else if (string.equals("1750")) {
            if (nIRaidType instanceof NIRaidType5) {
                if (n2 == 1) {
                    n = 4;
                } else if (n2 == 0) {
                    n = 5;
                }
            } else if (nIRaidType instanceof NIRaidType10) {
                if (n2 == 0) {
                    n = 6;
                } else if (n2 == 2) {
                    n = 7;
                }
            }
        }
        int n5 = nIExtentType instanceof NIExtentTypeCKD ? (string.equals("2107") ? NIConfigurationConstants.EXTENTS_IN_CKD_ARRAY_2107[n4][n] : NIConfigurationConstants.EXTENTS_IN_CKD_ARRAY_1750[n4][n]) : (string.equals("2107") ? NIConfigurationConstants.EXTENTS_IN_FB_ARRAY_2107[n4][n] : NIConfigurationConstants.EXTENTS_IN_FB_ARRAY_1750[n4][n]);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("diskCapacity: " + l + ", raidType: " + nIRaidType.toString() + ", numSpares: " + n2 + ", machineType: " + string + ", extentType: " + nIExtentType + ", 8-DDM: " + bl + ", extents: " + n5);
        logger.debug_general(stringBuffer.toString());
        return n5;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

