/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroup;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.ca.NIAvailableLSS;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorExpressCommon;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorExtentPool;
import com.ibm.storage.ess.ni.ca.NIExpressArray;
import com.ibm.storage.ess.ni.ca.NIExtentPoolData;
import com.ibm.storage.ess.ni.ca.NIHostType;
import com.ibm.storage.ess.ni.constants.NIConfigurationConstants;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize141GB;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize17GB;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize282GB;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize35GB;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize72GB;
import com.ibm.storage.ess.ni.option.config.NIAs400VolumeSize8GB;
import com.ibm.storage.ess.ni.option.config.NIDataType;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock512;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Protected;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Unprotected;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.option.config.NIFBVolumeType;
import com.ibm.storage.ess.ni.option.config.NIFBVolumeTypeAS400Protected;
import com.ibm.storage.ess.ni.option.config.NIFBVolumeTypeAS400Unprotected;
import com.ibm.storage.ess.ni.option.config.NIFBVolumeTypeStandard2107;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockBase;
import com.ibm.storage.ess.ni.resource.NIVolumeImpl;
import com.ibm.storage.ess.ni.services.NIDomainService;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class NIConfigurationAdvisorExpressOpenSystemVolumes {
    private NILogicalConfigurationService logicalService = null;
    private NIDomainService domainService = null;
    private NIConfigurationAdvisor ca = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor = NIConfigurationAdvisorExpressOpenSystemVolumes.class$("com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor);
    private static final int CKD_ADDR_GROUP = 0;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor;

    protected NIConfigurationAdvisorExpressOpenSystemVolumes(NIConfigurationAdvisor nIConfigurationAdvisor) {
        this.ca = nIConfigurationAdvisor;
        this.logicalService = this.ca.getLogicalService();
        this.domainService = this.ca.getDomainService();
    }

    protected int getExpressMaxVolumeQuantity(NIExtentPoolData[] nIExtentPoolDataArray, double d, long l) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        int n = 0;
        long l2 = this.ca.convertBlocksToExtents(l);
        long l3 = this.ca.convertBinaryGBToExtents(d, NIExtentTypeFB.Option);
        int n2 = (int)(l3 / l2);
        NIESSID nIESSID = ((NIExtentPoolID)nIExtentPoolDataArray[0].getExtentPool().getID()).getESS();
        NIAvailableLSS[] nIAvailableLSSArray = this.getFutureFBLSS(nIESSID);
        int[] nArray = new int[]{this.getMaxAvailableFBVolume(nIAvailableLSSArray, 0), this.getMaxAvailableFBVolume(nIAvailableLSSArray, 1)};
        int n3 = nIExtentPoolDataArray.length;
        int n4 = 0;
        while (n4 < n3) {
            NIExtentPoolData nIExtentPoolData = nIExtentPoolDataArray[n4];
            NIExtentPool nIExtentPool = nIExtentPoolData.getExtentPool();
            int n5 = nIExtentPoolData.getRankGroup();
            long l4 = nIExtentPoolData.getNumExtents() / l2;
            if (l4 > (long)nArray[n5]) {
                l4 = nArray[n5];
            }
            int n6 = n5;
            nArray[n6] = (int)((long)nArray[n6] - l4);
            n = (int)((long)n + l4);
            ++n4;
        }
        if (n > n2 && n2 > 0) {
            n = n2;
        }
        return n;
    }

    private NIAvailableLSS[] getFutureFBLSS(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.logicalService.getLogicalSubsystems(nIESSID, NIDeviceTypeFB.Option);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        List list = null;
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        NILSS[] nILSSArray = list.toArray(new NILSS[0]);
        boolean[] blArray = new boolean[32];
        int n = 0;
        while (n < nILSSArray.length) {
            int n2 = ((NILSSID)nILSSArray[n].getID()).getLSSNumber();
            if (n2 < 16) {
                blArray[n2] = true;
            } else if (!blArray[n2]) {
                if (nILSSArray[n].getDeviceType() instanceof NIDeviceTypeCKD) {
                    int n3 = n2 / 16;
                    int n4 = n3 *= 16;
                    while (n4 < 16) {
                        blArray[n4] = true;
                        ++n4;
                    }
                } else {
                    blArray[n2] = true;
                }
            }
            ++n;
        }
        Vector<NIAvailableLSS> vector = new Vector<NIAvailableLSS>();
        Vector<NIAvailableLSS> vector2 = new Vector<NIAvailableLSS>();
        n = 0;
        while (n < blArray.length) {
            if (!blArray[n]) {
                if (n / 16 == 0) {
                    vector2.add(new NIAvailableLSS(n));
                } else {
                    vector.add(new NIAvailableLSS(n));
                }
            }
            ++n;
        }
        vector.addAll(vector2);
        if (vector.size() > 0) {
            Collections.sort(vector, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n = 0;
                    NIAvailableLSS nIAvailableLSS = (NIAvailableLSS)object;
                    NIAvailableLSS nIAvailableLSS2 = (NIAvailableLSS)object2;
                    int n2 = nIAvailableLSS.getLssAddress();
                    int n3 = nIAvailableLSS2.getLssAddress();
                    if (n2 < 16) {
                        n2 += 256;
                    }
                    if (n3 < 16) {
                        n3 += 256;
                    }
                    n = n2 - n3;
                    return n;
                }
            });
        }
        NIAvailableLSS[] nIAvailableLSSArray = vector.toArray(new NIAvailableLSS[0]);
        return nIAvailableLSSArray;
    }

    protected int getExpressMaxAs400VolumeQuantity(NIExtentPoolData[] nIExtentPoolDataArray, double d, NIAs400VolumeSize nIAs400VolumeSize) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        long l = nIAs400VolumeSize.getStorageBlock();
        if (l < NIAs400VolumeSize8GB.Option.getStorageBlock()) {
            l = NIAs400VolumeSize8GB.Option.getStorageBlock();
        }
        int n = this.getExpressMaxVolumeQuantity(nIExtentPoolDataArray, d, l);
        return n;
    }

    protected long getExpressMaxVolumeCapacity(NIExtentPoolData[] nIExtentPoolDataArray, double d, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n2;
        if (nIExtentPoolDataArray.length < 1 || nIExtentPoolDataArray[0] == null) {
            return 0L;
        }
        if (n < 1) {
            n = 1;
        }
        int[] nArray = new int[2];
        Arrays.fill(nArray, 0);
        long l = 0L;
        int n3 = 0;
        while (n3 < nIExtentPoolDataArray.length) {
            if (nIExtentPoolDataArray[n3].isExisting()) {
                int n4 = nIExtentPoolDataArray[n3].getRankGroup();
                nArray[n4] = nArray[n4] + nIExtentPoolDataArray[n3].getExtentPool().getNumVolumes();
                try {
                    l += (long)this.logicalService.queryExtentAvailability(nIExtentPoolDataArray[n3].getExtentPoolID()).getNumAvailableExtents();
                }
                catch (Exception exception) {
                    logger.debug_general("Warning: Existing extents willl not be considered");
                }
            } else {
                l += nIExtentPoolDataArray[n3].getNumExtents();
            }
            ++n3;
        }
        if (l == 0L) {
            return 0L;
        }
        double d2 = (double)nIExtentPoolDataArray[0].getNumExtents() / (double)l;
        int n5 = (int)Math.round(d2 * (double)n);
        int n6 = (int)Math.round((1.0 - d2) * (double)n);
        if (n5 > 4096 - nArray[0]) {
            n2 = n5 - (4096 - nArray[0]);
            n5 = 4096;
            n6 += n2;
        } else if (n6 > 4096 - nArray[1]) {
            n2 = n6 - (4096 - nArray[1]);
            n6 = 4096;
            n5 += n2;
        }
        if (d > (double)l) {
            d = l;
        }
        long l2 = (long)(d2 * d);
        long l3 = (long)((1.0 - d2) * d);
        int n7 = n5 != 0 && n6 != 0 ? Math.min((int)(l2 / (long)n5), (int)(l3 / (long)n6)) : (n5 != 0 ? (int)(l2 / (long)n5) : (n6 != 0 ? (int)(l3 / (long)n6) : 0));
        long l4 = (long)n7 * 16384L * 128L;
        if (l4 > 0x100000000L) {
            l4 = 0x100000000L;
        }
        return l4;
    }

    protected int getExpressTotalStorageGB(NIExtentPoolData[] nIExtentPoolDataArray, int n, int n2) throws NIParameterInvalidCAException {
        int n3 = n * n2;
        return n3;
    }

    protected int getExpressTotalStorageGB(NIExtentPoolData[] nIExtentPoolDataArray, int n, NIAs400VolumeSize nIAs400VolumeSize) throws NIParameterInvalidCAException {
        long l = nIAs400VolumeSize.getStorageBlock();
        long l2 = this.ca.convertBlocksToExtents(l);
        long l3 = (long)n * l2;
        int n2 = this.ca.convertExtentsToIntBinaryGB(l3, NIExtentTypeFB.Option);
        return n2;
    }

    protected List getExpressFutureVolumes(NIESSID nIESSID, NIFBVolumeType nIFBVolumeType, NIExtentPoolData[] nIExtentPoolDataArray, int n, long l, NIAs400VolumeSize nIAs400VolumeSize, boolean bl, String string, String string2, boolean bl2, boolean bl3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Object object;
        Object object2;
        int n2;
        int n3;
        NIExtentPoolData nIExtentPoolData;
        int n4;
        int n5 = NILogicalConfigurationService.LSS_GROUPS.length;
        NIExtentPoolData[] nIExtentPoolDataArray2 = new NIExtentPoolData[n5];
        StringBuffer stringBuffer = new StringBuffer();
        NIAvailableLSS[] nIAvailableLSSArray = this.getFutureFBLSS(nIESSID);
        Vector vector = new Vector();
        int n6 = 0;
        try {
            n4 = bl3 ? Integer.parseInt(string2) : Integer.parseInt(string2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            n4 = Integer.MIN_VALUE;
        }
        int n7 = 0;
        int n8 = 0;
        while (n8 < nIExtentPoolDataArray.length && n7 < n5) {
            nIExtentPoolData = nIExtentPoolDataArray[n8];
            if (nIExtentPoolDataArray2[nIExtentPoolData.getRankGroup()] == null && !nIExtentPoolData.isExisting()) {
                nIExtentPoolDataArray2[nIExtentPoolData.getRankGroup()] = nIExtentPoolData;
                ++n7;
            }
            ++n8;
        }
        Vector<NIExtentPoolData> vector2 = new Vector<NIExtentPoolData>();
        int n9 = 0;
        while (n9 < nIExtentPoolDataArray2.length) {
            if (nIExtentPoolDataArray2[n9] != null) {
                vector2.add(nIExtentPoolDataArray2[n9]);
            }
            ++n9;
        }
        Collections.sort(vector2, new Comparator(){

            public int compare(Object object, Object object2) {
                long l = ((NIExtentPoolData)object).getNumExtents() - ((NIExtentPoolData)object2).getNumExtents();
                if (l > 0L) {
                    return 1;
                }
                if (l < 0L) {
                    return -1;
                }
                return 0;
            }
        });
        Vector<NIExtentPoolData> vector3 = new Vector<NIExtentPoolData>();
        int n10 = 0;
        while (n10 < nIExtentPoolDataArray.length) {
            if (nIExtentPoolDataArray[n10].isExisting()) {
                vector3.add(nIExtentPoolDataArray[n10]);
            }
            ++n10;
        }
        nIExtentPoolDataArray2 = vector2.toArray(nIExtentPoolDataArray2);
        List list = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while (n13 < nIExtentPoolDataArray2.length) {
            nIExtentPoolData = nIExtentPoolDataArray2[n13];
            if (nIExtentPoolData != null) {
                n3 = n - n6;
                int n14 = n3 / (n7 - n13);
                n14 += n3 % (n7 - n13);
                if (bl && n4 > Integer.MIN_VALUE) {
                    n2 = n4 + n6;
                    object2 = this.ca.padding(n2, string2.length(), bl3);
                    list = this.getFutureVolumes(nIESSID, nIFBVolumeType, nIExtentPoolData, nIAvailableLSSArray, n14, l, nIAs400VolumeSize, bl, string, (String)object2, bl2, bl3);
                    vector.addAll(list);
                    nIExtentPoolData.setFutureVolumesForExtentPoolData(list);
                    if (nIExtentPoolData.getRankGroup() == 0) {
                        n11 += list.size();
                    } else {
                        n12 += list.size();
                    }
                } else {
                    list = this.getFutureVolumes(nIESSID, nIFBVolumeType, nIExtentPoolData, nIAvailableLSSArray, n14, l, nIAs400VolumeSize, bl, string, string2, bl2, bl3);
                    vector.addAll(list);
                    nIExtentPoolData.setFutureVolumesForExtentPoolData(list);
                    if (nIExtentPoolData.getRankGroup() == 0) {
                        n11 += list.size();
                    } else {
                        n12 += list.size();
                    }
                }
                n6 += list.size();
            }
            ++n13;
        }
        n3 = 0;
        while (n3 < vector3.size() && n > n6) {
            nIExtentPoolData = (NIExtentPoolData)vector3.get(n3);
            if (nIExtentPoolData != null) {
                n2 = n - n6;
                if (bl && n4 > Integer.MIN_VALUE) {
                    int n15 = n4 + n6;
                    object = this.ca.padding(n15, string2.length(), bl3);
                    list = this.getFutureVolumes(nIESSID, nIFBVolumeType, nIExtentPoolData, nIAvailableLSSArray, n2, l, nIAs400VolumeSize, bl, string, (String)object, bl2, bl3, nIExtentPoolData.getRankGroup() == 0 ? n11 : n12);
                    vector.addAll(list);
                    nIExtentPoolData.setFutureVolumesForExtentPoolData(list);
                    if (nIExtentPoolData.getRankGroup() == 0) {
                        n11 += list.size();
                    } else {
                        n12 += list.size();
                    }
                } else {
                    list = this.getFutureVolumes(nIESSID, nIFBVolumeType, nIExtentPoolData, nIAvailableLSSArray, n2, l, nIAs400VolumeSize, bl, string, string2, bl2, bl3, nIExtentPoolData.getRankGroup() == 0 ? n11 : n12);
                    vector.addAll(list);
                    nIExtentPoolData.setFutureVolumesForExtentPoolData(list);
                    if (nIExtentPoolData.getRankGroup() == 0) {
                        n11 += list.size();
                    } else {
                        n12 += list.size();
                    }
                }
                n6 += list.size();
            }
            ++n3;
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append(" Number of future volumes: " + vector.size());
        logger.debug_general(stringBuffer.toString());
        n2 = 0;
        while (n2 < vector.size()) {
            stringBuffer = new StringBuffer();
            object2 = (NIVolume)vector.get(n2);
            stringBuffer.append("Future Volume: " + object2.getID().toString());
            object = object2.getExtentPool();
            if (object != null) {
                stringBuffer.append(">>>ExtentPool ID: " + ((NIExtentPoolID)object).toString());
            } else {
                stringBuffer.append(">>>ExtentPool ID: NULL");
            }
            NIESSID nIESSID2 = ((NIExtentPoolID)object).getESS();
            if (nIESSID2 != null) {
                stringBuffer.append(">>>ESS ID: " + nIESSID2.toString());
            } else {
                stringBuffer.append(">>>ESS ID: NULL");
            }
            logger.debug_general(stringBuffer.toString());
            ++n2;
        }
        return vector;
    }

    private Vector generateVolumeNicknames(String string, String string2, int n) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        Vector<String> vector = new Vector<String>(n);
        int n3 = 0;
        while (n3 < n) {
            String string3 = string + this.ca.padding(n2, string2.length());
            ++n2;
            vector.add(n3, string3);
            ++n3;
        }
        return vector;
    }

    protected List getExpressAs400VolumeSizeList(NIExtentPoolData[] nIExtentPoolDataArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        List list = null;
        int n = nIExtentPoolDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            NIExtentPoolData nIExtentPoolData = nIExtentPoolDataArray[n2];
            if (n2 == 0) {
                list = this.getAs400VolumeSizeList(nIExtentPoolData);
            } else {
                List list2 = this.getAs400VolumeSizeList(nIExtentPoolData);
                if (list2.size() < list.size()) {
                    list = list2;
                }
            }
            ++n2;
        }
        return list;
    }

    protected NIVolumeGroup getExpressFutureVolumeGroup(NIESSID nIESSID, String string, NIHostType nIHostType, NIVolume[] nIVolumeArray) throws NIParameterInvalidCAException {
        NIHostType[] nIHostTypeArray = new NIHostType[]{nIHostType};
        NIVolumeGroup nIVolumeGroup = this.ca.getFutureVolumeGroup(nIESSID, string, nIHostTypeArray, null, nIVolumeArray);
        return nIVolumeGroup;
    }

    protected List getExpressUpdatedExtentPools(NIExtentPoolData[] nIExtentPoolDataArray, NIVolume[] nIVolumeArray) throws NIParameterInvalidCAException {
        Vector<NIExtentPoolData> vector = new Vector<NIExtentPoolData>();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        List list = new Vector();
        Vector vector4 = new Vector();
        Vector<NIResourceID> vector5 = new Vector<NIResourceID>();
        NIESS nIESS = null;
        long l = 0L;
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this.ca);
        try {
            nIESS = (NIESS)this.domainService.getESSs(new NIESSID[]{nIExtentPoolDataArray[0].getExtentPoolID().getESS()}).getResourceList().get(0);
            list = this.logicalService.getRanks(nIExtentPoolDataArray[0].getExtentPoolID().getESS()).getResourceList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = 0;
        while (n < list.size()) {
            vector5.add(((NIRank)list.get(n)).getID());
            ++n;
        }
        int n2 = 0;
        while (n2 < nIExtentPoolDataArray.length) {
            NIExtentPoolData nIExtentPoolData = nIExtentPoolDataArray[n2];
            long l2 = !nIExtentPoolDataArray[n2].isExisting() ? nIExtentPoolData.getNumVolumeExtents() : 0L;
            long l3 = 0L;
            Vector<Serializable> vector6 = new Vector<Serializable>();
            Vector<Serializable> vector7 = new Vector<Serializable>();
            Vector<Serializable> vector8 = new Vector<Serializable>();
            Vector vector9 = new Vector();
            if (l2 > 0L) {
                Serializable serializable;
                int n3;
                if (l2 > l3) {
                    n3 = 0;
                    while (n3 < nIExtentPoolData.getFutureArraysForExtentPoolData().size()) {
                        serializable = (NIExpressArray)nIExtentPoolData.getFutureArraysForExtentPoolData().get(n3);
                        logger.debug_general("Array:" + ((NIExpressArray)serializable).getArray().toString() + "  Extents:" + ((NIExpressArray)serializable).getEffectiveCapacity());
                        vector7.add(serializable);
                        if (l2 <= (l3 += (long)((NIExpressArray)serializable).getEffectiveCapacity())) break;
                        ++n3;
                    }
                }
                if (l2 > l3) {
                    n3 = 0;
                    while (n3 < nIExtentPoolData.getFutureRanksForExtentPoolData().size()) {
                        serializable = (NIRank)nIExtentPoolData.getFutureRanksForExtentPoolData().get(n3);
                        List list2 = null;
                        try {
                            list2 = this.logicalService.getArrays(serializable.getArrayIDs()).getResourceList();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        int n4 = 0;
                        while (n4 < list2.size()) {
                            NIArray nIArray = (NIArray)list2.get(n4);
                            NIConfigurationAdvisorExpressCommon nIConfigurationAdvisorExpressCommon = new NIConfigurationAdvisorExpressCommon(this.ca);
                            l3 += (long)nIConfigurationAdvisorExpressCommon.getArrayCapacity(nIArray, "1750", nIExtentPoolData.getExtentPool().getExtentType(), false);
                            ++n4;
                        }
                        if (vector5.contains(serializable.getID())) {
                            vector8.add(serializable);
                        } else {
                            vector6.add(serializable);
                        }
                        if (l2 <= l3) break;
                        ++n3;
                    }
                }
                nIExtentPoolData.setExistingRanks(vector8);
                nIExtentPoolData.setFutureRanksForExtentPoolData(vector6);
                nIExtentPoolData.setFutureArraysForExtentPoolData(vector7);
            }
            if (nIExtentPoolData.getNumVolumeExtents() != 0L) {
                vector.add(nIExtentPoolData);
            }
            ++n2;
        }
        int n5 = 0;
        while (n5 < vector.size()) {
            NIExtentPoolData nIExtentPoolData = (NIExtentPoolData)vector.get(n5);
            logger.debug_general("Pool[" + n5 + "] " + "existingRanks:" + nIExtentPoolData.getExistingRanks().size() + " futureRanks:" + nIExtentPoolData.getFutureRanksForExtentPoolData().size() + " futureArrays:" + nIExtentPoolData.getFutureArraysForExtentPoolData().size());
            ++n5;
        }
        return vector;
    }

    private List getAs400VolumeSizeList(NIExtentPoolData nIExtentPoolData) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Vector vector = new Vector();
        Vector<NIAs400VolumeSize> vector2 = new Vector<NIAs400VolumeSize>();
        NIAs400VolumeSize[] nIAs400VolumeSizeArray = new NIAs400VolumeSize[]{NIAs400VolumeSize8GB.Option, NIAs400VolumeSize17GB.Option, NIAs400VolumeSize35GB.Option, NIAs400VolumeSize72GB.Option, NIAs400VolumeSize141GB.Option, NIAs400VolumeSize282GB.Option};
        double d = this.ca.convertExtentsToBinaryGB(nIExtentPoolData.getNumExtents(), NIExtentTypeFB.Option);
        int n = nIAs400VolumeSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!(d >= nIAs400VolumeSizeArray[n2].getStorageBinaryGB())) break;
            vector2.add(nIAs400VolumeSizeArray[n2]);
            ++n2;
        }
        if (vector2.size() == 0) {
            return vector;
        }
        return vector2;
    }

    private int getMaxFBVolumeQuantity(NIESSID nIESSID, NIExtentPoolData nIExtentPoolData, NIAvailableLSS[] nIAvailableLSSArray, long l) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        long l2;
        int n;
        long l3 = this.ca.convertBlocksToExtents(l);
        int n2 = 0;
        String string = nIESSID.getType();
        n2 = NIConfigurationConstants.MAX_VOLUMES_PER_ESS_1750;
        int n3 = nIExtentPoolData.getRankGroup();
        int n4 = this.getMaxAvailableFBVolume(nIAvailableLSSArray, n3);
        int n5 = Math.min(n4, n = (int)((l2 = nIExtentPoolData.getNumExtents()) / l3));
        if (n5 > 0) {
            n5 = Math.min(n5, n2);
        }
        return n5;
    }

    private int getMaxAvailableFBVolume(NIAvailableLSS[] nIAvailableLSSArray, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < nIAvailableLSSArray.length) {
            NIAvailableLSS nIAvailableLSS = nIAvailableLSSArray[n3];
            int n4 = nIAvailableLSS.getLssAddress();
            if (n4 % 2 == 0 && n == 0 || n4 % 2 == 1 && n == 1) {
                n2 += nIAvailableLSS.getNumberOfAvailableDevices();
            }
            ++n3;
        }
        return n2;
    }

    private List getFutureVolumes(NIESSID nIESSID, NIFBVolumeType nIFBVolumeType, NIExtentPoolData nIExtentPoolData, NIAvailableLSS[] nIAvailableLSSArray, int n, long l, NIAs400VolumeSize nIAs400VolumeSize, boolean bl, String string, String string2, boolean bl2, boolean bl3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        return this.getFutureVolumes(nIESSID, nIFBVolumeType, nIExtentPoolData, nIAvailableLSSArray, n, l, nIAs400VolumeSize, bl, string, string2, bl2, bl3, 0);
    }

    private List getFutureVolumes(NIESSID nIESSID, NIFBVolumeType nIFBVolumeType, NIExtentPoolData nIExtentPoolData, NIAvailableLSS[] nIAvailableLSSArray, int n, long l, NIAs400VolumeSize nIAs400VolumeSize, boolean bl, String string, String string2, boolean bl2, boolean bl3, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n3;
        int n4 = 0;
        int n5 = -1;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector vector2 = new Vector();
        boolean bl4 = false;
        int n6 = 0;
        NIDataType nIDataType = null;
        int n7 = 1;
        int n8 = nIExtentPoolData.getRankGroup();
        ArrayList arrayList = new ArrayList();
        Vector vector3 = new Vector();
        NIVolumeTypeFixedBlockBase nIVolumeTypeFixedBlockBase = NIVolumeTypeFixedBlockBase.Option;
        if (nIFBVolumeType instanceof NIFBVolumeTypeAS400Protected || nIFBVolumeType instanceof NIFBVolumeTypeAS400Unprotected) {
            l = nIAs400VolumeSize.getStorageBlock();
            n7 = this.getMTMValue(nIFBVolumeType, nIAs400VolumeSize);
        }
        if ((n3 = this.getMaxFBVolumeQuantity(nIESSID, nIExtentPoolData, nIAvailableLSSArray, l)) == 0) {
            nIExtentPoolData.setNumVolumeExtents(0L);
            return vector2;
        }
        if (n3 < n) {
            n = n3;
        }
        long l2 = this.ca.convertBlocksToExtents(l);
        if (bl && string2 != null && !string2.equals("")) {
            int n9 = n6 = bl3 ? Integer.parseInt(string2) : Integer.parseInt(string2, 16);
        }
        if (bl2) {
            arrayList = this.getVolumeNames(nIESSID);
        }
        if (nIFBVolumeType instanceof NIFBVolumeTypeStandard2107) {
            nIDataType = NIDataTypeBlock512.Option;
        } else if (nIFBVolumeType instanceof NIFBVolumeTypeAS400Protected) {
            nIDataType = NIDataTypeBlock520Protected.Option;
        } else if (nIFBVolumeType instanceof NIFBVolumeTypeAS400Unprotected) {
            nIDataType = NIDataTypeBlock520Unprotected.Option;
        }
        boolean bl5 = false;
        NILSSID nILSSID = null;
        boolean bl6 = false;
        int n10 = 0;
        while (n10 < nIAvailableLSSArray.length && n4 < n) {
            NIAvailableLSS nIAvailableLSS = nIAvailableLSSArray[n10];
            int n11 = nIAvailableLSS.getLssAddress();
            if (!(n11 % 2 == 0 && n8 == 1 || n11 % 2 == 1 && n8 == 0)) {
                int n12 = nIAvailableLSS.getNumberOfAvailableDevices() - n2;
                nILSSID = new NILSSID(nIESSID, n11, -1);
                int n13 = 0;
                while (n13 < n12 && n4 < n) {
                    Serializable serializable;
                    n5 = n13 + n2;
                    String string3 = new String();
                    if (bl) {
                        if (string2 != null && !string2.equals("")) {
                            string3 = string + this.ca.padding(n6, string2.length(), bl3);
                            ++n6;
                        } else {
                            string3 = string;
                        }
                        if (bl2 && arrayList.contains(string3)) {
                            serializable = new StringBuffer();
                            serializable = new StringBuffer();
                            ((StringBuffer)serializable).append("Volume Nickname is not unique");
                            logger.debug_general(((StringBuffer)serializable).toString());
                            throw new NIParameterInvalidCAException((Object)string3, "Volume Nickname is not unique");
                        }
                    }
                    serializable = new NIVolumeImpl(new NIVolumeID(nILSSID, n5), string3, null, null, null, nIExtentPoolData.getExtentPoolID(), false, nIVolumeTypeFixedBlockBase, nIDataType, l, n7, 0, 0, 0);
                    vector.add(serializable);
                    ++n4;
                    ++n13;
                }
            }
            ++n10;
        }
        long l3 = (long)vector.size() * l2;
        nIExtentPoolData.setNumVolumeExtents(l3);
        return vector;
    }

    private int getMTMValue(NIFBVolumeType nIFBVolumeType, NIAs400VolumeSize nIAs400VolumeSize) {
        int n = 1;
        if (nIFBVolumeType instanceof NIFBVolumeTypeAS400Protected) {
            n = nIAs400VolumeSize.getMTMProtectedValue();
        } else if (nIFBVolumeType instanceof NIFBVolumeTypeAS400Unprotected) {
            n = nIAs400VolumeSize.getMTMUnprotectedValue();
        }
        return n;
    }

    private ArrayList getVolumeNames(NIESSID nIESSID) throws NIQueryFailureCAException {
        int n;
        ArrayList<String> arrayList;
        ArrayList arrayList2;
        block9: {
            arrayList2 = new ArrayList();
            NIConfigQueryResult nIConfigQueryResult = null;
            NIConfigQueryResult nIConfigQueryResult2 = null;
            try {
                nIConfigQueryResult = this.logicalService.getLogicalSubsystems(nIESSID);
                if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
                    arrayList = nIConfigQueryResult.getResourceList();
                    arrayList2 = new ArrayList();
                    n = arrayList.size();
                    int n2 = 0;
                    while (n2 < n) {
                        block8: {
                            NILSS nILSS = (NILSS)arrayList.get(n2);
                            try {
                                Object object;
                                nIConfigQueryResult2 = this.logicalService.getVolumes((NILSSID)nILSS.getID());
                                if (nIConfigQueryResult2.getCode() == 0 && nIConfigQueryResult2.getResourceList() != null) {
                                    object = nIConfigQueryResult2.getResourceList();
                                    arrayList2.addAll(object);
                                    break block8;
                                }
                                object = new StringBuffer();
                                ((StringBuffer)object).append("Query Failure");
                                logger.debug_general(((StringBuffer)object).toString());
                                throw new NIQueryFailureCAException();
                            }
                            catch (Exception exception) {
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append(exception.toString());
                                logger.debug_general(stringBuffer.toString());
                                throw new NIQueryFailureCAException();
                            }
                        }
                        ++n2;
                    }
                    break block9;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Query Failure");
                logger.debug_general(stringBuffer.toString());
                throw new NIQueryFailureCAException();
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(exception.toString());
                logger.debug_general(stringBuffer.toString());
                throw new NIQueryFailureCAException();
            }
        }
        arrayList = new ArrayList<String>();
        n = 0;
        while (n < arrayList2.size()) {
            NIVolume nIVolume = (NIVolume)arrayList2.get(n);
            arrayList.add(nIVolume.getUserName());
            ++n;
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

