/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIExtentUsageResult;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor;
import com.ibm.storage.ess.ni.ca.NIRankClientData;
import com.ibm.storage.ess.ni.constants.NIMachineTypeModel;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class NIConfigurationAdvisorRank {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor = NIConfigurationAdvisorRank.class$("com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor);
    private NIConfigurationAdvisor ca = null;
    private NILogicalConfigurationService logicalService = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor;

    protected NIConfigurationAdvisorRank(NIConfigurationAdvisor nIConfigurationAdvisor) {
        this.ca = nIConfigurationAdvisor;
        this.logicalService = this.ca.getLogicalService();
    }

    protected double getTotalStorageGB(NIRank nIRank) throws NIParameterInvalidCAException {
        double d = 0.0;
        long l = nIRank.getNumExtents();
        double d2 = 0.0;
        NIExtentType nIExtentType = nIRank.getExtentType();
        if (nIExtentType instanceof NIExtentTypeCKD) {
            d2 = 0.88104;
        } else if (nIExtentType instanceof NIExtentTypeFB) {
            d2 = 1.0;
        }
        d = (double)l * d2;
        return d;
    }

    protected NIRank getFutureRank(NIESSID nIESSID, NIArray nIArray, NIExtentType nIExtentType, NIExtentPool nIExtentPool) throws NIParameterInvalidCAException {
        NIArrayID[] nIArrayIDArray = new NIArrayID[]{(NIArrayID)nIArray.getID()};
        NIRank nIRank = null;
        if (nIArray.getArrayStatus() == 1) {
            nIRank = NIResourceFactory.newRank(nIArrayIDArray, nIExtentType);
            if (nIExtentPool != null && !nIExtentPool.getExtentType().equals(nIExtentType)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Invalid Extent Type");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException(nIExtentPool, "Invalid Extent Type");
            }
        }
        return nIRank;
    }

    protected int[] getNextRankNumber(NIESS nIESS, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(nIESSID.getType(), nIESS.getModel());
        int n2 = nIMachineTypeModel.getMaxNumRanks();
        int[] nArray = new int[]{};
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getMaxRankNumber(nIESS);
        int[] nArray2 = new int[n5];
        Arrays.fill(nArray2, -1);
        int n6 = 0;
        List list = null;
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.logicalService.getRanks(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        if (list != null) {
            n4 = list.size();
        }
        n3 = 0;
        while (n3 < n4) {
            n6 = ((NIRankID)((NIRank)list.get(n3)).getID()).getRankNumber();
            if (n6 >= n2) {
                return nArray;
            }
            nArray2[n6] = n6;
            ++n3;
        }
        int[] nArray3 = null;
        if (n >= 0) {
            nArray3 = new int[n];
        }
        int n7 = 0;
        n3 = 0;
        while (n3 < n2 && n7 < n) {
            if (nArray2[n3] == -1) {
                nArray3[n7] = n3;
                ++n7;
            }
            ++n3;
        }
        if (nArray3 == null || nArray3.length == 0) {
            return nArray;
        }
        return nArray3;
    }

    private int getMaxRankNumber(NIESS nIESS) {
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        int n = 0;
        String string = nIESSID.getType();
        String string2 = nIESS.getModel();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(string, string2);
        n = nIMachineTypeModel.getMaxNumSites();
        return n;
    }

    protected List getRankClientData(NIESSID nIESSID, NIRank[] nIRankArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIResourceID nIResourceID;
        int n;
        Serializable serializable;
        Object object;
        int n2;
        NIExtentPoolID[] nIExtentPoolIDArray;
        Vector<NIRankClientData> vector = new Vector<NIRankClientData>();
        NIExtentPool[] nIExtentPoolArray = null;
        int n3 = nIRankArray.length;
        NIConfigQueryResult nIConfigQueryResult = null;
        NIExtentUsageResult[] nIExtentUsageResultArray = null;
        if (nIRankArray.length == 0) {
            return vector;
        }
        HashMap<NIResourceID[], Object> hashMap = new HashMap<NIResourceID[], Object>();
        int n4 = 0;
        while (n4 < n3) {
            nIExtentPoolIDArray = nIRankArray[n4].getExtentPoolID();
            if (nIExtentPoolIDArray != null && !hashMap.containsKey(nIExtentPoolIDArray)) {
                hashMap.put(nIExtentPoolIDArray, nIExtentPoolIDArray);
            }
            ++n4;
        }
        nIExtentPoolIDArray = hashMap.values().toArray(new NIExtentPoolID[0]);
        if (nIExtentPoolIDArray.length > 0) {
            try {
                nIConfigQueryResult = this.logicalService.getExtentPools(nIExtentPoolIDArray);
            }
            catch (NullPointerException nullPointerException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(nullPointerException.toString());
                logger.debug_general(stringBuffer.toString());
                throw new NIUnknownCAException(nullPointerException.toString());
            }
            if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
                nIExtentPoolArray = nIConfigQueryResult.getResourceList().toArray(new NIExtentPool[0]);
            } else if (nIConfigQueryResult.getCode() != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Query Failure");
                logger.debug_general(stringBuffer.toString());
                throw new NIQueryFailureCAException("Query Failure");
            }
            hashMap = new HashMap();
            int n5 = nIExtentPoolArray.length;
            n2 = 0;
            while (n2 < n5) {
                object = (NIExtentPoolID)nIExtentPoolArray[n2].getID();
                hashMap.put((NIResourceID[])object, nIExtentPoolArray[n2]);
                ++n2;
            }
        }
        HashMap<Serializable, Serializable> hashMap2 = new HashMap<Serializable, Serializable>();
        n2 = 0;
        while (n2 < n3) {
            object = nIRankArray[n2];
            if (!(object.getExtentPoolID() == null || object.getConfigurationState() != 0 && object.getConfigurationState() != 2 && object.getConfigurationState() != 3 && object.getConfigurationState() != 4 || hashMap2.containsKey(serializable = (NIRankID)object.getID()))) {
                hashMap2.put(serializable, serializable);
            }
            ++n2;
        }
        object = hashMap2.values().toArray(new NIRankID[0]);
        serializable = new HashMap();
        if (((NIRankID[])object).length > 0) {
            try {
                nIExtentUsageResultArray = this.logicalService.queryExtentUsage((NIRankID[])object);
            }
            catch (NullPointerException nullPointerException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(nullPointerException.toString());
                logger.debug_general(stringBuffer.toString());
                throw new NIUnknownCAException(nullPointerException.toString());
            }
            if (nIExtentUsageResultArray == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Query Failure");
                logger.debug_general(stringBuffer.toString());
                throw new NIQueryFailureCAException("Query Failure");
            }
            n = 0;
            while (n < nIExtentUsageResultArray.length) {
                if (nIExtentUsageResultArray[n].getCode() != 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Query Failure");
                    logger.debug_general(stringBuffer.toString());
                    throw new NIQueryFailureCAException("Query Failure");
                }
                long l = nIExtentUsageResultArray[n].getNumExtentsUsed();
                nIResourceID = nIExtentUsageResultArray[n].getRank();
                ((HashMap)serializable).put(nIResourceID, new Long(l));
                ++n;
            }
        }
        n = 0;
        while (n < n3) {
            NIRank nIRank = nIRankArray[n];
            NIRankID nIRankID = (NIRankID)nIRank.getID();
            nIResourceID = nIRank.getExtentPoolID();
            NIExtentPool nIExtentPool = null;
            if (nIResourceID != null) {
                nIExtentPool = (NIExtentPool)hashMap.get(nIResourceID);
            }
            double d = 0.0;
            NIExtentType nIExtentType = nIRank.getExtentType();
            if (nIExtentType instanceof NIExtentTypeCKD) {
                d = 0.88104;
            } else if (nIExtentType instanceof NIExtentTypeFB) {
                d = 1.0;
            }
            long l = nIRank.getNumExtents();
            double d2 = (double)l * d;
            long l2 = 0L;
            if (((HashMap)serializable).containsKey(nIRankID)) {
                Long l3 = (Long)((HashMap)serializable).get(nIRankID);
                l2 = l3;
            }
            double d3 = (double)l2 * d;
            NIRankClientData nIRankClientData = new NIRankClientData(nIRank, nIExtentPool, d2, d3);
            vector.add(nIRankClientData);
            ++n;
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

