/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIDDMPack;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIIOPort;
import com.ibm.storage.ess.ni.application.resource.NIOfflineESS;
import com.ibm.storage.ess.ni.application.resource.NIOfflineStorageFacility;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NIStorageFacility;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor;
import com.ibm.storage.ess.ni.ca.NIIOAdapter;
import com.ibm.storage.ess.ni.constants.NIConfigurationConstants;
import com.ibm.storage.ess.ni.constants.NIMachineTypeModel;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.identifiers.NIStoragePlexID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.services.NIDomainService;
import com.ibm.storage.ess.ni.services.NIPhysicalConfigurationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class NIConfigurationAdvisorStorageFacility {
    private NIConfigurationAdvisor advisor = null;
    private NIDomainService domainService = null;
    private NIPhysicalConfigurationService physicalService = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor = NIConfigurationAdvisorStorageFacility.class$("com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor);
    private static final String[] machineType = new String[]{"2107", "1750"};
    private static final String[] modelNumber_2107 = new String[]{"921", "922", "9A2"};
    private static final String[] modelNumber_1750 = new String[]{"511", "522"};
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor;

    protected NIConfigurationAdvisorStorageFacility(NIConfigurationAdvisor nIConfigurationAdvisor) {
        this.advisor = nIConfigurationAdvisor;
        this.domainService = this.advisor.getDomainService();
        this.physicalService = this.advisor.getPhysicalService();
    }

    protected List getMachineTypes() {
        Vector<String> vector = new Vector<String>(Arrays.asList(machineType));
        return vector;
    }

    protected List getModelType(String string) throws NIParameterInvalidCAException {
        Vector<Object> vector = new Vector();
        if (string.equals("2107")) {
            vector = new Vector<String>(Arrays.asList(modelNumber_2107));
        } else if (string.equals("1750")) {
            vector = new Vector<String>(Arrays.asList(modelNumber_1750));
        }
        return vector;
    }

    protected int getMaximumNumberOfImages(String string, String string2) throws NIParameterInvalidCAException {
        int n = 0;
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(string, string2);
        n = nIMachineTypeModel.getMaxNumImages();
        return n;
    }

    protected double getTotalStorageGB(NIStorageFacilityID nIStorageFacilityID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n = 0;
        String string = nIStorageFacilityID.getType();
        if (string.equals("2107")) {
            n = 8;
        } else if (string.equals("1750")) {
            n = 4;
        }
        double d = 0.0;
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.domainService.getESSs(nIStorageFacilityID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            List list = nIConfigQueryResult.getResourceList();
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                NIESSID nIESSID = (NIESSID)((NIESS)list.get(n3)).getID();
                d += this.advisor.getTotalStorageGB(nIESSID);
                ++n3;
            }
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        return d;
    }

    protected int getMaxDDMPacks(NIStorageFacility nIStorageFacility) throws NIParameterInvalidCAException {
        NIStorageFacilityID nIStorageFacilityID = (NIStorageFacilityID)nIStorageFacility.getID();
        return this.getMaxDDMPacks(nIStorageFacilityID.getType(), nIStorageFacility.getModel());
    }

    protected int getMaxDDMPacks(String string, String string2) throws NIParameterInvalidCAException {
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(string, string2);
        return nIMachineTypeModel.getMaxNumDDMPack();
    }

    protected int getMaxAdapters(NIStorageFacility nIStorageFacility) throws NIParameterInvalidCAException {
        int n = 0;
        NIStorageFacilityID nIStorageFacilityID = (NIStorageFacilityID)nIStorageFacility.getID();
        n = this.getMaxAdapters(nIStorageFacilityID.getType(), nIStorageFacility.getModel());
        return n;
    }

    protected int getMaxAdapters(String string, String string2) throws NIParameterInvalidCAException {
        boolean bl = false;
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(string, string2);
        return nIMachineTypeModel.getMaxNumAdapters();
    }

    protected NIOfflineStorageFacility getFutureOfflineStorageFacility(NIStoragePlexID nIStoragePlexID, String string, String string2, String string3, String string4, NIOfflineESS[] nIOfflineESSArray) throws NIParameterInvalidCAException {
        NIOfflineStorageFacility nIOfflineStorageFacility = NIResourceFactory.newOfflineStorageFacility(nIStoragePlexID, string3, string, string2, string4, nIOfflineESSArray);
        return nIOfflineStorageFacility;
    }

    protected double getTotalFutureStorageGB(NIDDMPack[] nIDDMPackArray) throws NIParameterInvalidCAException {
        double d = 0.0;
        int n = 0;
        while (n < nIDDMPackArray.length) {
            d += nIDDMPackArray[n].getCapacity() * (double)nIDDMPackArray[n].getQuantity();
            ++n;
        }
        double d2 = d / NIConfigurationConstants.MB_IN_ONE_GB_DEC;
        return d2;
    }

    protected double getTotalFutureStorageGB(NIDDMPack[] nIDDMPackArray, String string) throws NIParameterInvalidCAException {
        double d = 0.0;
        int n = 0;
        if (string.equals("2107")) {
            n = 16;
        } else if (string.equals("1750")) {
            n = 4;
        }
        int n2 = 0;
        while (n2 < nIDDMPackArray.length) {
            d += nIDDMPackArray[n2].getCapacity() * (double)nIDDMPackArray[n2].getQuantity() * (double)n;
            ++n2;
        }
        double d2 = d / NIConfigurationConstants.MB_IN_ONE_GB_DEC;
        return d2;
    }

    protected List getSupportedDDMPack(String string, String string2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Vector<NIDDMPack> vector = new Vector<NIDDMPack>();
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(string, string2);
        int[] nArray = nIMachineTypeModel.getSupportedDDMCapacities();
        int n = -1;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int[] nArray2 = null;
            if (n4 == 73000) {
                if (string.equals("2107")) {
                    nArray2 = NIConfigurationConstants.RPM_FOR_73GB_2107;
                } else if (string.equals("1750")) {
                    nArray2 = NIConfigurationConstants.RPM_FOR_73GB_1750;
                }
                n = 1;
            } else if (n4 == 146000) {
                if (string.equals("2107")) {
                    nArray2 = NIConfigurationConstants.RPM_FOR_146GB_2107;
                } else if (string.equals("1750")) {
                    nArray2 = NIConfigurationConstants.RPM_FOR_146GB_1750;
                }
                n = 1;
            } else if (n4 == 300000) {
                nArray2 = NIConfigurationConstants.RPM_FOR_300GB;
                n = 1;
            } else if (n4 == 500000) {
                nArray2 = NIConfigurationConstants.RPM_FOR_500GB;
                n = 2;
            }
            if (nArray2 != null) {
                int n5 = nArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = nArray2[n6];
                    NIDDMPack nIDDMPack = NIResourceFactory.newDDMPack(n4, n7, 1, n);
                    vector.add(nIDDMPack);
                    ++n6;
                }
            }
            ++n3;
        }
        return vector;
    }

    protected NIIOAdapter[] getInstalledIOAdapters(NIStorageFacility nIStorageFacility) throws NIUnavailableServerException, NIUnsupportedException, NIUnauthorizedServerException, NIServerException {
        NIIOAdapter[] nIIOAdapterArray = null;
        ArrayList arrayList = new ArrayList();
        NIConfigQueryResult nIConfigQueryResult = this.domainService.getESSs((NIStorageFacilityID)nIStorageFacility.getID());
        if (nIConfigQueryResult.getCode() == 0) {
            List list = nIConfigQueryResult.getResourceList();
            int n = 0;
            while (n < list.size()) {
                NIESS nIESS = (NIESS)list.get(n);
                List list2 = this.getESSIOAdapters(nIESS);
                arrayList.addAll(list2);
                ++n;
            }
            nIIOAdapterArray = arrayList.toArray(new NIIOAdapter[0]);
        }
        return nIIOAdapterArray;
    }

    private List getESSIOAdapters(NIESS nIESS) throws NIUnavailableServerException, NIUnsupportedException, NIUnauthorizedServerException, NIServerException {
        Serializable serializable;
        NIConfigQueryResult nIConfigQueryResult;
        ArrayList arrayList = new ArrayList();
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        HashMap<String, NIIOAdapter> hashMap = new HashMap<String, NIIOAdapter>();
        NIConfigQueryResult nIConfigQueryResult2 = this.physicalService.getFibreChannelPorts(nIESSID);
        if (nIConfigQueryResult2.getCode() == 0) {
            List list = nIConfigQueryResult2.getResourceList();
            arrayList.addAll(list);
        }
        if ((nIConfigQueryResult = this.physicalService.getESCONPorts(nIESSID)).getCode() == 0) {
            List list = nIConfigQueryResult.getResourceList();
            arrayList.addAll(list);
        }
        int n = 0;
        while (n < arrayList.size()) {
            serializable = (NIIOPort)arrayList.get(n);
            int n2 = serializable.getInterfaceId();
            int n3 = nIESSID.getImageNumber();
            int n4 = serializable.getPortType();
            int n5 = (n2 & 0xF00) >> NIConfigurationConstants.ENCLOSURE_SHIFT_INDEX;
            int n6 = (n2 & 0xF0) >> NIConfigurationConstants.ADAPTER_SHIFT_INDEX;
            int n7 = 0;
            int n8 = 0;
            if (nIESSID.getType().equals("2107")) {
                n7 = NIConfigurationConstants.RACK_NUMBERS_2107[n5 / 4];
                n8 = NIConfigurationConstants.ENCLOSURE_NUMBERS_2107[n5 % 4];
            } else if (n5 == 0) {
                n7 = NIConfigurationConstants.RACK_NUMBERS_1750[0];
                n8 = NIConfigurationConstants.ENCLOSURE_NUMBERS_1750[0];
            } else {
                n7 = NIConfigurationConstants.RACK_NUMBERS_1750[0];
                n8 = NIConfigurationConstants.ENCLOSURE_NUMBERS_1750[1];
            }
            String string = "image" + n3 + "rack" + n7 + "enclosure" + n8 + "adapter" + n6;
            if (!hashMap.containsKey(string)) {
                NIIOAdapter nIIOAdapter = new NIIOAdapter(n3, n7, n8, n6, n4);
                hashMap.put(string, nIIOAdapter);
            }
            ++n;
        }
        serializable = new ArrayList(hashMap.values());
        return serializable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

