/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIArraySite;
import com.ibm.storage.ess.ni.application.resource.NIDDMPack;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NIIOPort;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIExtentAvailabilityResult;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorExtentPool;
import com.ibm.storage.ess.ni.ca.NIIOAdapter;
import com.ibm.storage.ess.ni.ca.NIStorageFacilityImageClientData;
import com.ibm.storage.ess.ni.constants.NIConfigurationConstants;
import com.ibm.storage.ess.ni.constants.NIMachineTypeModel;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIAddressGroupID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyFCArbitratedLoop;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import com.ibm.storage.ess.ni.resource.NIESCONPortImpl;
import com.ibm.storage.ess.ni.resource.NIFibreChannelPortImpl;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import com.ibm.storage.ess.ni.services.NIPhysicalConfigurationService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class NIConfigurationAdvisorStorageFacilityImage {
    private NIConfigurationAdvisor ca = null;
    private NIPhysicalConfigurationService physicalService = null;
    private NILogicalConfigurationService logicalService = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor = NIConfigurationAdvisorStorageFacilityImage.class$("com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor;

    protected NIConfigurationAdvisorStorageFacilityImage(NIConfigurationAdvisor nIConfigurationAdvisor) {
        this.ca = nIConfigurationAdvisor;
        this.physicalService = this.ca.getPhysicalService();
        this.logicalService = this.ca.getLogicalService();
    }

    protected int[] getSupportedDDMCapacities(NIESS nIESS) throws NIParameterInvalidCAException {
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        String string = nIESSID.getType();
        String string2 = nIESS.getModel();
        return this.getSupportedDDMCapacities(string, string2);
    }

    protected int[] getSupportedDDMCapacities(String string, String string2) throws NIParameterInvalidCAException {
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(string, string2);
        int[] nArray = nIMachineTypeModel.getSupportedDDMCapacities();
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = nArray[n] / (int)NIConfigurationConstants.MB_IN_ONE_GB_DEC;
            ++n;
        }
        return nArray;
    }

    protected int[] getSupportedRPMs(NIESS nIESS) throws NIParameterInvalidCAException {
        NIESSID nIESSID = (NIESSID)nIESS.getID();
        String string = nIESSID.getType();
        String string2 = nIESS.getModel();
        return this.getSupportedRPMs(string, string2);
    }

    protected int[] getSupportedRPMs(String string, String string2) throws NIParameterInvalidCAException {
        NIMachineTypeModel nIMachineTypeModel = new NIMachineTypeModel(string, string2);
        int[] nArray = nIMachineTypeModel.getSupportedDDMRPMs();
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = nArray[n] / 1000;
            ++n;
        }
        return nArray;
    }

    protected double getTotalStorageGB(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n = 0;
        String string = nIESSID.getType();
        if (string.equals("2107")) {
            n = 8;
        } else if (string.equals("1750")) {
            n = 4;
        }
        int n2 = 0;
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.logicalService.getArraySites(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            List list = nIConfigQueryResult.getResourceList();
            if (list != null) {
                int n3 = list.size();
                int n4 = 0;
                while (n4 < n3) {
                    n2 += ((NIArraySite)list.get(n4)).getDiskCapacity() * n;
                    ++n4;
                }
            }
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        double d = (double)n2 / NIConfigurationConstants.MB_IN_ONE_GB_DEC;
        return d;
    }

    protected double getAvailableStorageGB(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        List list = null;
        List list2 = null;
        List list3 = null;
        List list4 = null;
        NIConfigQueryResult nIConfigQueryResult = null;
        NIConfigQueryResult nIConfigQueryResult2 = null;
        NIConfigQueryResult nIConfigQueryResult3 = null;
        NIConfigQueryResult nIConfigQueryResult4 = null;
        try {
            nIConfigQueryResult = this.logicalService.getExtentPools(nIESSID);
            nIConfigQueryResult2 = this.logicalService.getRanks(nIESSID);
            nIConfigQueryResult3 = this.logicalService.getArrays(nIESSID);
            nIConfigQueryResult4 = this.logicalService.getArraySites(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() != 0 || nIConfigQueryResult.getResourceList() == null || nIConfigQueryResult2.getCode() != 0 || nIConfigQueryResult2.getResourceList() == null || nIConfigQueryResult3.getCode() != 0 || nIConfigQueryResult3.getResourceList() == null || nIConfigQueryResult4.getCode() != 0 || nIConfigQueryResult4.getResourceList() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        list = nIConfigQueryResult.getResourceList();
        list2 = nIConfigQueryResult2.getResourceList();
        list3 = nIConfigQueryResult3.getResourceList();
        list4 = nIConfigQueryResult4.getResourceList();
        double d = 0.0;
        int n = 0;
        String string = nIESSID.getType();
        if (string.equals("2107")) {
            n = 8;
        } else if (string.equals("1750")) {
            n = 4;
        }
        int n2 = 0;
        while (n2 < list4.size()) {
            NIArraySite nIArraySite = (NIArraySite)list4.get(n2);
            if (nIArraySite.getArraySiteStatus() == 1) {
                d += (double)(nIArraySite.getDiskCapacity() * n) / NIConfigurationConstants.MB_IN_ONE_GB_DEC;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < list3.size()) {
            NIArray nIArray = (NIArray)list3.get(n3);
            if (nIArray.getArrayStatus() == 1) {
                d += this.ca.getTotalStorageGB(nIArray);
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < list2.size()) {
            NIRank nIRank = (NIRank)list2.get(n4);
            if (nIRank.getConfigurationState() == 2) {
                d += this.ca.getTotalStorageGB(nIRank);
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < list.size()) {
            NIExtentAvailabilityResult nIExtentAvailabilityResult;
            NIExtentPool nIExtentPool = (NIExtentPool)list.get(n5);
            NIExtentType nIExtentType = nIExtentPool.getExtentType();
            try {
                nIExtentAvailabilityResult = this.logicalService.queryExtentAvailability((NIExtentPoolID)nIExtentPool.getID());
            }
            catch (NullPointerException nullPointerException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(nullPointerException.toString());
                logger.debug_general(stringBuffer.toString());
                throw new NIUnknownCAException(nullPointerException.toString());
            }
            int n6 = 0;
            if (nIExtentAvailabilityResult.getCode() != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Query Failure queryExtentAvailability " + nIExtentAvailabilityResult.getCode());
                logger.debug_general(stringBuffer.toString());
                throw new NIQueryFailureCAException(stringBuffer.toString());
            }
            n6 = nIExtentAvailabilityResult.getNumAvailableExtents();
            d += this.ca.convertExtentsToBinaryGB(n6, nIExtentType);
            ++n5;
        }
        return d;
    }

    protected List getRaidTypesList(NIESSID nIESSID) throws NIParameterInvalidCAException {
        Vector<Object> vector = new Vector();
        String string = nIESSID.getType();
        if (string != null) {
            if (string.equals("2107")) {
                vector = new Vector<NIRaidType>(Arrays.asList(NIMachineTypeModel.supportedRaidTypes_2107));
            } else if (string.equals("1750")) {
                vector = new Vector<NIRaidType>(Arrays.asList(NIMachineTypeModel.supportedRaidTypes_1750));
            }
        }
        return vector;
    }

    protected List getInstalledDDMPack(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Vector<NIDDMPack> vector = new Vector<NIDDMPack>();
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.logicalService.getArraySites(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            List list = nIConfigQueryResult.getResourceList();
            if (list != null) {
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    NIDDMPack nIDDMPack;
                    NIArraySite nIArraySite = (NIArraySite)list.get(n2);
                    int n3 = nIArraySite.getDiskCapacity();
                    int n4 = nIArraySite.getDiskRPM();
                    int n5 = nIArraySite.getDiskClass();
                    boolean bl = false;
                    int n6 = vector.size();
                    int n7 = 0;
                    while (n7 < n6) {
                        nIDDMPack = (NIDDMPack)vector.get(n7);
                        if (Math.abs(nIDDMPack.getCapacity() - (double)n3) < 20000.0 && Math.abs(nIDDMPack.getRPM() - (double)n4) < 1500.0) {
                            bl = true;
                        }
                        ++n7;
                    }
                    if (!bl) {
                        nIDDMPack = NIResourceFactory.newDDMPack(n3, n4, 1, n5);
                        vector.add(nIDDMPack);
                    }
                    ++n2;
                }
            }
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        return vector;
    }

    protected NIStorageFacilityImageClientData getStorageFacilityImageClientData(NIESSID nIESSID) throws NIUnavailableServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException, NIServerException {
        Object object;
        double d;
        Vector vector = new Vector();
        Object var3_3 = null;
        int n = 0;
        String string = nIESSID.getType();
        if (string.equals("2107")) {
            n = 8;
        } else if (string.equals("1750")) {
            n = 4;
        }
        int n2 = 0;
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.logicalService.getArraySites(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            List list = nIConfigQueryResult.getResourceList();
            if (list != null) {
                int n3 = list.size();
                int n4 = 0;
                while (n4 < n3) {
                    n2 += ((NIArraySite)list.get(n4)).getDiskCapacity() * n;
                    ++n4;
                }
            }
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        double d2 = d = (double)n2 / NIConfigurationConstants.MB_IN_ONE_GB_DEC;
        NIConfigQueryResult nIConfigQueryResult2 = null;
        try {
            nIConfigQueryResult2 = this.logicalService.getExtentPools(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult2.getCode() == 0 && nIConfigQueryResult2.getResourceList() != null) {
            object = nIConfigQueryResult2.getResourceList();
            if (object != null) {
                int n5 = object.size();
                NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this.ca);
                int n6 = 0;
                while (n6 < n5) {
                    NIExtentPool nIExtentPool = (NIExtentPool)object.get(n6);
                    d2 -= nIConfigurationAdvisorExtentPool.getUsedAndReservedStorageGB(nIExtentPool);
                    ++n6;
                }
            }
        } else if (nIConfigQueryResult2.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        object = new NIStorageFacilityImageClientData(d, d2);
        return object;
    }

    protected List getAllInstalledDDMPack(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n;
        ArrayList arrayList;
        Hashtable<String, NIDDMPack> hashtable = new Hashtable<String, NIDDMPack>();
        int n2 = nIESSID.getType().equals("2107") ? 2 : 1;
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.logicalService.getArraySites(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            arrayList = nIConfigQueryResult.getResourceList();
            if (arrayList != null) {
                n = arrayList.size();
                int n3 = 0;
                while (n3 < n) {
                    NIDDMPack nIDDMPack;
                    NIArraySite nIArraySite = (NIArraySite)arrayList.get(n3);
                    int n4 = this.ca.convertDDMCapacityConstant(nIArraySite.getDiskCapacity());
                    int n5 = this.ca.convertDDMRPM(nIArraySite.getDiskRPM());
                    int n6 = nIArraySite.getDiskClass();
                    String string = String.valueOf(n4) + String.valueOf(n5);
                    if (hashtable.containsKey(string)) {
                        nIDDMPack = (NIDDMPack)hashtable.get(string);
                        nIDDMPack.setQuantity(nIDDMPack.getQuantity() + 1);
                    } else {
                        nIDDMPack = NIResourceFactory.newDDMPack(n4, n5, 1, n6);
                        hashtable.put(string, nIDDMPack);
                    }
                    ++n3;
                }
            }
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        arrayList = new ArrayList(hashtable.values());
        n = 0;
        while (n < arrayList.size()) {
            NIDDMPack nIDDMPack = (NIDDMPack)arrayList.get(n);
            nIDDMPack.setQuantity(nIDDMPack.getQuantity() / n2);
            ++n;
        }
        return arrayList;
    }

    protected double getUnconfiguredStorageGB(NIESSID nIESSID) throws NIParameterInvalidCAException, NIUnavailableServerException, NIUnsupportedException, NIUnauthorizedServerException, NIServerException, NIUnknownCAException, NIQueryFailureCAException {
        int n = 0;
        String string = nIESSID.getType();
        if (string.equals("2107")) {
            n = 8;
        } else if (string.equals("1750")) {
            n = 4;
        }
        int n2 = 0;
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.logicalService.getArraySites(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            List list = nIConfigQueryResult.getResourceList();
            if (list != null) {
                int n3 = list.size();
                int n4 = 0;
                while (n4 < n3) {
                    NIArraySite nIArraySite = (NIArraySite)list.get(n4);
                    if (nIArraySite.getArraySiteStatus() == 1) {
                        n2 += nIArraySite.getDiskCapacity() * n;
                    }
                    ++n4;
                }
            }
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        double d = (double)n2 / NIConfigurationConstants.MB_IN_ONE_GB_DEC;
        return d;
    }

    protected NIIOAdapter[] getDefaultIOAdapters(String string, String string2, int n, int n2, int n3, int n4) {
        NIIOAdapter[] nIIOAdapterArray = null;
        nIIOAdapterArray = n == 1 ? this.getDefaultAdaptersOneImage(string, string2, n2, n3, n4) : this.getDefaultAdaptersTwoImages(string, string2, n2, n3, n4);
        return nIIOAdapterArray;
    }

    private NIIOAdapter[] getDefaultAdaptersOneImage(String string, String string2, int n, int n2, int n3) {
        int[] nArray = this.ca.getAvailableRacks(string, string2);
        int[] nArray2 = this.ca.getAvailableIOAdapterEnclosures(string, string2);
        int[] nArray3 = this.ca.getAvailableIOAdapterLocations(string, string2);
        int[] nArray4 = NIConfigurationConstants.IMAGE_NUMBERS;
        int n4 = n + n2 + n3;
        int n5 = nArray.length;
        int n6 = nArray2.length;
        int n7 = nArray3.length;
        int n8 = n5 * n6 * n7;
        if (n4 > n8) {
            n4 = n8;
        }
        NIIOAdapter[] nIIOAdapterArray = new NIIOAdapter[n4];
        int n9 = 0;
        int n10 = 0;
        int n11 = 21;
        int n12 = 0;
        while (n12 < n5 && n10 < n4) {
            int n13 = 0;
            while (n13 < n6 && n10 < n4) {
                int n14 = 0;
                while (n14 < n7 && n10 < n4) {
                    if (n10 == n) {
                        n11 = 20;
                    }
                    if (n10 == n + n2) {
                        n11 = 10;
                    }
                    nIIOAdapterArray[n10] = new NIIOAdapter(nArray4[n9], nArray[n12], nArray2[n13], nArray3[n14], n11);
                    ++n10;
                    ++n14;
                }
                ++n13;
            }
            ++n12;
        }
        return nIIOAdapterArray;
    }

    private NIIOAdapter[] getDefaultAdaptersTwoImages(String string, String string2, int n, int n2, int n3) {
        int[] nArray = this.ca.getAvailableRacks(string, string2);
        int[] nArray2 = this.ca.getAvailableIOAdapterEnclosures(string, string2);
        int[] nArray3 = this.ca.getAvailableIOAdapterLocations(string, string2);
        int[] nArray4 = NIConfigurationConstants.IMAGE_NUMBERS;
        int n4 = nArray.length;
        int n5 = nArray2.length / 2;
        int n6 = nArray3.length;
        int n7 = n + n2 + n3;
        NIIOAdapter[] nIIOAdapterArray = new NIIOAdapter[n7];
        int n8 = 0;
        int n9 = 0;
        int n10 = 21;
        int n11 = 0;
        while (n11 < n4 && n9 < n7) {
            int n12 = 0;
            while (n12 < n5 && n9 < n7) {
                int n13 = 0;
                while (n13 < n6 && n9 < n7) {
                    if (n9 == n) {
                        n10 = 20;
                    }
                    if (n9 == n + n2) {
                        n10 = 10;
                    }
                    if (n9 % 2 == 1) {
                        nIIOAdapterArray[n9] = new NIIOAdapter(nArray4[++n8], nArray[n11], nArray2[n12 + 2], nArray3[n13], n10);
                        ++n13;
                    } else {
                        n8 = 0;
                        nIIOAdapterArray[n9] = new NIIOAdapter(nArray4[n8], nArray[n11], nArray2[n12], nArray3[n13], n10);
                    }
                    ++n9;
                }
                ++n12;
            }
            ++n11;
        }
        return nIIOAdapterArray;
    }

    protected NIIOPort[] getIOPorts(NIIOAdapter[] nIIOAdapterArray, String string, String string2, String string3, String string4, int n) {
        NIIOPort[] nIIOPortArray;
        ArrayList<NIIOPort> arrayList = new ArrayList<NIIOPort>();
        int n2 = 0;
        while (n2 < nIIOAdapterArray.length) {
            nIIOPortArray = nIIOAdapterArray[n2];
            if (nIIOPortArray.getImageNumber() == n) {
                int n3 = nIIOPortArray.getAdapterType();
                int n4 = n3 == 10 ? 2 : 4;
                int n5 = 0;
                while (n5 < n4) {
                    NIIOPortID nIIOPortID = this.getIOPortID(string, string2, string3, string4, (NIIOAdapter)nIIOPortArray, n5);
                    String string5 = this.getIOPortLocation(string, string2, string3, string4, nIIOPortArray.getAdapterNumber(), n5);
                    NIIOPort nIIOPort = n3 == 10 ? this.createEsconPort(nIIOPortID, string5, nIIOPortArray.getAdapterType(), nIIOPortID.getInterfaceIdentifier()) : this.createFCPort(nIIOPortID, string, n5, nIIOPortArray.getAdapterNumber(), nIIOPortArray.getEnclosureNumber(), string5, nIIOPortArray.getAdapterType(), nIIOPortID.getInterfaceIdentifier());
                    arrayList.add(nIIOPort);
                    ++n5;
                }
            }
            ++n2;
        }
        nIIOPortArray = arrayList.toArray(new NIIOPort[0]);
        return nIIOPortArray;
    }

    private NIIOPort createEsconPort(NIIOPortID nIIOPortID, String string, int n, int n2) {
        int n3 = 0;
        NIAddressGroupID nIAddressGroupID = null;
        NIVolumeGroupID nIVolumeGroupID = null;
        int n4 = 0;
        int n5 = 0;
        NIESCONPortImpl nIESCONPortImpl = new NIESCONPortImpl(nIIOPortID, string, n, n3, n5, nIAddressGroupID, nIVolumeGroupID, n2, n4);
        return nIESCONPortImpl;
    }

    private NIIOPort createFCPort(NIIOPortID nIIOPortID, String string, int n, int n2, int n3, String string2, int n4, int n5) {
        int n6 = 0;
        int n7 = 0;
        int n8 = this.getPortMaskBitIndex(string, n, n2, n3);
        NIFabricTopologyFCArbitratedLoop nIFabricTopologyFCArbitratedLoop = NIFabricTopologyFCArbitratedLoop.Option;
        long l = 0L;
        int n9 = 0;
        NIVolumeGroupID nIVolumeGroupID = null;
        NIFibreChannelPortImpl nIFibreChannelPortImpl = new NIFibreChannelPortImpl(nIIOPortID, string2, n4, n6, l, n9, n7, nIVolumeGroupID, n8, nIFabricTopologyFCArbitratedLoop, n5);
        return nIFibreChannelPortImpl;
    }

    private int getPortMaskBitIndex(String string, int n, int n2, int n3) {
        if (string.equalsIgnoreCase("2107")) {
            n2 = n2 < 3 ? --n2 : (n2 -= 2);
        }
        int n4 = n + n2 * 4 + n3 * 16;
        return n4;
    }

    private String getIOPortLocation(String string, String string2, String string3, String string4, int n, int n2) {
        String string5 = "U" + string + string2 + string3 + string4 + "-P1-C" + n + "-T" + n2;
        return string5;
    }

    private NIIOPortID getIOPortID(String string, String string2, String string3, String string4, NIIOAdapter nIIOAdapter, int n) {
        int n2;
        NIStorageFacilityID nIStorageFacilityID = new NIStorageFacilityID(string, string3, string4, 0L);
        NIESSID nIESSID = new NIESSID(nIStorageFacilityID, nIIOAdapter.getImageNumber());
        int n3 = 0;
        if (string.equals("2107")) {
            n2 = 0;
            int n4 = NIConfigurationConstants.ENCLOSURE_ARRAY_2107[nIIOAdapter.getRackNumber() - 1][nIIOAdapter.getEnclosureNumber()];
            int n5 = nIIOAdapter.getAdapterNumber();
            n3 = (n2 << NIConfigurationConstants.PORT_SHIFT_INDEX) + (n4 << NIConfigurationConstants.ENCLOSURE_SHIFT_INDEX) + (n5 << NIConfigurationConstants.ADAPTER_SHIFT_INDEX) + n;
        } else if (string.equals("1750")) {
            n2 = 0;
            int n6 = nIIOAdapter.getEnclosureNumber();
            int n7 = 0;
            n3 = (n2 << NIConfigurationConstants.PORT_SHIFT_INDEX) + (n6 << NIConfigurationConstants.ENCLOSURE_SHIFT_INDEX) + (n7 << NIConfigurationConstants.ADAPTER_SHIFT_INDEX) + n;
        }
        NIIOPortID nIIOPortID = new NIIOPortID(nIESSID, n3);
        return nIIOPortID;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

