/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NISCSIHostPort;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroup;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupVolumeList;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor;
import com.ibm.storage.ess.ni.ca.NIEnterpriseAdvisorHostManager;
import com.ibm.storage.ess.ni.ca.NIHostType;
import com.ibm.storage.ess.ni.ca.NIImageHostAttachment;
import com.ibm.storage.ess.ni.constants.NIHostConstants;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB;
import com.ibm.storage.ess.ni.option.config.NIFabricTopology;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyScsiFcp;
import com.ibm.storage.ess.ni.option.config.NIHostPortType;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeSCSIFcAl;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeSCSIFcSf;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupType;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520All;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Mask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMap256;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMask;
import com.ibm.storage.ess.ni.resource.NIVolumeGroupImpl;
import com.ibm.storage.ess.ni.services.NIHostConfigurationService;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class NIConfigurationAdvisorVolumeGroups {
    private static final String CLASS_NAME = "NIConfigurationAdvisorVolumeGroups";
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor = NIConfigurationAdvisorVolumeGroups.class$("com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor);
    private NIConfigurationAdvisor ca = null;
    private NILogicalConfigurationService logicalService = null;
    private NIHostConfigurationService hostService = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor;

    protected NIConfigurationAdvisorVolumeGroups(NIConfigurationAdvisor nIConfigurationAdvisor) {
        this.ca = nIConfigurationAdvisor;
        this.logicalService = this.ca.getLogicalService();
        this.hostService = this.ca.getHostService();
    }

    protected List getHostAttachments(NIImageHostAttachment[] nIImageHostAttachmentArray, NIVolumeGroupID[] nIVolumeGroupIDArray) {
        Vector<NIImageHostAttachment> vector = new Vector<NIImageHostAttachment>();
        int n = nIImageHostAttachmentArray.length;
        int n2 = nIVolumeGroupIDArray.length;
        int n3 = 0;
        while (n3 < n) {
            NIVolumeGroupID nIVolumeGroupID = nIImageHostAttachmentArray[n3].getVolumeGroup();
            if (nIVolumeGroupID != null) {
                int n4 = 0;
                while (n4 < n2) {
                    if (nIVolumeGroupID.equals(nIVolumeGroupIDArray[n4])) {
                        vector.add(nIImageHostAttachmentArray[n3]);
                        break;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        return vector;
    }

    protected List getVolumes(NIVolumeGroupID nIVolumeGroupID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        NIVolumeID[] nIVolumeIDArray = new NIVolumeID[]{};
        NIVolumeGroupID[] nIVolumeGroupIDArray = new NIVolumeGroupID[]{nIVolumeGroupID};
        NIVolumeGroup nIVolumeGroup = null;
        try {
            nIVolumeGroup = (NIVolumeGroup)this.logicalService.getVolumeGroups(nIVolumeGroupIDArray).getResourceList().get(0);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        return nIVolumeGroup.getVolumeGroupList().getVolumesInVolumeGroup();
    }

    protected List getVolumes(NIVolumeGroupID nIVolumeGroupID, NIDeviceType nIDeviceType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Serializable serializable;
        NILSSID[] nILSSIDArray;
        NIVolumeGroupID[] nIVolumeGroupIDArray = new NIVolumeGroupID[]{nIVolumeGroupID};
        NIVolumeGroup nIVolumeGroup = null;
        Vector<NIVolumeID> vector = new Vector<NIVolumeID>();
        try {
            nIVolumeGroup = (NIVolumeGroup)this.logicalService.getVolumeGroups(nIVolumeGroupIDArray).getResourceList().get(0);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        HashSet<NILSSID[]> hashSet = new HashSet<NILSSID[]>();
        Vector vector2 = nIVolumeGroup.getVolumeGroupList().getVolumesInVolumeGroup();
        NIVolumeID[] nIVolumeIDArray = vector2.toArray(new NIVolumeID[0]);
        if (nIVolumeIDArray.length == 0) {
            return vector;
        }
        int n = 0;
        while (n < nIVolumeIDArray.length) {
            nILSSIDArray = nIVolumeIDArray[n].getLSS();
            hashSet.add(nILSSIDArray);
            ++n;
        }
        nILSSIDArray = hashSet.toArray(new NILSSID[0]);
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.logicalService.getLogicalSubsystems(nILSSIDArray);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        List list = null;
        NILSS[] nILSSArray = new NILSS[]{};
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        nILSSArray = list.toArray(new NILSS[0]);
        HashSet<NILSSID> hashSet2 = new HashSet<NILSSID>();
        int n2 = 0;
        while (n2 < nILSSArray.length) {
            NILSSID nILSSID = (NILSSID)nILSSArray[n2].getID();
            serializable = nILSSArray[n2].getDeviceType();
            if (serializable instanceof NIDeviceTypeFB) {
                hashSet2.add(nILSSID);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < nIVolumeIDArray.length) {
            serializable = nIVolumeIDArray[n3].getLSS();
            if (hashSet2.contains(serializable)) {
                vector.add(nIVolumeIDArray[n3]);
            }
            ++n3;
        }
        return vector;
    }

    protected List getHostAttachments(NIImageHostAttachment[] nIImageHostAttachmentArray, NIVolumeGroupID nIVolumeGroupID) {
        Vector<NIImageHostAttachment> vector = new Vector<NIImageHostAttachment>();
        int n = nIImageHostAttachmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            NIVolumeGroupID nIVolumeGroupID2 = nIImageHostAttachmentArray[n2].getVolumeGroup();
            if (nIVolumeGroupID2 != null && nIVolumeGroupID2.equals(nIVolumeGroupID)) {
                vector.add(nIImageHostAttachmentArray[n2]);
            }
            ++n2;
        }
        return vector;
    }

    protected List getSCSIHostTypeList() {
        Vector<NIHostType> vector = new Vector<NIHostType>();
        int n = 0;
        while (n < 27) {
            if (n != 25 && n != 26) {
                String string = NIHostConstants.getHostInfo(n, 0);
                String string2 = NIHostConstants.getHostInfo(n, 1);
                String string3 = NIHostConstants.getHostInfo(n, 2);
                int n2 = Integer.parseInt(NIHostConstants.getHostInfo(n, 3));
                int n3 = Integer.parseInt(NIHostConstants.getHostInfo(n, 4));
                NIHostType nIHostType = new NIHostType(string, string2, string3, n2, n3);
                vector.add(nIHostType);
            }
            ++n;
        }
        return vector;
    }

    protected NIVolumeGroupType getVolumeGroupType(NIHostType nIHostType) throws NIParameterInvalidCAException {
        NIVolumeGroupType nIVolumeGroupType = NIVolumeGroupTypeSCSIAll.Option;
        int n = nIHostType.getLogicalSize();
        int n2 = nIHostType.getAddressDiscovery();
        if (n == Integer.parseInt(NIHostConstants.BLOCK_512)) {
            if (n2 == Integer.parseInt(NIHostConstants.LUN_POLLING)) {
                nIVolumeGroupType = NIVolumeGroupTypeSCSIMap256.Option;
            } else if (n2 == Integer.parseInt(NIHostConstants.REPORT_LUN)) {
                nIVolumeGroupType = NIVolumeGroupTypeSCSIMask.Option;
            }
        } else if (n == Integer.parseInt(NIHostConstants.BLOCK_520)) {
            nIVolumeGroupType = NIVolumeGroupTypeSCSI520Mask.Option;
        }
        return nIVolumeGroupType;
    }

    protected List getCompatibleHostTypes(NIVolumeGroupType nIVolumeGroupType) throws NIParameterInvalidCAException {
        int n = -1;
        int n2 = -1;
        if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIAll) {
            n = Integer.parseInt(NIHostConstants.BLOCK_512);
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMap256) {
            n = Integer.parseInt(NIHostConstants.BLOCK_512);
            n2 = Integer.parseInt(NIHostConstants.LUN_POLLING);
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIMask) {
            n = Integer.parseInt(NIHostConstants.BLOCK_512);
            n2 = Integer.parseInt(NIHostConstants.REPORT_LUN);
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520All) {
            n = Integer.parseInt(NIHostConstants.BLOCK_520);
        } else if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520Mask) {
            n = Integer.parseInt(NIHostConstants.BLOCK_520);
            n2 = Integer.parseInt(NIHostConstants.REPORT_LUN);
        }
        Vector<NIHostType> vector = new Vector<NIHostType>();
        int n3 = 0;
        while (n3 < 27) {
            if (n3 != 25 && n3 != 26) {
                int n4 = Integer.parseInt(NIHostConstants.getHostInfo(n3, 3));
                int n5 = Integer.parseInt(NIHostConstants.getHostInfo(n3, 4));
                if (n5 == n && (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIAll || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520All || n4 == n2)) {
                    String string = NIHostConstants.getHostInfo(n3, 0);
                    String string2 = NIHostConstants.getHostInfo(n3, 1);
                    String string3 = NIHostConstants.getHostInfo(n3, 2);
                    NIHostType nIHostType = new NIHostType(string, string2, string3, n4, n5);
                    vector.add(nIHostType);
                }
            }
            ++n3;
        }
        return vector;
    }

    protected List getAvailableHostAttachments(NIImageHostAttachment[] nIImageHostAttachmentArray, NIVolumeGroupType nIVolumeGroupType) throws NIParameterInvalidCAException {
        int n = nIImageHostAttachmentArray.length;
        Vector<NIImageHostAttachment> vector = new Vector<NIImageHostAttachment>();
        int n2 = 0;
        while (n2 < n) {
            NIHostType nIHostType;
            NIVolumeGroupType nIVolumeGroupType2;
            if (nIImageHostAttachmentArray[n2].getVolumeGroup() == null && (nIVolumeGroupType2 = this.getVolumeGroupType(nIHostType = nIImageHostAttachmentArray[n2].getHostType())) == nIVolumeGroupType) {
                vector.add(nIImageHostAttachmentArray[n2]);
            }
            ++n2;
        }
        return vector;
    }

    protected NIVolumeGroup getFutureVolumeGroup(NIESSID nIESSID, String string, NIHostType[] nIHostTypeArray, NIImageHostAttachment[] nIImageHostAttachmentArray, NIVolume[] nIVolumeArray) throws NIParameterInvalidCAException {
        Serializable serializable;
        NIVolumeGroup nIVolumeGroup = null;
        int n = -1;
        int n2 = -1;
        boolean bl = true;
        NIVolumeGroupType nIVolumeGroupType = NIVolumeGroupTypeSCSIAll.Option;
        NIHostType nIHostType = nIHostTypeArray[0];
        n = nIHostType.getAddressDiscovery();
        n2 = nIHostType.getLogicalSize();
        int n3 = 1;
        while (n3 < nIHostTypeArray.length) {
            serializable = nIHostTypeArray[n3];
            if (n != ((NIHostType)serializable).getAddressDiscovery() || n2 != ((NIHostType)serializable).getLogicalSize()) {
                bl = false;
            }
            ++n3;
        }
        if (!bl) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("Invalid Host Type");
            logger.debug_general(((StringBuffer)serializable).toString());
            throw new NIParameterInvalidCAException(nIHostTypeArray, "Invalid Host Type");
        }
        if (n == Integer.parseInt(NIHostConstants.REPORT_LUN) && n2 == Integer.parseInt(NIHostConstants.BLOCK_512)) {
            nIVolumeGroupType = NIVolumeGroupTypeSCSIMask.Option;
        } else if (n == Integer.parseInt(NIHostConstants.LUN_POLLING) && n2 == Integer.parseInt(NIHostConstants.BLOCK_512)) {
            nIVolumeGroupType = NIVolumeGroupTypeSCSIMap256.Option;
        } else if (n == Integer.parseInt(NIHostConstants.REPORT_LUN) && n2 == Integer.parseInt(NIHostConstants.BLOCK_520)) {
            nIVolumeGroupType = NIVolumeGroupTypeSCSI520Mask.Option;
        }
        if (nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIAll || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520All) {
            nIVolumeGroup = NIResourceFactory.newVolumeGroup(nIESSID, string, nIVolumeGroupType);
        } else {
            serializable = null;
            int n4 = 0;
            if (nIVolumeArray != null && nIVolumeArray.length > 0) {
                n4 = nIVolumeArray.length;
            }
            NIVolumeID[] nIVolumeIDArray = new NIVolumeID[n4];
            int n5 = 0;
            while (n5 < n4) {
                nIVolumeIDArray[n5] = (NIVolumeID)nIVolumeArray[n5].getID();
                ++n5;
            }
            try {
                serializable = NIResourceFactory.newVolumeGroupVolumeList(nIVolumeIDArray, nIVolumeGroupType);
            }
            catch (NIParameterInvalidServerException nIParameterInvalidServerException) {
                logger.throwable((Throwable)nIParameterInvalidServerException);
                throw new NIParameterInvalidCAException(nIVolumeArray, "The number of volumes passed in is not valid for the group type");
            }
            nIVolumeGroup = NIResourceFactory.newVolumeGroup(nIESSID, string, nIVolumeGroupType);
            nIVolumeGroup.setVolumeGroupList((NIVolumeGroupVolumeList)serializable);
        }
        return nIVolumeGroup;
    }

    protected NIVolumeGroup getVolumeGroupForModify(NIVolumeGroup nIVolumeGroup, NIVolumeGroupID nIVolumeGroupID) throws NIParameterInvalidCAException {
        NIVolumeGroupVolumeList nIVolumeGroupVolumeList = nIVolumeGroup.getVolumeGroupList();
        NIVolumeGroupImpl nIVolumeGroupImpl = null;
        if (nIVolumeGroupVolumeList != null) {
            nIVolumeGroupImpl = new NIVolumeGroupImpl(nIVolumeGroupID, nIVolumeGroup.getUserName(), nIVolumeGroup.getType(), nIVolumeGroupVolumeList);
        }
        return nIVolumeGroupImpl;
    }

    protected List getImageHostAttachments(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException {
        NIEnterpriseAdvisorHostManager nIEnterpriseAdvisorHostManager = new NIEnterpriseAdvisorHostManager();
        NIConfigQueryResult nIConfigQueryResult = null;
        Vector vector = new Vector();
        try {
            nIConfigQueryResult = this.hostService.getSCSIHostPorts(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIServerException(0, nullPointerException.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            vector = new Vector(nIConfigQueryResult.getResourceList());
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure");
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException("Query Failure");
        }
        Vector<NIImageHostAttachment> vector2 = new Vector<NIImageHostAttachment>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)vector.elementAt(n2);
            String string = nISCSIHostPort.getUserHostName();
            String string2 = nISCSIHostPort.getPortProfile();
            String string3 = nISCSIHostPort.getHostType();
            int n3 = nISCSIHostPort.getLogicalBlockSize();
            int n4 = nISCSIHostPort.getAddressDiscovery();
            NIFabricTopology nIFabricTopology = nISCSIHostPort.getAttachingPortTopology();
            int n5 = nISCSIHostPort.getPortGroup();
            NIVolumeGroupID nIVolumeGroupID = nISCSIHostPort.getVolumeGroup();
            boolean bl = false;
            NIImageHostAttachment nIImageHostAttachment = null;
            int n6 = vector2.size();
            int n7 = 0;
            while (n7 < n6 && !bl) {
                nIImageHostAttachment = (NIImageHostAttachment)vector2.get(n7);
                if (nIImageHostAttachment.getHostName().equals(string) && nIImageHostAttachment.getPortProfile().equals(string2) && nIImageHostAttachment.getHostTypeString().equals(string3) && nIImageHostAttachment.getLogicalBlockSize() == n3 && nIImageHostAttachment.getAddressDiscovery() == n4 && nIImageHostAttachment.getAttachingPortTopology().equals(nIFabricTopology) && nIImageHostAttachment.getPortGroupNumber() == n5) {
                    bl = true;
                }
                ++n7;
            }
            if (!bl) {
                NIHostType nIHostType = nIEnterpriseAdvisorHostManager.getHostType(string3, string2, n3, n4);
                NIHostPortType nIHostPortType = null;
                nIHostPortType = nIFabricTopology instanceof NIFabricTopologyScsiFcp ? NIHostPortTypeSCSIFcSf.Option : NIHostPortTypeSCSIFcAl.Option;
                nIImageHostAttachment = new NIImageHostAttachment(string, string2, string3, n3, n4, nIFabricTopology, nIHostType, nIHostPortType, n5, nIVolumeGroupID);
                vector2.add(nIImageHostAttachment);
            }
            nIImageHostAttachment.addSCSIHostPort(nISCSIHostPort);
            ++n2;
        }
        return vector2;
    }

    protected int getNumberOfHostAttachments(NIImageHostAttachment[] nIImageHostAttachmentArray, NIVolumeGroup[] nIVolumeGroupArray) {
        int n = 0;
        int n2 = nIVolumeGroupArray.length;
        int n3 = nIImageHostAttachmentArray.length;
        if (n3 == 0 || n2 == 0) {
            return 0;
        }
        NIVolumeGroupID[] nIVolumeGroupIDArray = new NIVolumeGroupID[n2];
        int n4 = 0;
        while (n4 < n2) {
            nIVolumeGroupIDArray[n4] = (NIVolumeGroupID)nIVolumeGroupArray[n4].getID();
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            NIVolumeGroupID nIVolumeGroupID = nIImageHostAttachmentArray[n5].getVolumeGroup();
            if (nIVolumeGroupID != null) {
                int n6 = 0;
                while (n6 < n2) {
                    if (nIVolumeGroupID.equals(nIVolumeGroupIDArray[n6])) {
                        ++n;
                        break;
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

