/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIAddressGroup;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIAddressGroupID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model3;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model3TPF;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model6;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.services.NIDomainService;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class NIConfigurationAdvisorZSeriesLCUs {
    private static final String CLASS_NAME = "NIConfigurationAdvisorZSeriesLCUs";
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor = NIConfigurationAdvisorZSeriesLCUs.class$("com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor);
    private static final NICKDBaseCUType[] ckdBaseTypes = new NICKDBaseCUType[]{NICKDBaseCUType3990Model3.Option, NICKDBaseCUType3990Model3TPF.Option, NICKDBaseCUType3990Model6.Option};
    private NIConfigurationAdvisor ca = null;
    private NIDomainService domainService = null;
    private NILogicalConfigurationService logicalService = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor;

    protected NIConfigurationAdvisorZSeriesLCUs(NIConfigurationAdvisor nIConfigurationAdvisor) {
        this.ca = nIConfigurationAdvisor;
        this.domainService = this.ca.getDomainService();
        this.logicalService = this.ca.getLogicalService();
    }

    protected int[] getAvailableLCUIDs(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        String string = nIESSID.getType();
        if (string.equals("2107")) {
            n5 = 255;
            n6 = 16;
        } else if (string.equals("1750")) {
            n5 = 32;
            n6 = 2;
        }
        int[] nArray = new int[n5];
        Arrays.fill(nArray, -1);
        int[] nArray2 = new int[n5];
        Arrays.fill(nArray2, -1);
        boolean bl = false;
        List list = null;
        List list2 = null;
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.logicalService.getAddressGroups(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(stringBuffer.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure getAddressGroups " + nIConfigQueryResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        NIConfigQueryResult nIConfigQueryResult2 = null;
        try {
            nIConfigQueryResult2 = this.logicalService.getLogicalSubsystems(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(stringBuffer.toString());
        }
        if (nIConfigQueryResult2.getCode() == 0 && nIConfigQueryResult2.getResourceList() != null) {
            list2 = nIConfigQueryResult2.getResourceList();
        } else if (nIConfigQueryResult2.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure getLogicalSubsystems " + nIConfigQueryResult2.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        if (list2 != null) {
            n4 = list2.size();
            int n7 = 0;
            while (n7 < n4) {
                int n8;
                nArray2[n8] = n8 = ((NILSSID)((NILSS)list2.get(n7)).getID()).getLSSNumber();
                ++n7;
            }
        }
        n4 = 0;
        if (list != null) {
            n4 = list.size();
        }
        int[] nArray3 = new int[n6];
        Arrays.fill(nArray3, -1);
        int n9 = 0;
        while (n9 < n4) {
            n3 = 0;
            n2 = ((NIAddressGroupID)((NIAddressGroup)list.get(n9)).getID()).getAddressGroupNumber();
            n3 = 16;
            if (n2 == 15) {
                --n3;
            }
            nArray3[n2] = n2;
            int n10 = ((NIAddressGroupID)((NIAddressGroup)list.get(n9)).getID()).getAddressGroupNumber() * 16;
            if (((NIAddressGroup)list.get(n9)).getNumLogicalSubsystem() == 0) {
                n = 0;
                while (n < n3) {
                    nArray[n + n10] = n + n10;
                    ++n;
                }
            } else if (((NIAddressGroup)list.get(n9)).getDeviceType() instanceof NIDeviceTypeCKD && ((NIAddressGroup)list.get(n9)).getNumLogicalSubsystem() < n3) {
                n = 0;
                while (n < n3) {
                    if (nArray2[n + n10] == -1) {
                        nArray[n + n10] = n + n10;
                    }
                    ++n;
                }
            }
            ++n9;
        }
        n3 = 0;
        while (n3 < nArray3.length) {
            if (nArray3[n3] == -1) {
                n2 = 16;
                if (n3 == 15) {
                    --n2;
                }
                n = 0;
                while (n < n2) {
                    int n11;
                    nArray[n11] = n11 = n3 * 16 + n;
                    ++n;
                }
            }
            ++n3;
        }
        Arrays.sort(nArray);
        n2 = -1;
        n = 0;
        while (n < nArray.length) {
            if (nArray[n] != -1) {
                n2 = n;
                break;
            }
            ++n;
        }
        int[] nArray4 = new int[]{};
        if (n2 != -1) {
            nArray4 = new int[nArray.length - n2];
            int n12 = 0;
            while (n12 < nArray4.length) {
                nArray4[n12] = nArray[n12 + n2];
                ++n12;
            }
        }
        return nArray4;
    }

    protected boolean validateSsid(NIStorageFacilityID nIStorageFacilityID, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        if (n < 1 || n > 65535) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Invalid SSID ssid: " + n);
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException((Object)stringBuffer.toString());
        }
        boolean bl = true;
        List list = this.ca.getExistingLSSs(nIStorageFacilityID);
        Vector vector = new Vector(list);
        int n2 = 0;
        if (vector != null) {
            n2 = vector.size();
            Collections.sort(vector, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n = 0;
                    NILSS nILSS = (NILSS)object;
                    NILSS nILSS2 = (NILSS)object2;
                    int n2 = ((NILSSID)nILSS.getID()).getSSID();
                    int n3 = ((NILSSID)nILSS2.getID()).getSSID();
                    n = n2 - n3;
                    return n;
                }
            });
        }
        int n3 = 0;
        while (n3 < n2 && bl) {
            int n4 = ((NILSSID)((NILSS)vector.get(n3)).getID()).getSSID();
            if (n < n4) break;
            if (n4 == n) {
                bl = false;
            }
            ++n3;
        }
        return bl;
    }

    protected List getLcuTypeList() {
        Vector<NICKDBaseCUType> vector = new Vector<NICKDBaseCUType>(Arrays.asList(ckdBaseTypes));
        return vector;
    }

    protected List getFutureLcus(NIESSID nIESSID, int[] nArray, int n, NICKDBaseCUType nICKDBaseCUType) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        int n2;
        int n3 = 0;
        String string = nIESSID.getType();
        if (string.equals("2107")) {
            n3 = 16;
        } else if (string.equals("1750")) {
            n3 = 2;
        }
        Vector vector = new Vector();
        List list = null;
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = this.logicalService.getAddressGroups(nIESSID);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(stringBuffer.toString());
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            list = nIConfigQueryResult.getResourceList();
        } else if (nIConfigQueryResult.getCode() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Query Failure getAddressGroups " + nIConfigQueryResult.getCode());
            logger.debug_general(stringBuffer.toString());
            throw new NIQueryFailureCAException(stringBuffer.toString());
        }
        boolean[] blArray = new boolean[n3];
        Arrays.fill(blArray, false);
        int[] nArray2 = null;
        int n4 = list.size();
        nArray2 = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            nArray2[n5] = ((NIAddressGroupID)((NIAddressGroup)list.get(n5)).getID()).getAddressGroupNumber();
            ++n5;
        }
        if (nArray != null) {
            int n6 = 0;
            while (n6 < nArray.length) {
                n2 = nArray[n6] / 16;
                int n7 = 0;
                while (n7 < nArray2.length) {
                    if (n2 == nArray2[n7]) {
                        blArray[n2] = true;
                        break;
                    }
                    ++n7;
                }
                ++n6;
            }
            n5 = 0;
            while (n5 < n4) {
                if (blArray[nArray2[n5]] && !(((NIAddressGroup)list.get(n5)).getDeviceType() instanceof NIDeviceTypeCKD)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Invalid Device Type " + ((NIAddressGroup)list.get(n5)).getDeviceType().getClass());
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException((Object)stringBuffer.toString());
                }
                ++n5;
            }
        }
        n2 = 0;
        if (nArray != null) {
            n2 = nArray.length;
        }
        NIDeviceTypeCKD nIDeviceTypeCKD = NIDeviceTypeCKD.Option;
        Vector<NILSS> vector2 = new Vector<NILSS>();
        int[] nArray3 = this.ca.getNextAvailableSSID(nIESSID.getStorageFacility(), n2, n);
        n5 = 0;
        while (n5 < nArray3.length) {
            NILSS nILSS = NIResourceFactory.newLSS(nIESSID, nArray[n5], nArray3[n5], nIDeviceTypeCKD, nICKDBaseCUType);
            vector2.add(nILSS);
            ++n5;
        }
        return vector2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

