/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor;
import com.ibm.storage.ess.ni.ca.NIConfigurationAdvisorExtentPool;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIQueryFailureCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnknownCAException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NICKDAddressPolicy;
import com.ibm.storage.ess.ni.option.config.NICKDAddressPolicySequential;
import com.ibm.storage.ess.ni.option.config.NICKDAddressPolicySpread;
import com.ibm.storage.ess.ni.option.config.NICKDAddressPolicySpreadWithLimit;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType3380Mod2;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType3380Mod3;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType3390Custom;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType3390Mod3;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeType3390Mod9;
import com.ibm.storage.ess.ni.option.config.NICKDVolumeTypeUnknown;
import com.ibm.storage.ess.ni.option.config.NIDataType;
import com.ibm.storage.ess.ni.option.config.NIDataType3380;
import com.ibm.storage.ess.ni.option.config.NIDataType3390;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDBase;
import com.ibm.storage.ess.ni.resource.NIVolumeImpl;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class NIConfigurationAdvisorZSeriesVolumes {
    private static final NICKDVolumeType[] ckdVolumeTypes = new NICKDVolumeType[]{NICKDVolumeType3380Mod2.Option, NICKDVolumeType3380Mod3.Option, NICKDVolumeType3390Custom.Option, NICKDVolumeType3390Mod3.Option, NICKDVolumeType3390Mod9.Option};
    private static final long cyl_mod3_min = 1L;
    private static final long cyl_mod3_max = 3339L;
    private static final long cyl_mod9_min = 3340L;
    private static final long cyl_mod9_max = 65520L;
    private NIConfigurationAdvisor ca = null;
    private NILogicalConfigurationService logicalService = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor == null ? (class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor = NIConfigurationAdvisorZSeriesVolumes.class$("com.ibm.storage.ess.ni.ca.NIConfigurationAdvisor")) : class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIConfigurationAdvisor;

    protected NIConfigurationAdvisorZSeriesVolumes(NIConfigurationAdvisor nIConfigurationAdvisor) {
        this.ca = nIConfigurationAdvisor;
        this.logicalService = this.ca.getLogicalService();
    }

    protected NICKDVolumeType getCKDVolumeType(NIVolume nIVolume) throws NIParameterInvalidCAException {
        NICKDVolumeType nICKDVolumeType = NICKDVolumeTypeUnknown.Option;
        NIDataType nIDataType = nIVolume.getDataType();
        int n = nIVolume.getMTM();
        if (nIDataType != null) {
            if (nIDataType instanceof NIDataType3380) {
                if (n == 40) {
                    nICKDVolumeType = NICKDVolumeType3380Mod2.Option;
                } else if (n == 41) {
                    nICKDVolumeType = NICKDVolumeType3380Mod3.Option;
                }
            } else if (nIDataType instanceof NIDataType3390) {
                nICKDVolumeType = n == 42 && nIVolume.getCapacity() == NICKDVolumeType3390Mod3.Option.getStorageCylinder() ? NICKDVolumeType3390Mod3.Option : (n == 43 && nIVolume.getCapacity() == NICKDVolumeType3390Mod9.Option.getStorageCylinder() ? NICKDVolumeType3390Mod9.Option : NICKDVolumeType3390Custom.Option);
            }
        }
        return nICKDVolumeType;
    }

    protected List getCkdVolumeTypeList() {
        Vector<NICKDVolumeType> vector = new Vector<NICKDVolumeType>(Arrays.asList(ckdVolumeTypes));
        return vector;
    }

    protected List getAvailableLcusForVolumes(NILSS[] nILSSArray, NIExtentPool nIExtentPool) throws NIParameterInvalidCAException, NIUnknownCAException {
        NIESSID nIESSID = null;
        try {
            nIESSID = ((NIExtentPoolID)nIExtentPool.getID()).getESS();
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        Vector<NILSS> vector = new Vector<NILSS>();
        if (nILSSArray != null) {
            boolean bl = this.ca.checkAllLSS(nIESSID, nILSSArray);
            if (!bl) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("EssIDs don't match");
                logger.debug_general(stringBuffer.toString());
                throw new NIParameterInvalidCAException(nIESSID, "EssIDs don't match");
            }
            int n = nILSSArray.length;
            vector = new Vector(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4;
                NILSS nILSS = nILSSArray[n2];
                if (nILSS != null && nILSS.getDeviceType() instanceof NIDeviceTypeCKD && nILSS.getConfiguredDevices() < 256 && (n4 = ((NILSSID)nILSS.getID()).getLSSGroupID()) == (n3 = nIExtentPool.getRankGroup())) {
                    vector.add(nILSS);
                }
                ++n2;
            }
        }
        return vector;
    }

    protected int getMaxCkdVolumeQuantity(NIExtentPool nIExtentPool, NILSS[] nILSSArray, NICKDVolumeType nICKDVolumeType) throws NIServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        int n = NIConfigurationAdvisorZSeriesVolumes.getVolSize(nICKDVolumeType);
        if (n == -1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Invalid Volume Type");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nICKDVolumeType, "Invalid Volume Type");
        }
        int n2 = 0;
        if (nILSSArray != null) {
            n2 = this.getMaxCkdCustomVolumeQuantity(nIExtentPool, nILSSArray, n);
        }
        return n2;
    }

    protected int getMaxCkdCustomVolumeQuantity(NIExtentPool nIExtentPool, NILSS[] nILSSArray, int n) throws NIServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        Serializable serializable;
        int n2;
        NIESSID nIESSID = null;
        try {
            nIESSID = ((NIExtentPoolID)nIExtentPool.getID()).getESS();
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nILSSArray != null) {
            n2 = 0;
            while (n2 < nILSSArray.length) {
                serializable = nILSSArray[n2];
                if (!((NILSSID)serializable.getID()).getESS().equals(nIESSID)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("EssIDs don't match");
                    logger.debug_general(stringBuffer.toString());
                    throw new NIParameterInvalidCAException(nIESSID, "EssIDs don't match");
                }
                ++n2;
            }
        }
        if ((n2 = this.getCkdExtentSize(nIExtentPool)) == -1 || nILSSArray != null && !this.verifyCkdExtentType(nILSSArray)) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("Invalid Extent Type");
            logger.debug_general(((StringBuffer)serializable).toString());
            throw new NIParameterInvalidCAException(nIExtentPool, "Invalid Extent Type");
        }
        if (n == 0) {
            n = 1;
        }
        int n3 = this.getVolumeExtents(n);
        int n4 = 0;
        if (nILSSArray != null) {
            n4 = this.getAvailableAddresses(nILSSArray, nIExtentPool);
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this.ca);
        int n5 = nIConfigurationAdvisorExtentPool.getAvailableExtents(nIExtentPool);
        int n6 = n5 / n3;
        return Math.min(n4, n6);
    }

    protected int getMaxCkdCustomVolSize(NIExtentPool nIExtentPool, NILSS[] nILSSArray, int n) throws NIServerException, NIQueryFailureCAException, NIParameterInvalidCAException, NIUnknownCAException {
        int n2;
        NIESSID nIESSID = null;
        try {
            nIESSID = ((NIExtentPoolID)nIExtentPool.getID()).getESS();
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nullPointerException.toString());
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException(nullPointerException.toString());
        }
        if (nILSSArray != null && (n2 = (int)(this.ca.checkAllLSS(nIESSID, nILSSArray) ? 1 : 0)) == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("EssIDs don't match");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, "EssIDs don't match");
        }
        n2 = this.getCkdExtentSize(nIExtentPool);
        int n3 = 0;
        boolean bl = false;
        if (n2 == -1 || nILSSArray != null && !this.verifyCkdExtentType(nILSSArray)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Invalid Extent Type");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIExtentPool, "Invalid Extent Type");
        }
        NIConfigurationAdvisorExtentPool nIConfigurationAdvisorExtentPool = new NIConfigurationAdvisorExtentPool(this.ca);
        int n4 = nIConfigurationAdvisorExtentPool.getAvailableExtents(nIExtentPool);
        if (n4 > 0) {
            n3 = n4 / n;
        }
        int n5 = n3 * 1113;
        return Math.min(65520, n5);
    }

    protected int getAvailableAddresses(NILSS[] nILSSArray, NIExtentPool nIExtentPool) throws NIParameterInvalidCAException, NIUnknownCAException {
        Vector vector = new Vector(this.getAvailableLcusForVolumes(nILSSArray, nIExtentPool));
        int n = 0;
        int n2 = 0;
        n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            NILSS nILSS = (NILSS)vector.get(n3);
            n += 256 - nILSS.getConfiguredDevices();
            ++n3;
        }
        return n;
    }

    protected int[] getVolumeAddresses(NILSS[] nILSSArray, NIExtentPool nIExtentPool) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException, NIParameterInvalidCAException {
        Vector vector = new Vector(this.getAvailableLcusForVolumes(nILSSArray, nIExtentPool));
        int n = this.getAvailableAddresses(nILSSArray, nIExtentPool);
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        n3 = vector.size();
        int n4 = 0;
        while (n4 < n3) {
            NILSS nILSS = (NILSS)vector.get(n4);
            NILSSID nILSSID = (NILSSID)nILSS.getID();
            int[] nArray2 = new int[256];
            nArray2 = this.ca.getVolAddrTable(nILSSID);
            int n5 = 256 - nILSS.getConfiguredDevices();
            int[] nArray3 = this.getAvailableVolumeNum(nArray2, n5);
            int n6 = nILSSID.getLSSNumber();
            int n7 = n6 << 8;
            int n8 = 0;
            while (n8 < nArray3.length) {
                nArray[n2] = n7 + nArray3[n8];
                if (++n2 == n) break;
                ++n8;
            }
            ++n4;
        }
        return nArray;
    }

    protected List getFutureCkdBaseVolumes(NIESSID nIESSID, NICKDVolumeType nICKDVolumeType, NIExtentPool nIExtentPool, NILSS[] nILSSArray, int n, int n2, int n3, boolean bl, NICKDAddressPolicy nICKDAddressPolicy, int n4, int n5, boolean bl2, String string, String string2, boolean bl3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        boolean bl4;
        if (nILSSArray != null && !(bl4 = this.ca.checkAllLSS(nIESSID, nILSSArray))) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("EssIDs don't match");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, "EssIDs don't match");
        }
        Vector<NIVolumeImpl> vector = new Vector<NIVolumeImpl>();
        Vector vector2 = new Vector();
        if (nICKDAddressPolicy == null) {
            nICKDAddressPolicy = NICKDAddressPolicySequential.Option;
        }
        if (n4 > 0 && (nILSSArray == null || nILSSArray.length < n4)) {
            return vector2;
        }
        int n6 = 0;
        if (bl2 && string2 != null && !string2.equals("")) {
            n6 = bl3 ? Integer.parseInt(string2) : Integer.parseInt(string2, 16);
        }
        NIDataType nIDataType = null;
        if (nICKDVolumeType instanceof NICKDVolumeType3380Mod2 || nICKDVolumeType instanceof NICKDVolumeType3380Mod3) {
            nIDataType = NIDataType3380.Option;
        } else if (nICKDVolumeType instanceof NICKDVolumeType3390Mod3 || nICKDVolumeType instanceof NICKDVolumeType3390Mod9 || nICKDVolumeType instanceof NICKDVolumeType3390Custom) {
            nIDataType = NIDataType3390.Option;
        }
        long l = 0L;
        int n7 = 0;
        if (nICKDVolumeType instanceof NICKDVolumeType3390Custom) {
            l = n2;
            if ((long)n2 >= 1L && (long)n2 >= 3339L) {
                n7 = 42;
            } else if ((long)n2 >= 3340L && (long)n2 >= 65520L) {
                n7 = 43;
            }
        } else {
            l = nICKDVolumeType.getStorageCylinder();
            n7 = nICKDVolumeType.getMTMValue();
        }
        int n8 = this.getMaxCkdCustomVolumeQuantity(nIExtentPool, nILSSArray, (int)l);
        if (n8 < n) {
            return vector2;
        }
        Vector vector3 = this.getCompatibleLCUs(nILSSArray, nIExtentPool);
        Hashtable hashtable = this.populateLSSTable(vector3, n4);
        int n9 = 0;
        Vector vector4 = new Vector(hashtable.keySet());
        int n10 = 0;
        while (n10 < n4 && n9 < n) {
            int n11;
            int n12;
            int n13;
            NILSS nILSS = (NILSS)vector4.elementAt(n10);
            int[] nArray = new int[256];
            Arrays.fill(nArray, -1);
            Vector vector5 = (Vector)hashtable.get(nILSS);
            if (vector5 != null) {
                n13 = vector5.size();
                n12 = 0;
                while (n12 < n13) {
                    nArray[n11] = n11 = ((Integer)vector5.elementAt(n12)).intValue();
                    ++n12;
                }
            }
            n13 = -1;
            n12 = 0;
            if (nICKDAddressPolicy instanceof NICKDAddressPolicySpread) {
                n12 = 1;
            } else if (nICKDAddressPolicy instanceof NICKDAddressPolicySpreadWithLimit) {
                n12 = n5 - n3 + 1;
            } else if (nICKDAddressPolicy instanceof NICKDAddressPolicySequential) {
                n12 = 256 - nILSS.getConfiguredDevices();
            }
            n11 = 0;
            while (n11 < n12) {
                if (nICKDAddressPolicy instanceof NICKDAddressPolicySpreadWithLimit) {
                    n13 = this.ca.getNextVolNum(nArray, n3, bl, n5);
                    if (n13 > n5) {
                        break;
                    }
                } else {
                    n13 = this.ca.getNextVolNum(nArray, n3, bl);
                }
                if (n13 == -1) break;
                nArray[n13] = n13;
                vector5.add(new Integer(n13));
                String string3 = new String();
                if (bl2) {
                    if (string != null) {
                        string3 = string3 + string;
                    }
                    if (string2 != null && !string2.equals("")) {
                        string3 = string3 + this.ca.padding(n6, string2.length(), bl3);
                        ++n6;
                    }
                }
                NIVolumeTypeCKDBase nIVolumeTypeCKDBase = NIVolumeTypeCKDBase.Option;
                NIVolumeImpl nIVolumeImpl = new NIVolumeImpl(new NIVolumeID((NILSSID)nILSS.getID(), n13), string3, null, null, null, (NIExtentPoolID)nIExtentPool.getID(), false, nIVolumeTypeCKDBase, nIDataType, l, n7, 0, 0, 0);
                vector.add(nIVolumeImpl);
                hashtable.put(nILSS, vector5);
                if (++n9 == n) break;
                ++n11;
            }
            if (nICKDAddressPolicy instanceof NICKDAddressPolicySpread && n9 < n && n10 == vector3.size() - 1) {
                n10 = -1;
            }
            ++n10;
        }
        return vector;
    }

    protected List getFutureCkdAliasVolumes(NIESSID nIESSID, NILSS nILSS, NIVolume[] nIVolumeArray, NIVolume[] nIVolumeArray2, int n, boolean bl, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        if (n < 0 || n > 255) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Invalid Starting Address");
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException("Invalid Starting Address");
        }
        NILSSID nILSSID = (NILSSID)nILSS.getID();
        if (!nILSSID.getESS().equals(nIESSID)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("EssIDs don't match");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, "EssIDs don't match");
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        NILSS[] nILSSArray = new NILSS[]{nILSS};
        if (nIVolumeArray == null) {
            return vector2;
        }
        int n4 = nIVolumeArray.length;
        int n5 = nILSS.getAddressGroupID().getAddressGroupNumber();
        int n6 = 0;
        while (n6 < n4) {
            if (n5 != nIVolumeArray[n6].getAddressGroup().getAddressGroupNumber()) {
                return vector2;
            }
            ++n6;
        }
        int n7 = -1;
        if (nILSSID != null) {
            n7 = nILSSID.getLSSGroupID();
        }
        if (nIVolumeArray != null) {
            n6 = 0;
            while (n6 < n4) {
                int n8 = -1;
                try {
                    n8 = ((NIVolumeID)nIVolumeArray[n6].getID()).getLSS().getLSSGroupID();
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(numberFormatException.toString());
                    logger.debug_general(stringBuffer.toString());
                    throw new NIUnknownCAException(numberFormatException.toString());
                }
                if (n7 != n8) {
                    return vector2;
                }
                ++n6;
            }
        }
        NIVolumeID[] nIVolumeIDArray = new NIVolumeID[nIVolumeArray.length];
        int[] nArray = new int[nIVolumeArray.length];
        int n9 = 0;
        while (n9 < nIVolumeArray.length) {
            NIVolumeID nIVolumeID;
            nIVolumeIDArray[n9] = nIVolumeID = (NIVolumeID)nIVolumeArray[n9].getID();
            nArray[n9] = nIVolumeID.getVolNumber();
            ++n9;
        }
        vector = new Vector(this.getAliasVolumes(nILSS, nIVolumeIDArray, nArray, nIVolumeArray2, n, bl, n2, n3));
        return vector;
    }

    protected List getFutureCkdAliasVolumes(NIESSID nIESSID, NILSS nILSS, int[] nArray, NIVolume[] nIVolumeArray, int n, boolean bl, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        if (n < 0 || n > 255) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Invalid Starting Address");
            logger.debug_general(stringBuffer.toString());
            throw new NIUnknownCAException("Invalid Starting Address");
        }
        NILSSID nILSSID = (NILSSID)nILSS.getID();
        if (!nILSSID.getESS().equals(nIESSID)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("EssIDs don't match");
            logger.debug_general(stringBuffer.toString());
            throw new NIParameterInvalidCAException(nIESSID, "EssIDs don't match");
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        NILSS[] nILSSArray = new NILSS[]{nILSS};
        if (nArray == null) {
            return vector2;
        }
        int n4 = nArray.length;
        NIVolumeID[] nIVolumeIDArray = new NIVolumeID[n4];
        int n5 = 0;
        while (n5 < n4) {
            nIVolumeIDArray[n5] = new NIVolumeID(nILSSID, nArray[n5]);
            ++n5;
        }
        vector = new Vector(this.getAliasVolumes(nILSS, nIVolumeIDArray, nArray, nIVolumeArray, n, bl, n2, n3));
        return vector;
    }

    protected List getCompatibleCKDVolumeType(NIVolume nIVolume) throws NIParameterInvalidCAException {
        Vector<NICKDVolumeType> vector = new Vector<NICKDVolumeType>();
        NICKDVolumeType nICKDVolumeType = this.getCKDVolumeType(nIVolume);
        if (nICKDVolumeType instanceof NICKDVolumeType3380Mod2) {
            vector.add(NICKDVolumeType3380Mod3.Option);
        } else if (nICKDVolumeType instanceof NICKDVolumeType3380Mod3) {
            vector.add(NICKDVolumeType3380Mod2.Option);
        } else if (nICKDVolumeType instanceof NICKDVolumeType3390Mod3) {
            vector.add(NICKDVolumeType3390Mod9.Option);
            vector.add(NICKDVolumeType3390Custom.Option);
        } else if (nICKDVolumeType instanceof NICKDVolumeType3390Mod9) {
            vector.add(NICKDVolumeType3390Mod3.Option);
            vector.add(NICKDVolumeType3390Custom.Option);
        } else if (nICKDVolumeType instanceof NICKDVolumeType3390Custom) {
            long l = nIVolume.getCapacity();
            if (l <= 3339L) {
                vector.add(NICKDVolumeType3390Mod3.Option);
                vector.add(NICKDVolumeType3390Mod9.Option);
            } else if (l <= 10017L) {
                vector.add(NICKDVolumeType3390Mod9.Option);
            }
        }
        return vector;
    }

    protected NIVolume setCKDVolumeType(NIVolume nIVolume, NICKDVolumeType nICKDVolumeType) throws NIParameterInvalidCAException {
        int n = nICKDVolumeType.getMTMValue();
        int n2 = nIVolume.getMTM();
        NIVolume nIVolume2 = nIVolume;
        return nIVolume2;
    }

    private List getAliasVolumes(NILSS nILSS, NIVolumeID[] nIVolumeIDArray, int[] nArray, NIVolume[] nIVolumeArray, int n, boolean bl, int n2, int n3) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIQueryFailureCAException, NIUnknownCAException {
        int n4;
        int n5;
        Vector<NIVolume> vector = new Vector<NIVolume>();
        Vector vector2 = new Vector();
        int n6 = 0;
        int n7 = 0;
        int n8 = n;
        NILSS[] nILSSArray = new NILSS[]{nILSS};
        NILSSID nILSSID = (NILSSID)nILSS.getID();
        int[] nArray2 = this.ca.getVolAddrTable(nILSSID);
        if (nArray != null) {
            n5 = 0;
            while (n5 < nArray.length) {
                nArray2[nArray[n5]] = nArray[n5];
                ++n5;
            }
        }
        if (nIVolumeArray != null && nIVolumeArray.length > 0) {
            n5 = 0;
            while (n5 < nIVolumeArray.length) {
                n4 = ((NIVolumeID)nIVolumeArray[n5].getID()).getVolNumber();
                if (nILSSID.compareTo(((NIVolumeID)nIVolumeArray[n5].getID()).getLSS()) == 0) {
                    nArray2[n4] = n4;
                }
                ++n5;
            }
        }
        if (n2 >= n3) {
            n6 = n2 / n3;
            n7 = 1;
        } else {
            n6 = 1;
            n7 = n3 / n2;
        }
        n5 = 0;
        while (n5 < nArray.length) {
            if (n5 % n7 == 0) {
                n4 = 0;
                while (n4 < n6) {
                    if ((n8 = this.ca.getNextVolNum(nArray2, n8, bl)) == -1) {
                        return vector2;
                    }
                    nArray2[n8] = n8;
                    NIVolume nIVolume = NIResourceFactory.newVolume(nILSSID, n8, nIVolumeIDArray[n5], NIConfigurationAdvisor.ALIAS_TYPE, "", null);
                    vector.add(nIVolume);
                    ++n4;
                }
            }
            ++n5;
        }
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = 0;
                NIVolume nIVolume = (NIVolume)object;
                NIVolume nIVolume2 = (NIVolume)object2;
                int n2 = nIVolume.getOriginalBaseVolumeID().getVolNumber();
                int n3 = nIVolume2.getOriginalBaseVolumeID().getVolNumber();
                n = n2 - n3;
                return n;
            }
        });
        return vector;
    }

    protected static int getVolSize(NICKDVolumeType nICKDVolumeType) {
        int n = 0;
        n = (int)nICKDVolumeType.getStorageCylinder();
        return n;
    }

    private int getCkdExtentSize(NIExtentPool nIExtentPool) {
        int n = -1;
        if (nIExtentPool.getExtentType() instanceof NIExtentTypeCKD) {
            n = 1113;
        }
        return n;
    }

    private boolean verifyCkdExtentType(NILSS[] nILSSArray) {
        boolean bl = true;
        int n = nILSSArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!(nILSSArray[n2].getDeviceType() instanceof NIDeviceTypeCKD)) {
                bl = false;
            }
            ++n2;
        }
        return bl;
    }

    private int[] getAvailableVolumeNum(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] == -1) {
                nArray2[n2] = n3;
                ++n2;
            }
            if (n2 == n) break;
            ++n3;
        }
        return nArray2;
    }

    private int getNumAvailableAddresses(NILSS[] nILSSArray) {
        int n = 0;
        int n2 = nILSSArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (nILSSArray[n3].getDeviceType() instanceof NIDeviceTypeCKD) {
                n += 256 - nILSSArray[n3].getConfiguredDevices();
            }
            ++n3;
        }
        return n;
    }

    private Vector getCompatibleLCUs(NILSS[] nILSSArray, NIExtentPool nIExtentPool) {
        Vector<NILSS> vector = new Vector<NILSS>();
        int n = nILSSArray.length;
        int n2 = 0;
        while (n2 < nILSSArray.length) {
            NILSS nILSS = nILSSArray[n2];
            if (nILSS.getDeviceType() instanceof NIDeviceTypeCKD && nIExtentPool.getRankGroup() == ((NILSSID)nILSS.getID()).getLSSGroupID()) {
                vector.add(nILSS);
            }
            ++n2;
        }
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = 0;
                NILSS nILSS = (NILSS)object;
                NILSS nILSS2 = (NILSS)object2;
                int n2 = ((NILSSID)nILSS.getID()).getLSSNumber();
                int n3 = ((NILSSID)nILSS2.getID()).getLSSNumber();
                n = n2 - n3;
                return n;
            }
        });
        return vector;
    }

    private Hashtable populateLSSTable(Vector vector, int n) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException, NIParameterInvalidCAException, NIQueryFailureCAException, NIUnknownCAException {
        Hashtable hashtable = new Hashtable();
        int n2 = 0;
        while (n2 < n) {
            NILSS nILSS = (NILSS)vector.elementAt(n2);
            NILSSID nILSSID = (NILSSID)nILSS.getID();
            NIConfigQueryResult nIConfigQueryResult = null;
            Vector vector2 = null;
            Vector<Integer> vector3 = new Vector<Integer>();
            try {
                nIConfigQueryResult = this.logicalService.getVolumes(nILSSID);
            }
            catch (NullPointerException nullPointerException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(nullPointerException.toString());
                logger.debug_general(stringBuffer.toString());
                throw new NIUnknownCAException(nullPointerException.toString());
            }
            if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
                vector2 = new Vector(nIConfigQueryResult.getResourceList());
            } else if (nIConfigQueryResult.getCode() != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Query Failure");
                logger.debug_general(stringBuffer.toString());
                throw new NIQueryFailureCAException("Query Failure");
            }
            if (vector2 != null) {
                int n3 = vector2.size();
                int n4 = 0;
                while (n4 < n3) {
                    NIVolumeID nIVolumeID = (NIVolumeID)((NIVolume)vector2.get(n4)).getID();
                    int n5 = nIVolumeID.getVolNumber();
                    vector3.add(new Integer(n5));
                    ++n4;
                }
            }
            hashtable.put(nILSS, vector3);
            ++n2;
        }
        return hashtable;
    }

    private int getVolumeExtents(int n) {
        long l = (n + 1113 - 1) / 1113;
        if (l < 1L) {
            l = 1L;
        }
        return (int)l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

