/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.NIServices;
import com.ibm.storage.ess.ni.application.resource.NIESCONPort;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIESSDomainElement;
import com.ibm.storage.ess.ni.application.resource.NIFibreChannelPort;
import com.ibm.storage.ess.ni.application.resource.NIIOPort;
import com.ibm.storage.ess.ni.application.resource.NISCSIHostPort;
import com.ibm.storage.ess.ni.application.resource.NIStoragePlex;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIESSDomainResult;
import com.ibm.storage.ess.ni.ca.NIEnterpriseAdvisor;
import com.ibm.storage.ess.ni.ca.NIEnterpriseHost;
import com.ibm.storage.ess.ni.ca.NIEnterpriseHostID;
import com.ibm.storage.ess.ni.ca.NIEnterpriseHostPortGroup;
import com.ibm.storage.ess.ni.ca.NIHostType;
import com.ibm.storage.ess.ni.ca.NIImage;
import com.ibm.storage.ess.ni.ca.NIImageHostPort;
import com.ibm.storage.ess.ni.ca.NIImageHostPortGroup;
import com.ibm.storage.ess.ni.ca.NIImageIOPort;
import com.ibm.storage.ess.ni.ca.NIPlex;
import com.ibm.storage.ess.ni.ca.NIQueryHostsError;
import com.ibm.storage.ess.ni.constants.NIConfigurationConstants;
import com.ibm.storage.ess.ni.constants.NIHostConstants;
import com.ibm.storage.ess.ni.exception.NIConnectionCAException;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidCAException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIFabricTopology;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyFCArbitratedLoop;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyFicon;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyScsiFcp;
import com.ibm.storage.ess.ni.option.config.NIHostPortType;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeESCON;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeFICON;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeSCSIFcAl;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeSCSIFcSf;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeUnknown;
import com.ibm.storage.ess.ni.services.NIDomainService;
import com.ibm.storage.ess.ni.services.NIHostConfigurationService;
import com.ibm.storage.ess.ni.services.NIInitialConfigurationService;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import com.ibm.storage.ess.ni.services.NIPhysicalConfigurationService;
import com.ibm.storage.ess.ni.util.NICADeepCloneable;
import com.ibm.storage.ess.ni.util.NICAVector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class NIEnterpriseAdvisorHostManager {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$ca$NIEnterpriseAdvisorHostManager == null ? (class$com$ibm$storage$ess$ni$ca$NIEnterpriseAdvisorHostManager = NIEnterpriseAdvisorHostManager.class$("com.ibm.storage.ess.ni.ca.NIEnterpriseAdvisorHostManager")) : class$com$ibm$storage$ess$ni$ca$NIEnterpriseAdvisorHostManager);
    private static final String CLASS_NAME = "NIEnterpriseAdvisorHostManager";
    private NIEnterpriseAdvisor advisor = null;
    private NIServices[] plexServices = null;
    private Vector vecAllHosts = new Vector();
    private List errors;
    private NIServices tempService;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$ca$NIEnterpriseAdvisorHostManager;

    public NIEnterpriseAdvisorHostManager(NIEnterpriseAdvisor nIEnterpriseAdvisor, NIServices[] nIServicesArray) {
        this.advisor = nIEnterpriseAdvisor;
        this.vecAllHosts = this.advisor.getHostsList();
        this.plexServices = nIServicesArray;
        this.errors = new ArrayList();
    }

    public NIEnterpriseAdvisorHostManager() {
        this.advisor = null;
        this.vecAllHosts = null;
        this.plexServices = null;
    }

    protected void loadHostsFromServer(boolean bl) {
        Object object;
        Object object2;
        logger.enter(CLASS_NAME, "loadHostsFromServer()");
        logger.debug_general("getCapacityData: " + bl);
        NICAVector nICAVector = new NICAVector();
        NICAVector nICAVector2 = new NICAVector();
        this.advisor.setHostsList(nICAVector);
        this.advisor.setPlexesList(nICAVector2);
        this.vecAllHosts = this.advisor.getHostsList();
        int n = this.plexServices.length;
        int n2 = 0;
        while (n2 < n) {
            this.tempService = this.plexServices[n2];
            if (this.tempService == null) {
                logger.error("Null passed in as NIServices at index: " + n2);
                this.errors.add(new NIQueryHostsError(new NIConnectionCAException((Object)"Operation cannot continue. Service not available"), this.tempService, null));
            } else {
                object2 = this.tempService.getDomainService();
                NIHostConfigurationService nIHostConfigurationService = this.tempService.getHostConfigurationService();
                object = this.tempService.getLogicalConfigurationService();
                NIPhysicalConfigurationService nIPhysicalConfigurationService = this.tempService.getPhysicalConfigurationService();
                if (object2 == null || nIHostConfigurationService == null || object == null || nIPhysicalConfigurationService == null) {
                    logger.error("One or more services was null for the NIServices at index: " + n2);
                    this.errors.add(new NIQueryHostsError(new NIConnectionCAException((Object)"Operation cannot continue. Service not available"), this.tempService, null));
                } else {
                    int n3 = this.tempService.getConnectionType();
                    if (n3 == 1) {
                        this.loadHostForSMR(nICAVector, nICAVector2, (NIDomainService)object2, nIHostConfigurationService, (NILogicalConfigurationService)object, nIPhysicalConfigurationService, bl);
                        logger.debug_general("1750 Connection: " + n3);
                    } else {
                        this.loadHostForSS(nICAVector, nICAVector2, (NIDomainService)object2, nIHostConfigurationService, (NILogicalConfigurationService)object, nIPhysicalConfigurationService, bl);
                        logger.debug_general("Not 1750 Connection: " + n3);
                    }
                }
            }
            ++n2;
        }
        Collections.sort(nICAVector, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = 0;
                NIEnterpriseHost nIEnterpriseHost = (NIEnterpriseHost)object;
                NIEnterpriseHost nIEnterpriseHost2 = (NIEnterpriseHost)object2;
                int n2 = nIEnterpriseHost.getID().getHostNumber();
                int n3 = nIEnterpriseHost2.getID().getHostNumber();
                n = n2 - n3;
                return n;
            }
        });
        object2 = new StringBuffer();
        ((StringBuffer)object2).append(" Number of sorted host ports from all images: " + nICAVector.size());
        logger.debug_general(((StringBuffer)object2).toString());
        int n4 = 0;
        while (n4 < nICAVector.size()) {
            object2 = new StringBuffer();
            object = (NIEnterpriseHost)nICAVector.elementAt(n4);
            ((StringBuffer)object2).append(" sorted host " + n4 + ": " + object);
            logger.debug_general(((StringBuffer)object2).toString());
            ++n4;
        }
        this.vecAllHosts = nICAVector;
        this.advisor.setHostsList(nICAVector);
        this.advisor.setPlexesList(nICAVector2);
        this.advisor.setBackupHostsList((NICAVector)nICAVector.clone());
        this.advisor.setBackupPlexesList((NICAVector)nICAVector2.clone());
        logger.exit(CLASS_NAME, "loadHostsFromServer()");
    }

    /*
     * Unable to fully structure code
     */
    private void loadHostForSMR(Vector var1_1, Vector var2_2, NIDomainService var3_3, NIHostConfigurationService var4_4, NILogicalConfigurationService var5_5, NIPhysicalConfigurationService var6_6, boolean var7_7) {
        block16: {
            var8_8 = new StringBuffer();
            var9_9 = this.getReefIDs(this.tempService);
            if (var9_9 == null) break block16;
            var10_10 = 0;
            while (var10_10 < var9_9.length) {
                block15: {
                    block19: {
                        block18: {
                            block17: {
                                var11_11 = null;
                                var12_12 = null;
                                var13_13 = null;
                                try {
                                    var13_13 = var3_3.getStoragePlex(var9_9[var10_10]);
                                }
                                catch (NIServerException var14_15) {
                                    NIEnterpriseAdvisorHostManager.logger.throwable((Throwable)var14_15);
                                    this.errors.add(new NIQueryHostsError(var14_15, this.tempService, var9_9[var10_10]));
                                    break block15;
                                }
                                if (var13_13 == null || var13_13.getCode() != 0 || var13_13.getResourceList() == null) break block17;
                                var14_14 = var13_13.getResourceList();
                                if (var14_14.size() > 0) {
                                    var11_11 = (NIStoragePlex)var14_14.get(0);
                                }
                                break block18;
                            }
                            if (var13_13 == null || var13_13.getCode() == 0) break block18;
                            NIEnterpriseAdvisorHostManager.logger.error("Failed to retrieve storage plex: " + var13_13);
                            this.errors.add(new NIQueryHostsError(var13_13, this.tempService, var9_9[var10_10]));
                            break block15;
                        }
                        if (var11_11 != null) {
                            var12_12 = new NIPlex(this.tempService, var11_11, 1);
                            var12_12.setNickName(var11_11.getUserName());
                            var14_16 = var2_2.indexOf(var12_12);
                            if (var14_16 == -1) {
                                var2_2.add(var12_12);
                            } else {
                                var12_12 = (NIPlex)var2_2.get(var14_16);
                            }
                        }
                        var14_14 = var9_9[var10_10];
                        var15_17 = var14_14.getStorageFacility();
                        var16_18 = null;
                        var17_19 = null;
                        try {
                            var17_19 = var3_3.getESSs(var15_17);
                            var8_8 = new StringBuffer();
                            var8_8.append(" Using domainService.getESSs(facilityID)");
                            NIEnterpriseAdvisorHostManager.logger.debug_general(var8_8.toString());
                        }
                        catch (NIServerException var18_21) {
                            NIEnterpriseAdvisorHostManager.logger.throwable((Throwable)var18_21);
                            this.errors.add(new NIQueryHostsError(var18_21, this.tempService, var9_9[var10_10]));
                            break block15;
                        }
                        if (var17_19 == null || var17_19.getCode() != 0 || var17_19.getResourceList() == null) break block19;
                        var16_18 = (NIESS)var17_19.getResourceList().get(0);
                        ** GOTO lbl-1000
                    }
                    if (var17_19 != null && var17_19.getCode() != 0) {
                        NIEnterpriseAdvisorHostManager.logger.error("Failed to retrieve ESS: " + var17_19);
                        this.errors.add(new NIQueryHostsError(var17_19, this.tempService, var9_9[var10_10]));
                    } else lbl-1000:
                    // 2 sources

                    {
                        var18_20 = new NIImage(var12_12, (NIESSID)var14_14, 1);
                        if (var16_18 != null) {
                            var18_20.setNickName(var16_18.getUserName());
                        } else {
                            var18_20.setNickName("");
                        }
                        if (var12_12 != null) {
                            var12_12.addImage(var18_20);
                        }
                        var19_22 = this.getAllFCPorts(var6_6, (NIESSID)var14_14);
                        var20_23 = this.getAllSCSIHosts(var5_5, var4_4, (NIESSID)var14_14, var12_12, var18_20, var19_22, var7_7);
                        var8_8 = new StringBuffer();
                        var8_8.append(" Number of hosts from image: " + var20_23.size());
                        NIEnterpriseAdvisorHostManager.logger.debug_general(var8_8.toString());
                        var21_24 = 0;
                        while (var21_24 < var20_23.size()) {
                            var8_8 = new StringBuffer();
                            var22_25 = (NIEnterpriseHost)var20_23.get(var21_24);
                            var8_8.append(" host " + var21_24 + ": " + var22_25);
                            NIEnterpriseAdvisorHostManager.logger.debug_general(var8_8.toString());
                            ++var21_24;
                        }
                        var1_1.addAll(var20_23);
                        var1_1.addAll(this.getAnonymousFICONHost(var5_5, var12_12, var18_20, var1_1, var19_22, var7_7));
                    }
                }
                ++var10_10;
            }
        }
    }

    private void loadHostForSS(Vector vector, Vector vector2, NIDomainService nIDomainService, NIHostConfigurationService nIHostConfigurationService, NILogicalConfigurationService nILogicalConfigurationService, NIPhysicalConfigurationService nIPhysicalConfigurationService, boolean bl) {
        NIStoragePlex nIStoragePlex = null;
        NIPlex nIPlex = null;
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = nIDomainService.getStoragePlex();
        }
        catch (NIServerException nIServerException) {
            logger.throwable((Throwable)nIServerException);
            this.errors.add(new NIQueryHostsError(nIServerException, this.tempService, null));
            return;
        }
        if (nIConfigQueryResult != null && nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            List list = nIConfigQueryResult.getResourceList();
            if (list.size() > 0) {
                nIStoragePlex = (NIStoragePlex)list.get(0);
            }
        } else if (nIConfigQueryResult != null && nIConfigQueryResult.getCode() != 0) {
            logger.error("Failed to retrieve storage plex: " + nIConfigQueryResult);
            this.errors.add(new NIQueryHostsError(nIConfigQueryResult, this.tempService, null));
            return;
        }
        if (nIStoragePlex != null) {
            nIPlex = new NIPlex(this.tempService, nIStoragePlex, 1);
            nIPlex.setNickName(nIStoragePlex.getUserName());
            int n = vector2.indexOf(nIPlex);
            if (n == -1) {
                vector2.add(nIPlex);
            } else {
                nIPlex = (NIPlex)vector2.get(n);
            }
        }
        NIConfigQueryResult nIConfigQueryResult2 = null;
        NICAVector nICAVector = new NICAVector();
        try {
            nIConfigQueryResult2 = nIDomainService.getESSs();
        }
        catch (NIServerException nIServerException) {
            logger.throwable((Throwable)nIServerException);
            this.errors.add(new NIQueryHostsError(nIServerException, this.tempService, null));
            return;
        }
        if (nIConfigQueryResult2 != null && nIConfigQueryResult2.getCode() == 0 && nIConfigQueryResult2.getResourceList() != null) {
            nICAVector = new NICAVector((Collection)nIConfigQueryResult2.getResourceList());
        } else if (nIConfigQueryResult2 != null && nIConfigQueryResult2.getCode() != 0) {
            logger.error("Failed to retrieve ESSs: " + nIConfigQueryResult2);
            this.errors.add(new NIQueryHostsError(nIConfigQueryResult2, this.tempService, null));
            return;
        }
        int n = nICAVector.size();
        int n2 = 0;
        while (n2 < n) {
            NIESS nIESS = (NIESS)nICAVector.get(n2);
            NIESSID nIESSID = (NIESSID)nIESS.getID();
            NIImage nIImage = new NIImage(nIPlex, nIESSID, 1);
            nIImage.setNickName(nIESS.getUserName());
            if (nIPlex != null) {
                nIPlex.addImage(nIImage);
            }
            Vector vector3 = this.getAllFCPorts(nIPhysicalConfigurationService, nIESSID);
            List list = this.getAllSCSIHosts(nILogicalConfigurationService, nIHostConfigurationService, nIESSID, nIPlex, nIImage, vector3, bl);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" Number of hosts from image: " + list.size());
            logger.debug_general(stringBuffer.toString());
            int n3 = 0;
            while (n3 < list.size()) {
                stringBuffer = new StringBuffer();
                NIEnterpriseHost nIEnterpriseHost = (NIEnterpriseHost)list.get(n3);
                stringBuffer.append(" host " + n3 + ": " + nIEnterpriseHost);
                logger.debug_general(stringBuffer.toString());
                ++n3;
            }
            vector.addAll(list);
            vector.addAll(this.getAnonymousFICONHost(nILogicalConfigurationService, nIPlex, nIImage, vector, vector3, bl));
            vector.addAll(this.getAnonymousESCONHost(nIPhysicalConfigurationService, nILogicalConfigurationService, nIPlex, nIImage, vector, bl));
            ++n2;
        }
    }

    private NIESSID[] getReefIDs(NIServices nIServices) {
        logger.enter(CLASS_NAME, "getReefIDs()");
        StringBuffer stringBuffer = new StringBuffer();
        NIESSID[] nIESSIDArray = null;
        if (nIServices == null) {
            stringBuffer.append(" NIServices is null ");
            logger.debug_general(stringBuffer.toString());
        } else {
            NIInitialConfigurationService nIInitialConfigurationService = nIServices.getInitialConfigurationService();
            if (nIInitialConfigurationService == null) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(" NIInitialConfigurationService is null ");
                logger.debug_general(stringBuffer.toString());
            }
            NIESSDomainResult nIESSDomainResult = null;
            try {
                nIESSDomainResult = nIInitialConfigurationService.getESSs();
            }
            catch (NIServerException nIServerException) {
                logger.throwable((Throwable)nIServerException);
                this.errors.add(new NIQueryHostsError(nIServerException, this.tempService, null));
                return null;
            }
            if (nIESSDomainResult != null && nIESSDomainResult.getCode() == 0) {
                List list = nIESSDomainResult.getResourceList();
                nIESSIDArray = new NIESSID[list.size()];
                int n = 0;
                while (n < list.size()) {
                    NIESSDomainElement nIESSDomainElement = (NIESSDomainElement)list.get(n);
                    if (nIESSDomainElement == null) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(" NIESSDomainElement is null ");
                        logger.debug_general(stringBuffer.toString());
                    } else {
                        nIESSIDArray[n] = nIESSDomainElement.getESS();
                    }
                    ++n;
                }
            } else if (nIESSDomainResult == null || nIESSDomainResult.getCode() != 0) {
                logger.error("Failed to retrieve reef ESSIDs: " + nIESSDomainResult);
                this.errors.add(new NIQueryHostsError(nIESSDomainResult, this.tempService, null));
            }
        }
        logger.exit(CLASS_NAME, "getReefIDs()");
        return nIESSIDArray;
    }

    private HashMap getAllHostsFromSCSIPorts(Vector vector) {
        HashMap hashMap = new HashMap();
        Vector<NIEnterpriseHost> vector2 = new Vector<NIEnterpriseHost>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Serializable serializable;
            Cloneable cloneable;
            NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)vector.elementAt(n2);
            boolean bl = false;
            Cloneable cloneable2 = null;
            String string = nISCSIHostPort.getUserHostName();
            String string2 = nISCSIHostPort.getPortProfile();
            String string3 = nISCSIHostPort.getHostType();
            int n3 = nISCSIHostPort.getLogicalBlockSize();
            int n4 = nISCSIHostPort.getAddressDiscovery();
            String string4 = nISCSIHostPort.getUserHostDescription();
            int n5 = 0;
            while (n5 < vector2.size() && !bl) {
                cloneable = (NIEnterpriseHost)vector2.elementAt(n5);
                serializable = ((NIEnterpriseHost)cloneable).getHostType();
                if (string.equals(((NIEnterpriseHost)cloneable).getUserName()) && string3.equals(((NIHostType)serializable).getHostType()) && string2.equals(((NIHostType)serializable).getPortProfile()) && n3 == ((NIHostType)serializable).getLogicalSize() && n4 == ((NIHostType)serializable).getAddressDiscovery() && string4.equals(((NIEnterpriseHost)cloneable).getHostDescription())) {
                    bl = true;
                    cloneable2 = cloneable;
                }
                ++n5;
            }
            if (!bl) {
                cloneable2 = this.getHost(string, string4, string3, string2, n3, n4);
                if (cloneable2 == null) {
                    int n6 = this.advisor.getNextHostNumber(vector2);
                    serializable = new NIEnterpriseHostID(n6);
                    cloneable2 = new NIEnterpriseHost((NIEnterpriseHostID)serializable, string, string4, true, 1);
                    NIHostType nIHostType = this.getHostType(string3, string2, n3, n4);
                    cloneable2.setHostType(nIHostType);
                }
                vector2.add((NIEnterpriseHost)cloneable2);
                hashMap.put((NIEnterpriseHost)cloneable2, new Vector());
            }
            cloneable = (Vector)hashMap.get(cloneable2);
            ((Vector)cloneable).add(nISCSIHostPort);
            ++n2;
        }
        return hashMap;
    }

    private NIEnterpriseHost getHost(String string, String string2, String string3, String string4, int n, int n2) {
        NIEnterpriseHost nIEnterpriseHost = null;
        boolean bl = false;
        int n3 = this.vecAllHosts.size();
        int n4 = 0;
        while (n4 < n3 && !bl) {
            NIEnterpriseHost nIEnterpriseHost2 = (NIEnterpriseHost)this.vecAllHosts.elementAt(n4);
            if (string.equals(nIEnterpriseHost2.getUserName()) && string3.equals(nIEnterpriseHost2.getHostType().getHostType()) && string4.equals(nIEnterpriseHost2.getHostType().getPortProfile()) && n == nIEnterpriseHost2.getHostType().getLogicalSize() && n2 == nIEnterpriseHost2.getHostType().getAddressDiscovery() && string2.equals(nIEnterpriseHost2.getHostDescription())) {
                bl = true;
                nIEnterpriseHost = nIEnterpriseHost2;
            }
            ++n4;
        }
        return nIEnterpriseHost;
    }

    private NIEnterpriseHost getFICONHost(Vector vector) {
        NIEnterpriseHost nIEnterpriseHost = null;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            NIEnterpriseHost nIEnterpriseHost2 = (NIEnterpriseHost)vector.elementAt(n2);
            String string = NIHostConstants.getHostInfo(25, 0);
            if (!nIEnterpriseHost2.isSCSIHost() && nIEnterpriseHost2.getHostType().getHostType().equals(string)) {
                nIEnterpriseHost = nIEnterpriseHost2;
                break;
            }
            ++n2;
        }
        return nIEnterpriseHost;
    }

    private NIEnterpriseHost getESCONHost(Vector vector) {
        NIEnterpriseHost nIEnterpriseHost = null;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            NIEnterpriseHost nIEnterpriseHost2 = (NIEnterpriseHost)vector.elementAt(n2);
            String string = NIHostConstants.getHostInfo(26, 0);
            if (!nIEnterpriseHost2.isSCSIHost() && nIEnterpriseHost2.getHostType().getHostType().equals(string)) {
                nIEnterpriseHost = nIEnterpriseHost2;
                break;
            }
            ++n2;
        }
        return nIEnterpriseHost;
    }

    private HashMap groupHostPorts(Vector vector) {
        HashMap<Integer, Vector> hashMap = new HashMap<Integer, Vector>();
        int n = 0;
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Vector vector2;
            NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)vector.elementAt(n3);
            boolean bl = false;
            int n4 = 0;
            while (n4 < hashMap.size() && !bl) {
                vector2 = (Vector)hashMap.get(new Integer(n4));
                NIFabricTopology nIFabricTopology = ((NISCSIHostPort)vector2.elementAt(0)).getAttachingPortTopology();
                int n5 = ((NISCSIHostPort)vector2.elementAt(0)).getPortGroup();
                if (nISCSIHostPort.getAttachingPortTopology().equals(nIFabricTopology) && nISCSIHostPort.getPortGroup() == n5) {
                    bl = true;
                    vector2.add(nISCSIHostPort);
                    hashMap.put(new Integer(n4), vector2);
                }
                ++n4;
            }
            if (!bl) {
                vector2 = new Vector();
                vector2.add(nISCSIHostPort);
                n = hashMap.size();
                hashMap.put(new Integer(n++), vector2);
            }
            ++n3;
        }
        return hashMap;
    }

    protected NIHostType getHostType(String string, String string2, int n, int n2) {
        String string3;
        String string4;
        boolean bl = false;
        NIHostType nIHostType = null;
        int n3 = 0;
        while (n3 < 27 && !bl) {
            String string5 = NIHostConstants.getHostInfo(n3, 2);
            if (string5.equals(string2)) {
                string4 = NIHostConstants.getHostInfo(n3, 0);
                string3 = NIHostConstants.getHostInfo(n3, 1);
                int n4 = Integer.parseInt(NIHostConstants.getHostInfo(n3, 3));
                int n5 = Integer.parseInt(NIHostConstants.getHostInfo(n3, 4));
                if (n == n5 && n2 == n4 && string4.equals(string)) {
                    nIHostType = new NIHostType(string4, string3, string5, n4, n5);
                    bl = true;
                }
            }
            ++n3;
        }
        if (!bl) {
            int n6 = 27;
            string4 = NIHostConstants.getHostInfo(n6, 0);
            string3 = NIHostConstants.getHostInfo(n6, 1);
            nIHostType = new NIHostType(string4, string3, string2, n2, n);
        }
        return nIHostType;
    }

    private NICAVector getHostTypes(String[] stringArray) {
        Object object;
        String string;
        String string2;
        NICAVector nICAVector = new NICAVector();
        Vector<String> vector = new Vector<String>();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            vector.add(stringArray[n2]);
            ++n2;
        }
        if (this.advisor.isAnonymousFICONCreated()) {
            string2 = NIHostConstants.getHostInfo(25, 0);
            string = NIHostConstants.getHostInfo(25, 1);
            object = new NIHostType(string2, string);
            nICAVector.add(object);
        }
        if (this.advisor.isAnonymousESCONCreated()) {
            string2 = NIHostConstants.getHostInfo(26, 0);
            string = NIHostConstants.getHostInfo(26, 1);
            object = new NIHostType(string2, string);
            nICAVector.add(object);
        }
        int n3 = 0;
        while (n3 < 27) {
            string = NIHostConstants.getHostInfo(n3, 2);
            if (vector.contains(string)) {
                object = NIHostConstants.getHostInfo(n3, 0);
                String string3 = NIHostConstants.getHostInfo(n3, 1);
                String string4 = string;
                int n4 = Integer.parseInt(NIHostConstants.getHostInfo(n3, 3));
                int n5 = Integer.parseInt(NIHostConstants.getHostInfo(n3, 4));
                NIHostType nIHostType = new NIHostType((String)object, string3, string4, n4, n5);
                nICAVector.add(nIHostType);
            }
            ++n3;
        }
        return nICAVector;
    }

    private List getWWPNs(Vector vector) {
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        while (n2 < n) {
            long l = ((NISCSIHostPort)vector.elementAt(n2)).getWWPN();
            String string = NIEnterpriseAdvisor.hexStringFromLong(l, 16);
            vector2.add(string);
            ++n2;
        }
        return vector2;
    }

    private long getCKDStorageInGB(NILogicalConfigurationService nILogicalConfigurationService, NIImage nIImage) {
        NIConfigQueryResult nIConfigQueryResult = null;
        try {
            nIConfigQueryResult = nILogicalConfigurationService.getVolumes(nIImage.getESSID(), (NIDeviceType)NIDeviceTypeCKD.Option);
        }
        catch (NIServerException nIServerException) {
            logger.throwable((Throwable)nIServerException);
            this.errors.add(new NIQueryHostsError(nIServerException, this.tempService, nIImage.getESSID()));
            return 0L;
        }
        Vector vector = new Vector();
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            vector = new Vector(nIConfigQueryResult.getResourceList());
        } else if (nIConfigQueryResult.getCode() != 0) {
            logger.error("Failed to retrieve volumes: " + nIConfigQueryResult);
            this.errors.add(new NIQueryHostsError(nIConfigQueryResult, this.tempService, nIImage.getESSID()));
            return 0L;
        }
        long l = 0L;
        long l2 = 0L;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            NIVolume nIVolume = (NIVolume)vector.get(n2);
            l = nIVolume.getCapacity();
            l2 = (long)((double)l2 + (double)(l * 880020L) / NIConfigurationConstants.BYTES_IN_ONE_GB_BIN);
            ++n2;
        }
        return l;
    }

    private List getAllSCSIHosts(NILogicalConfigurationService nILogicalConfigurationService, NIHostConfigurationService nIHostConfigurationService, NIESSID nIESSID, NIPlex nIPlex, NIImage nIImage, Vector vector, boolean bl) {
        Serializable serializable;
        Serializable serializable2;
        Vector vector2;
        logger.enter(CLASS_NAME, "getAllSCSIHosts()");
        Vector<NIEnterpriseHost> vector3 = new Vector<NIEnterpriseHost>();
        String[] stringArray = this.getPortProfilesFromHostConstants();
        if (stringArray.length > 0) {
            vector2 = this.getHostTypes(stringArray);
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                serializable2 = (NIHostType)vector2.elementAt(n2);
                nIImage.addHostType((NIHostType)serializable2);
                ++n2;
            }
        }
        vector2 = new Vector();
        NIConfigQueryResult nIConfigQueryResult = null;
        Vector vector4 = new Vector();
        try {
            nIConfigQueryResult = nIHostConfigurationService.getSCSIHostPorts(nIESSID);
        }
        catch (NIServerException nIServerException) {
            logger.throwable((Throwable)nIServerException);
            this.errors.add(new NIQueryHostsError(nIServerException, this.tempService, nIESSID));
            return vector3;
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            vector4 = new Vector(nIConfigQueryResult.getResourceList());
        } else if (nIConfigQueryResult.getCode() != 0) {
            logger.error("Failed to retrieve SCSIPorts: " + nIConfigQueryResult);
            this.errors.add(new NIQueryHostsError(nIConfigQueryResult, this.tempService, nIESSID));
            return vector3;
        }
        serializable2 = new StringBuffer();
        ((StringBuffer)serializable2).append(" Number of SCSI host ports: " + vector4.size());
        logger.debug_general(((StringBuffer)serializable2).toString());
        Collections.sort(vector4, new Comparator(){

            public int compare(Object object, Object object2) {
                NISCSIHostPortID nISCSIHostPortID = (NISCSIHostPortID)((NISCSIHostPort)object).getID();
                NISCSIHostPortID nISCSIHostPortID2 = (NISCSIHostPortID)((NISCSIHostPort)object2).getID();
                return nISCSIHostPortID.compareTo(nISCSIHostPortID2);
            }
        });
        int n = 0;
        while (n < vector4.size()) {
            serializable2 = new StringBuffer();
            serializable = (NISCSIHostPort)vector4.elementAt(n);
            ((StringBuffer)serializable2).append(" host port " + n + ": " + serializable);
            logger.debug_general(((StringBuffer)serializable2).toString());
            ++n;
        }
        serializable = null;
        HashMap hashMap = this.getAllHostsFromSCSIPorts(vector4);
        Vector vector5 = new Vector(hashMap.keySet());
        int n3 = vector5.size();
        int n4 = 0;
        while (n4 < n3) {
            block32: {
                NIEnterpriseHost nIEnterpriseHost = (NIEnterpriseHost)vector5.elementAt(n4);
                String string = nIEnterpriseHost.getUserName();
                try {
                    serializable = this.advisor.getHost(nIEnterpriseHost.getID());
                }
                catch (NIParameterInvalidCAException nIParameterInvalidCAException) {
                    logger.throwable((Throwable)nIParameterInvalidCAException);
                    this.errors.add(new NIQueryHostsError(nIParameterInvalidCAException, this.tempService, nIESSID));
                    break block32;
                }
                if (serializable == null) {
                    vector3.add(nIEnterpriseHost);
                }
                serializable = nIEnterpriseHost;
                Vector vector6 = (Vector)hashMap.get(serializable);
                HashMap hashMap2 = this.groupHostPorts(new Vector(vector6));
                int n5 = 0;
                while (n5 < hashMap2.size()) {
                    block33: {
                        Serializable serializable3;
                        Serializable serializable4;
                        NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup;
                        Vector vector7 = (Vector)hashMap2.get(new Integer(n5));
                        int n6 = vector7.size();
                        NIFabricTopology nIFabricTopology = ((NISCSIHostPort)vector7.elementAt(0)).getAttachingPortTopology();
                        int n7 = ((NISCSIHostPort)vector7.elementAt(0)).getPortGroup();
                        NIHostPortType nIHostPortType = null;
                        String string2 = "";
                        if (nIFabricTopology instanceof NIFabricTopologyFCArbitratedLoop) {
                            nIHostPortType = NIHostPortTypeSCSIFcAl.Option;
                            string2 = "Fc_Al";
                        } else if (nIFabricTopology instanceof NIFabricTopologyScsiFcp) {
                            nIHostPortType = NIHostPortTypeSCSIFcSf.Option;
                            string2 = "Fc_Sf";
                        } else {
                            nIHostPortType = NIHostPortTypeUnknown.Option;
                            string2 = "Unknown";
                        }
                        serializable2 = new StringBuffer();
                        ((StringBuffer)serializable2).append(" Topology: " + string2);
                        logger.debug_general(((StringBuffer)serializable2).toString());
                        String string3 = this.advisor.getPrefix(string, (NIEnterpriseHost)serializable, string2);
                        Vector vector8 = new Vector(this.getWWPNs(vector7));
                        try {
                            nIEnterpriseHostPortGroup = this.advisor.getHostPortGroup((NIEnterpriseHost)serializable, string3, nIHostPortType, n6, vector8, n7);
                        }
                        catch (NIParameterInvalidCAException nIParameterInvalidCAException) {
                            logger.throwable((Throwable)nIParameterInvalidCAException);
                            this.errors.add(new NIQueryHostsError(nIParameterInvalidCAException, this.tempService, nIESSID));
                            break block33;
                        }
                        if (nIEnterpriseHostPortGroup.getWWPNs().size() == 0) {
                            nIEnterpriseHostPortGroup.setWWPNs((Vector)vector8.clone());
                            nIEnterpriseHostPortGroup.setOriginalWWPNs((Vector)vector8.clone());
                            ((NIEnterpriseHost)serializable).addHostPortGroup(nIEnterpriseHostPortGroup);
                        }
                        NIImageHostPortGroup nIImageHostPortGroup = new NIImageHostPortGroup(nIImage, nIEnterpriseHostPortGroup, 1);
                        Vector<NIFibreChannelPort> vector9 = new Vector<NIFibreChannelPort>();
                        if (n6 > 0) {
                            NIVolumeID[] nIVolumeIDArray;
                            long l;
                            block34: {
                                serializable4 = (NISCSIHostPort)vector7.elementAt(0);
                                NIVolumeGroupID nIVolumeGroupID = serializable4.getVolumeGroup();
                                l = 0L;
                                if (nIVolumeGroupID != null) {
                                    nIImageHostPortGroup.setVolumeGroup(nIVolumeGroupID);
                                    if (((NIEnterpriseHost)serializable).addVolumeGroup(nIVolumeGroupID) && bl) {
                                        try {
                                            nIVolumeIDArray = this.advisor.getVolumes(nIVolumeGroupID, this.tempService);
                                            if (nIVolumeIDArray.length <= 0) break block34;
                                            l = this.advisor.getFBStorageInGB(nILogicalConfigurationService, nIVolumeIDArray);
                                        }
                                        catch (Exception exception) {
                                            logger.throwable((Throwable)exception);
                                            this.errors.add(new NIQueryHostsError(exception, this.tempService, nIESSID));
                                            break block33;
                                        }
                                    }
                                }
                            }
                            ((NIEnterpriseHost)serializable).addTotalStorageGB(l);
                            nIVolumeIDArray = serializable4.getPortMask();
                            int n8 = 0;
                            while (n8 < vector.size()) {
                                serializable3 = (NIFibreChannelPort)vector.elementAt(n8);
                                if (nIVolumeIDArray != null && nIVolumeIDArray.contains((NIIOPort)serializable3)) {
                                    vector9.add((NIFibreChannelPort)serializable3);
                                }
                                ++n8;
                            }
                        }
                        nIImageHostPortGroup.setAttachedToImage(true);
                        serializable4 = new Vector();
                        int n9 = 0;
                        while (n9 < n6) {
                            NIImageHostPort nIImageHostPort = new NIImageHostPort(nIImageHostPortGroup, (NISCSIHostPort)vector7.elementAt(n9), 1);
                            ((Vector)serializable4).add(nIImageHostPort);
                            ++n9;
                        }
                        nIImageHostPortGroup.addHostPorts((Vector)serializable4);
                        nIEnterpriseHostPortGroup.addHostPortGroup(nIImageHostPortGroup);
                        nIImage.addHostPortGroup(nIImageHostPortGroup);
                        Vector<NIImageIOPort> vector10 = new Vector<NIImageIOPort>();
                        int n10 = vector9.size();
                        if (n10 > 0) {
                            int n11 = 0;
                            while (n11 < n10) {
                                NIFibreChannelPort nIFibreChannelPort = (NIFibreChannelPort)vector9.elementAt(n11);
                                serializable3 = (NIIOPortID)nIFibreChannelPort.getID();
                                NIImageIOPort nIImageIOPort = new NIImageIOPort(nIFibreChannelPort, nIFibreChannelPort.getLocation(), nIFibreChannelPort.getTopology(), nIFibreChannelPort.getPortType(), 1);
                                vector10.add(nIImageIOPort);
                                if (!vector2.contains(serializable3)) {
                                    nIImage.addImagePort(nIImageIOPort);
                                    vector2.add(serializable3);
                                } else {
                                    nIImageIOPort = nIImage.getImagePort((NIIOPortID)serializable3);
                                }
                                nIImageIOPort.setSCSIEnabled(true);
                                nIImageIOPort.addHostPorts((Vector)serializable4);
                                ++n11;
                            }
                            nIImageHostPortGroup.addIOPorts(vector10);
                        }
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        logger.exit(CLASS_NAME, "getAllSCSIHosts()");
        return vector3;
    }

    private String[] getPortProfilesFromHostConstants() {
        Object object;
        logger.enter(CLASS_NAME, "getPortProfilesFromHostConstants()");
        Vector<String[]> vector = new Vector<String[]>();
        int n = 0;
        while (n < 27) {
            if (n != 26 && n != 25 && n != 27) {
                object = NIHostConstants.getHostInfo(n, 2);
                vector.add((String[])object);
            }
            ++n;
        }
        object = vector.toArray(new String[0]);
        logger.exit(CLASS_NAME, "getPortProfilesFromHostConstants()");
        return object;
    }

    private List getAnonymousFICONHost(NILogicalConfigurationService nILogicalConfigurationService, NIPlex nIPlex, NIImage nIImage, Vector vector, Vector vector2, boolean bl) {
        Object object;
        NICADeepCloneable nICADeepCloneable;
        logger.enter(CLASS_NAME, "getAnonymousFICONHost()");
        Vector<NICADeepCloneable> vector3 = new Vector<NICADeepCloneable>();
        Vector<NICADeepCloneable> vector4 = new Vector<NICADeepCloneable>();
        int n = vector2.size();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            NIFibreChannelPort nIFibreChannelPort = (NIFibreChannelPort)vector2.get(n2);
            nICADeepCloneable = nIImage.getImagePort((NIIOPortID)nIFibreChannelPort.getID());
            if (nICADeepCloneable == null) {
                object = nIFibreChannelPort.getLocation();
                nICADeepCloneable = new NIImageIOPort(nIFibreChannelPort, (String)object, nIFibreChannelPort.getTopology(), nIFibreChannelPort.getPortType(), 1);
                nIImage.addImagePort((NIImageIOPort)nICADeepCloneable);
            }
            if (nIFibreChannelPort.getTopology() instanceof NIFabricTopologyFicon) {
                stringBuffer = new StringBuffer();
                ((NIImageIOPort)nICADeepCloneable).setFICONEnabled(true);
                ((NIImageIOPort)nICADeepCloneable).setSCSIEnabled(false);
                stringBuffer.append("FICON ImageIOPort: " + ((NIImageIOPort)nICADeepCloneable).toString());
                logger.debug_general(stringBuffer.toString());
                vector4.add(nICADeepCloneable);
            }
            ++n2;
        }
        int n3 = vector4.size();
        if (n3 > 0) {
            nICADeepCloneable = null;
            object = null;
            if (!this.advisor.isAnonymousFICONCreated()) {
                this.advisor.setAnonymousFICONCreated(true);
                int n4 = this.advisor.getNextHostNumber(vector);
                NIEnterpriseHostID nIEnterpriseHostID = new NIEnterpriseHostID(n4);
                nICADeepCloneable = new NIEnterpriseHost(nIEnterpriseHostID, "Anonymous FICON Host", "Anonymous FICON Host", false, 1);
                String string = NIHostConstants.getHostInfo(25, 0);
                String string2 = NIHostConstants.getHostInfo(25, 1);
                NIHostType nIHostType = new NIHostType(string, string2);
                ((NIEnterpriseHost)nICADeepCloneable).setHostType(nIHostType);
                NIFabricTopologyFicon nIFabricTopologyFicon = NIFabricTopologyFicon.Option;
                NIHostPortTypeFICON nIHostPortTypeFICON = NIHostPortTypeFICON.Option;
                String string3 = "FICON";
                String string4 = this.advisor.getPrefix("Anonymous FICON Host", (NIEnterpriseHost)nICADeepCloneable, string3);
                string4 = string4 + "(" + 1 + ")";
                object = new NIEnterpriseHostPortGroup((NIEnterpriseHost)nICADeepCloneable, string4, 1, nIHostPortTypeFICON, 1, 1);
                ((NIEnterpriseHost)nICADeepCloneable).addHostPortGroup((NIEnterpriseHostPortGroup)object);
                vector3.add(nICADeepCloneable);
            } else {
                nICADeepCloneable = this.getFICONHost(vector);
                Vector vector5 = ((NIEnterpriseHost)nICADeepCloneable).getPortGroups();
                int n5 = vector5.size();
                if (n5 > 0) {
                    object = (NIEnterpriseHostPortGroup)vector5.elementAt(0);
                }
            }
            NIImageHostPortGroup nIImageHostPortGroup = new NIImageHostPortGroup(nIImage, (NIEnterpriseHostPortGroup)object, 1);
            if (bl) {
                long l = this.getCKDStorageInGB(nILogicalConfigurationService, nIImage);
                ((NIEnterpriseHost)nICADeepCloneable).addTotalStorageGB(l);
            }
            nIImageHostPortGroup.setAttachedToImage(true);
            nIImageHostPortGroup.addIOPorts(vector4);
            stringBuffer = new StringBuffer();
            stringBuffer.append("Number of IO Ports: " + nIImageHostPortGroup.getIOPorts().size());
            logger.debug_general(stringBuffer.toString());
            ((NIEnterpriseHostPortGroup)object).addHostPortGroup(nIImageHostPortGroup);
            nIImage.addHostPortGroup(nIImageHostPortGroup);
        }
        logger.exit(CLASS_NAME, "getAnonymousFICONHost()");
        return vector3;
    }

    private Vector getAllFCPorts(NIPhysicalConfigurationService nIPhysicalConfigurationService, NIESSID nIESSID) {
        NIConfigQueryResult nIConfigQueryResult = null;
        Vector vector = new Vector();
        try {
            nIConfigQueryResult = nIPhysicalConfigurationService.getFibreChannelPorts(nIESSID);
        }
        catch (NIServerException nIServerException) {
            logger.throwable((Throwable)nIServerException);
            this.errors.add(new NIQueryHostsError(nIServerException, this.tempService, nIESSID));
            return vector;
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            vector = new Vector(nIConfigQueryResult.getResourceList());
        } else if (nIConfigQueryResult.getCode() != 0) {
            logger.error("Failed to retrieve FCPorts: " + nIConfigQueryResult);
            this.errors.add(new NIQueryHostsError(nIConfigQueryResult, this.tempService, nIESSID));
        }
        return vector;
    }

    private List getAnonymousESCONHost(NIPhysicalConfigurationService nIPhysicalConfigurationService, NILogicalConfigurationService nILogicalConfigurationService, NIPlex nIPlex, NIImage nIImage, Vector vector, boolean bl) {
        NICADeepCloneable nICADeepCloneable;
        Object object;
        logger.enter(CLASS_NAME, "getAnonymousESCONHost()");
        Vector<Object> vector2 = new Vector<Object>();
        NIConfigQueryResult nIConfigQueryResult = null;
        Vector vector3 = new Vector();
        Vector<NIImageIOPort> vector4 = new Vector<NIImageIOPort>();
        try {
            nIConfigQueryResult = nIPhysicalConfigurationService.getESCONPorts(nIImage.getESSID());
        }
        catch (NIServerException nIServerException) {
            logger.throwable((Throwable)nIServerException);
            this.errors.add(new NIQueryHostsError(nIServerException, this.tempService, nIImage.getESSID()));
            return vector2;
        }
        if (nIConfigQueryResult.getCode() == 0 && nIConfigQueryResult.getResourceList() != null) {
            vector3 = new Vector(nIConfigQueryResult.getResourceList());
        } else if (nIConfigQueryResult.getCode() != 0) {
            logger.error("Failed to retrieve ESCONPorts: " + nIConfigQueryResult);
            this.errors.add(new NIQueryHostsError(nIConfigQueryResult, this.tempService, nIImage.getESSID()));
            return vector2;
        }
        int n = vector3.size();
        int n2 = 0;
        while (n2 < n) {
            NIESCONPort nIESCONPort = (NIESCONPort)vector3.get(n2);
            object = nIESCONPort.getLocation();
            nICADeepCloneable = new NIImageIOPort(nIESCONPort, (String)object, null, nIESCONPort.getPortType(), 1);
            ((NIImageIOPort)nICADeepCloneable).setESCONEnabled(true);
            nIImage.addImagePort((NIImageIOPort)nICADeepCloneable);
            vector4.add((NIImageIOPort)nICADeepCloneable);
            ++n2;
        }
        int n3 = vector4.size();
        if (n3 > 0) {
            object = null;
            nICADeepCloneable = null;
            if (!this.advisor.isAnonymousESCONCreated()) {
                this.advisor.setAnonymousESCONCreated(true);
                int n4 = this.advisor.getNextHostNumber(vector);
                NIEnterpriseHostID nIEnterpriseHostID = new NIEnterpriseHostID(n4);
                object = new NIEnterpriseHost(nIEnterpriseHostID, "Anonymous ESCON Host", "Anonymous ESCON Host", false, 1);
                String string = NIHostConstants.getHostInfo(26, 0);
                String string2 = NIHostConstants.getHostInfo(26, 1);
                NIHostType nIHostType = new NIHostType(string, string2);
                ((NIEnterpriseHost)object).setHostType(nIHostType);
                NIHostPortTypeESCON nIHostPortTypeESCON = NIHostPortTypeESCON.Option;
                String string3 = "ESCON";
                String string4 = this.advisor.getPrefix("Anonymous ESCON Host", (NIEnterpriseHost)object, string3);
                string4 = string4 + "(" + 1 + ")";
                nICADeepCloneable = new NIEnterpriseHostPortGroup((NIEnterpriseHost)object, string4, 1, nIHostPortTypeESCON, 1, 1);
                ((NIEnterpriseHost)object).addHostPortGroup((NIEnterpriseHostPortGroup)nICADeepCloneable);
                vector2.add(object);
            } else {
                object = this.getESCONHost(vector);
                Vector vector5 = ((NIEnterpriseHost)object).getPortGroups();
                int n5 = vector5.size();
                if (n5 > 0) {
                    nICADeepCloneable = (NIEnterpriseHostPortGroup)vector5.elementAt(0);
                }
            }
            NIImageHostPortGroup nIImageHostPortGroup = new NIImageHostPortGroup(nIImage, (NIEnterpriseHostPortGroup)nICADeepCloneable, 1);
            if (bl) {
                long l = this.getCKDStorageInGB(nILogicalConfigurationService, nIImage);
                ((NIEnterpriseHost)object).addTotalStorageGB(l);
            }
            nIImageHostPortGroup.setAttachedToImage(true);
            nIImageHostPortGroup.addIOPorts(vector4);
            ((NIEnterpriseHostPortGroup)nICADeepCloneable).addHostPortGroup(nIImageHostPortGroup);
            nIImage.addHostPortGroup(nIImageHostPortGroup);
        }
        logger.exit(CLASS_NAME, "getAnonymousESCONHost()");
        return vector2;
    }

    protected List getErrors() {
        return this.errors;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

