/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.ni.ca.NIEnterpriseHost;
import com.ibm.storage.ess.ni.ca.NIHostType;
import com.ibm.storage.ess.ni.ca.NIImage;
import com.ibm.storage.ess.ni.ca.NIImageHostPortGroup;
import com.ibm.storage.ess.ni.option.config.NIHostPortType;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeESCON;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeFICON;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeSCSIFcAl;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeSCSIFcSf;
import com.ibm.storage.ess.ni.option.config.NIHostPortTypeUnknown;
import com.ibm.storage.ess.ni.util.NICADeepCloneable;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public class NIEnterpriseHostPortGroup
implements Serializable,
NICADeepCloneable {
    private static final long serialVersionUID = 1L;
    public static final int NO_ACTION = 1;
    public static final int CREATE = 2;
    public static final int MODIFY = 3;
    public static final int DELETE = 4;
    private NIEnterpriseHost owner;
    private int iAction;
    private int iPortGroupNumber;
    private int iPortCount;
    private int suffix;
    private NIHostType hostType;
    private NIHostPortType portType;
    private String strIdentifier;
    private Vector vecImageHostPortGroups;
    private Vector vecWWPNs;
    private Vector vecOriginalWWPNs;

    protected NIEnterpriseHostPortGroup(NIEnterpriseHost nIEnterpriseHost, String string, int n, NIHostPortType nIHostPortType, int n2, int n3) {
        this.owner = nIEnterpriseHost;
        this.strIdentifier = string;
        this.iPortGroupNumber = n;
        this.portType = nIHostPortType;
        this.iPortCount = n2;
        this.iAction = n3;
        this.suffix = 1;
        this.hostType = nIEnterpriseHost.getHostType();
        this.vecImageHostPortGroups = new Vector();
        this.vecWWPNs = new Vector();
        this.vecOriginalWWPNs = null;
    }

    public int getPortCount() {
        return this.iPortCount;
    }

    public int getPortGroupNumber() {
        return this.iPortGroupNumber;
    }

    public NIHostPortType getHostPortType() {
        return this.portType;
    }

    public NIHostType getHostType() {
        return this.hostType;
    }

    protected NIEnterpriseHost getOwner() {
        return this.owner;
    }

    public String getIdentifier() {
        String string = new String("");
        if (this.strIdentifier != null) {
            string = this.strIdentifier;
        }
        return string;
    }

    protected void setIdentifier(String string) {
        this.strIdentifier = string;
    }

    public String getTopology() {
        String string = new String("");
        if (this.portType instanceof NIHostPortTypeSCSIFcAl) {
            string = "Fc_Al";
        } else if (this.portType instanceof NIHostPortTypeSCSIFcSf) {
            string = "Fc_Sf";
        } else if (this.portType instanceof NIHostPortTypeFICON) {
            string = "FICON";
        } else if (this.portType instanceof NIHostPortTypeESCON) {
            string = "ESCON";
        } else if (this.portType instanceof NIHostPortTypeUnknown) {
            string = "Unknown";
        }
        return string;
    }

    public List getAttachedImages() {
        Vector<NIImage> vector = new Vector<NIImage>();
        int n = 0;
        while (n < this.vecImageHostPortGroups.size()) {
            NIImage nIImage;
            NIImageHostPortGroup nIImageHostPortGroup = (NIImageHostPortGroup)this.vecImageHostPortGroups.get(n);
            if (nIImageHostPortGroup.getAction() != 4 && !vector.contains(nIImage = nIImageHostPortGroup.getOwner())) {
                vector.add(nIImage);
            }
            ++n;
        }
        return vector;
    }

    public int getAttachedImageCount() {
        return this.getAttachedImages().size();
    }

    public void setSuffix(int n) {
        this.suffix = n;
    }

    public int getSuffix() {
        return this.suffix;
    }

    public List getWWPNs() {
        Vector vector = new Vector();
        if (this.vecWWPNs.size() > 0) {
            return this.vecWWPNs;
        }
        return vector;
    }

    protected void setWWPNs(Vector vector) {
        this.vecWWPNs = vector;
    }

    public List getOriginalWWPNs() {
        Vector vector = new Vector();
        if (this.vecOriginalWWPNs.size() > 0) {
            return this.vecOriginalWWPNs;
        }
        return vector;
    }

    protected void setOriginalWWPNs(Vector vector) {
        this.vecOriginalWWPNs = vector;
    }

    public boolean areWWPNsChanged() {
        if (this.iAction == 3) {
            if (this.vecWWPNs.size() != this.vecOriginalWWPNs.size()) {
                return true;
            }
            int n = 0;
            while (n < this.vecWWPNs.size()) {
                String string;
                String string2 = (String)this.vecWWPNs.elementAt(n);
                if (!string2.equals(string = (String)this.vecOriginalWWPNs.elementAt(n))) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected int getAction() {
        return this.iAction;
    }

    protected void setAction(int n) {
        this.iAction = n;
    }

    public Vector getImageHostPortGrp() {
        return this.vecImageHostPortGroups;
    }

    protected void addHostPortGroup(NIImageHostPortGroup nIImageHostPortGroup) {
        if (!this.vecImageHostPortGroups.contains(nIImageHostPortGroup)) {
            this.vecImageHostPortGroups.add(nIImageHostPortGroup);
        }
    }

    public synchronized Object clone() {
        NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup = null;
        try {
            nIEnterpriseHostPortGroup = (NIEnterpriseHostPortGroup)super.clone();
            nIEnterpriseHostPortGroup.vecImageHostPortGroups = (Vector)this.vecImageHostPortGroups.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
        }
        return nIEnterpriseHostPortGroup;
    }

    public boolean equals(Object object) {
        return this.getOwner().equals(((NIEnterpriseHostPortGroup)object).getOwner()) && this.getPortGroupNumber() == ((NIEnterpriseHostPortGroup)object).getPortGroupNumber() && this.getHostType().equals(((NIEnterpriseHostPortGroup)object).getHostType()) && this.getIdentifier().equals(((NIEnterpriseHostPortGroup)object).getIdentifier());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Owner: [" + this.owner.toString() + "]");
        stringBuffer.append(" Identifier: " + this.strIdentifier);
        stringBuffer.append(" HostPortType: " + this.portType.toString());
        stringBuffer.append(" PortGroupNumber: " + this.iPortGroupNumber);
        stringBuffer.append(" PortCount: " + this.iPortCount);
        stringBuffer.append(" WWPNs:");
        int n = 0;
        while (n < this.vecWWPNs.size()) {
            String string = (String)this.vecWWPNs.elementAt(n);
            stringBuffer.append(" " + string);
            ++n;
        }
        stringBuffer.append(" Action: " + this.iAction);
        return stringBuffer.toString();
    }
}

