/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.ni.application.resource.NIHostPort;
import com.ibm.storage.ess.ni.application.resource.NISCSIHostPort;
import com.ibm.storage.ess.ni.ca.NIEnterpriseAdvisor;
import com.ibm.storage.ess.ni.ca.NIImageHostPortGroup;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID;
import com.ibm.storage.ess.ni.resource.NISCSIHostPortImpl;
import com.ibm.storage.ess.ni.util.NICADeepCloneable;
import java.io.Serializable;

public class NIImageHostPort
implements Serializable,
NICADeepCloneable {
    private static final long serialVersionUID = 1L;
    public static final int NO_ACTION = 1;
    public static final int CREATE = 2;
    public static final int MODIFY = 3;
    public static final int REPLACE = 4;
    public static final int DELETE = 5;
    private NIImageHostPortGroup hostPortGroup;
    private NIHostPort hostPort;
    private NIHostPort originalHostPort;
    private NIHostPortID hostPortID;
    private boolean replacePort;
    private long WWPN;
    private long originalWWPN;
    private int iAction;

    protected NIImageHostPort(NIImageHostPortGroup nIImageHostPortGroup, NIHostPort nIHostPort, int n) {
        this.hostPortGroup = nIImageHostPortGroup;
        this.hostPort = nIHostPort;
        this.hostPortID = (NIHostPortID)nIHostPort.getID();
        this.iAction = n;
        if (nIHostPort instanceof NISCSIHostPort) {
            NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)this.hostPort;
            this.originalHostPort = (NIHostPort)((NISCSIHostPortImpl)nISCSIHostPort).clone();
            this.WWPN = nISCSIHostPort.getWWPN();
            this.originalWWPN = nISCSIHostPort.getWWPN();
        }
    }

    public synchronized Object clone() {
        NIImageHostPort nIImageHostPort = null;
        try {
            nIImageHostPort = (NIImageHostPort)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
        }
        return nIImageHostPort;
    }

    public boolean equals(Object object) {
        return this.getHostPort().equals(((NIImageHostPort)object).getHostPort()) && this.getWWPN() == ((NIImageHostPort)object).getWWPN();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WWPN: 0x" + NIEnterpriseAdvisor.hexStringFromLong(this.WWPN, 16));
        stringBuffer.append(" Action: " + this.iAction);
        return stringBuffer.toString();
    }

    protected void setAction(int n) {
        this.iAction = n;
    }

    protected int getAction() {
        return this.iAction;
    }

    public NIImageHostPortGroup getOwner() {
        return this.hostPortGroup;
    }

    public NIHostPort getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(NIHostPort nIHostPort) {
        this.hostPort = nIHostPort;
    }

    public NIHostPort getOriginalHostPort() {
        return this.originalHostPort;
    }

    public void setOriginalHostPort(NIHostPort nIHostPort) {
        this.hostPort = nIHostPort;
    }

    public NIHostPortID getID() {
        return this.hostPortID;
    }

    public void setCreated(NIHostPortID nIHostPortID) {
        if (this.getAction() == 2) {
            this.hostPortID = nIHostPortID;
            ((NISCSIHostPortImpl)this.hostPort).setID(this.hostPortID);
            this.setAction(3);
        }
    }

    protected void setWWPN(long l) {
        this.WWPN = l;
        if (this.getAction() == 4) {
            NISCSIHostPortImpl nISCSIHostPortImpl = (NISCSIHostPortImpl)this.hostPort;
            NIESSID nIESSID = this.hostPortID.getESS();
            NISCSIHostPortID nISCSIHostPortID = new NISCSIHostPortID(nIESSID, 0);
            nISCSIHostPortImpl.setID(nISCSIHostPortID);
            nISCSIHostPortImpl.setWWPN(this.WWPN);
        } else if (this.getAction() == 3) {
            NISCSIHostPortImpl nISCSIHostPortImpl = (NISCSIHostPortImpl)this.hostPort;
            nISCSIHostPortImpl.setID((NISCSIHostPortID)this.hostPortID);
            nISCSIHostPortImpl.setWWPN(this.WWPN);
        } else if (this.getAction() == 2) {
            NISCSIHostPortImpl nISCSIHostPortImpl = (NISCSIHostPortImpl)this.hostPort;
            nISCSIHostPortImpl.setWWPN(this.WWPN);
        }
    }

    protected long getWWPN() {
        return this.WWPN;
    }

    protected long getOriginalWWPN() {
        return this.originalWWPN;
    }
}

