/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.ni.ca.NIEnterpriseHostPortGroup;
import com.ibm.storage.ess.ni.ca.NIHostType;
import com.ibm.storage.ess.ni.ca.NIImage;
import com.ibm.storage.ess.ni.ca.NIImageIOPort;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.option.config.NIAttachLoginPolicy;
import com.ibm.storage.ess.ni.option.config.NIAttachLoginPolicyAnyPort;
import com.ibm.storage.ess.ni.option.config.NIHostPortType;
import com.ibm.storage.ess.ni.util.NICADeepCloneable;
import java.io.Serializable;
import java.util.Vector;

public class NIImageHostPortGroup
implements Serializable,
NICADeepCloneable {
    private static final long serialVersionUID = 1L;
    public static final int NO_ACTION = 1;
    public static final int CREATE = 2;
    public static final int MODIFY = 3;
    public static final int DELETE = 4;
    public static final int CANDIDATE = 5;
    private int iAction;
    private NIImage owner;
    private NIEnterpriseHostPortGroup enterpriseGroup;
    private boolean attached;
    private NIVolumeGroupID volumeGroup;
    private NIAttachLoginPolicy loginPolicy;
    private Vector vecIOPorts;
    private Vector vecHostPorts;

    protected NIImageHostPortGroup(NIImage nIImage, NIEnterpriseHostPortGroup nIEnterpriseHostPortGroup, int n) {
        this.owner = nIImage;
        this.enterpriseGroup = nIEnterpriseHostPortGroup;
        this.iAction = n;
        this.attached = false;
        this.vecIOPorts = new Vector();
        this.vecHostPorts = new Vector();
        this.volumeGroup = null;
        this.loginPolicy = NIAttachLoginPolicyAnyPort.Option;
    }

    public String getIdentifier() {
        return this.enterpriseGroup.getIdentifier();
    }

    public int getPortCount() {
        return this.enterpriseGroup.getPortCount();
    }

    public int getPortGroupNumber() {
        return this.enterpriseGroup.getPortGroupNumber();
    }

    public NIHostPortType getHostPortType() {
        return this.enterpriseGroup.getHostPortType();
    }

    public NIHostType getHostType() {
        return this.enterpriseGroup.getHostType();
    }

    public int getAttachedImageCount() {
        return this.enterpriseGroup.getAttachedImageCount();
    }

    public boolean areWWPNsChanged() {
        return this.enterpriseGroup.areWWPNsChanged();
    }

    public NIImage getOwner() {
        return this.owner;
    }

    protected NIEnterpriseHostPortGroup getEnterpriseGroup() {
        return this.enterpriseGroup;
    }

    public NIVolumeGroupID getVolumeGroup() {
        return this.volumeGroup;
    }

    public void setVolumeGroup(NIVolumeGroupID nIVolumeGroupID) {
        this.volumeGroup = nIVolumeGroupID;
    }

    public boolean isAttachedToImage() {
        return this.attached;
    }

    protected void setAttachedToImage(boolean bl) {
        this.attached = bl;
    }

    protected NIAttachLoginPolicy getLoginPolicy() {
        return this.loginPolicy;
    }

    protected void setLoginPolicy(NIAttachLoginPolicy nIAttachLoginPolicy) {
        this.loginPolicy = nIAttachLoginPolicy;
    }

    protected Vector getIOPorts() {
        return this.vecIOPorts;
    }

    protected void addIOPorts(Vector vector) {
        this.vecIOPorts.addAll(vector);
    }

    protected void removeIOPort(NIImageIOPort nIImageIOPort) {
        if (this.vecIOPorts.contains(nIImageIOPort)) {
            this.vecIOPorts.remove(nIImageIOPort);
        }
    }

    protected void removeAllIOPorts() {
        this.vecIOPorts.removeAllElements();
    }

    protected Vector getHostPorts() {
        return this.vecHostPorts;
    }

    protected void addHostPorts(Vector vector) {
        this.vecHostPorts.addAll(vector);
    }

    protected int getAction() {
        return this.iAction;
    }

    protected void setAction(int n) {
        this.iAction = n;
    }

    public synchronized Object clone() {
        NIImageHostPortGroup nIImageHostPortGroup = null;
        try {
            nIImageHostPortGroup = (NIImageHostPortGroup)super.clone();
            nIImageHostPortGroup.vecIOPorts = (Vector)this.vecIOPorts.clone();
            nIImageHostPortGroup.vecHostPorts = (Vector)this.vecHostPorts.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
        }
        return nIImageHostPortGroup;
    }

    public boolean equals(Object object) {
        if (this.getOwner().equals(((NIImageHostPortGroup)object).getOwner()) && this.getEnterpriseGroup().equals(((NIImageHostPortGroup)object).getEnterpriseGroup())) {
            if (this.getVolumeGroup() != null && ((NIImageHostPortGroup)object).getVolumeGroup() != null) {
                return this.getVolumeGroup().equals(((NIImageHostPortGroup)object).getVolumeGroup());
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Owner: " + this.owner.toString());
        stringBuffer.append(" Group: [" + this.enterpriseGroup.toString() + "]");
        if (this.volumeGroup != null) {
            stringBuffer.append(" VolumeGroupID: " + this.volumeGroup.toString());
        }
        stringBuffer.append(" LoginPolicy: " + this.loginPolicy.toString());
        stringBuffer.append(" Action: " + this.iAction);
        return stringBuffer.toString();
    }
}

