/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.ca;

import com.ibm.storage.ess.ni.application.resource.NIIOPort;
import com.ibm.storage.ess.ni.ca.NIImageHostPort;
import com.ibm.storage.ess.ni.ca.NIImageHostPortGroup;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.option.config.NIFabricTopology;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyUnknown;
import com.ibm.storage.ess.ni.util.NICADeepCloneable;
import com.ibm.storage.ess.ni.util.NICAVector;
import java.io.Serializable;
import java.util.Vector;

public class NIImageIOPort
implements Serializable,
NICADeepCloneable {
    private static final long serialVersionUID = 1L;
    public static final int NO_ACTION = 1;
    public static final int MODIFY = 3;
    private Vector vecHostPorts;
    private NIFabricTopology fabricTopology;
    private NIIOPort port;
    private String strPortLocation;
    private boolean zAnonymousAccessEnabled;
    private boolean zAttached;
    private boolean zAvailable;
    private boolean zESCONEnabled;
    private boolean zFICONEnabled;
    private boolean zRecommended;
    private boolean zSCSIEnabled;
    private int iAction;
    private int iPortType;

    protected NIImageIOPort(NIIOPort nIIOPort, String string, NIFabricTopology nIFabricTopology, int n, int n2) {
        this.port = nIIOPort;
        this.strPortLocation = string;
        this.fabricTopology = nIFabricTopology != null ? nIFabricTopology : NIFabricTopologyUnknown.Option;
        this.iAction = n2;
        this.iPortType = n;
        this.zAvailable = false;
        this.zRecommended = false;
        this.zAttached = false;
        this.zSCSIEnabled = false;
        this.zFICONEnabled = false;
        this.zESCONEnabled = false;
        this.zAnonymousAccessEnabled = false;
        this.vecHostPorts = new Vector();
    }

    public boolean isAnonymousAccessEnabled() {
        return this.zAnonymousAccessEnabled;
    }

    public boolean isAttached() {
        return this.zAttached;
    }

    public boolean isAvailable() {
        return this.zAvailable;
    }

    public boolean isESCONEnabled() {
        return this.zESCONEnabled;
    }

    public boolean isFICONEnabled() {
        return this.zFICONEnabled;
    }

    public NIFabricTopology getFabricTopology() {
        return this.fabricTopology;
    }

    public int getHostAttachmentCount() {
        return this.getHostAttachments().size();
    }

    public Vector getHostAttachments() {
        Vector<NIImageHostPortGroup> vector = new Vector<NIImageHostPortGroup>();
        int n = 0;
        while (n < this.vecHostPorts.size()) {
            NIImageHostPortGroup nIImageHostPortGroup;
            NIImageHostPort nIImageHostPort = (NIImageHostPort)this.vecHostPorts.get(n);
            if (nIImageHostPort.getAction() != 5 && (nIImageHostPortGroup = nIImageHostPort.getOwner()).getAction() != 4 && !vector.contains(nIImageHostPortGroup)) {
                vector.add(nIImageHostPortGroup);
            }
            ++n;
        }
        return vector;
    }

    public NIIOPort getIOPort() {
        return this.port;
    }

    public String getLocation() {
        return this.strPortLocation;
    }

    public boolean isRecommended() {
        return this.zRecommended;
    }

    public boolean isSCSIEnabled() {
        return this.zSCSIEnabled;
    }

    public synchronized Object clone() {
        NIImageIOPort nIImageIOPort = null;
        try {
            nIImageIOPort = (NIImageIOPort)super.clone();
            nIImageIOPort.vecHostPorts = (NICAVector)this.vecHostPorts.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
        }
        return nIImageIOPort;
    }

    public boolean equals(Object object) {
        return this.getIOPort().equals(((NIImageIOPort)object).getIOPort()) && this.getLocation().equals(((NIImageIOPort)object).getLocation());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Port: " + ((NIIOPortID)this.port.getID()).toString());
        stringBuffer.append(" Location: " + this.strPortLocation);
        stringBuffer.append(" PortType: " + this.iPortType);
        stringBuffer.append(" FabricToplogy: " + this.fabricTopology);
        stringBuffer.append(" Action: " + this.iAction);
        return stringBuffer.toString();
    }

    protected void setAction(int n) {
        this.iAction = n;
    }

    protected int getAction() {
        return this.iAction;
    }

    protected void setAnonymousAccessEnabled(boolean bl) {
        this.zAnonymousAccessEnabled = bl;
    }

    protected void setAttached(boolean bl) {
        this.zAttached = bl;
    }

    protected void setAvailable(boolean bl) {
        this.zAvailable = bl;
    }

    protected void setESCONEnabled(boolean bl) {
        this.zESCONEnabled = bl;
    }

    protected void setFICONEnabled(boolean bl) {
        this.zFICONEnabled = bl;
    }

    protected void setFabricTopology(NIFabricTopology nIFabricTopology) {
        this.fabricTopology = nIFabricTopology != null ? nIFabricTopology : NIFabricTopologyUnknown.Option;
    }

    protected Vector getHostPorts() {
        return this.vecHostPorts;
    }

    protected int getIOPortType() {
        return this.iPortType;
    }

    protected void setRecommended(boolean bl) {
        this.zRecommended = bl;
    }

    protected void setSCSIEnabled(boolean bl) {
        this.zSCSIEnabled = bl;
    }

    protected void addHostPorts(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            NIImageHostPort nIImageHostPort = (NIImageHostPort)vector.elementAt(n2);
            if (!this.vecHostPorts.contains(nIImageHostPort)) {
                this.vecHostPorts.add(nIImageHostPort);
            }
            ++n2;
        }
    }

    protected void removeHostPorts(NIImageHostPort nIImageHostPort) {
        if (this.vecHostPorts.contains(nIImageHostPort)) {
            this.vecHostPorts.remove(nIImageHostPort);
        }
    }
}

