/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.cl.api;

import com.ibm.storage.ess.ni.application.NIServicesInfo;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.security.common.NIAuthenticationInfo;
import java.io.Serializable;

public class NICLTransfer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private NIStorageFacilityID srcSfid = null;
    private NIStorageFacilityID tgtSfid = null;
    private NIESSID srcEssId = null;
    private NIServicesInfo srcHmcInfo = null;
    private NIAuthenticationInfo srcAuth = null;
    private NIESSID tgtEssId = null;
    private NIServicesInfo tgtHmcInfo = null;
    private NIAuthenticationInfo tgtAuth = null;
    private NIResourceID[] aniResourceIdTgt;
    private int overwriteOption = -1;
    private boolean bPhysicalInScope = false;
    private boolean bLogicalInScope = false;
    private boolean bHostInScope = false;
    private int transferScope = -1;
    private int srcType;
    private int tgtType;
    private int[] milestoneIncrements = null;
    private NIResource[] configurationObjects = null;
    private String strTransferId = null;
    private int state = -1;
    public static final int CL_UNDEFINED = -1;
    public static final int DO_NOT_OVERWRITE = 0;
    public static final int MERGED_OVERWRITE = 1;
    public static final int COMPLETE_OVERWRITE = 2;
    public static final int USER_CHOICE_MERGED_OVERWRITE = 3;
    public static final int RUNNING_STATE = 0;
    public static final int PAUSED_STATE = 1;
    public static final int COMPLETED_STATE = 2;
    public static final int PHYSICAL_SCOPE = 0;
    public static final int PHYSICAL_AND_LOGICAL_SCOPE = 1;
    public static final int ALL_SCOPE = 2;
    public static final int LOGICAL_SCOPE = 3;
    public static final int LOGICAL_AND_HOST_SCOPE = 4;
    public static final int OFFLINE_TO_OFFLINE_TRANSFER_PATH = 0;
    public static final int OFFLINE_TO_ONLINE_TRANSFER_PATH = 1;
    public static final int ONLINE_TO_OFFLINE_TRANSFER_PATH = 2;
    public static final int ONLINE_TO_ONLINE_TRANSFER_PATH = 3;
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;

    public NICLTransfer(NIESSID nIESSID, NIServicesInfo nIServicesInfo, NIAuthenticationInfo nIAuthenticationInfo, int n, NIResource[] nIResourceArray) {
        this(nIESSID, nIServicesInfo, nIAuthenticationInfo, null, null, nIAuthenticationInfo, -1, -1, -1);
        this.srcType = n;
        this.configurationObjects = nIResourceArray;
        this.tgtType = -1;
    }

    public NICLTransfer(NIStorageFacilityID nIStorageFacilityID, NIServicesInfo nIServicesInfo, NIAuthenticationInfo nIAuthenticationInfo, int n) {
        this.srcSfid = nIStorageFacilityID;
        this.srcEssId = null;
        this.srcHmcInfo = nIServicesInfo;
        this.srcAuth = nIAuthenticationInfo;
        this.tgtEssId = null;
        this.tgtHmcInfo = null;
        this.tgtAuth = null;
        this.overwriteOption = -1;
        this.srcType = n;
        this.tgtType = -1;
        this.srcType = n;
    }

    public NICLTransfer(NIESSID nIESSID, NIServicesInfo nIServicesInfo, NIAuthenticationInfo nIAuthenticationInfo, NIESSID nIESSID2, NIServicesInfo nIServicesInfo2, NIAuthenticationInfo nIAuthenticationInfo2, int n, int n2, int n3) {
        this.srcEssId = nIESSID;
        this.srcHmcInfo = nIServicesInfo;
        this.srcAuth = nIAuthenticationInfo;
        this.tgtEssId = nIESSID2;
        this.tgtHmcInfo = nIServicesInfo2;
        this.tgtAuth = nIAuthenticationInfo2;
        this.overwriteOption = n;
        this.transferScope = n2;
        if (n3 != -1) {
            this.srcType = n3 == 2 || n3 == 3 ? 0 : 1;
            this.tgtType = n3 == 3 || n3 == 1 ? 0 : 1;
        }
        if (n2 == 0) {
            this.bPhysicalInScope = true;
        } else if (n2 == 1) {
            this.bPhysicalInScope = true;
            this.bLogicalInScope = true;
        } else if (n2 == 2) {
            this.bPhysicalInScope = true;
            this.bLogicalInScope = true;
            this.bHostInScope = true;
        } else if (n2 == 3) {
            this.bLogicalInScope = true;
        } else if (n2 == 4) {
            this.bLogicalInScope = true;
            this.bHostInScope = true;
        }
    }

    public String getTransferID() {
        return this.strTransferId;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public NIStorageFacilityID getSourceFacilityID() {
        return this.srcSfid;
    }

    public NIStorageFacilityID getTargetFacilityID() {
        return this.tgtSfid;
    }

    public NIESSID getSourceESSID() {
        return this.srcEssId;
    }

    public NIServicesInfo getSourceServicesInfo() {
        return this.srcHmcInfo;
    }

    public NIAuthenticationInfo getSourceAuthenticationInfo() {
        return this.srcAuth;
    }

    public NIESSID getTargetESSID() {
        return this.tgtEssId;
    }

    public NIServicesInfo getTargetServicesInfo() {
        return this.tgtHmcInfo;
    }

    public NIAuthenticationInfo getTargetAuthenticationInfo() {
        return this.tgtAuth;
    }

    public NIResourceID[] getTargetResourceIds() {
        return this.aniResourceIdTgt;
    }

    public int getOverwrite() {
        return this.overwriteOption;
    }

    public int getScope() {
        return this.transferScope;
    }

    public int getSourceType() {
        return this.srcType;
    }

    public int getTargetType() {
        return this.tgtType;
    }

    public int[] getMilestoneIncrements() {
        return this.milestoneIncrements;
    }

    public boolean isPhysicalInScope() {
        return this.bPhysicalInScope;
    }

    public boolean isLogicalInScope() {
        return this.bLogicalInScope;
    }

    public boolean isHostInScope() {
        return this.bHostInScope;
    }

    public void setMilestones(int n) {
        int n2 = 100 / n;
        this.milestoneIncrements = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.milestoneIncrements[n3] = n * (n3 + 1);
            ++n3;
        }
    }

    public void setMilestones(int[] nArray) {
        this.milestoneIncrements = nArray;
    }

    public NIResource[] getConfigurationObjects() {
        return this.configurationObjects;
    }

    public void setConfigurationObjects(NIResource[] nIResourceArray) {
        this.configurationObjects = nIResourceArray;
    }

    public void updateTarget(NIESSID nIESSID, NIServicesInfo nIServicesInfo, NIAuthenticationInfo nIAuthenticationInfo, NIResourceID[] nIResourceIDArray, int n, int n2, int n3) {
        this.tgtEssId = nIESSID;
        this.tgtHmcInfo = nIServicesInfo;
        this.tgtAuth = nIAuthenticationInfo;
        this.aniResourceIdTgt = nIResourceIDArray;
        this.tgtType = n;
        this.overwriteOption = n2;
        this.transferScope = n3;
        if (n3 == 0) {
            this.bPhysicalInScope = true;
        } else if (n3 == 1) {
            this.bPhysicalInScope = true;
            this.bLogicalInScope = true;
        } else if (n3 == 2) {
            this.bPhysicalInScope = true;
            this.bLogicalInScope = true;
            this.bHostInScope = true;
        } else if (n3 == 3) {
            this.bLogicalInScope = true;
        } else if (n3 == 4) {
            this.bLogicalInScope = true;
            this.bHostInScope = true;
        }
    }

    public void updateTarget(NIStorageFacilityID nIStorageFacilityID, NIServicesInfo nIServicesInfo, NIAuthenticationInfo nIAuthenticationInfo, int n, int n2, int n3) {
        this.tgtSfid = nIStorageFacilityID;
        this.tgtHmcInfo = nIServicesInfo;
        this.tgtAuth = nIAuthenticationInfo;
        this.tgtType = n;
        this.overwriteOption = n2;
        this.transferScope = n3;
        if (n3 == 0) {
            this.bPhysicalInScope = true;
        } else if (n3 == 1) {
            this.bPhysicalInScope = true;
            this.bLogicalInScope = true;
        } else if (n3 == 2) {
            this.bPhysicalInScope = true;
            this.bLogicalInScope = true;
            this.bHostInScope = true;
        } else if (n3 == 3) {
            this.bLogicalInScope = true;
        } else if (n3 == 4) {
            this.bLogicalInScope = true;
            this.bHostInScope = true;
        }
    }

    public void setTransferID(String string) {
        this.strTransferId = string;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof NICLTransfer ? ((NICLTransfer)object).getTransferID().equalsIgnoreCase(this.strTransferId) : false;
        return bl;
    }
}

