/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.cl.module;

import com.ibm.storage.ess.ni.application.NIServices;
import com.ibm.storage.ess.ni.application.NIServicesInfo;
import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIArraySite;
import com.ibm.storage.ess.ni.application.resource.NIDDMPack;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIESSDomainElement;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NIIOPort;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIOfflineStorageFacility;
import com.ibm.storage.ess.ni.application.resource.NIOfflineStoragePlex;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NISCSIHostPort;
import com.ibm.storage.ess.ni.application.resource.NIStorageDeviceFRU;
import com.ibm.storage.ess.ni.application.resource.NIStorageFacility;
import com.ibm.storage.ess.ni.application.resource.NIVolume;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroup;
import com.ibm.storage.ess.ni.application.results.NICLResult;
import com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIConfigResult;
import com.ibm.storage.ess.ni.application.results.NIESSDomainResult;
import com.ibm.storage.ess.ni.application.results.NIPortProfilesResult;
import com.ibm.storage.ess.ni.application.results.NIResult;
import com.ibm.storage.ess.ni.cl.api.NICLTransfer;
import com.ibm.storage.ess.ni.cl.module.NICLArrayToSiteMap;
import com.ibm.storage.ess.ni.cl.module.NICLProcessor;
import com.ibm.storage.ess.ni.cl.module.NICLReader;
import com.ibm.storage.ess.ni.cl.module.util.NICLGenealogist;
import com.ibm.storage.ess.ni.cl.module.util.NICLGeneralUtils;
import com.ibm.storage.ess.ni.cl.module.util.NICLResourceComparator;
import com.ibm.storage.ess.ni.constants.NIHostConstants;
import com.ibm.storage.ess.ni.event.extensions.NICLEventImpl;
import com.ibm.storage.ess.ni.exception.NIAuthenticationFailureException;
import com.ibm.storage.ess.ni.exception.NICLException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.identifiers.NIStoragePlexID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.olc.NIOlcEventProcessor;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import com.ibm.storage.ess.ni.option.config.NIRaidType5;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupType;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520All;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMap256;
import com.ibm.storage.ess.ni.resource.NIArrayImpl;
import com.ibm.storage.ess.ni.resource.NIExtentPoolImpl;
import com.ibm.storage.ess.ni.resource.NILSSImpl;
import com.ibm.storage.ess.ni.resource.NIResourceImpl;
import com.ibm.storage.ess.ni.resource.NISCSIHostPortImpl;
import com.ibm.storage.ess.ni.resource.NIStorageFacilityImpl;
import com.ibm.storage.ess.ni.resource.NIVolumeGroupImpl;
import com.ibm.storage.ess.ni.results.NIConfigCreatedResultImpl;
import com.ibm.storage.ess.ni.results.NIConfigQueryResultImpl;
import com.ibm.storage.ess.ni.results.NIConfigResultImpl;
import com.ibm.storage.ess.ni.security.common.NIAuthenticationInfo;
import com.ibm.storage.ess.ni.services.NIDomainService;
import com.ibm.storage.ess.ni.services.NIHostConfigurationService;
import com.ibm.storage.ess.ni.services.NILogicalConfigurationService;
import com.ibm.storage.ess.ni.services.NIOfflineDomainService;
import com.ibm.storage.ess.ni.services.NIPhysicalConfigurationService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class NICLTransferThread
implements Runnable {
    private static final String CLASS_NAME = "NICLTransferThread";
    private static final String TRANSFER_ID_PREFIX = "CL_XFER";
    private static final int SFI1 = 0;
    private static final int SFI2 = 1;
    private static final int FACILITY = 0;
    private static final int IMAGES = 1;
    private static final int IO_PORTS = 2;
    private static final int ARRAYS = 3;
    private static final int EXTENT_POOLS = 4;
    private static final int RANKS = 5;
    private static final int LSSS = 6;
    private static final int VOLUMES = 7;
    private static final int VOL_GROUPS = 8;
    private static final int SCSI_PORTS = 9;
    private static final int NUM_CONFIG_OBJECT_TYPES = 10;
    private static final String[] RSRC_NAMES = new String[]{"NIStorageFacility", "NIESS", "NIIOPort", "NIArray", "NIExtentPool", "NIRank", "NILSS", "NIVolume", "NIVolumeGroup", "NISCSIHostPort"};
    private static final int SOURCE = 0;
    private static final int TARGET = 1;
    private static final int NUM_IMAGES_FOR_XFER = 2;
    private static final String DUMMY_DESCRIPTION = "Temporary object for configuation transfer.";
    private static final NIExtentType DUMMY_EXTENT_TYPE = NIExtentTypeFB.Option;
    private static final String DUMMY_PORT_PROFILE = NIHostConstants.getHostInfo(0, 2);
    private static final NIRaidType DUMMY_RAID_TYPE = NIRaidType5.Option;
    private static final String DUMMY_USERNAME_PREFIX = "CL_Temporary_Resource_";
    private static final NIVolumeGroupType DUMMY_VOL_GROUP_TYPE = NIVolumeGroupTypeSCSIMap256.Option;
    private static final long DUMMY_WWNN = -1152921504606846976L;
    private static final String COPY_LABEL = "Copy of ";
    private static final int ARRAY_CHECKING_TIMEOUT = 720;
    private static final int ARRAY_CHECKING_SLEEP_VALUE = 20000;
    private static final int RANK_CHECKING_TIMEOUT = 180;
    private static final int RANK_CHECKING_SLEEP_VALUE = 20000;
    private static final int MAX_VOLS_FOR_CREATE_2107 = 64;
    private static final int MAX_VOLS_FOR_CREATE_1750 = 16;
    private static final int OP_CREATE = 0;
    private static final int OP_DELETE = 1;
    public static int iReadAndPauseCtr = 2;
    private NICLTransfer clTransfer;
    private NICLProcessor clProcessor;
    private NICLArrayToSiteMap clAtsMap;
    private NIResourceID[] aniResourceIdTgt;
    private int[] creationOrder = new int[]{0, 2, 3, 4, 5, 6, 7, 8, 1, 9};
    private int[] deletionOrder = new int[]{9, 8, 7, 6, 5, 4, 3};
    private boolean bPauseTransfer;
    private boolean bDeleteConfigComplete;
    private boolean bReadingComplete;
    private boolean bPhysicalCheckComplete;
    private boolean bMappingComplete;
    private int iStage;
    private List[][] alstConfigObjs = new List[2][10];
    private List[][] alstDeleteObjs = new List[2][10];
    private List[][] alstModifyObjs = new List[2][10];
    List[] lstDummyIds = new List[10];
    private boolean[] bObjTransferComplete = new boolean[10];
    private boolean bTransferComplete;
    private boolean[] bVolumesSorted = new boolean[2];
    private int[][] aiSrcVolIndx = new int[2][65536];
    private boolean[][] abVolDeletionTable = new boolean[2][65536];
    private int[] aiConnTypes = new int[2];
    private NIDomainService[] aniDomainService = new NIDomainService[2];
    private NIServices[] aniServices = new NIServices[2];
    private NIServicesInfo[] aniServicesInfo = new NIServicesInfo[2];
    private NIAuthenticationInfo[] aniAuthInfo = new NIAuthenticationInfo[2];
    private NIESSID[][] aniEssIds = new NIESSID[2][2];
    private NIStoragePlexID[] aniPlexIds = new NIStoragePlexID[2];
    private NIStorageFacilityID[] aniSfids = new NIStorageFacilityID[2];
    private NICLReader[] tgtReaders = new NICLReader[2];
    private int curEss;
    private int curCfgObj;
    private int curModObj;
    private int curType;
    private int iNumObjsXferred;
    private int iTotalObjs;
    private int iOverwrite;
    private boolean bReadAndPause;
    private boolean sentFailedEvent;

    public NICLTransferThread(NICLTransfer nICLTransfer, NICLProcessor nICLProcessor) {
        NIResourceID nIResourceID;
        NIOlcLogger.enter(CLASS_NAME, "NICLTransferThread()");
        this.clTransfer = nICLTransfer;
        this.clProcessor = nICLProcessor;
        this.aniResourceIdTgt = null;
        this.curEss = 0;
        this.curCfgObj = 0;
        this.curModObj = 0;
        this.curType = 0;
        this.iTotalObjs = 0;
        this.iNumObjsXferred = 0;
        this.bPauseTransfer = false;
        this.bDeleteConfigComplete = false;
        this.bReadingComplete = false;
        this.bMappingComplete = false;
        this.bPhysicalCheckComplete = false;
        this.bTransferComplete = false;
        this.sentFailedEvent = false;
        this.iOverwrite = nICLTransfer.getOverwrite();
        this.iStage = -1;
        this.aniServicesInfo[0] = nICLTransfer.getSourceServicesInfo();
        this.aniServicesInfo[1] = nICLTransfer.getTargetServicesInfo();
        this.aniAuthInfo[0] = nICLTransfer.getSourceAuthenticationInfo();
        this.aniAuthInfo[1] = nICLTransfer.getTargetAuthenticationInfo();
        this.aniEssIds[0][0] = nICLTransfer.getSourceESSID();
        this.aniEssIds[1][0] = nICLTransfer.getTargetESSID();
        this.aiConnTypes[0] = nICLTransfer.getSourceType();
        this.aiConnTypes[1] = nICLTransfer.getTargetType();
        Arrays.fill(this.bVolumesSorted, false);
        Arrays.fill(this.bObjTransferComplete, false);
        if (nICLTransfer.getTargetESSID() == null) {
            if (nICLTransfer.getTargetFacilityID() != null) {
                nIResourceID = nICLTransfer.getTargetFacilityID();
                this.bReadAndPause = false;
                this.clTransfer.setTransferID("CL_XFER." + ((NIStorageFacilityID)nIResourceID).getType() + "." + ((NIStorageFacilityID)nIResourceID).getSequence() + "." + iReadAndPauseCtr);
            } else if (nICLTransfer.getSourceFacilityID() != null) {
                nIResourceID = nICLTransfer.getSourceFacilityID();
                this.bReadAndPause = true;
                this.clTransfer.setTransferID("CL_XFER." + ((NIStorageFacilityID)nIResourceID).getType() + "." + ((NIStorageFacilityID)nIResourceID).getSequence() + "." + iReadAndPauseCtr);
                ++iReadAndPauseCtr;
            } else {
                nIResourceID = nICLTransfer.getSourceESSID();
                this.bReadAndPause = true;
                this.clTransfer.setTransferID("CL_XFER." + ((NIESSID)nIResourceID).getType() + "." + ((NIESSID)nIResourceID).getSequence() + "." + iReadAndPauseCtr);
                ++iReadAndPauseCtr;
            }
        } else {
            nIResourceID = nICLTransfer.getTargetESSID();
            this.bReadAndPause = false;
            this.clTransfer.setTransferID("CL_XFER." + ((NIESSID)nIResourceID).getType() + "." + ((NIESSID)nIResourceID).getSequence() + "." + this.aiConnTypes[1]);
        }
        if (this.aniEssIds[0][0] == null) {
            this.aniSfids[0] = nICLTransfer.getSourceFacilityID();
            this.aniPlexIds[0] = this.aniSfids[0].getStoragePlex();
            if (!this.bReadAndPause) {
                this.aniSfids[1] = nICLTransfer.getTargetFacilityID();
                this.aniPlexIds[1] = this.aniSfids[1].getStoragePlex();
            }
        } else {
            this.aniSfids[0] = this.aniEssIds[0][0].getStorageFacility();
            this.aniPlexIds[0] = this.aniEssIds[0][0].getStorageFacility().getStoragePlex();
            if (!this.bReadAndPause) {
                this.aniSfids[1] = this.aniEssIds[1][0].getStorageFacility();
                this.aniPlexIds[1] = this.aniSfids[1].getStoragePlex();
            }
        }
        int n = 0;
        while (n < 2) {
            Arrays.fill(this.aiSrcVolIndx[n], -1);
            int n2 = 0;
            while (n2 < 10) {
                this.alstConfigObjs[n][n2] = new ArrayList();
                this.alstModifyObjs[n][n2] = new ArrayList();
                this.alstDeleteObjs[n][n2] = new ArrayList();
                ++n2;
            }
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": NICLTransferThread()");
    }

    public void shutdown() {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": shutdown()");
        try {
            if (this.aniServices[0].checkConnection()) {
                this.aniServices[0].disconnect();
            }
        }
        catch (Exception exception) {
            NIOlcLogger.info(this.clTransfer.getTransferID() + ": WARNING - Exception while disconnecting from source...");
            NIOlcLogger.severe(exception.toString(), exception);
        }
        try {
            if (this.aniServices[1].checkConnection()) {
                this.aniServices[1].disconnect();
            }
        }
        catch (Exception exception) {
            NIOlcLogger.info(this.clTransfer.getTransferID() + ": WARNING - Exception while disconnecting from target...");
            NIOlcLogger.severe(exception.toString(), exception);
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": shutdown()");
    }

    public NICLTransfer getTransfer() {
        return this.clTransfer;
    }

    public void run() {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": run()");
        try {
            boolean bl = true;
            this.bPauseTransfer = false;
            if (this.connectToPlex(0) && !this.bPauseTransfer && (this.bReadAndPause && !this.bReadingComplete || this.connectToPlex(1) && !this.bPauseTransfer)) {
                this.clTransfer.setState(0);
                if (!this.bReadingComplete) {
                    this.iStage = 1;
                    bl = this.readSource();
                    this.aniServices[0].disconnect();
                }
                if (bl && !this.bPauseTransfer) {
                    this.initReaders();
                    if (!this.bPhysicalCheckComplete) {
                        this.iStage = 2;
                        bl = this.checkPhysicalCompatibility();
                    }
                    if (bl && !this.bPauseTransfer) {
                        if (!this.bMappingComplete) {
                            this.iStage = 3;
                            bl = this.mapResources();
                            if (bl && this.iOverwrite == 3) {
                                this.pause();
                                this.sendDeletionList();
                            }
                        }
                        if (bl && !this.bDeleteConfigComplete && !this.bPauseTransfer) {
                            this.iStage = 4;
                            bl = this.deleteConfig();
                        }
                        if (bl && !this.bTransferComplete && !this.bPauseTransfer) {
                            this.iStage = 5;
                            bl = this.processTransfer();
                            if (!this.bPauseTransfer && bl) {
                                this.clTransfer.setState(2);
                                this.clProcessor.markCompleted(this);
                                this.sendEvent(0, null, null);
                            }
                        }
                    }
                }
                if (!bl) {
                    this.pause();
                }
                if (this.bPauseTransfer) {
                    this.clTransfer.setState(1);
                    this.clProcessor.pauseTransfer(this.clTransfer);
                }
            } else {
                this.pause();
                this.clTransfer.setState(1);
                this.clProcessor.pauseTransfer(this.clTransfer);
            }
        }
        catch (Exception exception) {
            this.sendEvent(-1, null, exception);
            this.pause();
            this.clTransfer.setState(1);
            this.clProcessor.pauseTransfer(this.clTransfer);
        }
        try {
            if (this.clTransfer.getState() == 2) {
                this.aniServices[1].disconnect();
            }
            NIOlcLogger.info(this.clTransfer.getTransferID() + ": IDs of remaining dummy objects to follow if applicable:");
            int n = 0;
            while (n < 10) {
                if (this.lstDummyIds[n] != null) {
                    int n2 = this.lstDummyIds[n].size();
                    int n3 = 0;
                    while (n3 < n2) {
                        NIResourceID nIResourceID = (NIResourceID)this.lstDummyIds[n].get(n3);
                        NIOlcLogger.info(this.clTransfer.getTransferID() + ": Dummy object - " + nIResourceID);
                        ++n3;
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            NIOlcLogger.info(this.clTransfer.getTransferID() + ": ** Exception during logging of dummy objects **");
            this.sendEvent(-1, null, exception);
        }
        System.out.println("Transfer finished (" + this.clTransfer.getTransferID() + ").");
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": run()");
    }

    public void pause() {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": pause()");
        if (!this.bReadAndPause || this.bReadingComplete) {
            this.bPauseTransfer = true;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": pause()");
    }

    public void updateTarget(NICLTransfer nICLTransfer) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": updateTarget()");
        this.aniEssIds[1][0] = nICLTransfer.getTargetESSID();
        this.aniServicesInfo[1] = nICLTransfer.getTargetServicesInfo();
        this.aniAuthInfo[1] = nICLTransfer.getTargetAuthenticationInfo();
        this.aniResourceIdTgt = nICLTransfer.getTargetResourceIds();
        this.aiConnTypes[1] = nICLTransfer.getTargetType();
        this.aniSfids[1] = nICLTransfer.getSourceFacilityID();
        if (this.aniEssIds[1][0] != null) {
            this.aniPlexIds[1] = this.aniEssIds[1][0].getStorageFacility().getStoragePlex();
            this.clTransfer.setTransferID("CL_XFER." + this.aniEssIds[1][0].getType() + "." + this.aniEssIds[1][0].getSequence() + "." + this.aiConnTypes[1]);
        } else {
            this.aniPlexIds[1] = this.aniSfids[1].getStoragePlex();
            this.clTransfer.setTransferID("CL_XFER." + this.aniSfids[1].getType() + "." + this.aniSfids[1].getSequence() + "." + this.aiConnTypes[1]);
        }
        nICLTransfer.setTransferID(this.clTransfer.getTransferID());
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": updateTarget()");
    }

    public int getProgress() {
        int n;
        if (this.iTotalObjs == 0) {
            n = 0;
        } else {
            n = this.iNumObjsXferred * 100 / this.iTotalObjs;
            if (n > 100) {
                NIOlcLogger.info("WARNING: Progress is too large - " + this.iNumObjsXferred + " / " + this.iTotalObjs);
                n = 99;
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": equals()");
        boolean bl = object instanceof NICLTransfer ? ((NICLTransfer)object).getTransferID().equalsIgnoreCase(this.clTransfer.getTransferID()) : (object instanceof NICLTransferThread ? ((NICLTransferThread)object).getTransfer().getTransferID().equalsIgnoreCase(this.clTransfer.getTransferID()) : false);
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": equals()");
        return bl;
    }

    private NIConfigResult assignRank(NIExtentPoolID nIExtentPoolID, NIRankID nIRankID) throws NIServerException, NIUnsupportedException {
        NIConfigResult nIConfigResult;
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": assignRank()");
        boolean bl = true;
        NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
        NIRankID[] nIRankIDArray = new NIRankID[]{nIRankID};
        NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getRanks(new NIRankID[]{nIRankID});
        NIRank nIRank = (NIRank)this.getResource(nIConfigQueryResult, 5);
        if (NICLGeneralUtils.getIdIntValue(nIRank.getExtentPoolID()) != -1) {
            nIConfigQueryResult = nILogicalConfigurationService.queryVolumes(nIRankID);
            if (nIConfigQueryResult.isSuccessful()) {
                List list = nIConfigQueryResult.getResourceList();
                if (list.size() > 0) {
                    NIConfigResult[] nIConfigResultArray = nILogicalConfigurationService.deleteVolumes(list.toArray(new NIVolumeID[0]));
                    int n = 0;
                    while (n < nIConfigResultArray.length && !this.bPauseTransfer && bl) {
                        if (!nIConfigResultArray[n].isSuccessful()) {
                            nIConfigResult = nIConfigResultArray[n];
                            bl = false;
                        } else {
                            NIVolume nIVolume = (NIVolume)list.get(n);
                            int n2 = NICLGeneralUtils.getImageIndex(nIVolume.getID().getESS());
                            int n3 = this.indexOf(this.alstModifyObjs[n2][7], nIVolume.getID());
                            if (n3 >= 0) {
                                this.alstConfigObjs[n2][7].add(this.alstModifyObjs[n2][7].remove(n3));
                            }
                        }
                        ++n;
                    }
                }
            } else {
                nIConfigResult = new NIConfigResultImpl(null, false, nIConfigQueryResult.getCode());
                bl = false;
            }
            if (bl && (nIConfigResult = nILogicalConfigurationService.reserveRank(nIRankID)).isSuccessful()) {
                nIConfigResult = nILogicalConfigurationService.unassignRanks(nIRankIDArray)[0];
            }
        }
        if (NICLGeneralUtils.getIdIntValue(nIExtentPoolID) != -1) {
            this.waitForRankConfiguration(nILogicalConfigurationService, nIRankID);
            nIConfigQueryResult = nILogicalConfigurationService.getExtentPools(new NIExtentPoolID[]{nIExtentPoolID});
            NIExtentPool nIExtentPool = (NIExtentPool)this.getResource(nIConfigQueryResult, 5);
            nIConfigResult = nILogicalConfigurationService.assignRanks(nIExtentPool, nIRankIDArray)[0];
        } else {
            nIConfigResult = new NIConfigResultImpl(nIRankID, true, 0L);
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": assignRank()");
        return nIConfigResult;
    }

    private int indexOf(List list, NIResourceID nIResourceID) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": indexOf()");
        int n = -1;
        if (nIResourceID != null && list != null) {
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2 && n == -1) {
                if (((NIResource)list.get(n3)).getID().equals(nIResourceID)) {
                    n = n3;
                }
                ++n3;
            }
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": indexOf()");
        return n;
    }

    private void initReaders() throws NICLException {
        int n = 0;
        while (n < 2) {
            if (this.aniEssIds[1][n] != null && this.tgtReaders[n] == null) {
                this.tgtReaders[n] = new NICLReader(this.aniServices[1], this.aniEssIds[1][n]);
            }
            ++n;
        }
    }

    private NIResult getResult(NIResult[] nIResultArray) throws NICLException {
        if (nIResultArray.length > 0) {
            if (nIResultArray.length > 1) {
                int n = 1;
                while (n < nIResultArray.length) {
                    if (nIResultArray[n] != null) {
                        throw new NICLException(-1099694075L, 2);
                    }
                    ++n;
                }
            }
        } else {
            throw new NICLException(-1099694075L, 2);
        }
        NIResult nIResult = nIResultArray[0];
        return nIResult;
    }

    private NIResource getResource(NIConfigQueryResult nIConfigQueryResult, int n) throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": getResource()");
        List list = null;
        NIResource nIResource = null;
        if (!nIConfigQueryResult.isSuccessful()) {
            this.sendEvent(-1, nIConfigQueryResult, null);
            throw new NICLException((long)nIConfigQueryResult.getCode(), 2);
        }
        list = nIConfigQueryResult.getResourceList();
        if (list == null || list.size() != 1) {
            throw new NICLException(-1099694075L, 2);
        }
        nIResource = (NIResource)list.get(0);
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": getResource()");
        return nIResource;
    }

    private List getResourceList(NIConfigQueryResult nIConfigQueryResult) throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": getResourceList()");
        ArrayList arrayList = null;
        if (!nIConfigQueryResult.isSuccessful()) {
            if (nIConfigQueryResult.getCode() != -1101516788) {
                this.sendEvent(-1, nIConfigQueryResult, null);
                throw new NICLException((long)nIConfigQueryResult.getCode(), 2);
            }
            arrayList = new ArrayList();
        } else {
            arrayList = nIConfigQueryResult.getResourceList();
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": getResourceList()");
        return arrayList;
    }

    private List extractEssIds(NIESSDomainResult nIESSDomainResult) throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": extractEssIds()");
        ArrayList<NIESSID> arrayList = null;
        if (!nIESSDomainResult.isSuccessful()) {
            this.sendEvent(15, nIESSDomainResult, null);
            throw new NICLException((long)nIESSDomainResult.getCode(), 2);
        }
        arrayList = new ArrayList<NIESSID>();
        List list = nIESSDomainResult.getResourceList();
        if (list != null) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(((NIESSDomainElement)list.get(n2)).getESS());
                ++n2;
            }
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": extractEssIds()");
        return arrayList;
    }

    private NIOfflineStoragePlex getOfflinePlex(int n) throws NIServerException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": getOfflinePlex()");
        boolean bl = false;
        NIOfflineStoragePlex nIOfflineStoragePlex = null;
        NIConfigQueryResult nIConfigQueryResult = this.aniServices[n].getEnterpriseService().getStoragePlexes(this.aniPlexIds[n].getEnterprise());
        List list = nIConfigQueryResult.getResourceList();
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2 && !bl) {
            nIOfflineStoragePlex = (NIOfflineStoragePlex)list.get(n3);
            if (nIOfflineStoragePlex.getID().equals(this.aniPlexIds[n])) {
                bl = true;
            }
            ++n3;
        }
        if (!bl) {
            nIOfflineStoragePlex = null;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": getOfflinePlex()");
        return nIOfflineStoragePlex;
    }

    private boolean connectToPlex(int n) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": connectToPlex()");
        boolean bl = false;
        if (this.aniServices[n] == null) {
            this.aniServices[n] = new NIServices(this.aniServicesInfo[n], this.aniAuthInfo[n]);
        }
        if (!this.aniServices[n].checkConnection()) {
            try {
                int n2 = this.aniServices[n].connect();
                if (n2 == 1) {
                    this.sendEvent(1, null, null);
                } else if (n2 == 3) {
                    this.sendEvent(2, null, null);
                }
                if (!this.bPauseTransfer) {
                    Object object;
                    if (this.aiConnTypes[n] == 1) {
                        object = this.getOfflinePlex(n);
                        if (object == null) {
                            throw new NICLException(1L, 2);
                        }
                        this.aniServices[n] = this.aniServices[n].getEnterpriseService().getServices((NIOfflineStoragePlex)object, this.aniAuthInfo[n]);
                        n2 = this.aniServices[n].connect();
                        if (n2 == 3) {
                            this.sendEvent(2, null, null);
                        }
                        this.aniDomainService[n] = this.aniServices[n].getOfflineDomainService();
                    } else {
                        this.aniDomainService[n] = this.aniServices[n].getDomainService();
                    }
                    if (n == 0 && this.aniEssIds[0][0] == null) {
                        object = this.getSfis(this.aniSfids[0], 0);
                        List list = this.getResourceList((NIConfigQueryResult)object);
                        int n3 = list.size();
                        int n4 = 0;
                        while (n4 < n3) {
                            NIESSID nIESSID = (NIESSID)((NIESS)list.get(n4)).getID();
                            int n5 = NICLGeneralUtils.getImageIndex(nIESSID);
                            if (n5 < 2) {
                                this.aniEssIds[0][n5] = nIESSID;
                            } else {
                                NIOlcLogger.info("WARNING: An image with image number " + (n5 + 1) + " was found.\n" + "Only " + 2 + " images per facility are currently supported by CL.");
                            }
                            ++n4;
                        }
                    }
                    if (this.clTransfer.getTargetType() == 0) {
                        // empty if block
                    }
                    bl = true;
                }
            }
            catch (NICLException nICLException) {
                this.sendEvent(3, null, nICLException);
            }
            catch (NIAuthenticationFailureException nIAuthenticationFailureException) {
                this.sendEvent(4, null, nIAuthenticationFailureException);
            }
            catch (NIUnavailableServerException nIUnavailableServerException) {
                this.sendEvent(5, null, nIUnavailableServerException);
            }
            catch (NIServerException nIServerException) {
                this.sendEvent(6, null, nIServerException);
            }
        } else {
            bl = true;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": connectToPlex()");
        return bl;
    }

    private boolean readSource() {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": readSource()");
        boolean bl = true;
        if (this.clTransfer.isPhysicalInScope()) {
            bl = this.readSourcesPhysical();
        }
        if (bl && !this.bPauseTransfer) {
            if (this.clTransfer.getConfigurationObjects() != null) {
                NIServices nIServices = this.aniServices[0];
                NILogicalConfigurationService nILogicalConfigurationService = nIServices.getLogicalConfigurationService();
                bl = this.storeConfigObjects(this.clTransfer.getConfigurationObjects(), nILogicalConfigurationService);
            } else if (this.clTransfer.isLogicalInScope()) {
                bl = this.readSourcesLogical();
                if (!this.bPauseTransfer && bl && this.clTransfer.isHostInScope()) {
                    bl = this.readSourcesHosts();
                }
            }
        }
        if (!bl) {
            this.sendEvent(16, null, null);
        } else if (!this.bPauseTransfer) {
            this.bReadingComplete = true;
            if (this.bReadAndPause) {
                this.bPauseTransfer = true;
                NICLResult nICLResult = this.clProcessor.pauseTransfer(this.clTransfer);
                bl = nICLResult.isSuccessful();
            }
            if (bl) {
                this.sendEvent(0, null, null);
            }
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": readSource()");
        return bl;
    }

    private boolean storeConfigObjects(NIResource[] nIResourceArray, NILogicalConfigurationService nILogicalConfigurationService) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": storeConfigObjects()");
        boolean bl = true;
        try {
            int n = 0;
            while (n < nIResourceArray.length && !this.bPauseTransfer && bl) {
                if (nIResourceArray[n] != null) {
                    NIResource[] nIResourceArray2;
                    NIConfigQueryResult nIConfigQueryResult;
                    NIESSID nIESSID;
                    NIResourceID nIResourceID;
                    if (nIResourceArray[n] instanceof NIVolumeGroup) {
                        nIResourceID = ((NIVolumeGroup)nIResourceArray[n]).getID();
                        nIESSID = ((NIVolumeGroupID)nIResourceID).getESS();
                        this.addConfigObject(nIESSID, nIResourceArray[n], 8);
                    } else if (nIResourceArray[n] instanceof NIIOPort) {
                        nIResourceID = ((NIIOPort)nIResourceArray[n]).getID();
                        nIESSID = ((NIIOPortID)nIResourceID).getESS();
                        this.addConfigObject(nIESSID, nIResourceArray[n], 2);
                    } else if (nIResourceArray[n] instanceof NIArray) {
                        nIResourceID = ((NIArray)nIResourceArray[n]).getID();
                        nIESSID = ((NIArrayID)nIResourceID).getESS();
                        this.addConfigObject(nIESSID, nIResourceArray[n], 3);
                    } else if (nIResourceArray[n] instanceof NIRank) {
                        nIConfigQueryResult = nILogicalConfigurationService.getArrays(((NIRank)nIResourceArray[n]).getArrayIDs());
                        List list = this.getResourceList(nIConfigQueryResult);
                        NICLGeneralUtils.cleanArrays(list);
                        nIResourceArray2 = list.toArray(new NIResource[0]);
                        bl = this.storeConfigObjects(nIResourceArray2, nILogicalConfigurationService);
                        nIResourceID = ((NIRank)nIResourceArray[n]).getID();
                        nIESSID = ((NIRankID)nIResourceID).getESS();
                        this.addConfigObject(nIESSID, nIResourceArray[n], 5);
                    } else if (nIResourceArray[n] instanceof NIExtentPool) {
                        nIResourceID = ((NIExtentPool)nIResourceArray[n]).getID();
                        int n2 = ((NIExtentPoolID)nIResourceID).getExtentPoolNumber();
                        nIESSID = ((NIExtentPoolID)nIResourceID).getESS();
                        nIResourceArray2 = this.getRanks(nILogicalConfigurationService, nIESSID, n2);
                        bl = this.storeConfigObjects(nIResourceArray2, nILogicalConfigurationService);
                        this.addConfigObject(nIESSID, nIResourceArray[n], 4);
                    } else if (nIResourceArray[n] instanceof NILSS) {
                        nIResourceID = ((NILSS)nIResourceArray[n]).getID();
                        nIESSID = ((NILSSID)nIResourceID).getESS();
                        this.addConfigObject(nIESSID, nIResourceArray[n], 6);
                    } else if (nIResourceArray[n] instanceof NIVolume) {
                        nIResourceID = ((NIVolume)nIResourceArray[n]).getID();
                        nIESSID = ((NIVolumeID)nIResourceID).getLSS().getESS();
                        this.addConfigObject(nIESSID, nIResourceArray[n], 8);
                        NILSSID nILSSID = ((NIVolumeID)((NIVolume)nIResourceArray[n]).getID()).getLSS();
                        NILSSID[] nILSSIDArray = new NILSSID[]{nILSSID};
                        nIConfigQueryResult = nILogicalConfigurationService.getLogicalSubsystems(nILSSIDArray);
                        NILSS nILSS = (NILSS)this.getResource(nIConfigQueryResult, 1);
                        this.addConfigObject(nIESSID, nILSS, 6);
                        NIExtentPoolID nIExtentPoolID = ((NIVolume)nIResourceArray[n]).getExtentPool();
                        NIExtentPoolID[] nIExtentPoolIDArray = new NIExtentPoolID[]{nIExtentPoolID};
                        nIConfigQueryResult = nILogicalConfigurationService.getExtentPools(nIExtentPoolIDArray);
                        NIExtentPool nIExtentPool = (NIExtentPool)this.getResource(nIConfigQueryResult, 1);
                        this.addConfigObject(nIESSID, nIExtentPool, 4);
                    } else {
                        this.sendEvent(7, null, null);
                        bl = false;
                    }
                }
                ++n;
            }
        }
        catch (NIUnauthorizedServerException nIUnauthorizedServerException) {
            this.sendEvent(12, null, nIUnauthorizedServerException);
        }
        catch (NIUnsupportedException nIUnsupportedException) {
            this.sendEvent(9, null, nIUnsupportedException);
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.sendEvent(5, null, nIUnavailableServerException);
            bl = false;
        }
        catch (NICLException nICLException) {
            this.sendEvent(8, null, nICLException);
            bl = false;
        }
        catch (NIServerException nIServerException) {
            this.sendEvent(6, null, nIServerException);
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": storeConfigObjects()");
        return bl;
    }

    private boolean addConfigObject(NIESSID nIESSID, Object object, int n) {
        int n2;
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": addConfigObject()");
        boolean bl = false;
        boolean bl2 = true;
        int n3 = NICLGeneralUtils.getIdIntValue((NIResource)object);
        if (n >= 10 || !nIESSID.getStorageFacility().equals(this.aniSfids[0])) {
            this.sendEvent(7, null, null);
            bl2 = false;
        }
        if (this.alstConfigObjs[n2 = NICLGeneralUtils.getImageIndex(nIESSID)][n] == null) {
            this.alstConfigObjs[n2][n] = new ArrayList(1);
        }
        int n4 = this.alstConfigObjs[n2][n].size();
        int n5 = 0;
        while (n5 < n4 && !bl) {
            if (n3 == NICLGeneralUtils.getIdIntValue((NIResource)this.alstConfigObjs[n2][n].get(n5))) {
                bl = true;
            }
            ++n5;
        }
        if (!bl) {
            this.alstConfigObjs[n2][n].add(object);
            ++this.iTotalObjs;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": addConfigObject()");
        return bl2;
    }

    private boolean addDeleteObject(NIResource nIResource) {
        int n;
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": addDeleteObject()");
        boolean bl = true;
        int n2 = this.getResourceIndex(nIResource);
        if (n2 < 0) {
            this.sendEvent(7, null, null);
            bl = false;
        }
        if (this.alstDeleteObjs[n = NICLGeneralUtils.getImageIndex(nIResource.getID())][n2] == null) {
            this.alstDeleteObjs[n][n2] = new ArrayList();
        }
        if (!this.isContained(this.alstDeleteObjs, nIResource)) {
            this.alstDeleteObjs[n][n2].add(nIResource);
            if (nIResource instanceof NIVolume) {
                this.abVolDeletionTable[n][NICLGeneralUtils.getIdIntValue((NIResource)nIResource)] = true;
            }
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": addDeleteObject()");
        return bl;
    }

    private boolean addModifyObject(NIResource nIResource, int n, int n2, NIResource nIResource2) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": addModifyObject(NIResource, int, int, NIResource)");
        boolean bl = false;
        if (NICLResourceComparator.merge(nIResource, nIResource2)) {
            bl = this.addModifyObject(nIResource2, n, n2);
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": addModifyObject(NIResource, int, int, NIResource)");
        return bl;
    }

    private boolean addModifyObject(NIResource nIResource, int n, int n2) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": addModifyObject(NIResource, int, int)");
        boolean bl = true;
        if (n2 >= 10) {
            this.sendEvent(7, null, null);
            bl = false;
        }
        if (this.alstModifyObjs[n][n2] == null) {
            this.alstModifyObjs[n][n2] = new ArrayList(1);
        }
        this.alstModifyObjs[n][n2].add(nIResource);
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": addModifyObject(NIResource, int, int)");
        return bl;
    }

    private boolean readSourcesPhysical() {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": readSourcesPhysical()");
        boolean bl = false;
        try {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            ArrayList<NIDDMPack> arrayList = new ArrayList<NIDDMPack>();
            NIDomainService nIDomainService = this.aniDomainService[0];
            NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[0].getLogicalConfigurationService();
            NIPhysicalConfigurationService nIPhysicalConfigurationService = this.aniServices[0].getPhysicalConfigurationService();
            NIConfigQueryResult nIConfigQueryResult = nIDomainService.getStorageFacility(this.aniSfids[0]);
            NIStorageFacilityImpl nIStorageFacilityImpl = (NIStorageFacilityImpl)this.getResource(nIConfigQueryResult, 1);
            nIConfigQueryResult = this.getSfis((NIStorageFacilityID)nIStorageFacilityImpl.getID(), 0);
            List list = this.getResourceList(nIConfigQueryResult);
            int n6 = list.size();
            int n7 = 0;
            while (n7 < n6) {
                nIConfigQueryResult = nILogicalConfigurationService.getArraySites((NIESSID)((NIESS)list.get(n7)).getID());
                List list2 = this.getResourceList(nIConfigQueryResult);
                int n8 = list2.size();
                n = 0;
                while (n < n8) {
                    NIArraySite nIArraySite = (NIArraySite)list2.get(n);
                    if (((NIArraySiteID)nIArraySite.getID()).getArraySiteNumber() % 2 == 0) {
                        arrayList.add(NIResourceFactory.newDDMPack(NICLGeneralUtils.convertDDMCapacityMBtoGB(nIArraySite.getDiskCapacity()) * 1000, nIArraySite.getDiskRPM(), 1, nIArraySite.getDiskClass()));
                    }
                    ++n;
                }
                ++n7;
            }
            n7 = 0;
            while (n7 < n6) {
                nIConfigQueryResult = nIPhysicalConfigurationService.getESCONPorts((NIESSID)((NIESS)list.get(n7)).getID());
                n2 = this.getResourceList(nIConfigQueryResult).size();
                ++n7;
            }
            n7 = 0;
            while (n7 < n6) {
                nIConfigQueryResult = nIPhysicalConfigurationService.getNetworkPorts((NIESSID)((NIESS)list.get(n7)).getID());
                n3 = this.getResourceList(nIConfigQueryResult).size();
                ++n7;
            }
            n7 = 0;
            while (n7 < n6) {
                nIConfigQueryResult = nIPhysicalConfigurationService.getFibreChannelPorts((NIESSID)((NIESS)list.get(n7)).getID());
                List list3 = this.getResourceList(nIConfigQueryResult);
                int n9 = list3.size();
                n = 0;
                while (n < n9) {
                    int n10 = ((NIIOPort)list3.get(n)).getPortType();
                    if (n10 == 20) {
                        ++n4;
                    } else {
                        ++n5;
                    }
                    ++n;
                }
                ++n7;
            }
            NIStorageFacilityID nIStorageFacilityID = (NIStorageFacilityID)nIStorageFacilityImpl.getID();
            if (!this.bPauseTransfer) {
                bl = true;
            }
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.sendEvent(5, null, nIUnavailableServerException);
        }
        catch (NIServerException nIServerException) {
            this.sendEvent(6, null, nIServerException);
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": readSourcesPhysical()");
        return bl;
    }

    private boolean readSourcesLogical() {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": readSourcesLogical()");
        boolean bl = false;
        try {
            NIConfigQueryResult nIConfigQueryResult = this.getSfisForXfer(0);
            List list = this.getResourceList(nIConfigQueryResult);
            NIESS[] nIESSArray = new NIESS[list.size()];
            NIServices nIServices = this.aniServices[0];
            int n = 0;
            while (n < list.size()) {
                nIESSArray[n] = (NIESS)list.get(n);
                ++n;
            }
            NILogicalConfigurationService nILogicalConfigurationService = nIServices.getLogicalConfigurationService();
            n = 0;
            while (n < nIESSArray.length && !this.bPauseTransfer) {
                if (this.aniEssIds[0][n] != null) {
                    NIESSID nIESSID = this.aniEssIds[0][n];
                    this.addConfigObject(nIESSID, nIESSArray[n], 1);
                    if (!this.bPauseTransfer) {
                        nIConfigQueryResult = nILogicalConfigurationService.getArrays(nIESSID);
                        this.alstConfigObjs[n][3] = this.getResourceList(nIConfigQueryResult);
                        NICLGeneralUtils.cleanArrays(this.alstConfigObjs[n][3]);
                        this.iTotalObjs += this.alstConfigObjs[n][3].size();
                    }
                    if (!this.bPauseTransfer) {
                        nIConfigQueryResult = nILogicalConfigurationService.getRanks(nIESSID);
                        this.alstConfigObjs[n][5] = this.getResourceList(nIConfigQueryResult);
                        this.iTotalObjs += this.alstConfigObjs[n][5].size();
                    }
                    if (!this.bPauseTransfer) {
                        nIConfigQueryResult = nILogicalConfigurationService.getExtentPools(nIESSID);
                        this.alstConfigObjs[n][4] = this.getResourceList(nIConfigQueryResult);
                        this.iTotalObjs += this.alstConfigObjs[n][4].size();
                    }
                    if (!this.bPauseTransfer) {
                        nIConfigQueryResult = nILogicalConfigurationService.getVolumeGroups(nIESSID);
                        this.alstConfigObjs[n][8] = this.getResourceList(nIConfigQueryResult);
                        this.iTotalObjs += this.alstConfigObjs[n][8].size();
                    }
                    if (!this.bPauseTransfer) {
                        nIConfigQueryResult = nILogicalConfigurationService.getLogicalSubsystems(nIESSID);
                        this.alstConfigObjs[n][6] = this.getResourceList(nIConfigQueryResult);
                        this.iTotalObjs += this.alstConfigObjs[n][6].size();
                    }
                    if (!this.bPauseTransfer) {
                        List list2 = this.alstConfigObjs[n][6];
                        int n2 = list2.size();
                        ArrayList<NIVolume> arrayList = new ArrayList<NIVolume>();
                        int n3 = 0;
                        while (n3 < n2) {
                            nIConfigQueryResult = nILogicalConfigurationService.getVolumes((NILSSID)((NILSS)list2.get(n3)).getID());
                            List list3 = this.getResourceList(nIConfigQueryResult);
                            int n4 = list3.size();
                            boolean bl2 = false;
                            boolean bl3 = false;
                            int n5 = 0;
                            while (n5 < n4) {
                                NIVolume nIVolume = (NIVolume)list3.get(n5);
                                arrayList.add(nIVolume);
                                this.aiSrcVolIndx[n][NICLGeneralUtils.getIdIntValue((NIResource)nIVolume)] = arrayList.size() - 1;
                                if (nIVolume.isAlias()) {
                                    bl3 = true;
                                } else {
                                    bl2 = true;
                                }
                                ++n5;
                            }
                            if (bl2) {
                                ++this.iTotalObjs;
                            }
                            if (bl3) {
                                ++this.iTotalObjs;
                            }
                            ++n3;
                        }
                        nIConfigQueryResult = new NIConfigQueryResultImpl(arrayList, true, 0L);
                        this.alstConfigObjs[n][7] = this.getResourceList(nIConfigQueryResult);
                    }
                }
                ++n;
            }
            if (!this.bPauseTransfer) {
                bl = true;
            }
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.sendEvent(5, null, nIUnavailableServerException);
            bl = false;
        }
        catch (NIServerException nIServerException) {
            this.sendEvent(6, null, nIServerException);
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": readSourcesLogical()");
        return bl;
    }

    private boolean readSourcesHosts() {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": readSourcesHosts()");
        boolean bl = true;
        try {
            NIESSID nIESSID;
            NIConfigQueryResult nIConfigQueryResult = this.getSfisForXfer(0);
            List list = this.getResourceList(nIConfigQueryResult);
            ArrayList arrayList = new ArrayList();
            NIESS[] nIESSArray = new NIESS[list.size()];
            NIServices nIServices = this.aniServices[0];
            int n = 0;
            while (n < list.size()) {
                nIESSArray[n] = (NIESS)list.get(n);
                ++n;
            }
            NIHostConfigurationService nIHostConfigurationService = nIServices.getHostConfigurationService();
            int n2 = 0;
            while (n2 < nIESSArray.length && !this.bPauseTransfer) {
                if (this.aniEssIds[0][n2] != null) {
                    nIESSID = this.aniEssIds[0][n2];
                    nIConfigQueryResult = nIHostConfigurationService.getSCSIHostPorts(nIESSID);
                    this.alstConfigObjs[n2][9] = this.getResourceList(nIConfigQueryResult);
                    this.iTotalObjs += this.alstConfigObjs[n2][9].size();
                }
                ++n2;
            }
            NIPhysicalConfigurationService nIPhysicalConfigurationService = nIServices.getPhysicalConfigurationService();
            int n3 = 0;
            while (n3 < nIESSArray.length && !this.bPauseTransfer) {
                if (this.aniEssIds[0][n3] != null) {
                    nIESSID = this.aniEssIds[0][n3];
                    if (!NICLGeneralUtils.isReef(nIESSID)) {
                        nIConfigQueryResult = nIPhysicalConfigurationService.getESCONPorts(nIESSID);
                        arrayList.addAll(this.getResourceList(nIConfigQueryResult));
                    }
                    nIConfigQueryResult = nIPhysicalConfigurationService.getFibreChannelPorts(nIESSID);
                    arrayList.addAll(this.getResourceList(nIConfigQueryResult));
                    this.alstConfigObjs[n3][2] = arrayList;
                    this.iTotalObjs += this.alstConfigObjs[n3][2].size();
                }
                ++n3;
            }
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.sendEvent(5, null, nIUnavailableServerException);
            bl = false;
        }
        catch (NIServerException nIServerException) {
            this.sendEvent(6, null, nIServerException);
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": readSourcesHosts()");
        return bl;
    }

    private boolean checkPhysicalCompatibility() {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": checkPhysicalCompatibility()");
        boolean bl = true;
        if (this.clTransfer.isLogicalInScope()) {
            int n = 0;
            while (n < 2 && !this.bPauseTransfer && bl) {
                if (this.aniEssIds[1][n] != null) {
                    bl = this.checkAvailSites(n);
                    if (bl) {
                        bl = this.checkDdms(n);
                    }
                    if (bl && this.clTransfer.isHostInScope()) {
                        bl = this.checkHostSupport(n);
                    }
                }
                ++n;
            }
        }
        if (!bl) {
            this.sendEvent(15, null, null);
        } else if (!this.bPauseTransfer) {
            this.bPhysicalCheckComplete = true;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": checkPhysicalCompatibility()");
        return bl;
    }

    private NIConfigResult createResource(NIESSID nIESSID, NIResource nIResource) throws NIServerException {
        NIConfigResult nIConfigResult;
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": createResource()");
        NIHostConfigurationService nIHostConfigurationService = this.aniServices[1].getHostConfigurationService();
        NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
        NIOfflineDomainService nIOfflineDomainService = this.aniServices[1].getOfflineDomainService();
        if (nIResource == null) {
            nIConfigResult = new NIConfigResultImpl(null, false, -1099694077L);
        } else {
            NIOlcLogger.info(this.clTransfer.getTransferID() + ": creating " + nIResource.getClass().getName() + " - 0x" + Integer.toHexString(NICLGeneralUtils.getIdIntValue(nIResource)) + " (" + this.curCfgObj + ")");
            if (nIResource instanceof NIOfflineStorageFacility) {
                NIOfflineStorageFacility nIOfflineStorageFacility = (NIOfflineStorageFacility)nIResource;
                nIConfigResult = nIOfflineDomainService.createStorageFacility((NIOfflineStorageFacility)nIResource);
                int n = nIOfflineStorageFacility.getNumESS();
                if (n > this.aniEssIds[1].length) {
                    NIOlcLogger.info(this.clTransfer.getTransferID() + ": WARNING - Num SFIs on facility not equal to num supported by CL (numEsss=" + n + ")");
                }
                int n2 = 0;
                while (n2 < n && n2 < this.aniEssIds[1].length) {
                    this.aniEssIds[1][n2] = new NIESSID((NIStorageFacilityID)nIConfigResult.getResourceID(), n2 + 1);
                    ++n2;
                }
            } else if (nIResource instanceof NIESS) {
                nIConfigResult = new NIConfigResultImpl(null, true, 0L);
            } else if (nIResource instanceof NIArray) {
                NIArray nIArray = (NIArray)nIResource;
                NIArraySiteID[] nIArraySiteIDArray = (NIArraySiteID[])NICLGeneralUtils.generateTargetIds(nIESSID, nIArray.getArraySites());
                NIArray nIArray2 = NIResourceFactory.newArray(nIArraySiteIDArray, nIArray.getRaidType());
                nIConfigResult = nILogicalConfigurationService.createArray(nIArray2);
            } else if (nIResource instanceof NIExtentPool) {
                NIExtentPool nIExtentPool = (NIExtentPool)nIResource;
                NIExtentPool nIExtentPool2 = NIResourceFactory.newExtentPool(nIESSID, nIExtentPool.getRankGroup(), nIExtentPool.getExtentType(), nIExtentPool.getExtentLimit(), nIExtentPool.getUserName());
                nIConfigResult = nILogicalConfigurationService.createExtentPool(nIExtentPool2);
                if (nIConfigResult.isSuccessful() && !NICLResourceComparator.compareModifiables(nIExtentPool, nIExtentPool2)) {
                    NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getExtentPools(new NIExtentPoolID[]{(NIExtentPoolID)nIConfigResult.getResourceID()});
                    nIExtentPool2 = (NIExtentPool)this.getResource(nIConfigQueryResult, 5);
                    NICLResourceComparator.merge(nIExtentPool, nIExtentPool2);
                    nIConfigResult = (NIConfigResult)this.getResult(nILogicalConfigurationService.modifyExtentPool(new NIExtentPool[]{nIExtentPool2}));
                }
            } else if (nIResource instanceof NIRank) {
                NIRank nIRank = (NIRank)nIResource;
                NIArrayID[] nIArrayIDArray = (NIArrayID[])NICLGeneralUtils.generateTargetIds(nIESSID, nIRank.getArrayIDs());
                NIRank nIRank2 = NIResourceFactory.newRank(nIArrayIDArray, nIRank.getExtentType());
                int n = 0;
                while (n < nIArrayIDArray.length) {
                    this.waitForArrayStatus(nIArrayIDArray[n]);
                    ++n;
                }
                nIConfigResult = nILogicalConfigurationService.createRank(nIRank2);
                if (nIConfigResult.isSuccessful() && NICLGeneralUtils.getIdIntValue(nIRank.getExtentPoolID()) != -1) {
                    NIRankID nIRankID = (NIRankID)nIConfigResult.getResourceID();
                    nIConfigResult = this.assignRank((NIExtentPoolID)NICLGeneralUtils.generateTargetId(nIRankID.getESS(), nIRank.getExtentPoolID()), nIRankID);
                }
            } else if (nIResource instanceof NILSS) {
                NILSS nILSS = (NILSS)nIResource;
                if (nILSS.getDeviceType() instanceof NIDeviceTypeCKD) {
                    NILSS nILSS2 = NIResourceFactory.newLSS(nIESSID, NICLGeneralUtils.getIdIntValue(nILSS), nILSS.getSSID(), nILSS.getDeviceType(), nILSS.getCUBaseType());
                    nIConfigResult = nILogicalConfigurationService.createLogicalSubsystem(nILSS2);
                    if (nIConfigResult.isSuccessful() && !NICLResourceComparator.compareModifiables(nILSS, nILSS2)) {
                        NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getLogicalSubsystems(new NILSSID[]{(NILSSID)nIConfigResult.getResourceID()});
                        nILSS2 = (NILSS)this.getResource(nIConfigQueryResult, 5);
                        NICLResourceComparator.merge(nILSS, nILSS2);
                        nIConfigResult = (NIConfigResult)this.getResult(nILogicalConfigurationService.modifyLogicalSubsystems(new NILSS[]{nILSS2}));
                    }
                } else {
                    nIConfigResult = new NIConfigResultImpl(null, true, 0L);
                }
            } else if (nIResource instanceof NIVolume) {
                NIVolume nIVolume;
                NIVolume nIVolume2 = (NIVolume)nIResource;
                NILSSID nILSSID = (NILSSID)NICLGeneralUtils.generateTargetId(nIESSID, ((NIVolumeID)nIVolume2.getID()).getLSS());
                if (nIVolume2.isAlias()) {
                    NIVolumeID nIVolumeID = (NIVolumeID)NICLGeneralUtils.generateTargetId(nIESSID, nIVolume2.getOriginalBaseVolumeID());
                    NIVolumeGroupID nIVolumeGroupID = (NIVolumeGroupID)NICLGeneralUtils.generateTargetId(nIESSID, nIVolume2.getAliasMapVolumeGroup());
                    nIVolume = NIResourceFactory.newVolume(nILSSID, ((NIVolumeID)nIVolume2.getID()).getVolNumber(), nIVolumeID, nIVolume2.getVolumeType(), nIVolume2.getUserName(), nIVolumeGroupID);
                    nIConfigResult = nILogicalConfigurationService.createAliasVolumes(new NIVolume[]{nIVolume})[0];
                } else {
                    NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)NICLGeneralUtils.generateTargetId(nIESSID, nIVolume2.getExtentPool());
                    nIVolume = NIResourceFactory.newVolume(nILSSID, ((NIVolumeID)nIVolume2.getID()).getVolNumber(), nIVolume2.getUserName(), nIExtentPoolID, nIVolume2.getDataType(), nIVolume2.getVolumeType(), nIVolume2.getCapacity());
                    nIConfigResult = nILogicalConfigurationService.createVolumes(new NIVolume[]{nIVolume})[0];
                }
                if (nIConfigResult.isSuccessful() && !NICLResourceComparator.compareModifiables(nIVolume2, nIVolume)) {
                    NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getVolumes(new NIVolumeID[]{(NIVolumeID)nIConfigResult.getResourceID()});
                    nIVolume = (NIVolume)this.getResource(nIConfigQueryResult, 5);
                    NICLResourceComparator.merge(nIVolume2, nIVolume);
                    nIConfigResult = (NIConfigResult)this.getResult(nILogicalConfigurationService.modifyVolumes(new NIVolume[]{nIVolume}));
                }
            } else if (nIResource instanceof NIVolumeGroup) {
                NIVolumeGroup nIVolumeGroup = (NIVolumeGroup)nIResource;
                if (!(nIVolumeGroup.getType() instanceof NIVolumeGroupTypeFiconEsconAll || nIVolumeGroup.getType() instanceof NIVolumeGroupTypeSCSIAll || nIVolumeGroup.getType() instanceof NIVolumeGroupTypeSCSI520All)) {
                    NIVolumeGroup nIVolumeGroup2 = NIResourceFactory.newVolumeGroup(nIESSID, nIVolumeGroup.getUserName(), nIVolumeGroup.getType());
                    nIConfigResult = nILogicalConfigurationService.createVolumeGroup(nIVolumeGroup2);
                    if (nIConfigResult.isSuccessful() && !NICLResourceComparator.compareModifiables(nIVolumeGroup, nIVolumeGroup2)) {
                        NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getVolumeGroups(new NIVolumeGroupID[]{(NIVolumeGroupID)nIConfigResult.getResourceID()});
                        nIVolumeGroup2 = (NIVolumeGroup)this.getResource(nIConfigQueryResult, 5);
                        NICLResourceComparator.merge(nIVolumeGroup, nIVolumeGroup2);
                        NICLGeneralUtils.removeInvalidVols(nIVolumeGroup2, this.aiSrcVolIndx[NICLGeneralUtils.getImageIndex(nIESSID)]);
                        nIConfigResult = nILogicalConfigurationService.modifyVolumeGroup(nIVolumeGroup2);
                    }
                } else {
                    nIConfigResult = new NIConfigResultImpl(null, true, 0L);
                }
            } else if (nIResource instanceof NISCSIHostPort) {
                NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)nIResource;
                NISCSIHostPort nISCSIHostPort2 = NIResourceFactory.newSCSIHostPort(nIESSID, nISCSIHostPort.getWWPN(), nISCSIHostPort.getPortProfile(), nISCSIHostPort.getUserHostName(), nISCSIHostPort.getUserHostDescription());
                nIConfigResult = nIHostConfigurationService.createHostPort(nISCSIHostPort2);
                if (nIConfigResult.isSuccessful() && !NICLResourceComparator.compareModifiables(nISCSIHostPort, nISCSIHostPort2)) {
                    NIConfigQueryResult nIConfigQueryResult = nIHostConfigurationService.getSCSIHostPorts(new NISCSIHostPortID[]{(NISCSIHostPortID)nIConfigResult.getResourceID()});
                    nISCSIHostPort2 = (NISCSIHostPort)this.getResource(nIConfigQueryResult, 5);
                    NICLResourceComparator.merge(nISCSIHostPort, nISCSIHostPort2);
                    nIConfigResult = nIHostConfigurationService.modifyHostPort(nISCSIHostPort2);
                }
            } else {
                nIConfigResult = new NIConfigCreatedResultImpl(nIResource.getID(), false, -1099694077L);
            }
            if (!nIConfigResult.isSuccessful()) {
                this.pause();
                NIOlcLogger.info(this.clTransfer.getTransferID() + ": ERROR - when trying to create resource");
                NIOlcLogger.info(this.clTransfer.getTransferID() + ": ERROR - resource is " + nIResource);
            } else {
                int n;
                int n3 = NICLGeneralUtils.getIdIntValue(nIResource);
                if (n3 != (n = NICLGeneralUtils.getIdIntValue(nIConfigResult.getResourceID()))) {
                    NIOlcLogger.info(this.clTransfer.getTransferID() + ": WARNING - expected ID does not equal actual ID...");
                    NIOlcLogger.info(this.clTransfer.getTransferID() + ": WARNING - expected ID:  " + nIResource.getID());
                    NIOlcLogger.info(this.clTransfer.getTransferID() + ": WARNING - actual ID:    " + nIConfigResult.getResourceID());
                    this.updateDummyId(nIResource.getID(), nIConfigResult.getResourceID());
                }
                NIOlcLogger.info(this.clTransfer.getTransferID() + ": progress - " + this.getProgress());
            }
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": createResource()");
        return nIConfigResult;
    }

    private NIArraySiteID findAvailSite(NIESSID nIESSID) throws NIServerException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": findAvailSite()");
        NIArraySiteID nIArraySiteID = null;
        NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
        if (nIESSID != null) {
            int n = NICLGeneralUtils.getImageIndex(nIESSID);
            NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getArraySites(nIESSID);
            List list = this.getResourceList(nIConfigQueryResult);
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2 && !this.bPauseTransfer && nIArraySiteID == null) {
                NIArraySite nIArraySite = (NIArraySite)list.get(n3);
                if (nIArraySite.getArrayID() == null || nIArraySite.getArraySiteStatus() == 1) {
                    int n4 = NICLGeneralUtils.getIdIntValue(nIArraySite);
                    int n5 = this.alstConfigObjs[n][3].size();
                    int n6 = 0;
                    boolean bl = false;
                    while (n6 < n5 && !bl && !this.bPauseTransfer) {
                        NIArray nIArray = (NIArray)this.alstConfigObjs[n][3].get(n6);
                        NIArraySiteID[] nIArraySiteIDArray = nIArray.getArraySites();
                        int n7 = 0;
                        while (n7 < nIArraySiteIDArray.length && !bl) {
                            if (NICLGeneralUtils.getIdIntValue(nIArraySiteIDArray[n7]) == n4) {
                                bl = true;
                            }
                            ++n7;
                        }
                        ++n6;
                    }
                    if (!bl) {
                        nIArraySiteID = (NIArraySiteID)nIArraySite.getID();
                    }
                }
                ++n3;
            }
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": findAvailSite()");
        return nIArraySiteID;
    }

    private void generateDummyRsrcs() throws NIServerException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": generateDummyRsrcs()");
        int n = 0;
        while (n < 2 && !this.bPauseTransfer) {
            int n2 = 0;
            while (n2 < 10 && !this.bPauseTransfer) {
                if (!this.bPauseTransfer) {
                    if (this.lstDummyIds[n2] == null) {
                        this.lstDummyIds[n2] = new ArrayList();
                    }
                    this.lstDummyIds[n2].addAll(this.generateDummyRsrcs(this.aniEssIds[1][n], n2));
                }
                ++n2;
            }
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": generateDummyRsrcs()");
    }

    private List generateDummyRsrcs(NIESSID nIESSID, int n) throws NIServerException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": generateDummyRsrcs(NIESSID, int)");
        ArrayList<NIResourceID> arrayList = new ArrayList<NIResourceID>();
        NIResource nIResource = null;
        if (nIESSID != null && (n == 3 || n == 4 || n == 8 || n == 9)) {
            int n2;
            int n3 = NICLGeneralUtils.getImageIndex(nIESSID);
            List list = this.alstConfigObjs[n3][n];
            int n4 = list.size();
            int n5 = 0;
            int n6 = -1;
            while (n5 < n4) {
                n2 = NICLGeneralUtils.getIdIntValue((NIResource)list.get(n5));
                if (n2 > n6) {
                    n6 = n2;
                }
                ++n5;
            }
            boolean[] blArray = new boolean[n6 + 1];
            Arrays.fill(blArray, false);
            NIConfigQueryResult nIConfigQueryResult = this.getSfiResources(nIESSID, n);
            List list2 = this.getResourceList(nIConfigQueryResult);
            int n7 = list2.size();
            n5 = 0;
            while (n5 < n7) {
                n2 = NICLGeneralUtils.getIdIntValue((NIResource)list2.get(n5));
                if (n2 <= n6) {
                    blArray[n2] = true;
                }
                ++n5;
            }
            List list3 = this.alstDeleteObjs[n3][n];
            int n8 = list3.size();
            n5 = 0;
            while (n5 < n8) {
                n2 = NICLGeneralUtils.getIdIntValue((NIResource)list3.get(n5));
                if (n2 <= n6) {
                    blArray[n2] = false;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < n4) {
                n2 = NICLGeneralUtils.getIdIntValue((NIResource)list.get(n5));
                blArray[n2] = true;
                ++n5;
            }
            n5 = 0;
            while (n5 < blArray.length && !this.bPauseTransfer) {
                if (!blArray[n5]) {
                    if (n == 3) {
                        NIArraySiteID nIArraySiteID = this.findAvailSite(nIESSID);
                        if (nIArraySiteID == null) {
                            throw new NICLException(-1099694075L, 2);
                        }
                        nIResource = NIResourceFactory.newArray(nIArraySiteID, DUMMY_RAID_TYPE);
                        this.assignSites(nIESSID, (NIArray)nIResource, new NIArraySiteID[]{nIArraySiteID});
                        ((NIArrayImpl)nIResource).setID(new NIArrayID(nIESSID, n5));
                    } else if (n == 4) {
                        nIResource = NIResourceFactory.newExtentPool(nIESSID, n5 % 2, DUMMY_EXTENT_TYPE, DUMMY_USERNAME_PREFIX + n5);
                        ((NIExtentPoolImpl)nIResource).setID(new NIExtentPoolID(nIESSID, n5));
                    } else if (n == 8) {
                        if (!NICLGeneralUtils.isVolGroupIdReserved(n5, nIESSID.getType())) {
                            nIResource = NIResourceFactory.newVolumeGroup(nIESSID, DUMMY_USERNAME_PREFIX + n5, DUMMY_VOL_GROUP_TYPE);
                            ((NIVolumeGroupImpl)nIResource).setID(new NIVolumeGroupID(nIESSID, n5));
                        } else {
                            nIResource = null;
                        }
                    } else if (n == 9) {
                        nIResource = NIResourceFactory.newSCSIHostPort(nIESSID, -1152921504606846976L + (long)n5, DUMMY_PORT_PROFILE, DUMMY_USERNAME_PREFIX + n5, DUMMY_DESCRIPTION);
                        ((NISCSIHostPortImpl)nIResource).setID(new NISCSIHostPortID(nIESSID, n5));
                    }
                    if (nIResource != null) {
                        this.alstConfigObjs[n3][n].add(nIResource);
                        arrayList.add(nIResource.getID());
                        this.iTotalObjs += 2;
                    }
                }
                ++n5;
            }
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": generateDummyRsrcs(NIESSID, int)");
        return arrayList;
    }

    private NIConfigResult modifyResource(NIResource nIResource) throws NIServerException {
        NIConfigResult nIConfigResult;
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": modifyResource()");
        NIDomainService nIDomainService = this.aniDomainService[1];
        NIHostConfigurationService nIHostConfigurationService = this.aniServices[1].getHostConfigurationService();
        NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
        NIPhysicalConfigurationService nIPhysicalConfigurationService = this.aniServices[1].getPhysicalConfigurationService();
        if (nIResource == null) {
            nIConfigResult = new NIConfigResultImpl(null, false, -1099694077L);
        } else {
            NIVolumeGroupType nIVolumeGroupType;
            nIConfigResult = nIResource instanceof NIESS ? nIDomainService.modifyESS((NIESS)nIResource) : (nIResource instanceof NIIOPort ? nIPhysicalConfigurationService.modifyPort((NIIOPort)nIResource) : (nIResource instanceof NIExtentPool ? nILogicalConfigurationService.modifyExtentPool(new NIExtentPool[]{(NIExtentPool)nIResource})[0] : (nIResource instanceof NIRank ? this.assignRank(((NIRank)nIResource).getExtentPoolID(), (NIRankID)nIResource.getID()) : (nIResource instanceof NILSS ? nILogicalConfigurationService.modifyLogicalSubsystems(new NILSS[]{(NILSS)nIResource})[0] : (nIResource instanceof NIVolume ? nILogicalConfigurationService.modifyVolumes(new NIVolume[]{(NIVolume)nIResource})[0] : (nIResource instanceof NIVolumeGroup ? (!((nIVolumeGroupType = ((NIVolumeGroup)nIResource).getType()) instanceof NIVolumeGroupTypeFiconEsconAll || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIAll || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520All) ? nILogicalConfigurationService.modifyVolumeGroup((NIVolumeGroup)nIResource) : new NIConfigResultImpl(nIResource.getID(), true, 0L)) : (nIResource instanceof NISCSIHostPort ? nIHostConfigurationService.modifyHostPort((NISCSIHostPort)nIResource) : new NIConfigResultImpl(nIResource.getID(), false, -1099694077L))))))));
            if (!nIConfigResult.isSuccessful()) {
                this.pause();
            }
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": modifyResource()");
        return nIConfigResult;
    }

    private NIConfigResult deleteResource(NIResourceID nIResourceID) throws NIServerException, NIUnavailableServerException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": deleteResource(): " + nIResourceID);
        NIConfigResult[] nIConfigResultArray = this.deleteResources(new NIResourceID[]{nIResourceID});
        if (nIConfigResultArray == null || nIConfigResultArray.length <= 0) {
            nIConfigResultArray[0] = new NIConfigResultImpl(nIResourceID, false, 2L);
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": deleteResource()");
        return nIConfigResultArray[0];
    }

    private NIConfigResult[] deleteResources(NIResourceID[] nIResourceIDArray) throws NIServerException, NIUnavailableServerException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": deleteResources()");
        NIConfigResult[] nIConfigResultArray = null;
        NIHostConfigurationService nIHostConfigurationService = this.aniServices[1].getHostConfigurationService();
        NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
        if (nIResourceIDArray == null || nIResourceIDArray.length <= 0) {
            nIConfigResultArray = new NIConfigResultImpl[]{new NIConfigResultImpl(null, false, -1099694077L)};
        } else {
            nIConfigResultArray = new NIConfigResultImpl[nIResourceIDArray.length];
            int n = 0;
            while (n < nIResourceIDArray.length && !this.bPauseTransfer) {
                NIConfigQueryResult nIConfigQueryResult;
                if (nIResourceIDArray[n] instanceof NIArrayID) {
                    this.waitForArrayStatus((NIArrayID)nIResourceIDArray[n]);
                    nIConfigResultArray[n] = nILogicalConfigurationService.deleteArray((NIArrayID)nIResourceIDArray[n]);
                } else if (nIResourceIDArray[n] instanceof NIExtentPoolID) {
                    nIConfigResultArray[n] = nILogicalConfigurationService.deleteExtentPool(new NIExtentPoolID[]{(NIExtentPoolID)nIResourceIDArray[n]})[0];
                } else if (nIResourceIDArray[n] instanceof NIRankID) {
                    nIConfigQueryResult = nILogicalConfigurationService.getRanks(new NIRankID[]{(NIRankID)nIResourceIDArray[n]});
                    nIConfigResultArray[n] = NICLGeneralUtils.getIdIntValue(((NIRank)this.getResource(nIConfigQueryResult, 4)).getExtentPoolID()) != -1 ? this.assignRank(null, (NIRankID)nIResourceIDArray[n]) : new NIConfigResultImpl(nIResourceIDArray[n], nIConfigQueryResult.isSuccessful(), nIConfigQueryResult.getCode());
                    if (nIConfigResultArray[n].isSuccessful()) {
                        nIConfigResultArray[n] = nILogicalConfigurationService.deleteRank(new NIRankID[]{(NIRankID)nIResourceIDArray[n]})[0];
                    }
                } else if (nIResourceIDArray[n] instanceof NILSSID) {
                    nIConfigQueryResult = nILogicalConfigurationService.getLogicalSubsystems(new NILSSID[]{(NILSSID)nIResourceIDArray[n]});
                    try {
                        NILSS nILSS = (NILSS)this.getResource(nIConfigQueryResult, 4);
                        if (nILSS.getDeviceType().equals(NIDeviceTypeCKD.Option)) {
                            nIConfigResultArray[n] = nILogicalConfigurationService.deleteLogicalSubsystems(new NILSSID[]{(NILSSID)nIResourceIDArray[n]})[0];
                        }
                        nIConfigResultArray[n] = new NIConfigResultImpl(null, true, 0L);
                    }
                    catch (NICLException nICLException) {
                        if (nIConfigQueryResult.isSuccessful()) {
                            NIOlcLogger.info(this.clTransfer.getTransferID() + ": WARNING - Received NICLException while getting LSS " + nIResourceIDArray[n]);
                            NIOlcLogger.info(this.clTransfer.getTransferID() + ": WARNING - Probably due to an automatically deleted FB LSS");
                            nIConfigResultArray[n] = new NIConfigResultImpl(null, true, 0L);
                        }
                        throw nICLException;
                    }
                } else if (nIResourceIDArray[n] instanceof NIVolumeID) {
                    nIConfigResultArray[n] = nILogicalConfigurationService.deleteVolumes(new NIVolumeID[]{(NIVolumeID)nIResourceIDArray[n]})[0];
                } else if (nIResourceIDArray[n] instanceof NIVolumeGroupID) {
                    nIConfigQueryResult = nILogicalConfigurationService.getVolumeGroups(new NIVolumeGroupID[]{(NIVolumeGroupID)nIResourceIDArray[n]});
                    NIVolumeGroupType nIVolumeGroupType = ((NIVolumeGroup)this.getResource(nIConfigQueryResult, 4)).getType();
                    if (!(nIVolumeGroupType instanceof NIVolumeGroupTypeFiconEsconAll || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSIAll || nIVolumeGroupType instanceof NIVolumeGroupTypeSCSI520All)) {
                        List list = this.tgtReaders[NICLGeneralUtils.getImageIndex(nIResourceIDArray[n])].getSCSIHostPorts((NIVolumeGroupID)nIResourceIDArray[n]);
                        int n2 = list.size();
                        boolean bl = true;
                        int n3 = 0;
                        while (n3 < n2 && bl) {
                            NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)list.get(n3);
                            nISCSIHostPort.setVolumeGroup(null);
                            nIConfigResultArray[n] = nIHostConfigurationService.modifyHostPort(nISCSIHostPort);
                            if (!nIConfigResultArray[n].isSuccessful()) {
                                bl = false;
                            }
                            ++n3;
                        }
                        if (bl) {
                            nIConfigResultArray[n] = nILogicalConfigurationService.deleteVolumeGroup((NIVolumeGroupID)nIResourceIDArray[n]);
                        }
                    } else {
                        nIConfigResultArray[n] = new NIConfigResultImpl(null, true, 0L);
                    }
                } else {
                    nIConfigResultArray[n] = nIResourceIDArray[n] instanceof NIHostPortID ? (this.clTransfer.isHostInScope() ? nIHostConfigurationService.deleteHostPort((NIHostPortID)nIResourceIDArray[n]) : new NIConfigResultImpl(null, true, 0L)) : new NIConfigResultImpl(nIResourceIDArray[n], false, -1099694077L);
                }
                if (!nIConfigResultArray[n].isSuccessful()) {
                    this.pause();
                }
                ++n;
            }
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": deleteResources()");
        return nIConfigResultArray;
    }

    private NIConfigQueryResult getSfiResources(NIESSID nIESSID, int n) throws NIServerException, NIUnavailableServerException {
        NIConfigQueryResult nIConfigQueryResult;
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": getSfiResources()");
        NIHostConfigurationService nIHostConfigurationService = this.aniServices[1].getHostConfigurationService();
        NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
        NIPhysicalConfigurationService nIPhysicalConfigurationService = this.aniServices[1].getPhysicalConfigurationService();
        NIOlcLogger.info(this.clTransfer.getTransferID() + ": getting " + RSRC_NAMES[n] + " resources from " + nIESSID);
        if (nIESSID == null) {
            nIConfigQueryResult = new NIConfigQueryResultImpl(new ArrayList(), false, -1099694077L);
        } else if (n == 3) {
            nIConfigQueryResult = nILogicalConfigurationService.getArrays(nIESSID);
            NICLGeneralUtils.cleanArrays(nIConfigQueryResult.getResourceList());
        } else if (n == 2) {
            ArrayList arrayList = new ArrayList();
            if (!NICLGeneralUtils.isReef(nIESSID)) {
                arrayList.addAll(this.getResourceList(nIPhysicalConfigurationService.getESCONPorts(nIESSID)));
            }
            arrayList.addAll(this.getResourceList(nIPhysicalConfigurationService.getFibreChannelPorts(nIESSID)));
            nIConfigQueryResult = new NIConfigQueryResultImpl(arrayList, true, 0L);
        } else if (n == 4) {
            nIConfigQueryResult = nILogicalConfigurationService.getExtentPools(nIESSID);
        } else if (n == 5) {
            nIConfigQueryResult = nILogicalConfigurationService.getRanks(nIESSID);
        } else if (n == 6) {
            nIConfigQueryResult = nILogicalConfigurationService.getLogicalSubsystems(nIESSID);
        } else if (n == 7) {
            nIConfigQueryResult = nILogicalConfigurationService.getLogicalSubsystems(nIESSID);
            List list = this.getResourceList(nIConfigQueryResult);
            int n2 = list.size();
            ArrayList arrayList = new ArrayList();
            int n3 = 0;
            while (n3 < n2) {
                nIConfigQueryResult = nILogicalConfigurationService.getVolumes((NILSSID)((NILSS)list.get(n3)).getID());
                List list2 = this.getResourceList(nIConfigQueryResult);
                int n4 = list2.size();
                int n5 = 0;
                while (n5 < n4) {
                    arrayList.add(list2.get(n5));
                    ++n5;
                }
                ++n3;
            }
            nIConfigQueryResult = new NIConfigQueryResultImpl(arrayList, true, 0L);
        } else {
            nIConfigQueryResult = n == 8 ? nILogicalConfigurationService.getVolumeGroups(nIESSID) : (n == 9 ? nIHostConfigurationService.getSCSIHostPorts(nIESSID) : new NIConfigQueryResultImpl(new ArrayList(), false, -1099694077L));
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": getSfiResources()");
        return nIConfigQueryResult;
    }

    private boolean deleteConfig() {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": deleteConfig()");
        boolean bl = true;
        try {
            if (this.clTransfer.getOverwrite() != 0) {
                int n = 0;
                while (n < 2 && !this.bPauseTransfer) {
                    if (this.aniEssIds[1][n] != null) {
                        int n2 = 0;
                        while (n2 < this.deletionOrder.length && !this.bPauseTransfer) {
                            int n3 = this.deletionOrder[n2];
                            int n4 = this.alstDeleteObjs[n][n3].size();
                            if (n3 == 7) {
                                this.alstDeleteObjs[n][n3] = this.sortVolumes(this.alstDeleteObjs[n][n3], 1);
                            }
                            int n5 = 0;
                            while (n5 < n4) {
                                NIConfigResult nIConfigResult = this.deleteResource(((NIResource)this.alstDeleteObjs[n][n3].get(n5)).getID());
                                if (!nIConfigResult.isSuccessful()) {
                                    this.pause();
                                    this.sendEvent(18, nIConfigResult, null);
                                    throw new NICLException((long)nIConfigResult.getCode(), 2);
                                }
                                ++this.iNumObjsXferred;
                                ++n5;
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.sendEvent(5, null, nIUnavailableServerException);
            bl = false;
        }
        catch (NIServerException nIServerException) {
            this.sendEvent(6, null, nIServerException);
            bl = false;
        }
        if (!bl) {
            this.sendEvent(18, null, null);
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": deleteConfig()");
        return bl;
    }

    private NIRank[] getRanks(NILogicalConfigurationService nILogicalConfigurationService, NIESSID nIESSID, int n) {
        NIRank[] nIRankArray;
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": getRanks()");
        try {
            NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getRanks(nIESSID);
            List list = this.getResourceList(nIConfigQueryResult);
            ArrayList<NIRank> arrayList = new ArrayList<NIRank>(1);
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                NIRank nIRank = (NIRank)list.get(n3);
                if (NICLGeneralUtils.getIdIntValue(nIRank.getExtentPoolID()) == n) {
                    arrayList.add(nIRank);
                }
                ++n3;
            }
            nIRankArray = arrayList.toArray(new NIRank[0]);
        }
        catch (NIAuthenticationFailureException nIAuthenticationFailureException) {
            this.sendEvent(4, null, nIAuthenticationFailureException);
            nIRankArray = null;
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.sendEvent(5, null, nIUnavailableServerException);
            nIRankArray = null;
        }
        catch (NIServerException nIServerException) {
            this.sendEvent(6, null, nIServerException);
            nIRankArray = null;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": getRanks()");
        return nIRankArray;
    }

    private void assignSites(NIESSID nIESSID, NIArray nIArray, NIArraySiteID[] nIArraySiteIDArray) throws NIServerException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ":assignSites(NIESSID, NIArray, NIArraySiteID[])");
        NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
        List list = this.getResourceList(nILogicalConfigurationService.getArraySites(nIArraySiteIDArray));
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": assignSites(NIESSID, NIArray, NIArraySiteID[])");
        this.assignSites(nIArray, list);
    }

    private void assignSites(NIArray nIArray, List list) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ":assignSites(NIArray, List)");
        ArrayList<NIResourceID> arrayList = new ArrayList<NIResourceID>();
        NIArrayImpl nIArrayImpl = (NIArrayImpl)nIArray;
        NIArraySite nIArraySite = (NIArraySite)list.get(0);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(((NIArraySite)list.get(n2)).getID());
            ++n2;
        }
        nIArrayImpl.setArraySiteIDs(arrayList.toArray(new NIArraySiteID[0]));
        nIArrayImpl.setDeviceAdapterPairID(nIArraySite.getDeviceAdapterPair());
        nIArrayImpl.setDiskCapacity(nIArraySite.getDiskCapacity());
        nIArrayImpl.setDiskRPM(nIArraySite.getDiskRPM());
        nIArrayImpl.setDiskInterfaceRate(new Long(nIArraySite.getDiskInterfaceRate()).intValue());
        nIArrayImpl.setDiskInterfaceType(nIArraySite.getDiskInterfaceType());
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": assignSites(NIArray, List)");
    }

    private boolean checkAvailSites(int n) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": checkAvailSites()");
        boolean bl = true;
        int n2 = -1;
        NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
        try {
            if (this.alstConfigObjs[n][3] != null) {
                NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getArraySites(this.aniEssIds[1][n]);
                List list = this.getResourceList(nIConfigQueryResult);
                int n3 = list.size();
                int n4 = 0;
                List list2 = this.alstConfigObjs[n][3];
                int n5 = list2.size();
                int n6 = 0;
                while (n6 < n5 && !this.bPauseTransfer) {
                    int n7 = ((NIArrayID)((NIArray)list2.get(n6)).getID()).getArrayNumber();
                    if (n2 < n7) {
                        n2 = n7;
                    }
                    n4 += ((NIArray)list2.get(n6)).getArraySites().length - 1;
                    ++n6;
                }
                if (n3 - n4 < n2 + 1) {
                    NIOlcLogger.info(this.clTransfer.getTransferID() + ": ERROR - Not enough array sites (num sites=" + n3 + ", arrays needed=" + (n2 + 1) + "(+" + n4 + " extra sites)" + ")");
                    bl = false;
                } else {
                    bl = this.mapArraysToSites(n, list);
                }
            }
        }
        catch (NIAuthenticationFailureException nIAuthenticationFailureException) {
            this.sendEvent(4, null, nIAuthenticationFailureException);
            bl = false;
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.sendEvent(5, null, nIUnavailableServerException);
            bl = false;
        }
        catch (NIServerException nIServerException) {
            this.sendEvent(6, null, nIServerException);
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": checkAvailSites()");
        return bl;
    }

    private boolean checkDdms(int n) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": checkDdms()");
        boolean bl = true;
        NIPhysicalConfigurationService nIPhysicalConfigurationService = this.aniServices[1].getPhysicalConfigurationService();
        try {
            if (this.alstConfigObjs[n][3] != null && this.alstConfigObjs[n][3].size() > 0) {
                NIConfigQueryResult nIConfigQueryResult = nIPhysicalConfigurationService.getStorageDeviceFRUs(this.aniEssIds[1][n]);
                List list = this.getResourceList(nIConfigQueryResult);
                int n2 = list.size();
                int n3 = 0;
                while (n3 < n2) {
                    NIStorageDeviceFRU nIStorageDeviceFRU = (NIStorageDeviceFRU)list.get(n3);
                    if (nIStorageDeviceFRU.getFRUState() != 0) {
                        NIOlcLogger.info(this.clTransfer.getTransferID() + ": DDM is not in a good state (serial=" + nIStorageDeviceFRU.getDiskSerialNumber() + ", location=" + nIStorageDeviceFRU.getLocation() + ", ddmName=" + nIStorageDeviceFRU.getDdmName() + ")");
                        bl = false;
                    }
                    ++n3;
                }
                if (!bl) {
                    this.sendEvent(19, null, null);
                    this.pause();
                }
            }
        }
        catch (NIServerException nIServerException) {
            this.sendEvent(6, null, nIServerException);
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": checkDdms()");
        return bl;
    }

    private List getAvailSites(int n) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": getAvailSites()");
        ArrayList arrayList = new ArrayList();
        NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
        try {
            NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getArraySites(this.aniEssIds[1][n]);
            List list = this.getResourceList(nIConfigQueryResult);
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                if (((NIArraySite)list.get(n3)).getArraySiteStatus() == 1) {
                    arrayList.add(list.get(n3));
                }
                ++n3;
            }
        }
        catch (NICLException nICLException) {
            this.sendEvent(8, null, nICLException);
            arrayList = null;
        }
        catch (NIServerException nIServerException) {
            this.sendEvent(6, null, nIServerException);
            arrayList = null;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": getAvailSites()");
        return arrayList;
    }

    private boolean mapArraysToSites(int n, List list) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": mapArraysToSites()");
        boolean bl = true;
        ArrayList arrayList = new ArrayList();
        this.clAtsMap = new NICLArrayToSiteMap(list);
        List list2 = this.sortArraysByDdmType(this.alstConfigObjs[n][3]);
        int n2 = list2.size();
        int n3 = 0;
        while (n3 < n2 && bl && !this.bPauseTransfer) {
            NIArrayImpl nIArrayImpl = (NIArrayImpl)list2.get(n3);
            List list3 = this.clAtsMap.reserveAvailableSites(nIArrayImpl);
            if (list3.size() < 1) {
                NIOlcLogger.info(this.clTransfer.getTransferID() + ": ERROR - Unable to find array sites for " + nIArrayImpl.getID());
                NIOlcLogger.info(this.clTransfer.getTransferID() + ": all arrays needed:");
                int n4 = 0;
                while (n4 < n2) {
                    NIOlcLogger.info(this.clTransfer.getTransferID() + ": " + n4 + "-" + list2.get(n4));
                    ++n4;
                }
                NIOlcLogger.info(this.clTransfer.getTransferID() + ": all avail sites:");
                n2 = list.size();
                n4 = 0;
                while (n4 < n2) {
                    NIOlcLogger.info(this.clTransfer.getTransferID() + ": " + n4 + "-" + list.get(n4));
                    ++n4;
                }
                bl = false;
            } else {
                this.assignSites(nIArrayImpl, list3);
                arrayList.clear();
            }
            ++n3;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": mapArraysToSites()");
        return bl;
    }

    private boolean mapResources() {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": mapResources()");
        boolean bl = true;
        int n = 0;
        NIResource nIResource = null;
        String string = "";
        try {
            int n2 = 0;
            while (n2 < 2 && !this.bPauseTransfer) {
                block41: {
                    if (this.aniEssIds[1][n2] == null) break block41;
                    NICLGenealogist nICLGenealogist = new NICLGenealogist(this.tgtReaders[n2]);
                    int n3 = 1;
                    while (n3 < 10 && !this.bPauseTransfer) {
                        block43: {
                            NIConfigQueryResult nIConfigQueryResult;
                            ArrayList<String> arrayList;
                            block44: {
                                block42: {
                                    if (this.alstDeleteObjs[n2][n3] == null) {
                                        this.alstDeleteObjs[n2][n3] = new ArrayList();
                                    }
                                    if ((arrayList = this.alstConfigObjs[n2][n3]) == null) {
                                        arrayList = new ArrayList<String>();
                                    }
                                    if (n3 != 1) break block42;
                                    if (n2 > 0) break block43;
                                    nIConfigQueryResult = this.getSfisForXfer(1);
                                    break block44;
                                }
                                if ((n3 == 9 || n3 == 2) && !this.clTransfer.isHostInScope()) break block43;
                                nIConfigQueryResult = this.getSfiResources(this.aniEssIds[1][n2], n3);
                            }
                            List list = this.getResourceList(nIConfigQueryResult);
                            int n4 = list.size();
                            int n5 = arrayList.size();
                            int n6 = 0;
                            while (n6 < n4 && !this.bPauseTransfer) {
                                int n7;
                                boolean bl2 = true;
                                boolean bl3 = false;
                                NIResource nIResource2 = (NIResource)list.get(n6);
                                if (this.iOverwrite == 1 || this.iOverwrite == 3 || this.iOverwrite == 0) {
                                    if (nIResource2 instanceof NIVolume) {
                                        n = this.aiSrcVolIndx[n2][NICLGeneralUtils.getIdIntValue(nIResource2)];
                                        if (n != -1) {
                                            nIResource = (NIVolume)arrayList.get(n);
                                            bl3 = true;
                                        } else {
                                            nIResource = null;
                                            bl3 = false;
                                        }
                                    } else {
                                        n = 0;
                                        while (n < n5 && !this.bPauseTransfer && !bl3) {
                                            nIResource = (NIResource)arrayList.get(n);
                                            if (NICLResourceComparator.checkCorrespondence(nIResource, nIResource2)) {
                                                bl3 = true;
                                            }
                                            ++n;
                                        }
                                    }
                                }
                                if (bl3) {
                                    if (this.iOverwrite == 1 || this.iOverwrite == 3) {
                                        if (!this.isContained(this.alstDeleteObjs, nIResource2)) {
                                            if (NICLResourceComparator.compareNonmodifiables(nIResource, nIResource2)) {
                                                if (nIResource2 instanceof NIVolume) {
                                                    arrayList.set(n, string);
                                                } else {
                                                    arrayList.remove(--n);
                                                    --n5;
                                                }
                                                bl2 = false;
                                                if (!NICLResourceComparator.compareModifiables(nIResource, nIResource2)) {
                                                    this.addModifyObject(nIResource, n2, n3, nIResource2);
                                                    if (nIResource2 instanceof NIRank) {
                                                        List list2 = this.tgtReaders[n2].queryVolumes((NIRankID)nIResource2.getID());
                                                        int n8 = list2.size();
                                                        n7 = 0;
                                                        while (n7 < n8 && bl) {
                                                            bl = this.addDeleteObject((NIVolume)list2.get(n7));
                                                            ++n7;
                                                        }
                                                        this.iTotalObjs += n8;
                                                    }
                                                } else {
                                                    --this.iTotalObjs;
                                                }
                                            }
                                        } else {
                                            bl2 = false;
                                        }
                                    } else if (this.iOverwrite == 0) {
                                        this.sendEvent(10, null, null);
                                        bl = false;
                                        this.pause();
                                    }
                                }
                                if (bl2) {
                                    int n9 = NICLGeneralUtils.getIdIntValue(nIResource2);
                                    String string2 = nIResource2.getID().getESS().getType();
                                    if (!(nIResource2 instanceof NIIOPort || nIResource2 instanceof NIVolumeGroup && NICLGeneralUtils.isVolGroupIdReserved(n9, string2))) {
                                        bl = this.addDeleteObject(nIResource2);
                                        List list3 = nICLGenealogist.getDependents(nIResource2);
                                        int n10 = list3.size();
                                        n7 = 0;
                                        while (n7 < n10 && bl) {
                                            bl = this.addDeleteObject((NIResource)list3.get(n7));
                                            ++this.iTotalObjs;
                                            ++n7;
                                        }
                                    }
                                }
                                ++n6;
                            }
                            if (n3 == 7) {
                                n6 = 0;
                                while (n6 < n5 && !this.bPauseTransfer) {
                                    if (string.equals(arrayList.get(n6))) {
                                        arrayList.remove(n6);
                                        --n6;
                                        --n5;
                                    }
                                    ++n6;
                                }
                            } else if (n3 == 2) {
                                this.iTotalObjs -= arrayList.size();
                                arrayList.clear();
                            }
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            if (bl && !this.bPauseTransfer) {
                this.bMappingComplete = true;
                this.generateDummyRsrcs();
            } else {
                this.sendEvent(17, null, null);
            }
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.sendEvent(5, null, nIUnavailableServerException);
            bl = false;
        }
        catch (NIServerException nIServerException) {
            this.sendEvent(6, null, nIServerException);
            bl = false;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": mapResources()");
        return bl;
    }

    private boolean checkHostSupport(int n) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": checkHostSupport()");
        boolean bl = true;
        String[] stringArray = null;
        try {
            List list = this.alstConfigObjs[n][9];
            if (list != null && this.clTransfer.getTargetType() == 0) {
                NIHostConfigurationService nIHostConfigurationService = this.aniServices[1].getHostConfigurationService();
                NIPortProfilesResult nIPortProfilesResult = nIHostConfigurationService.queryPortProfiles(this.aniEssIds[1][n]);
                if (nIPortProfilesResult.isSuccessful()) {
                    stringArray = nIPortProfilesResult.portProfiles();
                    int n2 = list.size();
                    int n3 = 0;
                    while (n3 < n2 && !this.bPauseTransfer && bl) {
                        NISCSIHostPort nISCSIHostPort = (NISCSIHostPort)list.get(n3);
                        String string = nISCSIHostPort.getPortProfile();
                        bl = false;
                        int n4 = 0;
                        while (n4 < stringArray.length && !bl) {
                            if (stringArray[n4].equalsIgnoreCase(string)) {
                                bl = true;
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                } else {
                    this.sendEvent(8, nIPortProfilesResult, null);
                    bl = false;
                }
            }
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.sendEvent(5, null, nIUnavailableServerException);
            bl = false;
        }
        catch (NIServerException nIServerException) {
            this.sendEvent(6, null, nIServerException);
            bl = false;
        }
        if (!bl) {
            this.pause();
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": checkHostSupport()");
        return bl;
    }

    private int getResourceIndex(NIResource nIResource) {
        int n = -1;
        if (nIResource instanceof NIStorageFacility) {
            n = 0;
        } else if (nIResource instanceof NIESS) {
            n = 1;
        } else if (nIResource instanceof NIIOPort) {
            n = 2;
        } else if (nIResource instanceof NIArray) {
            n = 3;
        } else if (nIResource instanceof NIExtentPool) {
            n = 4;
        } else if (nIResource instanceof NIRank) {
            n = 5;
        } else if (nIResource instanceof NILSS) {
            n = 6;
        } else if (nIResource instanceof NIVolume) {
            n = 7;
        } else if (nIResource instanceof NIVolumeGroup) {
            n = 8;
        } else if (nIResource instanceof NISCSIHostPort) {
            n = 9;
        }
        return n;
    }

    private NIConfigQueryResult getSfis(NIStorageFacilityID nIStorageFacilityID, int n) throws NIServerException, NIUnavailableServerException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": getSfis()");
        NIConfigQueryResult nIConfigQueryResult = this.aniDomainService[n].getESSs(this.aniSfids[n]);
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": getSfis()");
        return nIConfigQueryResult;
    }

    private NIConfigQueryResult getSfisForXfer(int n) throws NIServerException, NIUnavailableServerException {
        NIConfigQueryResult nIConfigQueryResult;
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": getSfisForXfer()");
        if (this.aniEssIds[n][0] == null) {
            nIConfigQueryResult = this.aniDomainService[n].getESSs(this.aniSfids[n]);
        } else {
            ArrayList<NIESSID> arrayList = new ArrayList<NIESSID>();
            int n2 = 0;
            while (n2 < this.aniEssIds[n].length) {
                if (this.aniEssIds[n][n2] != null) {
                    arrayList.add(this.aniEssIds[n][n2]);
                }
                ++n2;
            }
            nIConfigQueryResult = this.aniDomainService[n].getESSs(arrayList.toArray(new NIESSID[0]));
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": getSfisForXfer()");
        return nIConfigQueryResult;
    }

    private boolean isContained(List[][] listArray, NIResource nIResource) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": isContained()");
        boolean bl = false;
        NIResourceID nIResourceID = nIResource.getID();
        int n = NICLGeneralUtils.getImageIndex(nIResourceID);
        int n2 = this.getResourceIndex(nIResource);
        List list = listArray[n][n2];
        if (nIResource instanceof NIVolume) {
            bl = this.abVolDeletionTable[n][NICLGeneralUtils.getIdIntValue(nIResource)];
        } else {
            int n3 = list.size();
            int n4 = 0;
            while (n4 < n3 && !bl) {
                if (NICLResourceComparator.checkCorrespondence(nIResource, (NIResource)list.get(n4))) {
                    bl = true;
                }
                ++n4;
            }
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": isContained()");
        return bl;
    }

    private void setPasteLocation() {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": setPasteLocation()");
        boolean bl = false;
        int n = this.clTransfer.getConfigurationObjects().length;
        NIResource[] nIResourceArray = this.clTransfer.getConfigurationObjects();
        int n2 = 0;
        while (n2 < n && !bl) {
            NIResourceImpl nIResourceImpl;
            if (nIResourceArray[n2] instanceof NIVolumeGroup) {
                nIResourceImpl = (NIVolumeGroupImpl)nIResourceArray[n2];
                ((NIVolumeGroupImpl)nIResourceImpl).setUserName(COPY_LABEL + ((NIVolumeGroupImpl)nIResourceImpl).getUserName());
                bl = true;
            } else if (nIResourceArray[n2] instanceof NILSS) {
                int n3 = ((NILSSID)nIResourceArray[n2].getID()).getLSSNumber();
                int n4 = 0;
                while (n4 < 2) {
                    if (this.alstConfigObjs[n4][6] != null) {
                        int n5 = this.alstConfigObjs[n4][6].size();
                        int n6 = 0;
                        while (n6 < n5 && !bl) {
                            nIResourceImpl = (NILSSImpl)this.alstConfigObjs[n4][6].get(n6);
                            if (n3 == ((NILSSID)((NILSSImpl)nIResourceImpl).getID()).getLSSNumber()) {
                                NILSSID nILSSID = new NILSSID(this.aniEssIds[1][n4], ((NILSSID)this.aniResourceIdTgt[0]).getLSSNumber(), ((NILSSID)this.aniResourceIdTgt[0]).getSSID());
                                ((NILSSImpl)nIResourceImpl).setID(nILSSID);
                                ((NILSSImpl)nIResourceImpl).setSSID(((NILSSID)this.aniResourceIdTgt[0]).getSSID());
                                bl = true;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": setPasteLocation()");
    }

    private void sendDeletionList() {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": sendDeletionList()");
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < 2) {
            if (this.aniEssIds[1][n] != null) {
                int n2 = 0;
                while (n2 < 10) {
                    arrayList.addAll(NICLGeneralUtils.getResourceIds(this.alstDeleteObjs[n][n2]));
                    ++n2;
                }
            }
            ++n;
        }
        this.iTotalObjs += arrayList.size();
        NIOlcEventProcessor.enqueueEvent(new NICLEventImpl(this.clTransfer.getTransferID(), 0, 3, arrayList));
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": sendDeletionList()");
    }

    private void sendEvent(int n, NIResult nIResult, Exception exception) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": sendEvent()");
        if (exception != null) {
            NIOlcLogger.info(this.clTransfer.getTransferID() + ": *** RECEIVED EXCEPTION DURING TRANSFER ***");
            NIOlcLogger.severe(exception.toString(), exception);
        }
        if (nIResult != null) {
            if (nIResult instanceof NIConfigResult) {
                NIOlcLogger.info(this.clTransfer.getTransferID() + ": Config request resource ID: " + ((NIConfigResult)nIResult).getResourceID());
            }
            NIOlcLogger.info(this.clTransfer.getTransferID() + ": Config request code: 0x" + Integer.toHexString(nIResult.getCode()));
        }
        NIOlcLogger.info(this.clTransfer.getTransferID() + ": Sending NICLEvent (transfer ID: " + this.clTransfer.getTransferID() + ", rc: " + n + ", stage: " + this.iStage + ")");
        if (n == 0 || !this.sentFailedEvent) {
            NIOlcEventProcessor.enqueueEvent(new NICLEventImpl(this.clTransfer.getTransferID(), n, this.iStage, this.getProgress(), nIResult));
            if (n != 0) {
                this.sentFailedEvent = true;
            }
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": sendEvent()");
    }

    private NIConfigResult createBulkResources(NIESSID nIESSID, List list) throws NIServerException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": createBulkResources()");
        NIConfigResult nIConfigResult = null;
        if (list != null && list.size() > 0) {
            int n = list.size();
            NIResource nIResource = (NIResource)list.get(0);
            NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
            if (nIResource instanceof NIVolume) {
                int[] nArray = new int[256];
                int[] nArray2 = new int[256];
                int n2 = this.curCfgObj;
                int n3 = this.curCfgObj;
                do {
                    int n4;
                    NIVolume nIVolume = (NIVolume)list.get(n3);
                    int n5 = ((NIVolumeID)nIVolume.getID()).getLSS().getLSSNumber();
                    boolean bl = nIVolume.isAlias();
                    ArrayList<NIVolume> arrayList = new ArrayList<NIVolume>(256);
                    ArrayList<NIResourceID> arrayList2 = new ArrayList<NIResourceID>(256);
                    int n6 = 0;
                    while (n2 < n && n5 == ((NIVolumeID)((NIVolume)list.get(n2)).getID()).getLSS().getLSSNumber() && bl == ((NIVolume)list.get(n2)).isAlias()) {
                        nIVolume = (NIVolume)list.get(n2);
                        NILSSID nILSSID = (NILSSID)NICLGeneralUtils.generateTargetId(nIESSID, ((NIVolumeID)nIVolume.getID()).getLSS());
                        if (nIVolume.isAlias()) {
                            NIVolumeID nIVolumeID = (NIVolumeID)NICLGeneralUtils.generateTargetId(nIESSID, nIVolume.getOriginalBaseVolumeID());
                            NIVolumeGroupID nIVolumeGroupID = (NIVolumeGroupID)NICLGeneralUtils.generateTargetId(nIESSID, nIVolume.getAliasMapVolumeGroup());
                            nIVolume = NIResourceFactory.newVolume(nILSSID, ((NIVolumeID)nIVolume.getID()).getVolNumber(), nIVolumeID, nIVolume.getVolumeType(), nIVolume.getUserName(), nIVolumeGroupID);
                        } else {
                            NIExtentPoolID nIExtentPoolID = (NIExtentPoolID)NICLGeneralUtils.generateTargetId(nIESSID, nIVolume.getExtentPool());
                            nIVolume = NIResourceFactory.newVolume(nILSSID, ((NIVolumeID)nIVolume.getID()).getVolNumber(), nIVolume.getUserName(), nIExtentPoolID, nIVolume.getDataType(), nIVolume.getVolumeType(), nIVolume.getCapacity());
                        }
                        arrayList.add(nIVolume);
                        ++n2;
                    }
                    NIVolume[] nIVolumeArray = arrayList.toArray(new NIVolume[0]);
                    NIConfigCreatedResult[] nIConfigCreatedResultArray = this.createVolumes(nIVolumeArray);
                    int n7 = 0;
                    while (n7 < nIConfigCreatedResultArray.length) {
                        if (!nIConfigCreatedResultArray[n7].isSuccessful()) {
                            nArray2[n6] = n3 + n7;
                            ++n6;
                            if (nIConfigResult == null) {
                                nIConfigResult = nIConfigCreatedResultArray[n7];
                                this.pause();
                            }
                            NIOlcLogger.info(this.clTransfer.getTransferID() + ": (p-" + n7 + ") VolId=" + nIConfigCreatedResultArray[n7].getResourceID() + " rc=" + nIConfigCreatedResultArray[n7].getCode());
                        } else if (!bl && !NICLResourceComparator.compareModifiables((NIVolume)list.get(n3 + n7), (NIVolume)arrayList.get(n7))) {
                            arrayList2.add(nIConfigCreatedResultArray[n7].getResourceID());
                            nArray[arrayList2.size() - 1] = n3 + n7;
                        }
                        ++n7;
                    }
                    if (arrayList2.size() > 0) {
                        NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getVolumes(arrayList2.toArray(new NIVolumeID[0]));
                        List list2 = this.getResourceList(nIConfigQueryResult);
                        int n8 = arrayList2.size();
                        list2 = NICLGeneralUtils.sortRsrcsById(list2);
                        n4 = 0;
                        while (n4 < n8) {
                            NICLResourceComparator.merge((NIVolume)list.get(nArray[n4]), (NIVolume)list2.get(n4));
                            ++n4;
                        }
                        NIConfigResult[] nIConfigResultArray = this.modifyVolumes(list2.toArray(new NIVolume[0]));
                        n4 = 0;
                        while (n4 < nIConfigResultArray.length && nIConfigResult == null) {
                            if (!nIConfigResultArray[n4].isSuccessful()) {
                                nIConfigResult = nIConfigResultArray[n4];
                                this.pause();
                            }
                            ++n4;
                        }
                    }
                    n4 = 1;
                    while (n4 <= n6) {
                        nIVolume = (NIVolume)list.get(n2 - n4);
                        list.set(n2 - n4, list.get(nArray2[n6 - n4]));
                        list.set(nArray2[n6 - n4], nIVolume);
                        ++n4;
                    }
                    this.curCfgObj += n7 - n6;
                    ++this.iNumObjsXferred;
                    n3 = n2;
                    NIOlcLogger.info(this.clTransfer.getTransferID() + ": progress - " + this.getProgress() + " (" + this.iNumObjsXferred + "/" + this.iTotalObjs + ")");
                } while (n2 < n && nIConfigResult == null && !this.bPauseTransfer);
            } else {
                nIConfigResult = new NIConfigResultImpl(nIResource.getID(), false, -1099694077L);
            }
        }
        if (nIConfigResult == null) {
            nIConfigResult = new NIConfigResultImpl(null, true, 0L);
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": createBulkResources()");
        return nIConfigResult;
    }

    private int findConfigTypeIndex(NIResourceID nIResourceID) {
        int n = -1;
        if (nIResourceID instanceof NIStorageFacilityID) {
            n = 0;
        } else if (nIResourceID instanceof NIESSID) {
            n = 1;
        } else if (nIResourceID instanceof NIIOPortID) {
            n = 2;
        } else if (nIResourceID instanceof NIArrayID) {
            n = 3;
        } else if (nIResourceID instanceof NIExtentPoolID) {
            n = 4;
        } else if (nIResourceID instanceof NIRankID) {
            n = 5;
        } else if (nIResourceID instanceof NILSSID) {
            n = 6;
        } else if (nIResourceID instanceof NIVolumeID) {
            n = 7;
        } else if (nIResourceID instanceof NIVolumeGroupID) {
            n = 8;
        } else if (nIResourceID instanceof NISCSIHostPortID) {
            n = 9;
        }
        return n;
    }

    private void createDummyRsrcs(int n, NIResource nIResource) throws NIServerException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": createDummyRsrcs()");
        int n2 = NICLGeneralUtils.getIdIntValue(nIResource);
        int n3 = this.getResourceIndex(nIResource);
        List list = this.alstConfigObjs[n][n3];
        ArrayList<NIArraySite> arrayList = new ArrayList<NIArraySite>();
        NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
        NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getArraySites(this.aniEssIds[1][n]);
        List list2 = this.getResourceList(nIConfigQueryResult);
        int n4 = list2.size();
        int n5 = list.size();
        int n6 = 0;
        while (n6 < n5) {
            NIResource nIResource2 = (NIResource)list.get(n6);
            if (this.isDummyObject(nIResource2) && n2 >= NICLGeneralUtils.getIdIntValue(nIResource2)) {
                NIConfigResult nIConfigResult;
                if (n3 == 3) {
                    NIArraySite nIArraySite = null;
                    NIArraySiteID nIArraySiteID = this.findAvailSite(this.aniEssIds[1][n]);
                    int n7 = NICLGeneralUtils.getIdIntValue(nIArraySiteID);
                    int n8 = 0;
                    while (n8 < n4 && nIArraySite == null) {
                        if (n7 == NICLGeneralUtils.getIdIntValue((NIResource)list2.get(n8))) {
                            nIArraySite = (NIArraySite)list2.get(n8);
                        }
                        ++n8;
                    }
                    arrayList.add(nIArraySite);
                    this.assignSites((NIArray)nIResource2, arrayList);
                    arrayList.clear();
                }
                if (!(nIConfigResult = this.createResource(this.aniEssIds[1][n], nIResource2)).isSuccessful()) {
                    throw new NICLException((long)nIConfigResult.getCode(), 2);
                }
            }
            ++n6;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": createDummyRsrcs()");
    }

    private void deleteDummyRsrcs(NIResource nIResource) throws NIServerException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": deleteDummyRsrcs()");
        int n = NICLGeneralUtils.getIdIntValue(nIResource);
        int n2 = this.getResourceIndex(nIResource);
        List list = this.lstDummyIds[n2];
        int n3 = list.size();
        int n4 = 0;
        while (n4 < n3) {
            NIConfigResult nIConfigResult;
            NIResourceID nIResourceID = (NIResourceID)list.get(n4);
            if (n >= NICLGeneralUtils.getIdIntValue(nIResourceID) && !(nIConfigResult = this.deleteResource(nIResourceID)).isSuccessful()) {
                throw new NICLException((long)nIConfigResult.getCode(), 2);
            }
            ++n4;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": deleteDummyRsrcs()");
    }

    private boolean isDummyObject(NIResource nIResource) {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": isDummyObject()");
        boolean bl = false;
        int n = NICLGeneralUtils.getIdIntValue(nIResource);
        int n2 = this.getResourceIndex(nIResource);
        List list = this.lstDummyIds[n2];
        int n3 = list.size();
        int n4 = 0;
        while (n4 < n3 && !bl) {
            bl = n == NICLGeneralUtils.getIdIntValue((NIResourceID)list.get(n4));
            ++n4;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": isDummyObject(): " + bl + ", " + n2 + "-" + n);
        return bl;
    }

    private boolean locateSitesForArray(int n, NIArray nIArray) throws NIServerException {
        boolean bl;
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": locateSitesForArray()");
        NICLArrayToSiteMap nICLArrayToSiteMap = new NICLArrayToSiteMap(this.getAvailSites(this.curEss));
        List list = nICLArrayToSiteMap.reserveAvailableSites(nIArray);
        if (!(this.isDummyObject(nIArray) || list != null && list.size() > 0)) {
            this.deleteDummyRsrcs(nIArray);
            nICLArrayToSiteMap = new NICLArrayToSiteMap(this.getAvailSites(this.curEss));
            list = nICLArrayToSiteMap.reserveAvailableSites(nIArray);
            if (list != null && list.size() > 0) {
                this.assignSites(nIArray, list);
                this.createDummyRsrcs(this.curEss, nIArray);
                bl = true;
            } else {
                bl = false;
            }
        } else {
            this.assignSites(nIArray, list);
            bl = true;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": locateSitesForArray(): " + bl + " array=" + nIArray);
        return bl;
    }

    private boolean processTransfer() {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": processTransfer()");
        boolean bl = true;
        try {
            if (this.bReadAndPause) {
                this.setPasteLocation();
            }
            while (this.curEss < 2 && !this.bPauseTransfer) {
                if (this.aniEssIds[1][this.curEss] != null) {
                    int n;
                    NIConfigResult nIConfigResult;
                    int n2;
                    List list = this.getAvailSites(this.curEss);
                    if (list != null) {
                        if (NICLGeneralUtils.isMM(this.aniEssIds[1][this.curEss]) && !(bl = this.mapArraysToSites(this.curEss, list))) {
                            this.sendEvent(15, null, null);
                            this.pause();
                        }
                    } else {
                        this.sendEvent(15, null, null);
                        bl = false;
                    }
                    while (this.curType < 10 && !this.bPauseTransfer && bl) {
                        NIResource nIResource;
                        List list2;
                        n2 = this.creationOrder[this.curType];
                        if (n2 == 7) {
                            list2 = this.alstConfigObjs[this.curEss][n2];
                            if (!this.bVolumesSorted[this.curEss]) {
                                this.alstConfigObjs[this.curEss][n2] = list2 = this.sortRsrcsForCreation(list2);
                                this.bVolumesSorted[this.curEss] = true;
                            }
                            if (!(nIConfigResult = this.createBulkResources(this.aniEssIds[1][this.curEss], list2)).isSuccessful()) {
                                this.sendEvent(11, nIConfigResult, null);
                                bl = false;
                                this.pause();
                                break;
                            }
                        } else {
                            list2 = this.sortRsrcsForCreation(this.alstConfigObjs[this.curEss][n2]);
                            n = list2.size();
                            while (this.curCfgObj < n && !this.bPauseTransfer && bl) {
                                nIResource = (NIResource)list2.get(this.curCfgObj);
                                if (n2 == 3 && NICLGeneralUtils.isReef(nIResource)) {
                                    bl = this.locateSitesForArray(this.curEss, (NIArray)nIResource);
                                }
                                if (bl) {
                                    nIConfigResult = this.createResource(this.aniEssIds[1][this.curEss], nIResource);
                                    if (!nIConfigResult.isSuccessful()) {
                                        this.sendEvent(11, nIConfigResult, null);
                                        bl = false;
                                        this.pause();
                                        break;
                                    }
                                    ++this.iNumObjsXferred;
                                    ++this.curCfgObj;
                                    continue;
                                }
                                this.sendEvent(15, null, null);
                                this.pause();
                            }
                        }
                        if (this.bPauseTransfer) continue;
                        list2 = this.alstModifyObjs[this.curEss][n2];
                        n = list2.size();
                        while (this.curModObj < n && bl && !this.bPauseTransfer) {
                            nIResource = (NIResource)list2.get(this.curModObj);
                            nIConfigResult = this.modifyResource(nIResource);
                            if (!nIConfigResult.isSuccessful()) {
                                NIOlcLogger.info(this.clTransfer.getTransferID() + ": ERROR - Modifying resource failed!");
                                NIOlcLogger.info(this.clTransfer.getTransferID() + ": ERROR - Resource is " + nIResource);
                                this.sendEvent(11, nIConfigResult, null);
                                bl = false;
                                this.pause();
                                continue;
                            }
                            ++this.iNumObjsXferred;
                            ++this.curModObj;
                        }
                        if (this.bPauseTransfer) continue;
                        this.curCfgObj = 0;
                        this.curModObj = 0;
                        ++this.curType;
                    }
                    int n3 = 0;
                    while (n3 < this.deletionOrder.length && !this.bPauseTransfer) {
                        n2 = this.deletionOrder[n3];
                        if (this.lstDummyIds[n2] != null) {
                            n = this.lstDummyIds[n2].size();
                            int n4 = 0;
                            while (n4 < n && !this.bPauseTransfer) {
                                NIResourceID nIResourceID = (NIResourceID)this.lstDummyIds[n2].get(n4);
                                NIOlcLogger.info(this.clTransfer.getTransferID() + ": Deleting dummy object " + nIResourceID + "... progress - " + this.getProgress() + " (" + this.iNumObjsXferred + "/" + this.iTotalObjs + ")");
                                nIConfigResult = this.deleteResource(nIResourceID);
                                if (!nIConfigResult.isSuccessful()) {
                                    this.sendEvent(11, nIConfigResult, null);
                                    bl = false;
                                    this.pause();
                                } else {
                                    this.lstDummyIds[n2].remove(n4);
                                    --n4;
                                    --n;
                                    ++this.iNumObjsXferred;
                                }
                                ++n4;
                            }
                        }
                        ++n3;
                    }
                }
                if (this.bPauseTransfer) continue;
                this.curType = 0;
                ++this.curEss;
            }
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.sendEvent(5, null, nIUnavailableServerException);
            this.pause();
            bl = false;
        }
        catch (NIServerException nIServerException) {
            this.sendEvent(6, null, nIServerException);
            this.pause();
            bl = false;
        }
        if (!this.bPauseTransfer && bl) {
            this.bTransferComplete = true;
            System.out.println("Transfer successful (" + this.clTransfer.getTransferID() + ").");
            NIOlcLogger.info(this.clTransfer.getTransferID() + ": TRANSFER COMPLETE!  iNumObjsXferred=" + this.iNumObjsXferred + ", iTotalObjs=" + this.iTotalObjs);
            if (this.iTotalObjs < 1) {
                this.iTotalObjs = 1;
            }
            this.iNumObjsXferred = this.iTotalObjs;
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": processTransfer()");
        return bl;
    }

    private List sortArraysByDdmType(List list) {
        int n;
        List<NIArray> list2;
        String string;
        int n2;
        HashMap hashMap = new HashMap();
        int n3 = list.size();
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList arrayList3 = new ArrayList(n3);
        String string2 = ":";
        int n4 = 0;
        while (n4 < n3) {
            NIArray nIArray = (NIArray)list.get(n4);
            n2 = NICLGeneralUtils.convertDDMCapacityMBtoGB(nIArray.getDiskCapacity());
            string = "" + n2 + string2 + nIArray.getDiskRPM();
            if (!hashMap.containsKey(string)) {
                list2 = new ArrayList<NIArray>();
                list2.add(nIArray);
                arrayList2.add(string);
                hashMap.put(string, list2);
            } else {
                string = (String)arrayList2.get(arrayList2.indexOf(string));
                list2 = (List)hashMap.get(string);
                list2.add(nIArray);
            }
            ++n4;
        }
        ArrayList<String> arrayList4 = new ArrayList<String>(arrayList2.size());
        n4 = 0;
        while (arrayList2.size() > 0) {
            int n5 = 0;
            String string3 = (String)arrayList2.get(n5);
            int n6 = string3.indexOf(string2);
            int n7 = Integer.parseInt(string3.substring(0, n6));
            int n8 = Integer.parseInt(string3.substring(n6 + 1, string3.length()));
            n = arrayList2.size();
            int n9 = 1;
            while (n9 < n) {
                string = (String)arrayList2.get(n9);
                n6 = string.indexOf(string2);
                n2 = Integer.parseInt(string.substring(0, n6));
                int n10 = Integer.parseInt(string.substring(n6 + 1, string.length()));
                if (n2 > n7 || n2 == n7 && n10 > n8) {
                    string3 = string;
                    n7 = n2;
                    n8 = n10;
                    n5 = n9;
                }
                ++n9;
            }
            arrayList4.add(string3);
            arrayList2.remove(n5);
            ++n4;
        }
        n = arrayList4.size();
        n4 = 0;
        while (n4 < n) {
            list2 = (ArrayList<NIArray>)hashMap.get(arrayList4.get(n4));
            list2 = NICLGeneralUtils.sortRsrcsById(list2);
            arrayList3.addAll(list2);
            NIOlcLogger.info(this.clTransfer.getTransferID() + ": " + list2.size() + " sites with DDM type " + arrayList4.get(n4));
            ++n4;
        }
        return arrayList3;
    }

    private List sortRsrcsForCreation(List list) {
        List list2 = null;
        if (list != null && list.size() > 0) {
            list2 = list.get(0) instanceof NIVolume ? this.sortVolumes(list, 0) : NICLGeneralUtils.sortRsrcsById(list);
        }
        if (list2 == null) {
            list2 = new ArrayList(0);
        }
        return list2;
    }

    private List sortVolumes(List list, int n) {
        ArrayList arrayList = null;
        if (list != null && list.size() > 0) {
            List<NIVolume> list2 = new ArrayList();
            List<NIVolume> list3 = new ArrayList<NIVolume>();
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                NIVolume nIVolume = (NIVolume)list.get(n3);
                if (nIVolume.isAlias()) {
                    list3.add(nIVolume);
                } else {
                    list2.add(nIVolume);
                }
                ++n3;
            }
            arrayList = new ArrayList(n2);
            list2 = NICLGeneralUtils.sortRsrcsById(list2);
            list3 = NICLGeneralUtils.sortRsrcsById(list3);
            if (n == 0) {
                arrayList.addAll(list2);
                arrayList.addAll(list3);
            } else if (n == 1) {
                arrayList.addAll(list3);
                arrayList.addAll(list2);
            }
        }
        if (arrayList == null) {
            arrayList = new ArrayList(0);
        }
        return arrayList;
    }

    private boolean updateDummyId(NIResourceID nIResourceID, NIResourceID nIResourceID2) {
        int n;
        boolean bl = false;
        if (nIResourceID != null && nIResourceID2 != null && !nIResourceID.getClass().isInstance(nIResourceID2) && !nIResourceID2.getClass().isInstance(nIResourceID) && (n = this.findConfigTypeIndex(nIResourceID)) > 0) {
            int n2 = NICLGeneralUtils.getIdIntValue(nIResourceID);
            int n3 = this.lstDummyIds[n].size();
            int n4 = 0;
            while (n4 < n3 && !bl) {
                int n5 = NICLGeneralUtils.getIdIntValue((NIResourceID)this.lstDummyIds[n].get(n4));
                if (n2 == n5) {
                    this.lstDummyIds[n].remove(n4);
                    this.lstDummyIds[n].add(n4, nIResourceID2);
                    bl = true;
                }
                ++n4;
            }
        }
        return bl;
    }

    private void waitForArrayStatus(NIArrayID nIArrayID) throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": waitForArrayStatus()");
        int n = 0;
        NIArrayID[] nIArrayIDArray = new NIArrayID[]{nIArrayID};
        NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
        try {
            int n2;
            do {
                NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getArrays(nIArrayIDArray);
                n2 = ((NIArray)this.getResource(nIConfigQueryResult, 5)).getArrayStatus();
                NIOlcLogger.info(this.clTransfer.getTransferID() + ": (" + n + ") array status = " + n2);
                if (n2 != 2 || n + 1 >= 720) continue;
                Thread.sleep(20000L);
            } while (n2 == 2 && ++n < 720);
        }
        catch (Exception exception) {
            if (exception instanceof NICLException) {
                throw (NICLException)exception;
            }
            throw new NICLException(1L, 2);
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": waitForArrayStatus()");
    }

    private void waitForRankConfiguration(NILogicalConfigurationService nILogicalConfigurationService, NIRankID nIRankID) throws NICLException {
        NIOlcLogger.enter(CLASS_NAME, this.clTransfer.getTransferID() + ": waitForRankConfiguration()");
        int n = 1;
        int n2 = 0;
        NIRankID[] nIRankIDArray = new NIRankID[]{nIRankID};
        try {
            while (n == 1 && n2 < 180) {
                NIConfigQueryResult nIConfigQueryResult = nILogicalConfigurationService.getRanks(nIRankIDArray);
                n = ((NIRank)this.getResource(nIConfigQueryResult, 5)).getConfigurationState();
                NIOlcLogger.info(this.clTransfer.getTransferID() + ": rank config state = " + n);
                if (n == 1 && n2 + 1 < 180) {
                    Thread.sleep(20000L);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            if (exception instanceof NICLException) {
                throw (NICLException)exception;
            }
            throw new NICLException(1L, 2);
        }
        NIOlcLogger.exit(CLASS_NAME, this.clTransfer.getTransferID() + ": waitForRankConfiguration()");
    }

    private NIConfigCreatedResult[] createVolumes(NIVolume[] nIVolumeArray) throws NIServerException {
        NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
        int n = this.aniServices[1].getConnectionType();
        int n2 = 256;
        NIVolume nIVolume = nIVolumeArray[0];
        int n3 = ((NIVolumeID)nIVolume.getID()).getLSS().getLSSNumber();
        NIConfigCreatedResult[] nIConfigCreatedResultArray = new NIConfigCreatedResult[nIVolumeArray.length];
        if (n == 3) {
            n2 = 64;
        } else if (n == 1) {
            n2 = 16;
        }
        int n4 = 0;
        while (n4 < nIVolumeArray.length) {
            int n5 = n2;
            if (n4 + n5 > nIVolumeArray.length) {
                n5 = nIVolumeArray.length - n4;
            }
            NIVolume[] nIVolumeArray2 = new NIVolume[n5];
            System.arraycopy(nIVolumeArray, n4, nIVolumeArray2, 0, n5);
            if (nIVolume.isAlias()) {
                NIOlcLogger.info(this.clTransfer.getTransferID() + ": create aliases on LSS 0x" + Integer.toHexString(n3) + " (" + n4 + "-" + (n4 + n5 - 1) + ")");
                System.arraycopy(nILogicalConfigurationService.createAliasVolumes(nIVolumeArray2), 0, nIConfigCreatedResultArray, n4, n5);
            } else {
                NIOlcLogger.info(this.clTransfer.getTransferID() + ": create vols on LSS 0x" + Integer.toHexString(n3) + " (" + n4 + "-" + (n4 + n5 - 1) + ")");
                System.arraycopy(nILogicalConfigurationService.createVolumes(nIVolumeArray2), 0, nIConfigCreatedResultArray, n4, n5);
            }
            n4 += n2;
        }
        return nIConfigCreatedResultArray;
    }

    private NIConfigResult[] modifyVolumes(NIVolume[] nIVolumeArray) throws NIServerException {
        NILogicalConfigurationService nILogicalConfigurationService = this.aniServices[1].getLogicalConfigurationService();
        int n = this.aniServices[1].getConnectionType();
        int n2 = 256;
        NIConfigResult[] nIConfigResultArray = new NIConfigResult[nIVolumeArray.length];
        if (n == 3) {
            n2 = 64;
        } else if (n == 1) {
            n2 = 16;
        }
        int n3 = 0;
        while (n3 < nIVolumeArray.length) {
            int n4 = n2;
            if (n3 + n4 > nIVolumeArray.length) {
                n4 = nIVolumeArray.length - n3;
            }
            NIVolume[] nIVolumeArray2 = new NIVolume[n4];
            System.arraycopy(nIVolumeArray, n3, nIVolumeArray2, 0, n4);
            System.arraycopy(nILogicalConfigurationService.modifyVolumes(nIVolumeArray2), 0, nIConfigResultArray, n3, n4);
            n3 += n2;
        }
        return nIConfigResultArray;
    }
}

