/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.cl.module.util;

import com.ibm.jvm.ExtendedSystem;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroup;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupVolumeList;
import com.ibm.storage.ess.ni.cl.module.util.NICLResourceComparator;
import com.ibm.storage.ess.ni.constants.NIConfigurationConstants;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import com.ibm.storage.ess.ni.resource.NIArrayImpl;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NICLGeneralUtils {
    public static final int MBS_PER_GB = 1000;
    public static final int MAX_ARRAY_SITE_NUM = 224;
    public static final int MAX_IMAGES_PER_SF = 2;
    public static final int MAX_LSS_PER_SFI = 256;
    public static final int MAX_VOLS_PER_LSS = 256;
    public static final int UNDEFINED = -1;
    private static final String CLASS_NAME = "NICLGeneralUtils";
    private static final int FIRST_AVAIL_VOL_GROUP_NUM_1750 = 11;
    private static final int FIRST_AVAIL_VOL_GROUP_NUM_2107 = 0;

    public static void cleanArrays(List list) {
        if (list != null) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                NIArrayImpl nIArrayImpl = (NIArrayImpl)list.get(n2);
                NIArraySiteID[] nIArraySiteIDArray = nIArrayImpl.getArraySites();
                ArrayList<NIArraySiteID> arrayList = new ArrayList<NIArraySiteID>();
                int n3 = 0;
                while (n3 < nIArraySiteIDArray.length) {
                    if (nIArraySiteIDArray[n3].getArraySiteNumber() >= 0) {
                        arrayList.add(nIArraySiteIDArray[n3]);
                    }
                    ++n3;
                }
                nIArrayImpl.setArraySiteIDs(arrayList.toArray(new NIArraySiteID[0]));
                ++n2;
            }
        }
    }

    public static int convertDDMCapacityMBtoGB(int n) {
        NIOlcLogger.enter(CLASS_NAME, "convertDDMCapacityMBtoGB()");
        int n2 = 0;
        if (Math.abs(n - 500000) < 20000) {
            n2 = 500000 / (int)NIConfigurationConstants.MB_IN_ON_GB_DEC;
        } else if (Math.abs(n - 300000) < 20000) {
            n2 = 300000 / (int)NIConfigurationConstants.MB_IN_ON_GB_DEC;
        } else if (Math.abs(n - 146000) < 20000) {
            n2 = 146000 / (int)NIConfigurationConstants.MB_IN_ON_GB_DEC;
        } else if (Math.abs(n - 73000) < 20000) {
            n2 = 73000 / (int)NIConfigurationConstants.MB_IN_ON_GB_DEC;
        }
        NIOlcLogger.exit(CLASS_NAME, "convertDDMCapacityMBtoGB()");
        return n2;
    }

    public static int convertDDMRPM(int n) {
        int n2 = 0;
        if (Math.abs(n - 15000) < 1500) {
            n2 = 15000;
        }
        if (Math.abs(n - 10000) < 1500) {
            n2 = 10000;
        }
        if (Math.abs(n - 7200) < 1500) {
            n2 = 7200;
        }
        return n2;
    }

    public static boolean isMM(NIResource nIResource) {
        return NICLGeneralUtils.isMM(nIResource.getID());
    }

    public static boolean isMM(NIResourceID nIResourceID) {
        boolean bl;
        try {
            bl = nIResourceID.getESS().getType().equals("2107");
        }
        catch (Exception exception) {
            bl = false;
            NIOlcLogger.severe("WARNING: Exception while checking for MM", exception);
        }
        return bl;
    }

    public static boolean isReef(NIResource nIResource) {
        return NICLGeneralUtils.isReef(nIResource.getID());
    }

    public static boolean isReef(NIResourceID nIResourceID) {
        boolean bl;
        try {
            bl = nIResourceID.getESS().getType().equals("1750");
        }
        catch (Exception exception) {
            bl = false;
            NIOlcLogger.severe("WARNING: Exception while checking for Reef", exception);
        }
        return bl;
    }

    public static NIResourceID[] generateTargetIds(NIESSID nIESSID, NIResourceID[] nIResourceIDArray) {
        NIResourceID[] nIResourceIDArray2;
        NIOlcLogger.enter(CLASS_NAME, "generateTargetId()[]");
        if (nIESSID != null && nIResourceIDArray != null && nIResourceIDArray.length >= 0) {
            nIResourceIDArray2 = (NIResourceID[])Array.newInstance(nIResourceIDArray.getClass().getComponentType(), nIResourceIDArray.length);
            int n = 0;
            while (n < nIResourceIDArray.length) {
                nIResourceIDArray2[n] = NICLGeneralUtils.generateTargetId(nIESSID, nIResourceIDArray[n]);
                ++n;
            }
        } else {
            nIResourceIDArray2 = (NIResourceID[])Array.newInstance(nIResourceIDArray.getClass().getComponentType(), 0);
        }
        NIOlcLogger.exit(CLASS_NAME, "generateTargetId()[]");
        return nIResourceIDArray2;
    }

    public static NIResourceID generateTargetId(NIESSID nIESSID, NIResourceID nIResourceID) {
        NIOlcLogger.enter(CLASS_NAME, "generateTargetId()");
        NIResourceID nIResourceID2 = null;
        if (nIESSID != null && nIResourceID != null) {
            if (nIResourceID instanceof NIArraySiteID) {
                nIResourceID2 = new NIArraySiteID(nIESSID, NICLGeneralUtils.getIdIntValue(nIResourceID));
            } else if (nIResourceID instanceof NIArrayID) {
                nIResourceID2 = new NIArrayID(nIESSID, NICLGeneralUtils.getIdIntValue(nIResourceID));
            } else if (nIResourceID instanceof NIRankID) {
                nIResourceID2 = new NIRankID(nIESSID, NICLGeneralUtils.getIdIntValue(nIResourceID));
            } else if (nIResourceID instanceof NIExtentPoolID) {
                nIResourceID2 = new NIExtentPoolID(nIESSID, NICLGeneralUtils.getIdIntValue(nIResourceID));
            } else if (nIResourceID instanceof NILSSID) {
                nIResourceID2 = new NILSSID(nIESSID, NICLGeneralUtils.getIdIntValue(nIResourceID));
            } else if (nIResourceID instanceof NIVolumeID) {
                nIResourceID2 = new NIVolumeID((NILSSID)NICLGeneralUtils.generateTargetId(nIESSID, ((NIVolumeID)nIResourceID).getLSS()), ((NIVolumeID)nIResourceID).getVolNumber());
            } else if (nIResourceID instanceof NIVolumeGroupID) {
                nIResourceID2 = new NIVolumeGroupID(nIESSID, NICLGeneralUtils.getIdIntValue(nIResourceID));
            } else if (nIResourceID instanceof NISCSIHostPortID) {
                nIResourceID2 = new NISCSIHostPortID(nIESSID, NICLGeneralUtils.getIdIntValue(nIResourceID));
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "generateTargetId()");
        return nIResourceID2;
    }

    public static int getIdIntValue(NIResource nIResource) {
        int n = nIResource == null ? -1 : NICLGeneralUtils.getIdIntValue(nIResource.getID());
        return n;
    }

    public static int getIdIntValue(NIResourceID nIResourceID) {
        int n = -1;
        if (nIResourceID instanceof NIESSID) {
            n = ((NIESSID)nIResourceID).getImageNumber();
        } else if (nIResourceID instanceof NIArraySiteID) {
            n = ((NIArraySiteID)nIResourceID).getArraySiteNumber();
        } else if (nIResourceID instanceof NIIOPortID) {
            n = ((NIIOPortID)nIResourceID).getInterfaceIdentifier();
        } else if (nIResourceID instanceof NIArrayID) {
            n = ((NIArrayID)nIResourceID).getArrayNumber();
        } else if (nIResourceID instanceof NIRankID) {
            n = ((NIRankID)nIResourceID).getRankNumber();
        } else if (nIResourceID instanceof NIExtentPoolID) {
            n = ((NIExtentPoolID)nIResourceID).getExtentPoolNumber();
        } else if (nIResourceID instanceof NILSSID) {
            n = ((NILSSID)nIResourceID).getLSSNumber();
        } else if (nIResourceID instanceof NIVolumeID) {
            n = ((NIVolumeID)nIResourceID).getLSS().getLSSNumber() * 256 + ((NIVolumeID)nIResourceID).getVolNumber();
        } else if (nIResourceID instanceof NIVolumeGroupID) {
            n = ((NIVolumeGroupID)nIResourceID).getVolumeGroupNumber();
        } else if (nIResourceID instanceof NISCSIHostPortID) {
            n = ((NISCSIHostPortID)nIResourceID).getPortID();
        }
        return n;
    }

    public static int getImageIndex(NIResourceID nIResourceID) {
        return nIResourceID.getESS().getImageNumber() - 1;
    }

    public static Object[] getNewArray(Class clazz, int n) {
        Object[] objectArray = ExtendedSystem.isResettableJVM() ? (Object[])ExtendedSystem.newArray(clazz.getComponentType(), (int)n, (Object)clazz) : (Object[])Array.newInstance(clazz.getComponentType(), n);
        return objectArray;
    }

    public static List getResourceIds(List list) {
        ArrayList<NIResourceID> arrayList;
        NIOlcLogger.enter(CLASS_NAME, "getResourceIds()");
        if (list != null) {
            int n = list.size();
            arrayList = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(((NIResource)list.get(n2)).getID());
                ++n2;
            }
        } else {
            arrayList = new ArrayList<NIResourceID>();
        }
        NIOlcLogger.exit(CLASS_NAME, "getResourceIds()");
        return arrayList;
    }

    public static boolean isEqual(Object object, Object object2) {
        NIOlcLogger.enter(CLASS_NAME, "isEqual()");
        boolean bl = object == null && object2 != null || object != null && object2 == null ? false : (object == null && object2 == null ? true : object.equals(object2));
        NIOlcLogger.exit(CLASS_NAME, "isEqual()");
        return bl;
    }

    public static boolean isVolGroupIdReserved(int n, String string) {
        boolean bl = string.equals("1750") && n < 11 || string.equals("2107") && n < 0 || n == 10 || n == 20 || n == 30;
        return bl;
    }

    public static boolean removeInvalidVols(NIVolumeGroup nIVolumeGroup, int[] nArray) {
        boolean bl = true;
        NIVolumeGroupVolumeList nIVolumeGroupVolumeList = nIVolumeGroup.getVolumeGroupList();
        if (nIVolumeGroupVolumeList != null) {
            NIVolumeID[] nIVolumeIDArray = nIVolumeGroupVolumeList.getVolumesInVolumeGroup().toArray(new NIVolumeID[0]);
            int n = 0;
            while (n < nIVolumeIDArray.length) {
                if (nArray[NICLGeneralUtils.getIdIntValue(nIVolumeIDArray[n])] == -1) {
                    NIOlcLogger.info("WARNING: Volume " + NICLGeneralUtils.getIdIntValue(nIVolumeIDArray[n]) + " in vol group " + nIVolumeGroup.getUserName() + " does not exist");
                    bl = false;
                    nIVolumeGroupVolumeList.remove(nIVolumeIDArray[n]);
                }
                ++n;
            }
        }
        return bl;
    }

    public static List sortRsrcsById(List list) {
        NIOlcLogger.enter(CLASS_NAME, "sortRsrcsById()");
        int n = list.size();
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(list.get(n2));
            ++n2;
        }
        Collections.sort(arrayList, new NICLResourceComparator());
        NIOlcLogger.exit(CLASS_NAME, "sortRsrcsById()");
        return arrayList;
    }
}

