/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.command.extensions;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.command.extensions.NICommandAddress;
import com.ibm.storage.ess.ni.command.extensions.NICommandID;
import com.ibm.storage.ess.ni.command.extensions.timeouts.NICommandTimeoutOracle;
import com.ibm.storage.ess.ni.commandagent.common.NIOwnership;
import com.ibm.storage.ess.ni.commandagent.common.NIResponseInterface;
import com.ibm.storage.ess.ni.commandagent.common.NIServicesInterface;
import com.ibm.storage.ess.ni.communication.NICommunication;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.iou.NIIou;
import com.ibm.storage.ess.ni.iou.NIIouCallback;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.resource.NIResourceImpl;
import com.ibm.storage.ess.ni.results.NIPeerConfigurationResultImpl;
import com.ibm.storage.ess.ni.results.NIResultImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class NICommand
implements NICommunication,
NIIouCallback {
    private static final String METHOD_PREFIX_QUERY = "query";
    private static final String METHOD_PREFIX_GET = "get";
    private static final String METHOD_TEST_CONNECTION = "testConnection";
    private static final String METHOD_MODIFY_USER_ACCOUNT_PASSWORD = "modifyUserAccountPassword";
    private static final String METHOD_MODIFY_RM_PASSWORD = "changeRMPassword";
    private static final Object[] FIELD_PARAMS = new Object[]{"params"};
    private static final Object[] FIELD_IDEMPOTENT = new Object[]{"idempotent"};
    private static final Object[] FIELD_SERVER_EXCEPTION = new Object[]{"serverException"};
    private static final Object[] FIELD_SERVICE_STRING = new Object[]{"serviceString"};
    private static final Object[] FIELD_METHOD_NAME = new Object[]{"methodName"};
    private static final Object[] FIELD_ID = new Object[]{"id"};
    private static final Object[] FIELD_PARAMETERS_STRING = new Object[]{"parametersString"};
    private static final Object[] FIELD_ADDRESS = new Object[]{"address"};
    private static final Object[] FIELD_RESPONSE = new Object[]{"response"};
    private static final Object[] FIELD_PRIMITIVE_CLASSES_TABLE = new Object[]{"primitiveClassesTable"};
    private static final Object[] FIELD_PARAM_TYPES_STRINGS = new Object[]{"paramTypesStrings"};
    private static final Object[] FIELD_PARAM_TYPE_IS_PRIMITIVE = new Object[]{"paramTypeIsPrimitive"};
    private static final Object[] FIELD_SERIALIZATION_VERSION = new Object[]{"clientSerializationVersion"};
    private static final Object[] FIELD_EXECUTED = new Object[]{"executed"};
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$command$extensions$NICommand == null ? (class$com$ibm$storage$ess$ni$command$extensions$NICommand = NICommand.class$("com.ibm.storage.ess.ni.command.extensions.NICommand")) : class$com$ibm$storage$ess$ni$command$extensions$NICommand);
    private static final long serialVersionUID = 2L;
    private static Method MAP_METHOD_REMOVE = null;
    private static Method MAP_METHOD_GET = null;
    private NICommandAddress address;
    private NICommandID id;
    private boolean idempotent = false;
    protected String methodName = null;
    protected Object[] params = null;
    private transient Class[] paramTypes = null;
    private String[] paramTypesStrings = null;
    private boolean[] paramTypeIsPrimitive = null;
    private Hashtable primitiveClassesTable = null;
    protected boolean resourcesOnNode;
    private Object response;
    protected transient NIResponseInterface responseInterface;
    private Exception serverException = null;
    private transient Class service = null;
    private String serviceString = null;
    private transient boolean classesReconstituted = false;
    private String parametersString = null;
    private Map fieldsTable = new HashMap();
    private static final int SERIALIZATION_VERSION_NONE = 0;
    private static final int SERIALIZATION_VERSION_1 = 1;
    private int serializationVersion = 1;
    private boolean executed = false;
    private long timeout;
    private static final int MAX_REEF_RESPONSE_SIZE = 4096;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$command$extensions$NICommand;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class array$Lcom$ibm$storage$ess$ni$application$resource$NIResource;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;

    protected NICommand() {
        this(null, null);
    }

    public NICommand(Method method, Object[] objectArray) {
        this(method, objectArray, method == null ? false : method.getName().startsWith(METHOD_PREFIX_GET) || method.getName().startsWith(METHOD_PREFIX_QUERY) || method.getName().equals(METHOD_TEST_CONNECTION));
    }

    public NICommand(Method method, Object[] objectArray, boolean bl) {
        this.idempotent = bl;
        this.params = objectArray;
        if (method == null) {
            this.methodName = "";
            this.serviceString = "";
        } else {
            this.methodName = method.getName();
            this.service = method.getDeclaringClass();
            this.serviceString = this.service.getName();
            this.paramTypes = method.getParameterTypes();
            if (this.paramTypes != null) {
                this.paramTypesStrings = new String[this.paramTypes.length];
                this.paramTypeIsPrimitive = new boolean[this.paramTypes.length];
                int n = 0;
                while (n < this.paramTypes.length) {
                    this.paramTypesStrings[n] = this.paramTypes[n].getName();
                    this.paramTypeIsPrimitive[n] = this.paramTypes[n].isPrimitive();
                    if (this.paramTypeIsPrimitive[n]) {
                        if (this.primitiveClassesTable == null) {
                            this.primitiveClassesTable = new Hashtable();
                        }
                        this.primitiveClassesTable.put(this.paramTypesStrings[n], this.paramTypes[n]);
                    }
                    ++n;
                }
            }
        }
        this.address = new NICommandAddress();
        this.id = new NICommandID();
        this.timeout = NICommandTimeoutOracle.getTimeout(method, objectArray);
        this.serializeCommandData();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void applyOwnership(NIOwnership nIOwnership) {
        this.resourcesOnNode = true;
    }

    public boolean areResourceOnNode() {
        return this.resourcesOnNode;
    }

    public void callback(Object object) {
        logger.enter("NICommand", "callback");
        if (object instanceof Exception) {
            this.setException((Exception)object);
        } else {
            this.response = object;
            if (this.methodName != null && this.methodName.compareTo("removePeer") == 0 && ((NIPeerConfigurationResultImpl)object).getCode() != 2) {
                logger.debug_general("Set peer did not fail - Changing server name to HMC1");
                NIMessageRouterAddress nIMessageRouterAddress = this.address.getReturnAddress();
                this.address.setReturnAddress(new NIMessageRouterAddress(nIMessageRouterAddress.getProcessChannelID(), "HMC1"));
            }
        }
        this.address.reverseAddress();
        this.serializeCommandData();
        this.responseInterface.send(this);
        logger.exit("NICommand", "callback");
    }

    public void checkException() throws Exception {
        this.deserializeCommandData(false);
        if (this.serverException != null) {
            if (this.serverException instanceof NIUnavailableServerException) {
                ((NIUnavailableServerException)this.serverException).throwSubException();
            }
            throw this.serverException;
        }
    }

    public void clearResourceSetMethods() {
        logger.enter("NICommand", "clearResourceSetMethods");
        this.reconstructParameters(false);
        if (this.params != null) {
            int n = 0;
            while (n < this.params.length) {
                NIResource[] nIResourceArray;
                if (this.params[n] instanceof NIResourceImpl) {
                    nIResourceArray = (NIResource[])this.params[n];
                    nIResourceArray.clearSetMethods();
                } else if (this.params[n] != null && (array$Lcom$ibm$storage$ess$ni$application$resource$NIResource == null ? NICommand.class$("[Lcom.ibm.storage.ess.ni.application.resource.NIResource;") : array$Lcom$ibm$storage$ess$ni$application$resource$NIResource).isAssignableFrom(this.params[n].getClass())) {
                    nIResourceArray = (NIResource[])this.params[n];
                    int n2 = 0;
                    while (n2 < nIResourceArray.length) {
                        ((NIResourceImpl)((Object)nIResourceArray[n2])).clearSetMethods();
                        ++n2;
                    }
                }
                ++n;
            }
        }
        logger.exit("NICommand", "clearResourceSetMethods");
    }

    public boolean equals(Object object) {
        return this == object || object instanceof NICommand && (this.address == null ? this.address == ((NICommand)object).address : this.address.equals(((NICommand)object).address)) && (this.id == null ? this.id == ((NICommand)object).id : this.id.equals(((NICommand)object).id)) && (this.service == null ? this.service == ((NICommand)object).service : this.service.equals(((NICommand)object).service)) && (this.methodName == null ? this.methodName == ((NICommand)object).methodName : this.methodName.equals(((NICommand)object).methodName)) && (this.response == null ? this.response == ((NICommand)object).response : this.response.equals(((NICommand)object).response));
    }

    public void execute(NIServicesInterface nIServicesInterface, NIResponseInterface nIResponseInterface) {
        logger.enter("NICommand", "execute");
        this.responseInterface = nIResponseInterface;
        logger.debug_detailed("Method invoked by command", this.serviceString, this.methodName, this.params);
        try {
            this.reconstituteClasses();
            this.executed = true;
            Object object = this.service.getDeclaredMethod(this.methodName, this.paramTypes).invoke(nIServicesInterface.getServiceInterface(this.service), this.params);
            if (object instanceof NIIou) {
                ((NIIou)object).addCallback(this);
            } else if (object != null && object.getClass().isArray() && ((Object[])object).length > 0 && ((Object[])object)[0] instanceof NIIou) {
                ((NIIou)((Object[])object)[0]).addCallback(this);
            } else {
                this.callback(object);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error("Command not supported where it is being executed.");
            logger.throwable((Throwable)classNotFoundException);
            this.setException(new NIUnsupportedException(classNotFoundException.toString()));
            this.callback(null);
        }
        catch (SecurityException securityException) {
            logger.error("Command not supported where it is being executed.");
            logger.throwable((Throwable)securityException);
            this.setException(new NIUnsupportedException(securityException.toString()));
            this.callback(null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.error("Command not supported where it is being executed.");
            logger.throwable((Throwable)noSuchMethodException);
            this.setException(new NIUnsupportedException(noSuchMethodException.toString()));
            this.callback(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Command not supported where it is being executed.");
            logger.throwable((Throwable)illegalArgumentException);
            this.setException(new NIUnsupportedException(illegalArgumentException.toString()));
            this.callback(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error("Command not supported where it is being executed.");
            logger.throwable((Throwable)illegalAccessException);
            this.setException(new NIUnsupportedException(illegalAccessException.toString()));
            this.callback(null);
        }
        catch (NIUnsupportedException nIUnsupportedException) {
            logger.error("Command not supported where it is being executed.");
            logger.throwable((Throwable)nIUnsupportedException);
            this.setException(nIUnsupportedException);
            this.callback(null);
        }
        catch (InvocationTargetException invocationTargetException) {
            NIServerException nIServerException;
            logger.error("InvocationTargetException - printing cause.");
            Throwable throwable = invocationTargetException.getTargetException();
            logger.throwable(throwable);
            if (throwable instanceof NIUnsupportedException) {
                nIServerException = (NIUnsupportedException)throwable;
            } else {
                nIServerException = new NIServerException(0, invocationTargetException.toString());
                nIServerException.initCause(throwable);
            }
            this.setException(nIServerException);
            this.callback(null);
        }
        catch (NIServerException nIServerException) {
            this.setException(nIServerException);
            this.callback(null);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            this.setException(new NIServerException(0));
            this.callback(null);
        }
        logger.exit("NICommand", "execute");
    }

    public NICommandAddress getAddress() {
        return this.address;
    }

    public NICommandID getID() {
        return this.id;
    }

    public String getMethodName() {
        block2: {
            if (this.methodName != null) break block2;
            try {
                this.methodName = (String)this.fieldsTable.get(FIELD_METHOD_NAME[0]);
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
            }
        }
        return this.methodName;
    }

    public Object[] getParameters() {
        this.reconstructParameters(false);
        return this.params == null ? new Object[]{} : this.params;
    }

    public Class[] getParamTypes() throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, IOException, NIServerException {
        if (this.paramTypes == null) {
            this.reconstituteClasses();
        }
        return this.paramTypes;
    }

    protected boolean reconstructParameters(boolean bl) {
        boolean bl2 = true;
        if (this.params == null) {
            Method method = bl ? MAP_METHOD_REMOVE : MAP_METHOD_GET;
            bl2 = false;
            try {
                this.params = (Object[])this.deserialize((byte[])method.invoke((Object)this.fieldsTable, FIELD_PARAMS));
                bl2 = true;
            }
            catch (Exception exception) {
                logger.error("Could not reconstruct parameters");
                logger.throwable((Throwable)exception);
                this.params = null;
            }
        } else if (bl) {
            this.fieldsTable.remove(FIELD_PARAMS[0]);
        }
        return bl2;
    }

    public String getServiceName() {
        block2: {
            if (this.serviceString != null) break block2;
            try {
                this.serviceString = (String)this.fieldsTable.get(FIELD_SERVICE_STRING[0]);
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
            }
        }
        return this.serviceString;
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public Object retrieveResponseData() {
        block2: {
            if (this.response != null) break block2;
            try {
                this.deserializeCommandData(false);
            }
            catch (Exception exception) {
                logger.error("Error deserializing response.");
                logger.throwable((Throwable)exception);
            }
        }
        return this.response;
    }

    public void setAddress(NICommandAddress nICommandAddress) {
        this.address = nICommandAddress;
    }

    public void setException(Exception exception) {
        logger.warning("exception set in command", "NICommand", "setException", new Object[]{exception});
        this.serverException = exception;
    }

    public void setID(NICommandID nICommandID) {
        this.id = nICommandID;
    }

    public String toString() {
        return "id: " + this.id + ", Dest: (" + this.address.getDestinationAddress() + "), " + this.parametersString;
    }

    private void buildParametersString() {
        String string = this.serviceString == null ? null : this.serviceString.substring(this.serviceString.lastIndexOf(46) + 1);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.methodName != null && this.methodName.equals(METHOD_MODIFY_USER_ACCOUNT_PASSWORD)) {
            stringBuffer.append(this.params[0] + ", ********");
        } else if (this.methodName != null && this.methodName.equals(METHOD_MODIFY_RM_PASSWORD)) {
            stringBuffer.append(this.params[0] + ", " + this.params[1] + ", ********, " + this.params[3]);
        } else {
            int n = 0;
            while (this.params != null && n < this.params.length) {
                stringBuffer.append(this.toString(this.params[n]));
                if (n != this.params.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
        }
        this.parametersString = string + "." + this.methodName + "(" + stringBuffer + ")" + ":" + this.toString(this.response);
    }

    private String toString(Object object) {
        String string = null;
        if (object != null && object.getClass().isArray()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            if ((array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = NICommand.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object).isAssignableFrom(object.getClass())) {
                Object[] objectArray = (Object[])object;
                if (objectArray.length > 8) {
                    stringBuffer.append(objectArray.getClass().getComponentType().getName()).append('[').append(objectArray.length).append(']');
                } else {
                    int n = 0;
                    while (n < objectArray.length) {
                        stringBuffer.append(this.toString(objectArray[n]));
                        if (n != objectArray.length - 1) {
                            stringBuffer.append(", ");
                        }
                        ++n;
                    }
                }
            } else if ((array$I == null ? (array$I = NICommand.class$("[I")) : array$I).isAssignableFrom(object.getClass())) {
                int[] nArray = (int[])object;
                if (nArray.length > 8) {
                    stringBuffer.append(nArray.getClass().getComponentType().getName()).append('[').append(nArray.length).append(']');
                } else {
                    int n = 0;
                    while (n < nArray.length) {
                        stringBuffer.append(nArray[n]);
                        if (n != nArray.length - 1) {
                            stringBuffer.append(", ");
                        }
                        ++n;
                    }
                }
            } else if ((array$D == null ? (array$D = NICommand.class$("[D")) : array$D).isAssignableFrom(object.getClass())) {
                double[] dArray = (double[])object;
                if (dArray.length > 8) {
                    stringBuffer.append(dArray.getClass().getComponentType().getName()).append('[').append(dArray.length).append(']');
                } else {
                    int n = 0;
                    while (n < dArray.length) {
                        stringBuffer.append(dArray[n]);
                        if (n != dArray.length - 1) {
                            stringBuffer.append(", ");
                        }
                        ++n;
                    }
                }
            } else if ((array$C == null ? (array$C = NICommand.class$("[C")) : array$C).isAssignableFrom(object.getClass())) {
                char[] cArray = (char[])object;
                if (cArray.length > 8) {
                    stringBuffer.append(cArray.getClass().getComponentType().getName()).append('[').append(cArray.length).append(']');
                } else {
                    int n = 0;
                    while (n < cArray.length) {
                        stringBuffer.append(cArray[n] + "");
                        if (n != cArray.length - 1) {
                            stringBuffer.append(", ");
                        }
                        ++n;
                    }
                }
            } else if ((array$Z == null ? (array$Z = NICommand.class$("[Z")) : array$Z).isAssignableFrom(object.getClass())) {
                boolean[] blArray = (boolean[])object;
                if (blArray.length > 8) {
                    stringBuffer.append(blArray.getClass().getComponentType().getName()).append('[').append(blArray.length).append(']');
                } else {
                    int n = 0;
                    while (n < blArray.length) {
                        stringBuffer.append(blArray[n] + "");
                        if (n != blArray.length - 1) {
                            stringBuffer.append(", ");
                        }
                        ++n;
                    }
                }
            } else if ((array$S == null ? (array$S = NICommand.class$("[S")) : array$S).isAssignableFrom(object.getClass())) {
                short[] sArray = (short[])object;
                if (sArray.length > 8) {
                    stringBuffer.append(sArray.getClass().getComponentType().getName()).append('[').append(sArray.length).append(']');
                } else {
                    int n = 0;
                    while (n < sArray.length) {
                        stringBuffer.append(sArray[n] + "");
                        if (n != sArray.length - 1) {
                            stringBuffer.append(", ");
                        }
                        ++n;
                    }
                }
            } else if ((array$J == null ? (array$J = NICommand.class$("[J")) : array$J).isAssignableFrom(object.getClass())) {
                long[] lArray = (long[])object;
                if (lArray.length > 8) {
                    stringBuffer.append(lArray.getClass().getComponentType().getName()).append('[').append(lArray.length).append(']');
                } else {
                    int n = 0;
                    while (n < lArray.length) {
                        stringBuffer.append(lArray[n] + "");
                        if (n != lArray.length - 1) {
                            stringBuffer.append(", ");
                        }
                        ++n;
                    }
                }
            } else if ((array$F == null ? (array$F = NICommand.class$("[F")) : array$F).isAssignableFrom(object.getClass())) {
                float[] fArray = (float[])object;
                if (fArray.length > 8) {
                    stringBuffer.append(fArray.getClass().getComponentType().getName()).append('[').append(fArray.length).append(']');
                } else {
                    int n = 0;
                    while (n < fArray.length) {
                        stringBuffer.append(fArray[n] + "");
                        if (n != fArray.length - 1) {
                            stringBuffer.append(", ");
                        }
                        ++n;
                    }
                }
            }
            stringBuffer.append("}");
            string = stringBuffer.toString();
        } else {
            string = "" + object;
        }
        return string;
    }

    public boolean verify() {
        logger.enter("NICommand", "verify");
        boolean bl = this.reconstructParameters(false);
        NIResourceImpl nIResourceImpl = null;
        if (this.params != null) {
            int n = 0;
            while (bl && n < this.params.length) {
                if (this.params[n] instanceof NIResourceImpl) {
                    nIResourceImpl = (NIResourceImpl)this.params[n];
                    bl = nIResourceImpl.validate();
                } else if (this.params[n] != null && (array$Lcom$ibm$storage$ess$ni$application$resource$NIResource == null ? NICommand.class$("[Lcom.ibm.storage.ess.ni.application.resource.NIResource;") : array$Lcom$ibm$storage$ess$ni$application$resource$NIResource).isAssignableFrom(this.params[n].getClass())) {
                    NIResource[] nIResourceArray = (NIResource[])this.params[n];
                    int n2 = 0;
                    while (bl && n2 < nIResourceArray.length) {
                        nIResourceImpl = (NIResourceImpl)((Object)nIResourceArray[n2]);
                        bl = nIResourceImpl.validate();
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (!bl) {
            logger.debug_general("Methods not validated for " + nIResourceImpl);
            this.setException(new NIUnsupportedException("Methods not validated for " + nIResourceImpl));
        }
        logger.exit("NICommand", "verify");
        return bl;
    }

    private void reconstituteClasses() throws NIServerException, IllegalArgumentException, IOException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        this.deserializeCommandData(true);
        if (this.serviceString != null) {
            this.service = Class.forName(this.serviceString);
        }
        if (this.paramTypesStrings != null) {
            this.paramTypes = new Class[this.paramTypesStrings.length];
            int n = 0;
            while (n < this.paramTypesStrings.length) {
                if (this.paramTypeIsPrimitive[n]) {
                    this.paramTypes[n] = (Class)this.primitiveClassesTable.get(this.paramTypesStrings[n]);
                    if (this.paramTypes[n] == null) {
                        logger.error("Attempted to get class for " + this.paramTypesStrings[n] + ", but it wasn't there!");
                        throw new NIServerException(2, "Error deserializing command");
                    }
                } else {
                    this.paramTypes[n] = Class.forName(this.paramTypesStrings[n]);
                }
                ++n;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.fieldsTable.put(FIELD_ADDRESS[0], this.address);
        this.fieldsTable.put(FIELD_PARAMETERS_STRING[0], this.parametersString);
        this.fieldsTable.put(FIELD_ID[0], this.id);
        this.fieldsTable.put(FIELD_METHOD_NAME[0], this.methodName);
        this.fieldsTable.put(FIELD_SERVER_EXCEPTION[0], this.serverException);
        this.fieldsTable.put(FIELD_SERVICE_STRING[0], this.serviceString);
        this.fieldsTable.put(FIELD_IDEMPOTENT[0], new Boolean(this.idempotent));
        this.fieldsTable.put(FIELD_SERIALIZATION_VERSION[0], new Integer(this.serializationVersion));
        objectOutputStream.writeUnshared(this.fieldsTable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.fieldsTable = (HashMap)objectInputStream.readObject();
        this.address = (NICommandAddress)this.fieldsTable.remove(FIELD_ADDRESS[0]);
        this.parametersString = (String)this.fieldsTable.remove(FIELD_PARAMETERS_STRING[0]);
        this.id = (NICommandID)this.fieldsTable.remove(FIELD_ID[0]);
        this.methodName = (String)this.fieldsTable.remove(FIELD_METHOD_NAME[0]);
        this.serviceString = (String)this.fieldsTable.remove(FIELD_SERVICE_STRING[0]);
        this.serverException = (Exception)this.fieldsTable.remove(FIELD_SERVER_EXCEPTION[0]);
        this.idempotent = (Boolean)this.fieldsTable.remove(FIELD_IDEMPOTENT[0]);
        Integer n = (Integer)this.fieldsTable.remove(FIELD_SERIALIZATION_VERSION[0]);
        this.serializationVersion = n == null ? 0 : n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeCommandData() {
        this.buildParametersString();
        this.fieldsTable.put(FIELD_PARAM_TYPE_IS_PRIMITIVE[0], this.paramTypeIsPrimitive);
        this.fieldsTable.put(FIELD_PARAM_TYPES_STRINGS[0], this.paramTypesStrings);
        this.fieldsTable.put(FIELD_PRIMITIVE_CLASSES_TABLE[0], this.primitiveClassesTable);
        this.fieldsTable.put(FIELD_EXECUTED[0], new Boolean(this.executed));
        try {
            try {
                this.fieldsTable.put(FIELD_PARAMS[0], this.serialize(this.params));
            }
            catch (IOException iOException) {
                logger.error("could not serialize parameters");
                this.fieldsTable.put(FIELD_PARAMS[0], null);
                if (this.serverException == null) {
                    this.serverException = iOException;
                }
                Object var3_2 = null;
                this.params = null;
            }
            Object var3_1 = null;
            this.params = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.params = null;
            throw throwable;
        }
        try {
            block14: {
                try {
                    if (!this.executed || this.serializationVersion == 0) {
                        int n = this.findResponseSize();
                        if (n > 4096 && NIAgentProperties.getAgentType() == 4) {
                            this.serverException = new NIServerException(1, "Too many results to be processed");
                            this.fieldsTable.put(FIELD_RESPONSE[0], this.serialize(null));
                        } else {
                            this.fieldsTable.put(FIELD_RESPONSE[0], this.serialize(this.response));
                        }
                        break block14;
                    }
                    this.fieldsTable.put(FIELD_RESPONSE[0], this.response);
                }
                catch (IOException iOException) {
                    logger.error("could not serialize response");
                    this.fieldsTable.put(FIELD_RESPONSE[0], null);
                    if (this.serverException == null) {
                        this.serverException = iOException;
                    }
                    Object var5_9 = null;
                    this.response = null;
                }
            }
            Object var5_8 = null;
            this.response = null;
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.response = null;
            throw throwable;
        }
    }

    private int findResponseSize() {
        int n = 0;
        if (this.response != null) {
            if (this.response instanceof NIResultImpl) {
                n = ((NIResultImpl)this.response).getSize();
            } else if (this.response instanceof NIResultImpl[]) {
                n = ((NIResultImpl[])this.response).length;
            }
        }
        return n;
    }

    private void deserializeCommandData(boolean bl) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = bl ? MAP_METHOD_REMOVE : MAP_METHOD_GET;
        this.paramTypeIsPrimitive = (boolean[])method.invoke((Object)this.fieldsTable, FIELD_PARAM_TYPE_IS_PRIMITIVE);
        this.paramTypesStrings = (String[])method.invoke((Object)this.fieldsTable, FIELD_PARAM_TYPES_STRINGS);
        this.primitiveClassesTable = (Hashtable)method.invoke((Object)this.fieldsTable, FIELD_PRIMITIVE_CLASSES_TABLE);
        Boolean bl2 = (Boolean)method.invoke((Object)this.fieldsTable, FIELD_EXECUTED);
        this.executed = bl2 == null ? true : bl2;
        this.response = !this.executed || this.serializationVersion == 0 ? this.deserialize((byte[])method.invoke((Object)this.fieldsTable, FIELD_RESPONSE)) : method.invoke((Object)this.fieldsTable, FIELD_RESPONSE);
        this.reconstructParameters(bl);
    }

    private byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    private Object deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public void setResponseInterface(NIResponseInterface nIResponseInterface) {
        this.responseInterface = nIResponseInterface;
    }

    protected void setTimeout(long l) {
        this.timeout = l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            MAP_METHOD_REMOVE = (class$java$util$Map == null ? (class$java$util$Map = NICommand.class$("java.util.Map")) : class$java$util$Map).getDeclaredMethod("remove", class$java$lang$Object == null ? (class$java$lang$Object = NICommand.class$("java.lang.Object")) : class$java$lang$Object);
            MAP_METHOD_GET = (class$java$util$Map == null ? (class$java$util$Map = NICommand.class$("java.util.Map")) : class$java$util$Map).getDeclaredMethod(METHOD_PREFIX_GET, class$java$lang$Object == null ? (class$java$lang$Object = NICommand.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (SecurityException securityException) {
            logger.throwable((Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.throwable((Throwable)noSuchMethodException);
        }
    }
}

