/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.commandagent;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.cache.NIAgentCache;
import com.ibm.storage.ess.ni.agent.cache.NIPeerMonitor;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.command.extensions.NICommandAddress;
import com.ibm.storage.ess.ni.commandagent.NICommandAgentStartupException;
import com.ibm.storage.ess.ni.commandagent.common.NIResponseInterface;
import com.ibm.storage.ess.ni.commandagent.common.NIServicesInterface;
import com.ibm.storage.ess.ni.commandagent.infrastructure.NICommandCommunicator;
import com.ibm.storage.ess.ni.commandagent.infrastructure.NICommandProcessorMonitor;
import com.ibm.storage.ess.ni.commandagent.infrastructure.NICommandReceiver;
import com.ibm.storage.ess.ni.commandagent.infrastructure.NIMRCommandCommunicator;
import com.ibm.storage.ess.ni.commandagent.infrastructure.NIServicesContainer;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.util.NIQueue;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class NICommandAgent {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$commandagent$NICommandAgent == null ? (class$com$ibm$storage$ess$ni$commandagent$NICommandAgent = NICommandAgent.class$("com.ibm.storage.ess.ni.commandagent.NICommandAgent")) : class$com$ibm$storage$ess$ni$commandagent$NICommandAgent);
    private static final int INVALID_INT = -1;
    private static final double INVALID_DOUBLE = -1.0;
    private static final String INVALID_STRING = "invalid";
    private static final int DEFAULT_MIN_THREADS = 16;
    private static final int DEFAULT_MAX_THREADS = 256;
    private static final int DEFAULT_MAX_QUEUE_SIZE = 1024;
    private static final double DEFAULT_QUEUE_REDUCTION_PERCENT = 0.25;
    private static final String KEY_MAX_QUEUE_SIZE = "maxQueueSize";
    private static final String KEY_QUEUE_REDUCTION_PERCENT = "queueReductionPercent";
    private static final String KEY_NODE_ADDRESS = "nodeAddress";
    private static final String KEY_PROCESS_ID = "processID";
    private static final String KEY_SERVICE_CLASSES = "serviceClasses";
    private static final String KEY_MAX_THREADS = "maximumThreadPoolSize";
    private static final String KEY_MIN_THREADS = "minimumThreadPoolSize";
    private boolean running = false;
    private NICommandCommunicator communicator = null;
    private NICommandProcessorMonitor processorMonitor = null;
    private NIQueue queue = null;
    private NIServicesInterface services = null;
    private NIResponseInterface response = null;
    private NICommandReceiver receiver = null;
    private int maxQueueSize = -1;
    private double queueReductionPercent = -1.0;
    private Object[] serviceClasses = null;
    private NIMessageRouterAddress localNodeAddress = null;
    private String nodeAddress = null;
    private int processID = -1;
    private int maximumThreadPoolSize = -1;
    private int minimumThreadPoolSize = -1;
    public static final String FILE_PROPERTY = "com.ibm.storage.ess.ni.agent";
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$commandagent$NICommandAgent;

    public static Properties loadConfigurationFile() {
        Properties properties = null;
        try {
            properties = new Properties();
            properties.load(new FileInputStream(System.getProperty(FILE_PROPERTY)));
        }
        catch (Exception exception) {
            properties = null;
            logger.throwable((Throwable)exception);
        }
        return properties;
    }

    public void loadConfiguration(Properties properties) {
        logger.enter("NICommandAgent", "loadConfiguration");
        this.maxQueueSize = this.parseInt(properties.getProperty(KEY_MAX_QUEUE_SIZE));
        this.queueReductionPercent = this.parseDouble(properties.getProperty(KEY_QUEUE_REDUCTION_PERCENT));
        this.nodeAddress = properties.getProperty(KEY_NODE_ADDRESS);
        this.processID = this.parseInt(properties.getProperty(KEY_PROCESS_ID));
        if (this.nodeAddress != null && this.processID != -1) {
            this.localNodeAddress = new NIMessageRouterAddress(this.processID, this.nodeAddress);
        }
        this.serviceClasses = this.parseClasses(properties.getProperty(KEY_SERVICE_CLASSES));
        this.maximumThreadPoolSize = this.parseInt(properties.getProperty(KEY_MAX_THREADS));
        this.minimumThreadPoolSize = this.parseInt(properties.getProperty(KEY_MIN_THREADS));
        if (logger.debug_detailedLoggingEnabled()) {
            Object[] objectArray = new Object[]{new Integer(this.maxQueueSize), new Double(this.queueReductionPercent), this.localNodeAddress, new Integer(this.maximumThreadPoolSize), new Integer(this.minimumThreadPoolSize)};
            logger.debug_detailed("configuration data loaded", "NICommandAgent", "loadConfiguration", objectArray);
            logger.debug_detailed("service classes loaded", "NICommandAgent", "loadConfiguration", this.serviceClasses);
        }
        logger.exit("NICommandAgent", "loadConfiguration");
    }

    private Object[] parseClasses(String string) {
        logger.enter("NICommandAgent", "parseClasses", (Object[])new String[]{string});
        Vector vector = new Vector();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    string2 = stringTokenizer.nextToken().trim();
                    vector.add(Class.forName(string2).newInstance());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.warning("invalid class specified " + string2, "NICommandAgent", "parseClasses", null);
                    logger.throwable((Throwable)classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    logger.warning("problem loading class " + string2, "NICommandAgent", "parseClasses", null);
                    logger.throwable((Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    logger.warning("problem accessing class " + string2, "NICommandAgent", "parseClasses", null);
                    logger.throwable((Throwable)illegalAccessException);
                }
            }
        }
        logger.exit("NICommandAgent", "parseClasses");
        return vector.toArray();
    }

    private int parseInt(String string) {
        logger.enter("NICommandAgent", "parseInt");
        int n = -1;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("log here --> NICommandAgent.parseInt --> invalid int specified");
                numberFormatException.printStackTrace();
            }
        }
        logger.exit("NICommandAgent", "parseInt");
        return n;
    }

    private double parseDouble(String string) {
        logger.enter("NICommandAgent", "parseDouble");
        double d = -1.0;
        if (string != null) {
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("log here --> NICommandAgent.parseDouble --> invalid double specified");
                numberFormatException.printStackTrace();
            }
        }
        logger.exit("NICommandAgent", "parseDouble");
        return d;
    }

    public synchronized void startup() throws NICommandAgentStartupException {
        logger.enter("NICommandAgent", "startup");
        if (this.localNodeAddress == null) {
            logger.error("localNodeAddress not defined.  Command agent cannot start up", "NICommandAgent", "startup", null);
            throw new NICommandAgentStartupException(1);
        }
        if (this.maxQueueSize == -1) {
            this.maxQueueSize = 1024;
        }
        if (this.minimumThreadPoolSize == -1) {
            this.minimumThreadPoolSize = 16;
        }
        if (this.maximumThreadPoolSize == -1) {
            this.maximumThreadPoolSize = 256;
        }
        if (this.queueReductionPercent == -1.0) {
            this.queueReductionPercent = 0.25;
        }
        NIPeerMonitor nIPeerMonitor = NIPeerMonitor.PEER_MONITOR;
        NIAgentCache nIAgentCache = NIAgentCache.CACHE;
        this.services = new NIServicesContainer(this.serviceClasses);
        this.queue = new NIQueue(this.maxQueueSize, this.queueReductionPercent);
        this.response = new NIMRCommandCommunicator(this.localNodeAddress);
        this.processorMonitor = new NICommandProcessorMonitor(this.minimumThreadPoolSize, this.maximumThreadPoolSize, this.queue, this.services, this.response);
        this.communicator = (NICommandCommunicator)((Object)this.response);
        this.receiver = new NICommandReceiver(this.queue, this.communicator);
        try {
            this.communicator.connect();
        }
        catch (Exception exception) {
            logger.error("exception caught while trying to connect to MR", "NICommandAgent", "startup", null);
            logger.throwable((Throwable)exception);
            throw new NICommandAgentStartupException(2);
        }
        this.processorMonitor.startProcessors();
        this.receiver.start();
        this.running = true;
        logger.debug_general("Command Agent started", "NICommandAgent", "startup", null);
        logger.exit("NICommandAgent", "startup");
    }

    public synchronized void shutdown() {
        logger.enter("NICommandAgent", "shutdown");
        if (this.receiver != null) {
            this.receiver.shutdown();
        }
        if (this.processorMonitor != null) {
            this.processorMonitor.stopProcessors();
        }
        if (this.communicator != null) {
            try {
                this.communicator.disconnect();
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
            }
        }
        this.processorMonitor = null;
        this.services = null;
        this.queue = null;
        this.response = null;
        this.communicator = null;
        this.receiver = null;
        this.running = false;
        logger.debug_general("Command Agent shutdown", "NICommandAgent", "shutdown", null);
        logger.exit("NICommandAgent", "shutdown");
    }

    public boolean isRunning() {
        return this.running;
    }

    public NIMessageRouterAddress getLocalNodeAddress() {
        return this.localNodeAddress;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public double getQueueReductionPercent() {
        return this.queueReductionPercent;
    }

    public Object[] getServiceClasses() {
        return this.serviceClasses;
    }

    public void setLocalNodeAddress(NIMessageRouterAddress nIMessageRouterAddress) {
        if (!this.running) {
            this.localNodeAddress = nIMessageRouterAddress;
        } else {
            logger.warning("local node address NOT set because command agent running", "NICommandAgent", "setLocalNodeAddress", null);
        }
    }

    public void setMaxQueueSize(int n) {
        if (!this.running) {
            this.maxQueueSize = n;
        } else {
            logger.warning("max queue size NOT server because command agent running", "NICommandAgent", "setMaxQueueSize", null);
        }
    }

    public void setQueueReductionPercent(double d) {
        if (!this.running) {
            this.queueReductionPercent = d;
        } else {
            logger.warning("queue reduction percent NOT set because command agent running", "NICommandAgent", "setQueueReductionPercent", null);
        }
    }

    public void setServiceClasses(Object[] objectArray) {
        if (!this.running) {
            this.serviceClasses = objectArray;
        } else {
            logger.warning("service classes NOT set because command agent is running", "NICommandAgent", "setServiceClasses", null);
        }
    }

    public void setMinimumThreadPoolSize(int n) {
        if (!this.running) {
            this.minimumThreadPoolSize = n;
        } else {
            logger.warning("minimum thread pool size NOT set because command agent is running", "NICommandAgent", "setMinimumThreadPoolSize", null);
        }
    }

    public void setMaximumThreadPoolSize(int n) {
        if (!this.running) {
            this.maximumThreadPoolSize = n;
        } else {
            logger.warning("maximum thread pool size NOT set because command agent is running", "NICommandAgent", "setMaximumThreadPoolSize", null);
        }
    }

    public NIServicesInterface getServicesInterface() {
        return this.services;
    }

    public void dump() {
        if (logger != null) {
            logger.dump();
        }
    }

    public boolean sendToPeer(NICommand nICommand) {
        String string = this.getPeersName(this.localNodeAddress.getEssServerName());
        NICommandAddress nICommandAddress = new NICommandAddress();
        nICommandAddress.setDestinationAddress(new NIMessageRouterAddress(this.localNodeAddress.getProcessChannelID(), string));
        nICommand.setAddress(nICommandAddress);
        return this.response.send(nICommand);
    }

    private String getPeersName(String string) {
        char c = '1';
        if (string.startsWith("HMC")) {
            if (string.endsWith("1")) {
                c = '2';
            }
        } else if (string.endsWith("1")) {
            c = '0';
        }
        String string2 = string.substring(0, string.length() - 1) + c;
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

