/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.commandagent.infrastructure;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.commandagent.common.NIResponseInterface;
import com.ibm.storage.ess.ni.commandagent.common.NIServicesInterface;
import com.ibm.storage.ess.ni.commandagent.infrastructure.NICommandProcessor;
import com.ibm.storage.ess.ni.exception.NIUnavailableStorageServerException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.util.NIQueue;

public class NICommandProcessorMonitor {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$commandagent$infrastructure$NICommandProcessorMonitor == null ? (class$com$ibm$storage$ess$ni$commandagent$infrastructure$NICommandProcessorMonitor = NICommandProcessorMonitor.class$("com.ibm.storage.ess.ni.commandagent.infrastructure.NICommandProcessorMonitor")) : class$com$ibm$storage$ess$ni$commandagent$infrastructure$NICommandProcessorMonitor);
    private static final long UPDATE_DELAY = 2000L;
    private long lastUpdate = 0L;
    private int minProcessors;
    private int maxProcessors;
    private int lastActiveIndex;
    private int maxQueueSize;
    private NIQueue queue = null;
    private NIServicesInterface services = null;
    private NIResponseInterface response = null;
    private double[] averages = null;
    private NICommandProcessor[] processors = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$commandagent$infrastructure$NICommandProcessorMonitor;

    public NICommandProcessorMonitor(int n, int n2, NIQueue nIQueue, NIServicesInterface nIServicesInterface, NIResponseInterface nIResponseInterface) {
        logger.enter("NICommandProcesorMonitor", "<init>");
        this.minProcessors = n;
        this.maxProcessors = n2;
        this.queue = nIQueue;
        this.services = nIServicesInterface;
        this.response = nIResponseInterface;
        this.lastActiveIndex = this.minProcessors;
        this.maxQueueSize = nIQueue.getMaxSize();
        this.processors = new NICommandProcessor[this.maxProcessors];
        this.averages = new double[this.maxProcessors];
        logger.exit("NICommandProcessor", "<init>");
    }

    public void startProcessors() {
        logger.enter("NICommandProcessorMonitor", "startProcessors");
        int n = 0;
        while (n < this.minProcessors) {
            this.processors[n] = new NICommandProcessor(this.queue, this.services, this.response, this, n);
            this.processors[n].start();
            ++n;
        }
        logger.exit("NICommandProcessorMonitor", "startProcessors");
    }

    public void stopProcessors() {
        logger.enter("NICommandProcessorMonitor", "stopProcessors");
        this.cancelPendingCommands();
        int n = 0;
        while (n < this.processors.length) {
            if (this.processors[n] != null) {
                try {
                    this.processors[n].stopRunning();
                }
                catch (InterruptedException interruptedException) {
                    logger.warning("Caught InterruptedException while shutting down processors.  Ignoring", "NICommandProcessorMonitor", "stopProcessors", new Object[]{interruptedException});
                }
            }
            ++n;
        }
        logger.exit("NICommandProcessorMonitor", "stopProcessors");
    }

    void cancelPendingCommands() {
        block5: {
            if (this.queue.isEmpty()) break block5;
            NICommand nICommand = null;
            logger.debug_general("Timing out " + this.queue.getSize() + " commands on the queue.");
            try {
                int n = 0;
                while (n < this.queue.getSize()) {
                    try {
                        nICommand = (NICommand)this.queue.dequeue();
                        logger.warning("Command explicitly cancelled " + nICommand);
                        nICommand.setResponseInterface(this.response);
                        nICommand.callback(new NIUnavailableStorageServerException(6, "Command agent is shutting down. Command canceled."));
                        nICommand.clearResourceSetMethods();
                        nICommand = null;
                    }
                    catch (Exception exception) {
                        logger.throwable((Throwable)exception);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
            }
        }
    }

    void processorEnded(int n) {
        if (this.processors[n] != null) {
            this.processors[n] = null;
        }
    }

    public void updateProcessorComplete(int n) {
        if (this.processors[n] != null) {
            this.averages[n] = this.processors[n].getAverageProcessingTime();
        }
        if (System.currentTimeMillis() - this.lastUpdate > 2000L) {
            this.updateStatistics();
        }
    }

    private void updateStatistics() {
        double d = 0.0;
        int n = 0;
        while (n < this.averages.length) {
            d += this.averages[n];
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

