/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.client;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.client.services.NIEventExecutor;
import com.ibm.storage.ess.ni.command.NICommand;
import com.ibm.storage.ess.ni.command.security.NIAuthenticationCommand;
import com.ibm.storage.ess.ni.communication.NICommunicationNotSupportedException;
import com.ibm.storage.ess.ni.communication.NIHandler;
import com.ibm.storage.ess.ni.communication.NIHandlerMonitor;
import com.ibm.storage.ess.ni.communication.NIInitiator;
import com.ibm.storage.ess.ni.communication.client.NICommunicationClientExecutor;
import com.ibm.storage.ess.ni.communication.client.NIConnectionTimeoutException;
import com.ibm.storage.ess.ni.communication.client.NIHeartbeatMonitor;
import com.ibm.storage.ess.ni.communication.client.NIHeartbeatThread;
import com.ibm.storage.ess.ni.communication.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.communication.common.NICommunicationConstants;
import com.ibm.storage.ess.ni.communication.common.NIConnectionCommunication;
import com.ibm.storage.ess.ni.communication.common.NIReconnectionCommunication;
import com.ibm.storage.ess.ni.communication.connection.NIConnectionFactory;
import com.ibm.storage.ess.ni.exception.NIAuthenticationFailureException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedAccessException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.security.common.NIAuthenticationInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class NICommunicationClient
implements NIHandlerMonitor,
NICommunicationConstants,
NIHeartbeatMonitor {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$client$NICommunicationClient == null ? (class$com$ibm$storage$ess$ni$communication$client$NICommunicationClient = NICommunicationClient.class$("com.ibm.storage.ess.ni.communication.client.NICommunicationClient")) : class$com$ibm$storage$ess$ni$communication$client$NICommunicationClient);
    private NIInitiator commandInitiator;
    private NIHandler eventHandler;
    private InetAddress server;
    private NIEventExecutor eventExecutor;
    private NICommunicationClientExecutor communicationClientExecutor;
    private NIClientConnectionToken clientToken = null;
    private NIAuthenticationInfo authenticationInfo;
    private Object recoveryLock = new Object();
    private boolean connected = false;
    private boolean connecting = false;
    private NIConnectionFactory connectionFactory = null;
    private NIHeartbeatThread heartbeatThread = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$client$NICommunicationClient;

    public NICommunicationClient(InetAddress inetAddress, NIEventExecutor nIEventExecutor, NIAuthenticationInfo nIAuthenticationInfo) {
        this.server = inetAddress;
        this.eventExecutor = nIEventExecutor;
        this.authenticationInfo = nIAuthenticationInfo;
        this.commandInitiator = null;
        this.eventHandler = null;
        this.communicationClientExecutor = null;
        this.clientToken = null;
        this.connectionFactory = NIConnectionFactory.getTimedConnectionFactory();
    }

    public void connect() throws NIUnavailableServerException, NIAuthenticationFailureException {
        this.connecting = true;
        this.establishCommandConnection();
        this.communicationClientExecutor = new NICommunicationClientExecutor(this.clientToken);
        this.establishEventConnection();
        this.connected = true;
        this.connecting = false;
    }

    private void establishCommandConnection() throws NIUnavailableServerException, NIAuthenticationFailureException {
        try {
            logger.enter("NICommunicationClient", "establishCommandConnection");
            Socket socket = this.connectionFactory.createNewSocket(this.server, 1718);
            this.commandInitiator = new NIInitiator(socket);
            NIConnectionCommunication nIConnectionCommunication = null;
            nIConnectionCommunication = this.clientToken != null ? new NIReconnectionCommunication(this.clientToken) : new NIConnectionCommunication();
            nIConnectionCommunication = (NIConnectionCommunication)this.commandInitiator.send(nIConnectionCommunication);
            nIConnectionCommunication.checkException();
            this.heartbeatThread = new NIHeartbeatThread(this.commandInitiator, 60000L, this);
            this.heartbeatThread.start();
            NIAuthenticationCommand nIAuthenticationCommand = new NIAuthenticationCommand();
            nIAuthenticationCommand.setAuthenitcationInfo(this.authenticationInfo);
            nIAuthenticationCommand = (NIAuthenticationCommand)this.send(nIAuthenticationCommand);
            this.clientToken = nIAuthenticationCommand.getToken();
            logger.debug_detailed("clientToken received: " + this.clientToken, "NICommunicationClient", "establishCommandConnection", null);
        }
        catch (IOException iOException) {
            logger.warning("IOException caught.  Server unavailable", "NICommunicationClient", "establishCommandConnection", null);
            logger.throwable((Throwable)iOException);
            this.disconnect();
            throw new NIUnavailableServerException(-1);
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.disconnect();
            throw nIUnavailableServerException;
        }
        catch (NIServerException nIServerException) {
            logger.throwable((Throwable)nIServerException);
            logger.warning("Client not authenticated", "NICommunicationClient", "establishCommandConnection", null);
            this.disconnect();
            throw new NIAuthenticationFailureException(6);
        }
        catch (NIUnauthorizedAccessException nIUnauthorizedAccessException) {
            logger.error("Unauthorized access received during connection", "NICommunicationClient", "establishCommandConnection", null);
            logger.throwable((Throwable)nIUnauthorizedAccessException);
            this.disconnect();
            throw new NIAuthenticationFailureException(6);
        }
        catch (NICommunicationNotSupportedException nICommunicationNotSupportedException) {
            logger.error("Communication not supported during connection", "NICommunicationClient", "establishCommandConnection", null);
            logger.throwable((Throwable)nICommunicationNotSupportedException);
            this.disconnect();
            throw new NIAuthenticationFailureException(6);
        }
    }

    private void establishEventConnection() throws NIUnavailableServerException, NIAuthenticationFailureException {
        try {
            logger.enter("NICommunicationClient", "establishEventConnection");
            Socket socket = this.connectionFactory.createNewSocket(this.server, 1719);
            this.eventHandler = new NIHandler(socket, this.communicationClientExecutor);
            this.eventHandler.start();
            if (!this.communicationClientExecutor.isConnectionEstablished()) {
                logger.warning("Conncetion not established", "NICommunicationClient", "establishEventConnection", null);
                this.disconnect();
                throw new NIAuthenticationFailureException(6);
            }
            this.eventHandler.setExecutor(this.eventExecutor);
        }
        catch (IOException iOException) {
            logger.warning("IOException while establishing connection.  disconnecting", "NICommunicationClient", "establishEventConnection", null);
            logger.throwable((Throwable)iOException);
            this.disconnect();
            throw new NIUnavailableServerException(-1);
        }
        catch (NIConnectionTimeoutException nIConnectionTimeoutException) {
            logger.warning("connection timeout during establish", "NICommunicationClient", "establishEventConnection", null);
            this.disconnect();
            throw new NIUnavailableServerException(-1);
        }
    }

    public boolean checkConnection() {
        boolean bl = false;
        if (this.commandInitiator != null && this.commandInitiator.isConnectionAlive()) {
            this.heartbeatThread.resetTimer();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void disconnect() {
        if (this.connected || this.connecting) {
            this.connected = false;
            this.clientToken = null;
            if (this.heartbeatThread != null) {
                this.heartbeatThread.stopRunning();
                this.heartbeatThread = null;
            }
            try {
                logger.debug_detailed("Closing the eventHandler");
                if (this.eventHandler != null) {
                    this.eventHandler.close();
                }
            }
            catch (IOException iOException) {
                logger.warning("problem closing event handler.  Ignored", "NICommunicationClient", "disconnect", null);
            }
            try {
                logger.debug_detailed("Closing the commandInitiator");
                if (this.commandInitiator != null) {
                    this.commandInitiator.close();
                }
            }
            catch (IOException iOException) {
                logger.warning("problem closing command initiator.  Ignored", "NICommunicationClient", "disconnect", null);
            }
        }
        this.commandInitiator = null;
        logger.exit("NICommunicationClient", "disconnect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NICommand send(NICommand nICommand) throws NIServerException, NIUnauthorizedAccessException, NICommunicationNotSupportedException, NIUnavailableServerException {
        Object object = this.recoveryLock;
        synchronized (object) {
            if (!this.connected && !this.connecting) {
                throw new NIUnavailableServerException(3);
            }
        }
        NICommand nICommand2 = null;
        try {
            logger.debug_general("sending: " + nICommand, "NICommunicationClient", "send", null);
            nICommand2 = (NICommand)this.commandInitiator.send(nICommand);
            logger.debug_general("received:" + nICommand2, "NICommunicationClient", "send", null);
            this.heartbeatThread.resetTimer();
        }
        catch (IOException iOException) {
            this.connected = false;
            if (!this.connecting) {
                this.doCommandConnectionLostRecovery();
            }
            if (this.connected) {
                throw new NIServerException(0);
            }
            throw new NIUnavailableServerException(3);
        }
        nICommand2.checkException();
        return nICommand2;
    }

    public void setExecutor(NIEventExecutor nIEventExecutor) {
        this.eventExecutor = nIEventExecutor;
    }

    public void handleConnectionProblem(NIHandler nIHandler) {
        this.connected = false;
        this.doEventConnectionLostRecovery();
    }

    public void handleConnectionProblem(NIHeartbeatThread nIHeartbeatThread) {
        this.doCommandConnectionLostRecovery();
    }

    public void handleUnsupportedCommunication(NIHandler nIHandler) {
        logger.warning("Unsupported communication received", "NICommunicationClient", "handleUnsupportedCommunication", null);
        this.eventExecutor.eventUnknown();
    }

    private void doCommandConnectionLostRecovery() {
        try {
            this.heartbeatThread.stopRunning();
            this.establishCommandConnection();
            this.connected = true;
        }
        catch (Exception exception) {
            logger.warning("Connection cannot be reestablished.  disconnecting", "NICommunicationClient", "doCommandConnectionRecovery", null);
            logger.throwable((Throwable)exception);
            this.disconnect();
            this.eventExecutor.connectionLost();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEventConnectionLostRecovery() {
        Object object = this.recoveryLock;
        synchronized (object) {
            logger.enter("NICommunicationClient", "doEventConnectionLostRecovery");
            this.eventExecutor.eventLost();
            boolean bl = this.connected = this.commandInitiator != null && this.commandInitiator.isConnectionAlive();
            if (!this.connected) {
                this.eventExecutor.connectionLost();
                this.disconnect();
            } else {
                try {
                    this.establishEventConnection();
                    this.connected = true;
                }
                catch (Exception exception) {
                    this.eventExecutor.connectionLost();
                    this.disconnect();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

