/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.connection;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.communication.connection.NIBasicConnectionFactory;
import com.ibm.storage.ess.ni.communication.connection.NISSLConnectionFactory;
import com.ibm.storage.ess.ni.communication.connection.NITimedConnectionFactory;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class NIConnectionFactory {
    public static final String NOSSL = "NOSSL";
    public static final String PROPERTY_KEY = "com.ibm.storage.ess.ni.communication.common.ConnectionType";
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$connection$NIBasicConnectionFactory == null ? (class$com$ibm$storage$ess$ni$communication$connection$NIBasicConnectionFactory = NIConnectionFactory.class$("com.ibm.storage.ess.ni.communication.connection.NIBasicConnectionFactory")) : class$com$ibm$storage$ess$ni$communication$connection$NIBasicConnectionFactory);
    public static final int SSL = 0;
    public static final int BASIC = 1;
    private static NIConnectionFactory factory = null;
    private static NITimedConnectionFactory timedFactory = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$connection$NIBasicConnectionFactory;

    public static synchronized NIConnectionFactory getConnectionFactory() {
        if (factory == null) {
            String string = System.getProperty(PROPERTY_KEY);
            factory = NIConnectionFactory.getConnectionFactory(string);
            timedFactory = new NITimedConnectionFactory(factory);
        }
        return factory;
    }

    public static synchronized NITimedConnectionFactory getTimedConnectionFactory() {
        if (timedFactory == null) {
            String string = System.getProperty(PROPERTY_KEY);
            factory = NIConnectionFactory.getConnectionFactory(string);
            timedFactory = new NITimedConnectionFactory(factory);
        }
        return timedFactory;
    }

    private static NIConnectionFactory getConnectionFactory(String string) {
        NIConnectionFactory nIConnectionFactory = null;
        if (NOSSL.equals(string)) {
            nIConnectionFactory = NIBasicConnectionFactory.getBasicConnectionFactory();
            logger.debug_detailed("Using NIBasicConnectionFactory", "NIConnectionFactory", "getConnectionFactory", null);
        } else {
            nIConnectionFactory = NISSLConnectionFactory.getSSLConnectionFactory();
            logger.debug_detailed("Using NISSLConnectionFactory", "NIConnectionFactory", "getConnectionFactory", null);
        }
        return nIConnectionFactory;
    }

    public abstract Socket createNewSocket(InetAddress var1, int var2) throws IOException;

    public abstract Socket createNewSocket(InetAddress var1, int var2, InetAddress var3, int var4) throws IOException;

    public abstract ServerSocket createNewServerSocket(int var1) throws IOException;

    public abstract ServerSocket createNewServerSocket(int var1, InetAddress var2) throws IOException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

