/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.connection;

import com.ibm.storage.ess.ni.communication.connection.NIConnectionFactory;
import com.ibm.storage.ess.ni.communication.connection.NITimedConnectionFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class NISocketConnectionThread
implements Runnable {
    private Thread executionThread;
    private NIConnectionFactory factory;
    private NITimedConnectionFactory monitor;
    private InetAddress remoteAddress;
    private int remotePort;
    private InetAddress localAddress;
    private int localPort;
    private boolean abandoned = false;
    private int mode;
    private static final int CLIENT_NO_LOCAL_INFO_MODE = 1;
    private static final int CLIENT_LOCAL_INFO_MODE = 2;
    private static final int SERVER_PORT_ONLY_MODE = 3;
    private static final int SERVER_PORT_ADDRESS_MODE = 4;

    private NISocketConnectionThread(NIConnectionFactory nIConnectionFactory, NITimedConnectionFactory nITimedConnectionFactory) {
        this.factory = nIConnectionFactory;
        this.monitor = nITimedConnectionFactory;
    }

    public NISocketConnectionThread(NIConnectionFactory nIConnectionFactory, NITimedConnectionFactory nITimedConnectionFactory, InetAddress inetAddress, int n) {
        this(nIConnectionFactory, nITimedConnectionFactory);
        this.remoteAddress = inetAddress;
        this.remotePort = n;
        this.mode = 1;
    }

    public NISocketConnectionThread(NIConnectionFactory nIConnectionFactory, NITimedConnectionFactory nITimedConnectionFactory, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) {
        this(nIConnectionFactory, nITimedConnectionFactory);
        this.remoteAddress = inetAddress;
        this.remotePort = n;
        this.localAddress = inetAddress2;
        this.localPort = n2;
        this.mode = 2;
    }

    public NISocketConnectionThread(NIConnectionFactory nIConnectionFactory, NITimedConnectionFactory nITimedConnectionFactory, int n) {
        this(nIConnectionFactory, nITimedConnectionFactory);
        this.localPort = n;
        this.mode = 3;
    }

    public NISocketConnectionThread(NIConnectionFactory nIConnectionFactory, NITimedConnectionFactory nITimedConnectionFactory, int n, InetAddress inetAddress) {
        this(nIConnectionFactory, nITimedConnectionFactory);
        this.localPort = n;
        this.localAddress = inetAddress;
        this.mode = 4;
    }

    public void start() {
        this.executionThread = new Thread(this);
        this.executionThread.start();
    }

    public void run() {
        block8: {
            Socket socket = null;
            ServerSocket serverSocket = null;
            if (this.mode == 1 || this.mode == 2) {
                try {
                    socket = this.mode == 1 ? this.factory.createNewSocket(this.remoteAddress, this.remotePort) : this.factory.createNewSocket(this.remoteAddress, this.remotePort, this.localAddress, this.localPort);
                    if (!this.abandoned) {
                        this.monitor.process(socket, null);
                        break block8;
                    }
                    socket.close();
                    socket = null;
                }
                catch (IOException iOException) {
                    if (this.abandoned) break block8;
                    this.monitor.process((Socket)null, iOException);
                }
            } else {
                try {
                    serverSocket = this.mode == 3 ? this.factory.createNewServerSocket(this.localPort) : this.factory.createNewServerSocket(this.localPort, this.localAddress);
                    if (!this.abandoned) {
                        this.monitor.process(serverSocket, null);
                        break block8;
                    }
                    serverSocket.close();
                    serverSocket = null;
                }
                catch (IOException iOException) {
                    if (this.abandoned) break block8;
                    this.monitor.process((ServerSocket)null, iOException);
                }
            }
        }
    }

    public void abandon() {
        this.abandoned = true;
    }
}

