/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.extensions;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.communication.NICommunication;
import com.ibm.storage.ess.ni.communication.NICommunicationExecutor;
import com.ibm.storage.ess.ni.communication.extensions.NIHandlerMonitor;
import com.ibm.storage.ess.ni.communication.extensions.NILowLevelCommunication;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.communication.extensions.common.NIZippedCommunication;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;

public class NIHandler
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$extensions$NIHandler == null ? (class$com$ibm$storage$ess$ni$communication$extensions$NIHandler = NIHandler.class$("com.ibm.storage.ess.ni.communication.extensions.NIHandler")) : class$com$ibm$storage$ess$ni$communication$extensions$NIHandler);
    private static final Logger detailedLogger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$extensions$NITransmissionLogger == null ? (class$com$ibm$storage$ess$ni$communication$extensions$NITransmissionLogger = NIHandler.class$("com.ibm.storage.ess.ni.communication.extensions.NITransmissionLogger")) : class$com$ibm$storage$ess$ni$communication$extensions$NITransmissionLogger);
    private Socket initiatorConnection;
    private ObjectInputStream in;
    private NICommunicationExecutor executor;
    private NIHandlerMonitor monitor;
    private String name;
    private NIClientConnectionToken token;
    private String label;
    private boolean running = false;
    private boolean disconnecting = false;
    private boolean zipped = false;
    private static int nextInstance = 0;
    private static Object instanceLock = new Object();
    private int instanceID;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$extensions$NIHandler;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$extensions$NITransmissionLogger;

    public NIHandler(Socket socket, NICommunicationExecutor nICommunicationExecutor, String string) {
        super(string + "Thread");
        this.initiatorConnection = socket;
        this.executor = nICommunicationExecutor;
        this.name = string;
        String string2 = "?";
        this.getInstanceID();
        if (this.initiatorConnection != null) {
            string2 = this.initiatorConnection.getInetAddress().getHostAddress().toString();
        }
        this.label = "<" + string + "(#" + this.instanceID + "):client #?-->" + string2 + "> ";
        this.monitor = null;
        this.in = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getInstanceID() {
        Object object = instanceLock;
        synchronized (object) {
            this.instanceID = nextInstance++;
        }
        return this.instanceID;
    }

    public void setHandlerName(String string) {
        this.name = string;
        super.setName(string + "Thread");
        this.setToken(this.token);
    }

    public void setToken(NIClientConnectionToken nIClientConnectionToken) {
        this.token = nIClientConnectionToken;
        String string = "?";
        if (this.initiatorConnection != null) {
            string = this.initiatorConnection.getInetAddress().getHostAddress().toString();
        }
        this.label = "<" + this.name + "(#" + this.instanceID + "):client #" + (nIClientConnectionToken == null ? "?" : nIClientConnectionToken.toString()) + "-->" + string + "> ";
    }

    public void run() {
        block17: {
            try {
                if (this.initiatorConnection != null) {
                    this.in = new ObjectInputStream(this.initiatorConnection.getInputStream());
                    break block17;
                }
                if (this.monitor != null) {
                    logger.error(this.label + "initiatorConnection is null, calling handleConnectionProblem");
                    this.monitor.handleConnectionProblem(this);
                }
                return;
            }
            catch (IOException iOException) {
                if (this.monitor != null) {
                    logger.error(this.label + "caught IOException when trying to open input stream");
                    this.logThrowable(iOException);
                    this.monitor.handleConnectionProblem(this);
                }
                return;
            }
        }
        NICommunication nICommunication = null;
        NIZippedCommunication nIZippedCommunication = null;
        Object object = null;
        this.running = true;
        while (this.running) {
            try {
                nICommunication = null;
                object = this.in.readObject();
                if (object instanceof NIZippedCommunication) {
                    nIZippedCommunication = (NIZippedCommunication)object;
                    nICommunication = nIZippedCommunication.unzip();
                    nIZippedCommunication = null;
                } else {
                    nICommunication = (NICommunication)object;
                }
                object = null;
                detailedLogger.debug_general(this.label + "received: " + nICommunication);
                if (nICommunication instanceof NILowLevelCommunication) {
                    this.monitor.handleLowLevelCommunication((NILowLevelCommunication)nICommunication, this);
                    continue;
                }
                this.monitor.communicationReceived(nICommunication, this);
                this.executor.execute(nICommunication);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error(this.label + "caught ClassNotFoundException:");
                this.logThrowable(classNotFoundException);
                if (this.monitor == null) continue;
                this.monitor.handleUnsupportedCommunication(this);
            }
            catch (InvalidClassException invalidClassException) {
                logger.error(this.label + "caught InvalidClassException:");
                this.logThrowable(invalidClassException);
                if (this.monitor == null) continue;
                this.monitor.handleUnsupportedCommunication(this);
            }
            catch (OptionalDataException optionalDataException) {
                logger.error(this.label + "caught OptionalDataException:");
                this.logThrowable(optionalDataException);
                if (this.monitor == null) continue;
                this.monitor.handleUnsupportedCommunication(this);
            }
            catch (IOException iOException) {
                if (this.disconnecting || !this.running) continue;
                logger.debug_general(this.label + "Connection problem detected", "NIHandler", "run", null);
                this.logThrowable(iOException);
                if (this.monitor != null) {
                    this.monitor.handleConnectionProblem(this);
                }
                this.running = false;
            }
            catch (ClassCastException classCastException) {
                logger.error(this.label + "caught ClassCastException:");
                this.logThrowable(classCastException);
            }
            catch (Throwable throwable) {
                if (!this.running) continue;
                logger.error(this.label + "caught throwable:");
                this.logThrowable(throwable);
            }
        }
    }

    public void close() throws IOException {
        logger.debug_general(this.label + "close called");
        this.running = false;
        if (this.initiatorConnection != null) {
            this.initiatorConnection.close();
        } else {
            logger.warning(this.label + "close called when initiatorConnection is null");
        }
        this.initiatorConnection = null;
        this.monitor = null;
        this.executor = null;
    }

    public void setDisconnecting() {
        logger.debug_detailed(this.label + "setDisconnecting called");
        this.disconnecting = true;
        this.running = false;
    }

    public void setMonitor(NIHandlerMonitor nIHandlerMonitor) {
        this.monitor = nIHandlerMonitor;
    }

    public NICommunicationExecutor getExecutor() {
        return this.executor;
    }

    public synchronized void setExecutor(NICommunicationExecutor nICommunicationExecutor) {
        this.executor = nICommunicationExecutor;
    }

    public void goZipped() {
        logger.debug_general(this.label + "goZipped called... zipped is now true");
        this.zipped = true;
    }

    private void logThrowable(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        logger.error(this.label + "caught THROWABLE: \n" + stringWriter.toString());
        stringWriter = null;
        printWriter = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

