/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.extensions.client;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.client.extensions.services.event.NIEventExecutor;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.command.extensions.NICommandID;
import com.ibm.storage.ess.ni.communication.NICommunication;
import com.ibm.storage.ess.ni.communication.connection.NIConnectionFactory;
import com.ibm.storage.ess.ni.communication.extensions.NIHandler;
import com.ibm.storage.ess.ni.communication.extensions.NIHandlerMonitor;
import com.ibm.storage.ess.ni.communication.extensions.NIHeartbeatCommunication;
import com.ibm.storage.ess.ni.communication.extensions.NIInitiator;
import com.ibm.storage.ess.ni.communication.extensions.NILowLevelCommunication;
import com.ibm.storage.ess.ni.communication.extensions.client.NICommunicationClientStatusListener;
import com.ibm.storage.ess.ni.communication.extensions.client.NIHeartbeatThread;
import com.ibm.storage.ess.ni.communication.extensions.common.NIACKCommunication;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.communication.extensions.common.NICommunicationConstants;
import com.ibm.storage.ess.ni.communication.extensions.common.NIConnectionCommunication;
import com.ibm.storage.ess.ni.communication.extensions.common.NIDisconnectionCommunication;
import com.ibm.storage.ess.ni.communication.extensions.common.NIEventConnectionCommunication;
import com.ibm.storage.ess.ni.communication.extensions.common.NITokenUnavailableException;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIResponseExecutor;
import com.ibm.storage.ess.ni.exception.NIAuthenticationFailureException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.security.common.NIAuthenticationInfo;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class NICommunicationClient
implements NIHandlerMonitor,
NICommunicationConstants {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$extensions$client$NICommunicationClient == null ? (class$com$ibm$storage$ess$ni$communication$extensions$client$NICommunicationClient = NICommunicationClient.class$("com.ibm.storage.ess.ni.communication.extensions.client.NICommunicationClient")) : class$com$ibm$storage$ess$ni$communication$extensions$client$NICommunicationClient);
    private boolean connectCommandSuccess = false;
    private NIUnavailableServerException connectCommandException;
    private int authenticateCommandSuccess = 7;
    private boolean eventCommandSuccess = false;
    private boolean tokenUnavailableReceived = false;
    private NIInitiator commandInitiator;
    private NIHandler eventHandler;
    private NIHandler responseHandler;
    private InetAddress server;
    private NIEventExecutor eventExecutor;
    private NIResponseExecutor responseExecutor;
    private NIClientConnectionToken clientToken = null;
    private NIAuthenticationInfo authenticationInfo;
    private Object recoveryLock = new Object();
    private Object connectBarrier = new Object();
    private Object eventBarrier = new Object();
    private Object disconnectBarrier = new Object();
    private Object hbBarrier = new Object();
    private boolean hbACKReceived;
    private boolean connected = false;
    private boolean connecting = false;
    private NIConnectionFactory connectionFactory = null;
    private NIHeartbeatThread heartbeatThread = null;
    private long serverVersion = 0L;
    public static final int STATUS_DOWN = 0;
    public static final int STATUS_UP = 1;
    public static final int STATUS_CONNECTING = 2;
    public static final int STATUS_DEAD = 3;
    public static final int STATUS_RECONNECTING = 4;
    private int status = 0;
    private Vector statusListeners;
    private boolean zipping = false;
    private boolean hbEvents = false;
    private boolean halfDuplex = false;
    private boolean responseACKs = false;
    private NIInitiator eventInitiator = null;
    private boolean commandHBNext = true;
    private String label = "<client #?> ";
    private Object connectLock = new Object();
    private Object disconnectLock = new Object();
    private boolean expectingACKs = false;
    private Map awaitingACKTable = Collections.synchronizedMap(new TreeMap(new NIACBComparator()));
    private static final int NUM_LOW_LEVEL_RETRIES = 3;
    private static String[] statusNames = new String[]{"STATUS_DOWN", "STATUS_UP", "STATUS_CONNECTING", "STATUS_DEAD", "STATUS_RECONNECTING"};
    private Object statusChangeLock = new Object();
    private static final int DISCONNECTED_STATE = 0;
    private static final int CONNECTING_COMMANDS_STATE = 1;
    private static final int CONNECTING_EVENTS_STATE = 2;
    private static final int CONNECTED_STATE = 3;
    private static final int DEAD_STATE = 4;
    private static final int DISCONNECTING_STATE = 5;
    private static String[] stateNames = new String[]{"DISCONNECTED_STATE", "CONNECTING_COMMANDS_STATE", "CONNECTING_EVENTS_STATE", "CONNECTED_STATE", "DEAD_STATE", "DISCONNECTING_STATE"};
    private int currentState = 0;
    private Object transitionLock = new Object();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$extensions$client$NICommunicationClient;

    public NICommunicationClient(InetAddress inetAddress, NIAuthenticationInfo nIAuthenticationInfo, NIEventExecutor nIEventExecutor, NIResponseExecutor nIResponseExecutor) {
        this.server = inetAddress;
        this.eventExecutor = nIEventExecutor;
        this.responseExecutor = nIResponseExecutor;
        this.authenticationInfo = nIAuthenticationInfo;
        this.commandInitiator = null;
        this.eventHandler = null;
        this.responseHandler = null;
        this.clientToken = null;
        this.connectionFactory = NIConnectionFactory.getTimedConnectionFactory();
        this.statusListeners = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIClientConnectionToken connect(NIClientConnectionToken nIClientConnectionToken) throws NIUnavailableServerException, NIAuthenticationFailureException {
        boolean bl = false;
        Object object = this.connectLock;
        synchronized (object) {
            int n = this.transition(1);
            if (n == 1) {
                this.clientToken = nIClientConnectionToken;
                this.label = "<client #" + (nIClientConnectionToken == null ? "?" : nIClientConnectionToken.toString()) + "-->" + this.server.getHostAddress() + "> ";
                bl = this.establishCommandConnection();
                if (bl) {
                    try {
                        bl = this.establishEventConnection();
                        if (bl) {
                            if (this.heartbeatThread == null) {
                                this.heartbeatThread = this.zipping ? new NIHeartbeatThread(this, 10000L) : new NIHeartbeatThread(this, 60000L);
                                this.heartbeatThread.setToken(this.clientToken);
                                this.heartbeatThread.start();
                            }
                            this.responseHandler.setToken(this.clientToken);
                            this.eventHandler.setToken(this.clientToken);
                            this.commandInitiator.setToken(this.clientToken);
                            this.eventInitiator.setToken(this.clientToken);
                            this.connected = true;
                            this.connecting = false;
                            this.changeStatus(1);
                            return this.clientToken;
                        }
                        logger.warning(this.label + "establishEventConnection failed... disconnecting and returning null");
                        this.disconnect(false);
                        return null;
                    }
                    catch (NIUnavailableServerException nIUnavailableServerException) {
                        logger.error(this.label + "Received unavailable server exception when trying to establish event connection");
                        this.logThrowable(nIUnavailableServerException);
                        this.disconnect(false);
                        throw nIUnavailableServerException;
                    }
                    catch (NIAuthenticationFailureException nIAuthenticationFailureException) {
                        logger.error(this.label + "Received authentication failure exception when trying to establish event connection... should never happen");
                        this.logThrowable(nIAuthenticationFailureException);
                        this.disconnect(true);
                        throw nIAuthenticationFailureException;
                    }
                }
                logger.warning(this.label + "establishCommandConnection failed... disconnecting and returning null");
                this.disconnect(false);
                return null;
            }
            if (n == 3) {
                return this.clientToken;
            }
            logger.error(this.label + "connect called in " + NICommunicationClient.stateToString(n) + ".... failing and returning null");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean establishEventConnection() throws NIUnavailableServerException, NIAuthenticationFailureException {
        this.eventCommandSuccess = false;
        try {
            logger.enter("NICommunicationClient", "establishEventConnection");
            Socket socket = this.connectionFactory.createNewSocket(this.server, 1750);
            this.eventInitiator = new NIInitiator(socket, "eventInitiator");
            this.eventHandler = new NIHandler(socket, this.eventExecutor, "eventHandler");
            this.eventHandler.setToken(this.clientToken);
            this.eventHandler.setMonitor(this);
            this.eventHandler.start();
            Object object = this.transitionLock;
            synchronized (object) {
                if (this.currentState != 2) {
                    logger.warning(this.label + "state was not correct to establish event connection: " + NICommunicationClient.stateToString(this.currentState));
                    return false;
                }
                NIEventConnectionCommunication nIEventConnectionCommunication = null;
                nIEventConnectionCommunication = new NIEventConnectionCommunication(this.clientToken);
                this.eventInitiator.send(nIEventConnectionCommunication);
                this.transitionLock.wait(60000L);
            }
            if (!this.eventCommandSuccess) {
                throw new NIUnavailableServerException(-1);
            }
            if (this.zipping) {
                logger.debug_general(this.label + "event command was successful and zipping is true... setting handler and initiator to zipped");
                this.eventHandler.goZipped();
                this.eventInitiator.goZipped();
            } else {
                logger.debug_general(this.label + "event command was successful, zipping is false");
            }
        }
        catch (InterruptedException interruptedException) {
            this.disconnect(false);
            throw new NIUnavailableServerException(-1);
        }
        catch (IOException iOException) {
            logger.warning(this.label + "IOException caught.  Server unavailable", "NICommunicationClient", "establishCommandConnection", null);
            this.logThrowable(iOException);
            this.disconnect(false);
            throw new NIUnavailableServerException(-1);
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.disconnect(false);
            throw nIUnavailableServerException;
        }
        catch (NIUnsupportedException nIUnsupportedException) {
            logger.error(this.label + "Communication not supported during connection", "NICommunicationClient", "establishCommandConnection", null);
            this.logThrowable(nIUnsupportedException);
            this.disconnect(false);
            throw new NIUnavailableServerException(-1);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean establishCommandConnection() throws NIUnavailableServerException, NIAuthenticationFailureException {
        this.connectCommandSuccess = false;
        this.connectCommandException = null;
        this.tokenUnavailableReceived = false;
        try {
            logger.enter("NICommunicationClient", "establishCommandConnection");
            if (this.responseHandler != null) {
                logger.debug_general(this.label + "closing the response handler");
                this.responseHandler.close();
                this.responseHandler = null;
            }
            Socket socket = this.connectionFactory.createNewSocket(this.server, 1750);
            socket.setSoTimeout(120000);
            logger.debug_general(this.label + "established socket from " + socket.getLocalAddress() + " to " + socket.getInetAddress().getHostAddress());
            this.commandInitiator = new NIInitiator(socket, "commandInitiator");
            this.responseHandler = new NIHandler(socket, this.responseExecutor, "responseHandler");
            this.responseHandler.setToken(this.clientToken);
            this.responseHandler.setMonitor(this);
            this.responseHandler.start();
            Object object = this.transitionLock;
            synchronized (object) {
                if (this.currentState != 1) {
                    logger.warning(this.label + "state is " + NICommunicationClient.stateToString(this.currentState) + " when trying to establish command connection... abort");
                    return false;
                }
                NIConnectionCommunication nIConnectionCommunication = null;
                nIConnectionCommunication = new NIConnectionCommunication(this.clientToken, this.authenticationInfo);
                this.commandInitiator.send(nIConnectionCommunication);
                this.transitionLock.wait(60000L);
            }
            if (this.tokenUnavailableReceived) {
                this.disconnect(true);
                throw new NIUnavailableServerException("unable to acquire given token");
            }
            if (!this.connectCommandSuccess) {
                this.disconnect(false);
                if (this.connectCommandException != null) {
                    throw this.connectCommandException;
                }
                throw new NIUnavailableServerException(-1);
            }
            if (this.authenticateCommandSuccess != 7) {
                this.disconnect(true);
                logger.debug_general(this.label + "NIAuthenticationFailureException code to throw to application is " + this.authenticateCommandSuccess);
                throw new NIAuthenticationFailureException(this.authenticateCommandSuccess, "Client failed to authenticate with server");
            }
            if (this.zipping) {
                logger.debug_general(this.label + "command connect successful and zipping is true, setting the command initiator to zipped");
                this.commandInitiator.goZipped();
            } else {
                logger.debug_general(this.label + "command connect successful, zipping is false");
                if (this.heartbeatThread != null) {
                    logger.debug_general(this.label + "HBThread exists... use old HB interval");
                    this.heartbeatThread.changeInterval(60000);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.disconnect(false);
            throw new NIUnavailableServerException(-1);
        }
        catch (IOException iOException) {
            logger.warning(this.label + "IOException caught.  Server unavailable", "NICommunicationClient", "establishCommandConnection", null);
            this.logThrowable(iOException);
            this.disconnect(false);
            throw new NIUnavailableServerException(-1);
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            this.disconnect(false);
            throw nIUnavailableServerException;
        }
        catch (NIUnsupportedException nIUnsupportedException) {
            logger.error(this.label + "Communication not supported during connection", "NICommunicationClient", "establishCommandConnection", null);
            this.logThrowable(nIUnsupportedException);
            this.disconnect(false);
            throw new NIAuthenticationFailureException(0);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.connectLock;
        synchronized (object) {
            if (this.heartbeatThread == null) {
                this.heartbeatThread = this.zipping ? new NIHeartbeatThread(this, 10000L) : new NIHeartbeatThread(this, 60000L);
                this.heartbeatThread.setToken(this.clientToken);
                this.heartbeatThread.start();
            }
            this.heartbeatThread.restoreConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLowLevelCommunication(NILowLevelCommunication nILowLevelCommunication, NIHandler nIHandler) {
        if (nILowLevelCommunication instanceof NIHeartbeatCommunication) {
            NIHeartbeatCommunication nIHeartbeatCommunication = (NIHeartbeatCommunication)nILowLevelCommunication;
            if (!this.expectingACKs || nIHeartbeatCommunication.isAck()) {
                Object object = this.hbBarrier;
                synchronized (object) {
                    this.hbACKReceived = true;
                    this.hbBarrier.notify();
                }
            } else {
                nIHeartbeatCommunication.setAck();
                try {
                    this.commandInitiator.send(nILowLevelCommunication);
                }
                catch (NIUnsupportedException nIUnsupportedException) {
                    logger.error(this.label + "unsupported exception when sending BACK an HBCommunication... never!");
                    this.logThrowable(nIUnsupportedException);
                    this.handleConnectionProblem();
                }
                catch (IOException iOException) {
                    logger.error(this.label + "IOexception when sending BACK an HBCommunication... connection problem");
                    this.logThrowable(iOException);
                    this.handleConnectionProblem();
                }
                catch (NullPointerException nullPointerException) {
                    logger.error(this.label + "NullPointer when trying to send back HB.... must've disconnected");
                }
            }
        } else {
            if (nILowLevelCommunication instanceof NIDisconnectionCommunication) {
                logger.debug_general(this.label + "received disconnection communication... wake up disconnect call");
                Object object = this.disconnectBarrier;
                synchronized (object) {
                    this.disconnectBarrier.notify();
                }
            }
            if (nILowLevelCommunication instanceof NIACKCommunication) {
                NIACB nIACB = (NIACB)this.awaitingACKTable.get(((NIACKCommunication)nILowLevelCommunication).getID());
                logger.debug_general(this.label + "ACK received for " + ((NIACKCommunication)nILowLevelCommunication).getID());
                if (nIACB != null) {
                    NIACB nIACB2 = nIACB;
                    synchronized (nIACB2) {
                        nIACB.ackReceived = true;
                        nIACB.notify();
                    }
                } else {
                    logger.warning(this.label + " but it is gone... should be duplicate ACK");
                }
            } else if (nILowLevelCommunication instanceof NIEventConnectionCommunication) {
                logger.debug_general(this.label + "NIEventConnectionCommunication received... event connection complete");
                this.eventCommandSuccess = true;
                this.transition(3);
            } else if (nILowLevelCommunication instanceof NIConnectionCommunication) {
                try {
                    this.connectCommandSuccess = true;
                    this.authenticateCommandSuccess = 7;
                    ((NIConnectionCommunication)nILowLevelCommunication).checkException();
                    int n = ((NIConnectionCommunication)nILowLevelCommunication).getVersionCode();
                    logger.debug_general(this.label + "versionCode returned from server is:" + n);
                    if (n == 0) {
                        logger.debug_general(this.label + "server knows nothing!");
                    } else if (n == 6) {
                        this.expectingACKs = true;
                        logger.debug_general(this.label + "server generates ACKS only!");
                    } else if (n == 3) {
                        this.expectingACKs = true;
                        logger.debug_general(this.label + "server generates ACKS");
                        this.zipping = true;
                        logger.debug_general(this.label + "server uses Zipped communication");
                        this.responseHandler.goZipped();
                    } else if (n == 5) {
                        logger.debug_general(this.label + "server generates ACKS");
                        this.expectingACKs = true;
                        this.zipping = true;
                        logger.debug_general(this.label + "server uses Zipped communication");
                        this.responseHandler.goZipped();
                        this.hbEvents = true;
                        logger.debug_general(this.label + "server handles event heartbeats");
                    } else if (n == 7) {
                        logger.debug_general(this.label + "server generates ACKS");
                        this.expectingACKs = true;
                        this.zipping = true;
                        logger.debug_general(this.label + "server uses Zipped communication");
                        this.responseHandler.goZipped();
                        this.hbEvents = true;
                        logger.debug_general(this.label + "server handles event heartbeats");
                        this.responseACKs = true;
                        logger.debug_general(this.label + "server expects response acks");
                    } else {
                        logger.debug_general(this.label + "invalid server version... setting no flags");
                    }
                    this.clientToken = ((NIConnectionCommunication)nILowLevelCommunication).getClientConnectionToken();
                    this.label = "<client #" + (this.clientToken == null ? "?" : this.clientToken.toString()) + "-->" + this.server.getHostAddress() + "> ";
                    logger.debug_general(this.label + "NIConnectionCommunication received, command connection complete");
                }
                catch (NITokenUnavailableException nITokenUnavailableException) {
                    this.tokenUnavailableReceived = true;
                    logger.error(this.label + "NIConnectionCommunication received.... with token unavailable exception:");
                    this.logThrowable(nITokenUnavailableException);
                }
                catch (NIUnavailableServerException nIUnavailableServerException) {
                    this.connectCommandSuccess = false;
                    this.connectCommandException = nIUnavailableServerException;
                    logger.error(this.label + "NIConnectionCommunication received... with unavailable server exception:");
                    this.logThrowable(nIUnavailableServerException);
                }
                catch (NIAuthenticationFailureException nIAuthenticationFailureException) {
                    this.authenticateCommandSuccess = nIAuthenticationFailureException.getCode();
                    logger.debug_general(this.label + "NIAuthenticationFailureException code obtained from Server is " + this.authenticateCommandSuccess);
                    this.logThrowable(nIAuthenticationFailureException);
                }
                this.transition(2);
            }
        }
    }

    public void goHalfDuplex() {
        this.halfDuplex = true;
        this.changeStatus(3);
    }

    public void disconnect() {
        logger.debug_general(this.label + "disconnect called");
        this.disconnect(true);
        this.responseExecutor = null;
        this.eventExecutor = null;
        this.statusListeners = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect(boolean bl) {
        Object object = this.disconnectLock;
        synchronized (object) {
            int n = this.transition(5);
            if (n == 5) {
                if (bl) {
                    if (this.heartbeatThread != null) {
                        this.heartbeatThread.stopRunning();
                    }
                    if (this.connected) {
                        try {
                            this.responseHandler.setDisconnecting();
                            this.eventHandler.setDisconnecting();
                            Object object2 = this.disconnectBarrier;
                            synchronized (object2) {
                                this.commandInitiator.send(new NIDisconnectionCommunication());
                                this.disconnectBarrier.wait(500L);
                            }
                        }
                        catch (NIUnsupportedException nIUnsupportedException) {
                            logger.error(this.label + "UnsupportedException when sending disconnect");
                            this.logThrowable(nIUnsupportedException);
                        }
                        catch (IOException iOException) {
                            logger.warning(this.label + "IOException thrown when trying to disconnect... cut the line");
                            this.logThrowable(iOException);
                        }
                        catch (InterruptedException interruptedException) {
                            logger.error(this.label + "Interrupted while waiting for disconnect to get to server");
                            this.logThrowable(interruptedException);
                        }
                    }
                }
                this.connected = false;
                try {
                    if (this.eventHandler != null) {
                        logger.debug_general(this.label + "Closing the eventHandler");
                        this.eventHandler.close();
                    }
                }
                catch (IOException iOException) {
                    logger.warning(this.label + "problem closing event handler.  Ignored", "NICommunicationClient", "disconnect", null);
                }
                try {
                    logger.debug_general(this.label + "Closing the eventInitiator");
                    if (this.eventInitiator != null) {
                        this.eventInitiator.close();
                    }
                }
                catch (IOException iOException) {
                    logger.warning(this.label + "problem closing event initiator.  Ignored", "NICommunicationClient", "disconnect", null);
                }
                try {
                    if (this.responseHandler != null) {
                        logger.debug_general(this.label + "Closing the responseHandler");
                        this.responseHandler.close();
                    }
                }
                catch (IOException iOException) {
                    logger.warning(this.label + "problem closing response handler.  Ignored", "NICommunicationClient", "disconnect", null);
                }
                try {
                    logger.debug_general(this.label + "Closing the commandInitiator");
                    if (this.commandInitiator != null) {
                        this.commandInitiator.close();
                    }
                }
                catch (IOException iOException) {
                    logger.warning(this.label + "problem closing command initiator.  Ignored", "NICommunicationClient", "disconnect", null);
                }
                if (bl) {
                    this.changeStatus(3);
                } else {
                    this.changeStatus(0);
                }
                this.commandInitiator = null;
                this.eventInitiator = null;
                this.eventHandler = null;
                this.responseHandler = null;
                this.transition(0);
                logger.exit("NICommunicationClient", "disconnect");
            } else if (bl) {
                if (this.heartbeatThread != null) {
                    this.heartbeatThread.stopRunning();
                }
                this.changeStatus(3);
            } else {
                logger.warning(this.label + "attempting to disconnect, but state is " + NICommunicationClient.stateToString(n));
            }
        }
    }

    public void blockingSend(NICommand nICommand) throws NIUnavailableServerException, NIUnsupportedException, InterruptedException {
        logger.debug_general(this.label + "blocking send called");
        this.waitForStatusChange(1);
        this.send(nICommand);
    }

    public void send(NICommand nICommand) throws NIUnavailableServerException, NIUnsupportedException {
        boolean bl = false;
        try {
            this.setupToWaitForACK(nICommand);
            int n = 0;
            while (n < 3 && !bl) {
                if (this.commandInitiator != null) {
                    if (this.currentState != 3) {
                        this.cancelACK(nICommand);
                        throw new NIUnavailableServerException(3);
                    }
                } else {
                    this.cancelACK(nICommand);
                    logger.debug_general(this.label + "initiator is null.... unable to send (attempt " + n + "): " + nICommand, "NICommunicationClient", "send", null);
                    throw new NIUnavailableServerException("Client disconnected before sending");
                }
                logger.debug_general(this.label + "sending (attempt " + n + "): " + nICommand, "NICommunicationClient", "send", null);
                this.commandInitiator.send(nICommand);
                bl = this.waitForACK(nICommand);
                ++n;
            }
            if (!bl) {
                this.cancelACK(nICommand);
                logger.error(this.label + "No ACK received for command: " + nICommand);
                this.handleConnectionProblem();
                throw new NIUnavailableServerException("No ACK received for command: " + nICommand);
            }
        }
        catch (IOException iOException) {
            this.cancelACK(nICommand);
            logger.error(this.label + "IOException caught when trying to send");
            this.logThrowable(iOException);
            this.handleConnectionProblem();
            throw new NIUnavailableServerException(3);
        }
        catch (InterruptedException interruptedException) {
            this.cancelACK(nICommand);
            logger.error(this.label + "InteruptedException caught when waiting for ACK");
            this.logThrowable(interruptedException);
            throw new NIUnavailableServerException(3);
        }
    }

    private void setupToWaitForACK(NICommand nICommand) {
        if (this.expectingACKs && nICommand.isIdempotent()) {
            this.awaitingACKTable.put(nICommand.getID(), new NIACB());
        }
    }

    private void cancelACK(NICommand nICommand) {
        NIACB nIACB;
        if (this.expectingACKs && nICommand.isIdempotent() && (nIACB = (NIACB)this.awaitingACKTable.get(nICommand.getID())) != null) {
            this.awaitingACKTable.remove(nICommand.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForACK(NICommand nICommand) throws InterruptedException {
        boolean bl = false;
        NICommandID nICommandID = nICommand.getID();
        if (this.expectingACKs && nICommand.isIdempotent()) {
            boolean bl2 = false;
            NIACB nIACB = (NIACB)this.awaitingACKTable.get(nICommandID);
            if (nIACB != null) {
                NIACB nIACB2 = nIACB;
                synchronized (nIACB2) {
                    bl2 = nIACB.ackReceived;
                    if (!bl2) {
                        nIACB.wait(25000L);
                        bl2 = nIACB.ackReceived;
                    }
                }
                if (bl2) {
                    Map map = this.awaitingACKTable;
                    synchronized (map) {
                        this.awaitingACKTable.remove(nICommandID);
                    }
                    bl = true;
                }
            } else {
                logger.error(this.label + "acb is null for command" + nICommandID);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void setExecutor(NIEventExecutor nIEventExecutor) {
        this.eventExecutor = nIEventExecutor;
        if (this.eventHandler != null) {
            this.eventHandler.setExecutor(nIEventExecutor);
        }
    }

    public void setExecutor(NIResponseExecutor nIResponseExecutor) {
        this.responseExecutor = nIResponseExecutor;
    }

    public void handleConnectionProblem(NIHandler nIHandler) {
        if (this.heartbeatThread != null) {
            logger.debug_general(this.label + "handleConnectionProblem(NIHandler) called, calling restoreConnection");
            this.heartbeatThread.restoreConnection();
        } else {
            logger.debug_general(this.label + "no HBthread... do nothing");
        }
    }

    public void handleConnectionProblem() {
        if (this.heartbeatThread != null) {
            logger.debug_general(this.label + "handleConnectionProblem() called, calling restoreConnection");
            this.heartbeatThread.restoreConnection();
        } else {
            logger.debug_general(this.label + "no HBthread... do nothing");
        }
    }

    private static String statusToString(int n) {
        if (n >= 0 && n < stateNames.length) {
            return statusNames[n];
        }
        return "INVALID_STATUS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeStatus(int n) {
        Object object = this.statusChangeLock;
        synchronized (object) {
            if (!(this.status == n || this.halfDuplex && n != 3)) {
                if (this.status == 1 && n == 0) {
                    n = 4;
                }
                logger.debug_general(this.label + "changing status from " + NICommunicationClient.statusToString(this.status) + " to " + NICommunicationClient.statusToString(n));
                this.status = n;
                Iterator iterator = this.statusListeners.iterator();
                while (iterator.hasNext()) {
                    NICommunicationClientStatusListener nICommunicationClientStatusListener = (NICommunicationClientStatusListener)iterator.next();
                    nICommunicationClientStatusListener.commClientStatusChanged(this, this.status);
                }
                this.statusChangeLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForStatusChange(int n) throws InterruptedException {
        Object object = this.statusChangeLock;
        synchronized (object) {
            while (this.status != n) {
                this.statusChangeLock.wait();
            }
        }
    }

    protected boolean isState(int n) {
        return this.currentState == n;
    }

    private static String stateToString(int n) {
        if (n >= 0 && n < stateNames.length) {
            return stateNames[n];
        }
        return "INVALID_STATE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transition(int n) {
        Object object = this.transitionLock;
        synchronized (object) {
            logger.debug_general(this.label + "transition from " + NICommunicationClient.stateToString(this.currentState) + " to " + NICommunicationClient.stateToString(n));
            switch (n) {
                case 0: {
                    if (this.currentState != 5) break;
                    this.currentState = n;
                    this.transitionLock.notify();
                    break;
                }
                case 1: {
                    if (this.currentState != 0) break;
                    this.currentState = n;
                    break;
                }
                case 2: {
                    if (this.currentState != 1) break;
                    this.currentState = n;
                    this.transitionLock.notify();
                    break;
                }
                case 3: {
                    if (this.currentState != 2) break;
                    this.currentState = n;
                    this.transitionLock.notify();
                    break;
                }
                case 5: {
                    if (this.currentState == 4 || this.currentState == 0) break;
                    this.currentState = n;
                    this.transitionLock.notify();
                    break;
                }
                case 4: {
                    this.currentState = n;
                    this.transitionLock.notify();
                }
                default: {
                    logger.error(this.label + "illegal state given to transition: " + n);
                }
            }
            if (this.currentState != n) {
                logger.warning(this.label + "transition FAILED");
            }
            return this.currentState;
        }
    }

    public void registerListener(NICommunicationClientStatusListener nICommunicationClientStatusListener) {
        this.statusListeners.add(nICommunicationClientStatusListener);
    }

    public void deregisterListener(NICommunicationClientStatusListener nICommunicationClientStatusListener) {
        this.statusListeners.remove(nICommunicationClientStatusListener);
    }

    public boolean blockingCheckConnection(boolean bl) throws InterruptedException {
        logger.debug_general(this.label + "blocking check connection called");
        this.waitForStatusChange(1);
        return this.checkConnection(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnection(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            bl2 = this.isState(3);
            logger.debug_general(this.label + "checkConnection called, connection state = " + NICommunicationClient.stateToString(this.currentState));
        } else if (this.isState(3)) {
            int n = 0;
            while (n < 2 && !bl2) {
                Object object = this.hbBarrier;
                synchronized (object) {
                    this.hbACKReceived = false;
                    if ((!this.hbEvents || this.commandHBNext) && this.commandInitiator != null && this.commandInitiator.isConnectionAlive() || this.hbEvents && this.eventInitiator != null && this.eventInitiator.isConnectionAlive()) {
                        try {
                            if (this.zipping) {
                                this.hbBarrier.wait(10000L);
                            } else {
                                this.hbBarrier.wait(60000L);
                            }
                            if (this.hbACKReceived) {
                                bl2 = true;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            logger.error(this.label + "interrupted while waiting for an HB ACK");
                            this.logThrowable(interruptedException);
                            return false;
                        }
                    }
                }
                ++n;
            }
            boolean bl3 = this.commandHBNext = !this.commandHBNext;
            if (!bl2) {
                logger.error(this.label + "checkConnection was not successful");
                this.handleConnectionProblem();
            }
        }
        return bl2;
    }

    public void handleUnsupportedCommunication(NIHandler nIHandler) {
        logger.warning(this.label + "Unsupported communication received", "NICommunicationClient", "handleUnsupportedCommunication", null);
        if (nIHandler == this.eventHandler) {
            this.eventExecutor.eventUnknown();
        }
    }

    public void communicationReceived(NICommunication nICommunication, NIHandler nIHandler) {
        block3: {
            if (!this.responseACKs || nIHandler != this.responseHandler) break block3;
            try {
                this.commandInitiator.send(new NIACKCommunication(((NICommand)nICommunication).getID()));
            }
            catch (NIUnsupportedException nIUnsupportedException) {
                logger.error(this.label + "unsupported exception when trying to send response ACK");
                this.logThrowable(nIUnsupportedException);
            }
            catch (IOException iOException) {
                logger.error(this.label + "IOException caught when trying to send response ACK");
                this.logThrowable(iOException);
            }
        }
    }

    private void logThrowable(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        logger.error(this.label + "caught THROWABLE: \n" + stringWriter.toString());
        stringWriter = null;
        printWriter = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NIACB {
        public boolean ackReceived = false;
    }

    private class NIACBComparator
    implements Comparator {
        private NIACBComparator() {
        }

        public int compare(Object object, Object object2) {
            Integer n = new Integer(((NICommandID)object).getCommandID());
            Integer n2 = new Integer(((NICommandID)object2).getCommandID());
            return n.compareTo(n2);
        }
    }
}

