/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.extensions.client;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.communication.extensions.client.NICommunicationClient;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.exception.NIAuthenticationFailureException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;

public class NIHeartbeatThread
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$extensions$client$NIHeartbeatThread == null ? (class$com$ibm$storage$ess$ni$communication$extensions$client$NIHeartbeatThread = NIHeartbeatThread.class$("com.ibm.storage.ess.ni.communication.extensions.client.NIHeartbeatThread")) : class$com$ibm$storage$ess$ni$communication$extensions$client$NIHeartbeatThread);
    private NICommunicationClient commClient;
    private long interval = -1L;
    private boolean running = false;
    private String label = "<client #?> ";
    private NIClientConnectionToken token;
    private boolean skipIt = false;
    private boolean reconnecting = false;
    private int numTries = 0;
    private Thread executionThread;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$extensions$client$NIHeartbeatThread;

    public NIHeartbeatThread(NICommunicationClient nICommunicationClient, long l) {
        super("NIHeartbeatThread");
        this.interval = l;
        this.commClient = nICommunicationClient;
        logger.debug_general("NIHeartbeatThread created with an HB interval of " + l + " milliseconds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.enter("NIHeartbeatThread", "run");
        this.running = true;
        this.executionThread = Thread.currentThread();
        while (this.running) {
            Object object;
            if (this.reconnecting) {
                object = null;
                try {
                    try {
                        object = this.commClient.connect(this.token);
                        if (object != null) {
                            logger.debug_general(this.label + "connection reestablished");
                            this.reconnecting = false;
                        } else {
                            logger.warning(this.label + "connect returned null, continuing");
                        }
                    }
                    catch (NIUnavailableServerException nIUnavailableServerException) {
                        if (this.numTries % 100 == 0) {
                            logger.debug_general(this.label + "reconnect attempt #" + this.numTries + " got unavailable server exception, trying again");
                            logger.throwable((Throwable)nIUnavailableServerException);
                        }
                    }
                    catch (NIAuthenticationFailureException nIAuthenticationFailureException) {
                        logger.error(this.label + "received authentication exception when trying to reconnect");
                        logger.throwable((Throwable)nIAuthenticationFailureException);
                        this.commClient.disconnect(true);
                        return;
                    }
                    catch (Throwable throwable) {
                        logger.error(this.label + "caught some throwable from connect...");
                        logger.throwable(throwable);
                    }
                    if (this.reconnecting) {
                        try {
                            NIHeartbeatThread nIHeartbeatThread = this;
                            synchronized (nIHeartbeatThread) {
                                this.wait(5000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            logger.error(this.label + "interrupted while delaying before next reconnect attempt");
                        }
                    }
                    ++this.numTries;
                }
                catch (Throwable throwable) {
                    logger.error(this.label + "caught throwable");
                    logger.throwable(throwable);
                }
                continue;
            }
            try {
                object = this;
                synchronized (object) {
                    try {
                        this.skipIt = false;
                        this.wait(this.interval);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug_general(this.label + "interrupted while sleeping for interval");
                    }
                }
                if (this.skipIt) continue;
                this.executeHeartbeat();
            }
            catch (Throwable throwable) {
                logger.warning(this.label + "caught throwable in HB thread");
                logger.throwable(throwable);
            }
        }
        logger.debug_detailed(this.label + "exiting the run loop");
        logger.exit("NIHeartbeatThread", "run");
    }

    public synchronized void stopRunning() {
        logger.debug_detailed(this.label + "stopRunning called");
        this.running = false;
        this.skipIt = true;
        if (Thread.currentThread() != this.executionThread) {
            this.interrupt();
        }
    }

    private void executeHeartbeat() {
        logger.enter("NIHeartbeatThread", "executeHeartbeat");
        boolean bl = this.commClient.checkConnection(false);
        if (!bl && this.running) {
            logger.error(this.label + "unable to heartbeat the server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreConnection() {
        logger.debug_general(this.label + "restoreConnection called, reconnecting is " + this.reconnecting);
        if (!this.reconnecting) {
            this.commClient.disconnect(false);
            NIHeartbeatThread nIHeartbeatThread = this;
            synchronized (nIHeartbeatThread) {
                this.reconnecting = true;
                this.numTries = 0;
                this.skipIt = true;
                if (Thread.currentThread() != this.executionThread) {
                    this.interrupt();
                }
            }
        }
    }

    public void setToken(NIClientConnectionToken nIClientConnectionToken) {
        this.token = nIClientConnectionToken;
        this.label = "<client #" + (nIClientConnectionToken == null ? "?" : nIClientConnectionToken.toString()) + "> ";
    }

    public void changeInterval(int n) {
        logger.debug_general(this.label + "changing interval from " + this.interval + " to " + n);
        this.interval = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

