/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.extensions.reliable;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.communication.extensions.client.NICommunicationClient;
import com.ibm.storage.ess.ni.communication.extensions.client.NICommunicationClientStatusListener;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;

public class NIClientCommandRouter
implements NICommunicationClientStatusListener {
    private NICommunicationClient[] channels;
    private int numChannels;
    private int nextChannel;
    private int[] status;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$extensions$reliable$NIClientCommandRouter == null ? (class$com$ibm$storage$ess$ni$communication$extensions$reliable$NIClientCommandRouter = NIClientCommandRouter.class$("com.ibm.storage.ess.ni.communication.extensions.reliable.NIClientCommandRouter")) : class$com$ibm$storage$ess$ni$communication$extensions$reliable$NIClientCommandRouter);
    private NIClientConnectionToken token;
    private String label = "<client #?> ";
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$extensions$reliable$NIClientCommandRouter;

    public NIClientCommandRouter(NICommunicationClient[] nICommunicationClientArray, int n, NIClientConnectionToken nIClientConnectionToken) {
        this.channels = new NICommunicationClient[nICommunicationClientArray.length];
        this.numChannels = n;
        this.nextChannel = 0;
        this.token = nIClientConnectionToken;
        this.label = "<client #" + (nIClientConnectionToken == null ? "?" : nIClientConnectionToken.toString()) + "> ";
        this.status = new int[this.numChannels];
        int n2 = 0;
        while (n2 < this.numChannels) {
            this.status[n2] = 1;
            this.channels[n2] = nICommunicationClientArray[n2];
            this.channels[n2].registerListener(this);
            ++n2;
        }
    }

    public void commClientStatusChanged(NICommunicationClient nICommunicationClient, int n) {
        int n2 = 0;
        while (n2 < this.numChannels) {
            if (this.channels[n2] == nICommunicationClient) {
                this.status[n2] = n;
            }
            ++n2;
        }
    }

    public void blockingRoute(NICommand nICommand) throws NIUnavailableServerException, NIUnsupportedException, InterruptedException {
        logger.debug_general("blockingRoute called");
        int n = 0;
        while (n < this.numChannels) {
            if (this.status[n] == 1) {
                this.channels[n].blockingSend(nICommand);
                return;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.numChannels) {
            if (this.status[n2] == 1 || this.status[n2] == 4) {
                this.channels[n2].blockingSend(nICommand);
                return;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.numChannels) {
            if (this.status[n3] == 1 || this.status[n3] == 4 || this.status[n3] == 0) {
                this.channels[n3].blockingSend(nICommand);
                return;
            }
            ++n3;
        }
        logger.error(this.label + "throwing all connections disconnected exception");
        throw new NIUnavailableServerException(3, "All connections disconnected");
    }

    public void route(NICommand nICommand) throws NIUnavailableServerException, NIUnsupportedException {
        int n = this.nextChannel;
        boolean bl = false;
        int n2 = 0;
        while (!bl) {
            if (this.status[this.nextChannel] == 1) {
                try {
                    logger.debug_detailed(this.label + "routing down channel " + this.nextChannel + "[" + Integer.toHexString(nICommand.getID().getCommandID()) + "]....");
                    this.channels[this.nextChannel].send(nICommand);
                    bl = true;
                }
                catch (NIUnavailableServerException nIUnavailableServerException) {
                    logger.debug_detailed(this.label + "channel send failed, trying another");
                }
            }
            ++this.nextChannel;
            if (this.nextChannel == this.numChannels) {
                this.nextChannel = 0;
            }
            if (!bl && this.nextChannel == n && n2 < 4) {
                ++n2;
                continue;
            }
            if (bl || this.nextChannel != n) continue;
            logger.error(this.label + "throwing all connections disconnected exception");
            throw new NIUnavailableServerException(3, "All connections disconnected");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

