/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.eventManager.agent;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.event.NIEventImpl;
import com.ibm.storage.ess.ni.eventManager.common.NIEventQueue;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterOutputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.common.NIESSNIConstants;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.util.NICircularBufferOverflowException;
import java.io.IOException;

public class NIEventAgentProcessThread
extends Thread
implements NIESSNIConstants {
    NIEventQueue eventQueue;
    NIEventImpl eventToSend;
    private NIMessageRouterChannel mrChannel;
    private NIMessageRouterOutputStream mrOutputStream;
    private NIMessageRouterAddress[] mrAddress;
    private static final int CHANNEL_ID = 1711;
    private static final int DEST_CHANNEL_ID = 1710;
    private static final int NUMBER_OF_SERVERS = 2;
    private static final String ESS_SERVER = "HMC1";
    private static final String ALT_ESS = "HMC2";
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$eventManager$agent$NIEventAgentProcessThread == null ? (class$com$ibm$storage$ess$ni$eventManager$agent$NIEventAgentProcessThread = NIEventAgentProcessThread.class$("com.ibm.storage.ess.ni.eventManager.agent.NIEventAgentProcessThread")) : class$com$ibm$storage$ess$ni$eventManager$agent$NIEventAgentProcessThread);
    boolean bShutdown;
    NIMessageRouter messageRouterInterface;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$eventManager$agent$NIEventAgentProcessThread;

    public NIEventAgentProcessThread(NIEventQueue nIEventQueue) {
        super("NIEventAgentProcessThread");
        this.eventQueue = nIEventQueue;
        this.messageRouterInterface = NIMessageRouterFactory.getInstanceOf();
        try {
            this.mrChannel = this.messageRouterInterface.createNIMessageRouterChannel(1711);
        }
        catch (NIMessageRouterException nIMessageRouterException) {
            logger.debug_general("EventAgentProcessThread: Exception thrown when creating a message router channel");
            logger.throwable((Throwable)nIMessageRouterException);
        }
        this.mrOutputStream = this.mrChannel.getNIMessageRouterOutputStream();
        this.mrAddress = new NIMessageRouterAddress[2];
        this.mrAddress[0] = new NIMessageRouterAddress(1710, ESS_SERVER);
        this.mrAddress[1] = new NIMessageRouterAddress(1710, ALT_ESS);
        this.bShutdown = false;
    }

    public void run() {
        int n = 0;
        while (!this.bShutdown) {
            try {
                this.eventToSend = this.eventQueue.dequeueEvent();
                logger.trace("NIEventAgentProcessThread: Dequeued Event: " + this.eventToSend);
                this.sendEvent(this.eventToSend, n);
            }
            catch (InterruptedException interruptedException) {
                logger.throwable((Throwable)interruptedException);
                this.bShutdown = true;
            }
        }
        logger.debug_general("NIEventAgentProcessThread: Thread shutdown");
    }

    private void sendEvent(NIEventImpl nIEventImpl, int n) {
        block4: {
            NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
            try {
                logger.debug_detailed("Writing event to the OutputStream ");
                nIMessageRouterReturnStatus = this.mrOutputStream.send(this.mrAddress[n], nIEventImpl);
                if (nIMessageRouterReturnStatus.getStatus() == 9) {
                    logger.debug_detailed(" Event: " + nIEventImpl + "Sent to EventManager on " + this.mrAddress[n].getEssServerName());
                    break block4;
                }
                logger.debug_general(" send failed for: " + nIEventImpl + " MessageRouterReturnStatus; " + nIMessageRouterReturnStatus.getStatus());
            }
            catch (NICircularBufferOverflowException nICircularBufferOverflowException) {
                logger.throwable((Throwable)nICircularBufferOverflowException);
            }
            catch (IOException iOException) {
                logger.throwable((Throwable)iOException);
            }
        }
    }

    public void shutDown() {
        this.bShutdown = true;
        this.interrupt();
        if (this.mrChannel != null && this.messageRouterInterface != null) {
            this.messageRouterInterface.destroyNIMessageRouterChannel(this.mrChannel);
        }
        logger.debug_general("NIEventAgentProcessThread: shutting down");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

