/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.eventManager.server;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.event.NIEvent;
import com.ibm.storage.ess.ni.event.NIEventImpl;
import com.ibm.storage.ess.ni.event.NIEventLostEventImpl;
import com.ibm.storage.ess.ni.eventManager.common.NIEventQueue;
import com.ibm.storage.ess.ni.eventManager.server.NIEventForwarder;
import com.ibm.storage.ess.ni.eventManager.server.NIEventRegistrationTable;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterInputStream;
import com.ibm.storage.ess.ni.messageRouter.common.NIESSNIConstants;
import com.ibm.storage.ess.ni.util.NIQueueFullException;
import java.util.Vector;

public class NIEventListenerThread
extends Thread
implements NIESSNIConstants,
NIEventForwarder {
    private NIEventQueue eventQueue;
    private NIEventRegistrationTable eventTable;
    private NIMessageRouterChannel mrChannel;
    private NIMessageRouterInputStream mrInputStream;
    private boolean shutdown;
    private static final int CHANNEL_ID = 1710;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$eventManager$server$NIEventListenerThread == null ? (class$com$ibm$storage$ess$ni$eventManager$server$NIEventListenerThread = NIEventListenerThread.class$("com.ibm.storage.ess.ni.eventManager.server.NIEventListenerThread")) : class$com$ibm$storage$ess$ni$eventManager$server$NIEventListenerThread);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$eventManager$server$NIEventListenerThread;

    public NIEventListenerThread(NIEventQueue nIEventQueue, NIEventRegistrationTable nIEventRegistrationTable) {
        this.eventQueue = nIEventQueue;
        this.eventTable = nIEventRegistrationTable;
        NIMessageRouter nIMessageRouter = NIMessageRouterFactory.getInstanceOf();
        try {
            this.mrChannel = nIMessageRouter.createNIMessageRouterChannel(1710);
        }
        catch (NIMessageRouterException nIMessageRouterException) {
            logger.throwable((Throwable)nIMessageRouterException);
        }
        this.mrInputStream = this.mrChannel.getNIMessageRouterInputStream();
        this.shutdown = false;
    }

    public void run() {
        NIEventImpl nIEventImpl = null;
        this.mrInputStream.acceptMessage();
        while (!this.shutdown) {
            try {
                nIEventImpl = (NIEventImpl)this.mrInputStream.readObject();
            }
            catch (InterruptedException interruptedException) {
                logger.throwable((Throwable)interruptedException);
            }
            catch (NIMessageRouterException nIMessageRouterException) {
                logger.throwable((Throwable)nIMessageRouterException);
            }
            this.forwardEvent(nIEventImpl);
        }
    }

    public void forwardEvent(NIEvent nIEvent) {
        block6: {
            NIEventImpl nIEventImpl = (NIEventImpl)nIEvent;
            if (nIEventImpl == null) break block6;
            int n = 0;
            Vector vector = nIEventImpl.getSnmpTraps();
            if (vector != null) {
                n = vector.size();
            }
            if (this.eventTable.hasEvent(nIEventImpl.getClass()) || n > 0) {
                try {
                    logger.trace("NIEventListener: Writing event to the queue");
                    this.eventQueue.enqueueEvent(nIEventImpl);
                }
                catch (NIQueueFullException nIQueueFullException) {
                    logger.debug_general("       EventQueue Full, dropped event: " + nIEventImpl);
                    logger.throwable((Throwable)nIQueueFullException);
                    this.eventQueue.clearEvents();
                    try {
                        this.eventQueue.enqueueEvent(new NIEventLostEventImpl());
                    }
                    catch (NIQueueFullException nIQueueFullException2) {}
                }
            }
        }
    }

    public void shutDown() {
        this.shutdown = true;
        this.interrupt();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

