/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.eventManager.server;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.application.event.NIEvent;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.event.NIEventImpl;
import com.ibm.storage.ess.ni.eventManager.agent.NIEventAgent;
import com.ibm.storage.ess.ni.eventManager.client.NIEventServer;
import com.ibm.storage.ess.ni.eventManager.common.NIEventQueue;
import com.ibm.storage.ess.ni.eventManager.server.NIDistributer;
import com.ibm.storage.ess.ni.eventManager.server.NIEventForwarder;
import com.ibm.storage.ess.ni.eventManager.server.NIEventListenerThread;
import com.ibm.storage.ess.ni.eventManager.server.NIEventManagerProcessThread;
import com.ibm.storage.ess.ni.eventManager.server.NIEventRegistrationTable;
import com.ibm.storage.ess.ni.eventManager.server.NIEventSender;
import com.ibm.storage.ess.ni.eventManager.server.NIMegaMouthEventSenderImpl;
import com.ibm.storage.ess.ni.eventManager.server.NIReefEventSenderImpl;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.services.NIDomainService;
import java.util.Vector;

public class NIEventServerImpl
extends Thread
implements NIEventServer {
    private Vector registeredClients;
    private NIEventRegistrationTable eventRegistrationTable;
    private NIEventQueue eventQueue;
    private NIEventManagerProcessThread processThread;
    private NIEventListenerThread eventListener;
    private NIMegaMouthEventSenderImpl mmEventSender = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$eventManager$server$NIEventServerImpl == null ? (class$com$ibm$storage$ess$ni$eventManager$server$NIEventServerImpl = NIEventServerImpl.class$("com.ibm.storage.ess.ni.eventManager.server.NIEventServerImpl")) : class$com$ibm$storage$ess$ni$eventManager$server$NIEventServerImpl);
    private static NIEventForwarder forwarder = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$eventManager$server$NIEventServerImpl;

    public static NIEventForwarder getForwarder() {
        if (forwarder == null) {
            logger.debug_general("getForwarder called before the event server is started... returning dummy");
            forwarder = new NIEventForwarder(){

                public void forwardEvent(NIEvent nIEvent) {
                    logger.debug_general("dummy NIEventForwarder dropping event on the floor: " + nIEvent);
                }
            };
        }
        return forwarder;
    }

    public NIEventServerImpl(NIDistributer nIDistributer) {
        NIEventSender nIEventSender = null;
        int n = NIAgentProperties.getAgentType();
        if (n == 4 || n == 1) {
            nIEventSender = new NIReefEventSenderImpl(nIDistributer);
        } else {
            this.mmEventSender = new NIMegaMouthEventSenderImpl(nIDistributer);
            nIEventSender = this.mmEventSender;
        }
        this.eventRegistrationTable = new NIEventRegistrationTable();
        this.eventQueue = new NIEventQueue();
        this.registeredClients = new Vector();
        this.eventListener = new NIEventListenerThread(this.eventQueue, this.eventRegistrationTable);
        this.eventListener.start();
        forwarder = this.eventListener;
        this.processThread = new NIEventManagerProcessThread(this.eventRegistrationTable, this.eventQueue, nIEventSender);
        this.processThread.start();
        if (n != 1) {
            NIEventAgent nIEventAgent = NIEventAgent.getEventAgent(true);
        }
    }

    public synchronized boolean setSubscriber(NIClientConnectionToken nIClientConnectionToken, NIEventImpl[] nIEventImplArray) {
        boolean bl = false;
        if (nIEventImplArray == null) {
            logger.trace("NIEventServerImpl:   De registering client: " + nIClientConnectionToken.toString());
            bl = this.unregisterSubscriber(nIClientConnectionToken);
            logger.debug_general("NIEventServerImpl:   After the unregisterSubscriber method w/ RC=" + bl);
        } else if (this.registeredClients.contains(nIClientConnectionToken)) {
            logger.trace("NIEventServerImpl:   Client: " + nIClientConnectionToken.toString() + " to update!");
            this.eventRegistrationTable.unregister(nIClientConnectionToken);
            if (this.eventRegistrationTable.update(nIClientConnectionToken, nIEventImplArray)) {
                logger.trace("NIEventServerImpl: Updated event registration for ClientID: " + nIClientConnectionToken.toString());
                bl = true;
            }
        } else {
            logger.trace("NIEventServerImpl:   Beginning creating the subscriber:");
            if (this.registeredClients.add(nIClientConnectionToken) && this.eventRegistrationTable.update(nIClientConnectionToken, nIEventImplArray)) {
                logger.trace("NIEventServerImpl:   Client: " + nIClientConnectionToken.toString() + " was successfuly registered for events" + " The number of registered clients is now: " + this.registeredClients.size());
                bl = true;
            }
        }
        return bl;
    }

    private boolean unregisterSubscriber(NIClientConnectionToken nIClientConnectionToken) {
        boolean bl = false;
        logger.trace("   Begin the unregister process of the Subscriber");
        if (this.registeredClients.contains(nIClientConnectionToken)) {
            this.eventRegistrationTable.unregister(nIClientConnectionToken);
            if (this.registeredClients.remove(nIClientConnectionToken)) {
                bl = true;
                logger.debug_general("    Subscriber " + nIClientConnectionToken.toString() + " has been unregistered");
                logger.debug_general("    The total number of registered clients is now: " + this.registeredClients.size());
            }
        } else {
            logger.trace("   Subscriber: " + nIClientConnectionToken.toString() + " can not be found in the list!");
            logger.trace("   No unregister actions have been performed");
        }
        logger.debug_general("   End of the unregister process of the Subscriber");
        return bl;
    }

    public void setDomainService(NIDomainService nIDomainService) {
        if (this.mmEventSender != null) {
            this.mmEventSender.updateSNMPManager(nIDomainService);
        }
    }

    public synchronized void shutdown() {
        logger.debug_detailed("   Client list size before shutdown: " + this.registeredClients.size());
        this.registeredClients.clear();
        this.eventListener.shutDown();
        this.processThread.shutDown();
        this.eventRegistrationTable.clear();
        logger.debug_general("   Exiting shutdown() in Event Server");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

