/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.identifiers;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;

public class NISessionID
extends NIResourceID {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$identifiers$NISessionID == null ? (class$com$ibm$storage$ess$ni$identifiers$NISessionID = NISessionID.class$("com.ibm.storage.ess.ni.identifiers.NISessionID")) : class$com$ibm$storage$ess$ni$identifiers$NISessionID);
    private static final long serialVersionUID = 1L;
    private static final int MIN_SESSION_NUM = 1;
    private static final int MAX_SESSION_NUM = 255;
    public static final int XDC_SESSION = 64;
    public static final int XRC_SESSION = 16;
    public static final int PPRC_SESSION = 32;
    public static final int FLC_SESSION = 48;
    private int sessionType;
    private int sessionNum;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$identifiers$NISessionID;

    public NISessionID(int n, int n2) throws NIParameterInvalidServerException {
        if (!this.isValid(n)) {
            throw new NIParameterInvalidServerException(2, new Integer(n));
        }
        this.sessionType = n;
        this.sessionNum = n2;
    }

    private boolean isValid(int n) {
        boolean bl = false;
        if (n == 64) {
            return true;
        }
        return bl;
    }

    public int getSessionType() {
        return this.sessionType;
    }

    public int getSessionNumber() {
        return this.sessionNum;
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object == null || this.getClass() != object.getClass()) {
            return n;
        }
        NISessionID nISessionID = (NISessionID)object;
        n = this.sessionNum - nISessionID.sessionNum;
        if (n == 0) {
            n = this.sessionType - nISessionID.sessionType;
        }
        return n;
    }

    public int hashCode() {
        return this.sessionNum + this.sessionType + this.getClass().hashCode();
    }

    public static int getESSSessionID(int n, int n2) {
        return n << 8 | n2;
    }

    public static boolean validate(int n) {
        return n >= 1 && n <= 255;
    }

    public NIESSID getESS() {
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NISessionID [");
        stringBuffer.append("type = " + Integer.toHexString(this.sessionType) + ", ");
        stringBuffer.append("number = " + Integer.toHexString(this.sessionNum) + "]");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

