/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.logging;

import com.ibm.storage.ess.logging.FormattedLogEntry;
import com.ibm.storage.ess.logging.Formatter;
import com.ibm.storage.ess.logging.LogEntry;
import com.ibm.storage.ess.logging.ThrowableLogEntry;
import com.ibm.storage.ess.ni.logging.NIStringFormattedLogEntry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class NIFormatter
implements Formatter {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:S");

    public FormattedLogEntry format(LogEntry logEntry) {
        if (logEntry instanceof ThrowableLogEntry) {
            return this.format((ThrowableLogEntry)logEntry);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("[").append(logEntry.getLevel()).append("]");
        while (stringBuffer.length() <= 20) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(" ").append(logEntry.getClassName()).append(".");
        stringBuffer.append(logEntry.getMethodName()).append("()");
        stringBuffer.append("\n");
        stringBuffer2.append(" [").append(sdf.format(new Date(logEntry.getTimeStamp()))).append("] ");
        stringBuffer2.append("\"").append(logEntry.getMessage()).append("\"");
        Object[] objectArray = logEntry.getData();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                stringBuffer2.append(" ").append(objectArray[n].getClass().getName()).append(": ");
                stringBuffer2.append(objectArray[n]);
            }
            ++n;
        }
        while (stringBuffer2.length() > 1023) {
            stringBuffer.append(stringBuffer2.substring(0, 1023)).append("\n");
            stringBuffer2.delete(0, 1023);
        }
        stringBuffer.append(stringBuffer2.toString());
        return new NIStringFormattedLogEntry(stringBuffer.toString(), stringBuffer.length());
    }

    private FormattedLogEntry format(ThrowableLogEntry throwableLogEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(throwableLogEntry.getLevel()).append("]");
        while (stringBuffer.length() <= 20) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(" [").append(sdf.format(new Date(throwableLogEntry.getTimeStamp())));
        stringBuffer.append("]\n");
        stringBuffer.append(this.getStackTrace(throwableLogEntry.getThrowable()));
        return new NIStringFormattedLogEntry(stringBuffer.toString(), stringBuffer.length());
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

