/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.logging;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.logging.NIFileHandler;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TimerTask;

class NIRemoveHeapdumpsTask
extends TimerTask {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$logging$NIFileMaintenanceThread == null ? (class$com$ibm$storage$ess$ni$logging$NIFileMaintenanceThread = NIRemoveHeapdumpsTask.class$("com.ibm.storage.ess.ni.logging.NIFileMaintenanceThread")) : class$com$ibm$storage$ess$ni$logging$NIFileMaintenanceThread);
    protected static final long WAIT_TIME = 300000L;
    private static final int NUM_ALLOWED_HEAPDUMPS = 2;
    private String logDirectory;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$logging$NIFileMaintenanceThread;

    NIRemoveHeapdumpsTask() {
        logger.debug_general("Created");
    }

    public void run() {
        this.logDirectory = this.getLoggingDir();
        logger.debug_detailed("Clearing heapdumps from directory: " + this.logDirectory);
        String[] stringArray = new File(this.logDirectory).list();
        if (stringArray == null) {
            logger.error("Invalid Logging Directory \"" + this.logDirectory + "\" found in System property \"com.ibm.storage.ess.ni.logging.LogDir\"");
        } else {
            ArrayList<File> arrayList = new ArrayList<File>();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("heapdump")) {
                    arrayList.add(new File(this.logDirectory + "/" + stringArray[n]));
                }
                ++n;
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    File file = (File)object;
                    File file2 = (File)object2;
                    return (int)(file2.lastModified() - file.lastModified());
                }
            });
            while (arrayList.size() > 2) {
                File file = (File)arrayList.get(0);
                file.delete();
                arrayList.remove(file);
            }
        }
    }

    private String getLoggingDir() {
        if (NIAgentProperties.is1750() && NIAgentProperties.isMC()) {
            return ".";
        }
        NIFileHandler nIFileHandler = (NIFileHandler)((Object)NIFileHandler.getHandlers().get(0));
        String string = nIFileHandler.getFilename();
        return string.substring(0, string.lastIndexOf("/"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

