/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NILocalPort;
import com.ibm.storage.ess.ni.messageRouter.common.NIESSNIConstants;

public class NILocalPortManager
implements NIESSNIConstants {
    private static final int MAX_PORTS = 35;
    private static final int BASE_PORT_VALUE = 1760;
    private static NILocalPortManager portManager = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableEntry == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableEntry = NILocalPortManager.class$("com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry")) : class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableEntry);
    private NILocalPort[] ports = new NILocalPort[35];
    private static int basePortValue = 0;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableEntry;

    private NILocalPortManager() {
        NILocalPortManager.initializeBasePortValue();
        int n = 0;
        while (n < 35) {
            this.ports[n] = new NILocalPort(NILocalPortManager.getBasePortValue() + n);
            ++n;
        }
    }

    protected static synchronized NILocalPortManager getPortManager() {
        if (portManager == null) {
            portManager = new NILocalPortManager();
        }
        return portManager;
    }

    protected synchronized int getLocalPort() {
        int n = this.findLocalPort();
        if (n == 0) {
            logger.warning("Freeing Local Ports");
            this.freeAllPorts();
            n = this.findLocalPort();
        }
        if (n == 0) {
            logger.error("No Available Ports: " + NILocalPortManager.getPortManager().toString());
        }
        return n;
    }

    protected synchronized void freeLocalPort(int n) {
        int n2 = 0;
        while (n2 < 35) {
            if (this.ports[n2].getPortNumber() == n) {
                this.ports[n2].setAvailable();
                return;
            }
            ++n2;
        }
    }

    protected synchronized void discardLocalPort(int n) {
        int n2 = 0;
        while (n2 < 35) {
            if (this.ports[n2].getPortNumber() == n) {
                this.ports[n2].setUnavailable();
                return;
            }
            ++n2;
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 35) {
            stringBuffer.append(this.ports[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static synchronized void setBasePortValue(int n) {
        basePortValue = n;
    }

    protected static synchronized int getBasePortValue() {
        NILocalPortManager.initializeBasePortValue();
        return basePortValue;
    }

    private void checkPortStates() {
        int n = 0;
        while (n < 35) {
            if (this.ports[n].isUnknownWait()) {
                this.ports[n].setUnknown();
            }
            ++n;
        }
    }

    private void freeAllPorts() {
        int n = 0;
        while (n < 35) {
            this.ports[n].setAvailable();
            ++n;
        }
    }

    private int findLocalPort() {
        int n = 0;
        int n2 = 0;
        while (n2 < 35 && n == 0) {
            if (this.ports[n2].isAvailable()) {
                this.ports[n2].setUnavailable();
                n = this.ports[n2].getPortNumber();
            }
            ++n2;
        }
        return n;
    }

    private static void initializeBasePortValue() {
        if (basePortValue == 0) {
            NILocalPortManager.setBasePortValue(1760);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

