/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIInternalMessageHandler;
import com.ibm.storage.ess.ni.messageRouter.NIMessage;
import com.ibm.storage.ess.ni.messageRouter.NIMessageHeader;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEstablishConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterInputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.NIProcessChannelTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.util.NICircularBufferOverflowException;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.net.SocketException;

public class NIMessageHandlerThread
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIMessageHandlerThread == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIMessageHandlerThread = NIMessageHandlerThread.class$("com.ibm.storage.ess.ni.messageRouter.NIMessageHandlerThread")) : class$com$ibm$storage$ess$ni$messageRouter$NIMessageHandlerThread);
    private Socket clientSocket;
    private ObjectInputStream ois = null;
    private static ThreadGroup MR_HANDLERS = new ThreadGroup("Message Router Handlers");
    private static NIMessageRouterChannel channel = null;
    private String clientSocketStr = "";
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIMessageHandlerThread;

    public NIMessageHandlerThread(Socket socket) {
        super(MR_HANDLERS, "NIMessageHandlerThread " + socket.toString());
        try {
            this.clientSocket = socket;
            this.clientSocketStr = socket.toString();
            this.ois = new ObjectInputStream(this.clientSocket.getInputStream());
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
    }

    private NIMessageRouterReturnStatus sendBacktoHMC(NIMessage nIMessage) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        String string = nIMessage.getMessageHeader().getDestinationAddress().getEssServerName();
        NIRoutingTableEntry nIRoutingTableEntry = NIRoutingTable.getRoutingTable().get(string);
        if (nIRoutingTableEntry == null) {
            logger.error(" Can not find the Entry of " + string + " in the Routingtable, Local node does not know " + string);
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-3);
            return nIMessageRouterReturnStatus;
        }
        nIMessageRouterReturnStatus = NIMessageRouterConnectionMonitor.getConnectionMonitor().writeMessage(nIRoutingTableEntry, nIMessage);
        return nIMessageRouterReturnStatus;
    }

    private NIMessageRouterReturnStatus sendBacktoAlternateHMC(String string, NIMessage nIMessage) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        NIRoutingTableEntry nIRoutingTableEntry = NIRoutingTable.getRoutingTable().get(string);
        if (nIRoutingTableEntry == null) {
            logger.error(" Can not find the Entry of " + string + " in the Routingtable, Local node does not know " + string);
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-3);
            return nIMessageRouterReturnStatus;
        }
        nIMessageRouterReturnStatus = NIMessageRouterConnectionMonitor.getConnectionMonitor().writeMessage(nIRoutingTableEntry, nIMessage);
        return nIMessageRouterReturnStatus;
    }

    private void loopBackCommandToHMC(NIMessage nIMessage) {
        Object object;
        NIMessageRouterAddress nIMessageRouterAddress;
        NIMessageHeader nIMessageHeader = null;
        nIMessageHeader = nIMessage.getMessageHeader();
        NIMessageRouterAddress nIMessageRouterAddress2 = nIMessageHeader.getDestinationAddress();
        NIMessageHeader nIMessageHeader2 = new NIMessageHeader(nIMessageRouterAddress2, nIMessageRouterAddress = nIMessageHeader.getSourceAddress());
        NIMessage nIMessage2 = new NIMessage(nIMessageHeader2, object = nIMessage.getMessage());
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = this.sendBacktoHMC(nIMessage2);
        if (nIMessageRouterReturnStatus.getStatus() != 9) {
            logger.error(NIMessageRouterMetaData.getEssServerName() + " failed to loopback message from " + nIMessageRouterAddress2.getEssServerName() + " to " + nIMessageRouterAddress.getEssServerName() + "error code is " + nIMessageRouterReturnStatus.getStatus());
            String string = nIMessageRouterAddress.getEssServerName();
            String string2 = string.endsWith("0") ? string.substring(0, string.length() - 1) + "1" : string.substring(0, string.length() - 1) + "0";
            NIMessageRouterReturnStatus nIMessageRouterReturnStatus2 = this.sendBacktoAlternateHMC(string2, nIMessage2);
            if (nIMessageRouterReturnStatus2.getStatus() != 9) {
                logger.error(NIMessageRouterMetaData.getEssServerName() + " failed to loopback message from " + nIMessageRouterAddress2.getEssServerName() + " to " + string + "error code is " + nIMessageRouterReturnStatus.getStatus());
            } else {
                logger.debug_general(NIMessageRouterMetaData.getEssServerName() + " failed to loopback message from " + nIMessageRouterAddress2.getEssServerName() + " to " + string);
            }
        } else {
            logger.debug_general(NIMessageRouterMetaData.getEssServerName() + " loopbacked message from " + nIMessageRouterAddress2.getEssServerName() + " to " + nIMessageRouterAddress.getEssServerName());
        }
    }

    private void transmitMessage(NIMessage nIMessage) {
        String string = nIMessage.getMessageHeader().getDestinationAddress().getEssServerName();
        if (NIAgentProperties.getAgentType() == 4 && string != null) {
            if (string.startsWith(NIMessageRouterMetaData.getGroupDomainID())) {
                NIMessageRouterReturnStatus nIMessageRouterReturnStatus = NIMessageRouterConnectionMonitor.getConnectionMonitor().writeMessage(nIMessage);
                logger.debug_general("PCIX routing rc = " + nIMessageRouterReturnStatus.getStatus());
                if (nIMessageRouterReturnStatus.getStatus() != 9) {
                    this.loopBackCommandToHMC(nIMessage);
                }
            }
        } else {
            logger.error("Incorrect destination, ESS Server Node: " + string);
        }
    }

    public void run() {
        NIMessage nIMessage = null;
        NIMessageHeader nIMessageHeader = null;
        NIMessageRouterChannel nIMessageRouterChannel = null;
        try {
            logger.debug_general("Client socket ready for reading " + this.clientSocketStr);
            while (true) {
                Object object;
                String string;
                nIMessage = null;
                nIMessage = (NIMessage)this.ois.readUnshared();
                nIMessageHeader = nIMessage.getMessageHeader();
                if (nIMessageHeader.getMessageType() != 99) {
                    logger.debug_general("Message received at: " + NIMessageRouterMetaData.getEssServerName() + "  Interface/Port " + this.clientSocketStr + "  Src: " + nIMessageHeader.getSourceAddress().toString() + "  Dest: " + nIMessageHeader.getDestinationAddress().toString() + " type = " + nIMessageHeader.getMessageType());
                    if (!NIAgentProperties.isMC()) {
                        NIMessageRouterEstablishConnectionMonitor.getConnectionTable().wakeup(nIMessageHeader.getSourceAddress().getEssServerName());
                    }
                    string = nIMessageHeader.getSourceAddress().getEssServerName();
                    NIRoutingTable nIRoutingTable = NIRoutingTable.getRoutingTable();
                    if (nIRoutingTable.contains(string)) {
                        nIRoutingTable.get(string).updateTimeStamp();
                    }
                }
                string = nIMessageHeader.getDestinationAddress().getEssServerName();
                int n = nIMessageHeader.getDestinationAddress().getProcessChannelID();
                if (n != 666) {
                    nIMessageRouterChannel = NIProcessChannelTable.getProcessChannelTable().get(n);
                    if (nIMessageRouterChannel == null) {
                        logger.error("Unknown Process Channel ID: " + n);
                        continue;
                    }
                    if (!NIMessageRouterMetaData.isNodeThisServer(string)) {
                        this.transmitMessage(nIMessage);
                        continue;
                    }
                    object = nIMessageRouterChannel.getNIMessageRouterInputStream();
                    ((NIMessageRouterInputStream)object).open();
                    ((NIMessageRouterInputStream)object).writeObject(nIMessage.getMessage());
                    continue;
                }
                object = NIInternalMessageHandler.getInternalMessageHandler();
                ((NIInternalMessageHandler)object).processMessage(nIMessage);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.throwable((Throwable)classNotFoundException);
            logger.warning("Unable to deserialize object from incoming application message.");
        }
        catch (NICircularBufferOverflowException nICircularBufferOverflowException) {
            logger.throwable((Throwable)nICircularBufferOverflowException);
            logger.warning("Buffer overflow.  Dropped Incoming message from::  " + nIMessageHeader.getSourceAddress().toString());
        }
        catch (SocketException socketException) {
            logger.throwable((Throwable)socketException);
            logger.warning("Socket terminated by peer (broken pipe)");
        }
        catch (EOFException eOFException) {
            logger.throwable((Throwable)eOFException);
            logger.error("Socket terminated by peer (EOF)" + this.clientSocket);
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
            logger.error("Unable to read incoming application message.");
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
        try {
            if (this.ois != null) {
                this.ois.close();
            }
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            logger.error("Unable to close output stream.");
        }
        try {
            if (this.clientSocket != null) {
                this.clientSocket.close();
            }
            logger.debug_general("socket closed.");
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            logger.error("Unable to close socket.");
        }
    }

    public void shutdown() {
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws IOException {
        try {
            this.clientSocket.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                super.finalize();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {}
    }

    public static void shutdownAllHandlers() {
        int n = MR_HANDLERS.activeCount();
        Thread[] threadArray = new Thread[n];
        try {
            MR_HANDLERS.enumerate(threadArray);
            int n2 = 0;
            while (n2 < threadArray.length) {
                if (threadArray[n2] != null) {
                    ((NIMessageHandlerThread)threadArray[n2]).shutdown();
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

