/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.communication.connection.NIConnectionFactory;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIInternalMessageHandler;
import com.ibm.storage.ess.ni.messageRouter.NIMessage;
import com.ibm.storage.ess.ni.messageRouter.NIMessageHeader;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterInputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.NIProcessChannelTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class NIMessageRouterCNCThread
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterCNCThread == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterCNCThread = NIMessageRouterCNCThread.class$("com.ibm.storage.ess.ni.messageRouter.NIMessageRouterCNCThread")) : class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterCNCThread);
    private boolean bRunning = true;
    private ServerSocket serverSocket = null;
    private Socket sock = null;
    private ObjectInputStream ois = null;
    private int serverPort = 1759;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterCNCThread;

    public NIMessageRouterCNCThread() {
        super("NIMessageRouterCNCThread");
    }

    public void getServerSocket() throws IOException {
        this.serverSocket = NIConnectionFactory.getConnectionFactory().createNewServerSocket(this.serverPort);
        logger.debug_general("Creating server socket on port " + this.serverPort);
    }

    private void cleanup() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
        if (this.ois != null) {
            try {
                this.ois.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ois = null;
        }
        if (this.sock != null) {
            try {
                logger.debug_general("Closing " + this.sock);
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sock = null;
        }
    }

    public void run() {
        logger.debug_general("PCIX: Server starting");
        while (this.bRunning) {
            try {
                this.cleanup();
                this.getServerSocket();
                logger.debug_general("PCIX: Waiting for connection.");
                while (this.sock == null) {
                    this.sock = this.serverSocket.accept();
                    if (this.sock.getInetAddress().getHostAddress().equals("192.0.2.0") || this.sock.getInetAddress().getHostAddress().equals("192.0.2.1")) continue;
                    logger.warning("PCIX: Invalid remote IP: " + this.sock.getInetAddress().getHostAddress());
                    this.sock.close();
                    this.sock = null;
                }
                logger.debug_general("PCIX: Incoming connection " + this.sock);
                this.ois = new ObjectInputStream(this.sock.getInputStream());
                logger.debug_general("PCIX: Input stream created " + this.sock);
                this.serverSocket.close();
                this.serverSocket = null;
                this.handlePCIXConnection();
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        logger.debug_general("PCIX: Server stopped");
    }

    private void handlePCIXConnection() {
        logger.debug_general("PCIX: Server starting");
        while (this.bRunning) {
            NIMessage nIMessage = null;
            try {
                nIMessage = (NIMessage)this.ois.readUnshared();
                logger.debug_general("PCIX: Read msg: " + nIMessage);
                if (nIMessage != null) {
                    NIMessageRouterAddress nIMessageRouterAddress = nIMessage.getMessageHeader().getDestinationAddress();
                    if (nIMessageRouterAddress.getEssServerName().startsWith("HMC")) {
                        NIRoutingTableEntry nIRoutingTableEntry = NIRoutingTable.getRoutingTable().get(nIMessageRouterAddress.getEssServerName());
                        if (nIRoutingTableEntry == null) continue;
                        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = NIMessageRouterConnectionMonitor.getConnectionMonitor().writeMessage(nIRoutingTableEntry, nIMessage);
                        if (nIMessageRouterReturnStatus.getStatus() == 9) {
                            logger.debug_general("PCIX: Successful routing msg " + nIMessage + " to SMC: " + nIMessageRouterAddress);
                            continue;
                        }
                        logger.warning("PCIX: Failed to route msg " + nIMessage + " to SMC: rc = " + nIMessageRouterReturnStatus.getStatus());
                        boolean bl = nIMessageRouterAddress.getEssServerName().equals("HMC1");
                        String string = bl ? "HMC2" : "HMC1";
                        nIMessage.getMessageHeader().getDestinationAddress().setServerName(string);
                        nIRoutingTableEntry = NIRoutingTable.getRoutingTable().get(string);
                        if (nIRoutingTableEntry == null) continue;
                        logger.debug_general("PCIX: Successful routing msg " + nIMessage + " to SMC: " + nIMessageRouterAddress);
                        nIMessageRouterReturnStatus = NIMessageRouterConnectionMonitor.getConnectionMonitor().writeMessage(nIRoutingTableEntry, nIMessage);
                        if (nIMessageRouterReturnStatus.getStatus() == 9) {
                            logger.debug_general("PCIX: Successful routing msg " + nIMessage + " to SMC: " + nIMessageRouterAddress);
                            continue;
                        }
                        logger.warning("PCIX: Failed to route msg " + nIMessage + " to SMC: rc = " + nIMessageRouterReturnStatus.getStatus());
                        continue;
                    }
                    if (nIMessageRouterAddress.getEssServerName().equals(NIMessageRouterMetaData.getEssServerName())) {
                        this.routeToChannel(nIMessage);
                        continue;
                    }
                    logger.warning("PCIX: Invalid destination " + nIMessageRouterAddress);
                    continue;
                }
                logger.error("PCIX: read null msg");
                return;
            }
            catch (IOException iOException) {
                logger.throwable((Throwable)iOException);
                return;
            }
            catch (ClassCastException classCastException) {
                logger.warning("PCIX: Invalid message received " + classCastException.getMessage());
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
                return;
            }
        }
    }

    private void routeToChannel(NIMessage nIMessage) {
        block5: {
            try {
                NIMessageHeader nIMessageHeader = nIMessage.getMessageHeader();
                int n = nIMessageHeader.getDestinationAddress().getProcessChannelID();
                logger.debug_general("PCIX: Sending to channel: " + n);
                if (n != 666) {
                    NIMessageRouterChannel nIMessageRouterChannel = NIProcessChannelTable.getProcessChannelTable().get(n);
                    if (nIMessageRouterChannel == null) {
                        logger.error("PCIX: Unknown Process Channel ID: " + n);
                    } else {
                        NIMessageRouterInputStream nIMessageRouterInputStream = nIMessageRouterChannel.getNIMessageRouterInputStream();
                        nIMessageRouterInputStream.open();
                        nIMessageRouterInputStream.writeObject(nIMessage.getMessage());
                    }
                    break block5;
                }
                NIInternalMessageHandler nIInternalMessageHandler = NIInternalMessageHandler.getInternalMessageHandler();
                nIInternalMessageHandler.processMessage(nIMessage);
            }
            catch (Exception exception) {
                logger.warning("PCIX: Unable to route to channel.");
                logger.throwable((Throwable)exception);
            }
        }
    }

    public void shutdown() {
        this.bRunning = false;
        this.interrupt();
        this.cleanup();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

