/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessage;
import com.ibm.storage.ess.ni.messageRouter.NIMessageHeader;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConnection;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConnectionTable;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEstablishConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMessage;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterSocketConnection;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NIMessageRouterConnectionMonitor {
    private static NIMessageRouterConnectionMonitor monitor = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterConnectionMonitor == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterConnectionMonitor = NIMessageRouterConnectionMonitor.class$("com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConnectionMonitor")) : class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterConnectionMonitor);
    private NIMessageRouterConnectionTable connectionTable = NIMessageRouterConnectionTable.getConnectionTable();
    private String ALT_KONA = "PCIX_KONA";
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterConnectionMonitor;

    private NIMessageRouterConnectionMonitor() {
    }

    public static synchronized NIMessageRouterConnectionMonitor getConnectionMonitor() {
        if (monitor == null) {
            monitor = new NIMessageRouterConnectionMonitor();
        }
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NIMessageRouterReturnStatus writeMessage(NIRoutingTableEntry nIRoutingTableEntry, NIMessage nIMessage) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        NIMessageRouterConnection nIMessageRouterConnection = null;
        NIMessageRouterConnectionMonitor nIMessageRouterConnectionMonitor = this;
        synchronized (nIMessageRouterConnectionMonitor) {
            nIMessageRouterConnection = this.connectionTable.get(nIRoutingTableEntry.getEssServerName());
            if (nIMessageRouterConnection == null) {
                nIMessageRouterConnection = nIRoutingTableEntry.getConnection();
                if (nIMessageRouterConnection != null) {
                    this.add(nIMessageRouterConnection);
                } else {
                    nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-12);
                }
            }
        }
        if (nIMessageRouterConnection != null) {
            if (!NIMessageRouterMetaData.isDiscoveryMode()) {
                if (nIMessageRouterConnection != null) {
                    boolean bl = nIMessage.getMessageHeader().getMessageType() == 99;
                    nIMessageRouterConnection.connect(bl);
                }
                nIMessageRouterReturnStatus = this.sendUpdate(nIRoutingTableEntry, nIMessageRouterConnection, nIMessage);
                if ((nIMessageRouterReturnStatus = this.checkBrokenSocket(nIRoutingTableEntry, nIMessageRouterConnection, nIMessage, nIMessageRouterReturnStatus.getStatus(), false)).getStatus() != 9 && nIMessageRouterReturnStatus.getStatus() != -6) {
                    this.remove(nIMessageRouterConnection.getKey());
                }
            }
            if (nIMessageRouterReturnStatus.getStatus() == 9) {
                nIMessageRouterReturnStatus = nIMessageRouterConnection.writeMessage(nIMessage);
                if ((nIMessageRouterReturnStatus = this.checkBrokenSocket(nIRoutingTableEntry, nIMessageRouterConnection, nIMessage, nIMessageRouterReturnStatus.getStatus(), true)).getStatus() == 9) {
                    if (nIMessage.getMessageHeader().getMessageType() != 99) {
                        logger.debug_general("Message sent from: " + NIMessageRouterMetaData.getEssServerName() + "  Interface/Port " + ((NIMessageRouterSocketConnection)nIMessageRouterConnection).getName() + " Src: " + nIMessage.getMessageHeader().getSourceAddress().toString() + " Dest: " + nIMessage.getMessageHeader().getDestinationAddress().toString() + " type = " + nIMessage.getMessageHeader().getMessageType());
                    }
                } else if (NIAgentProperties.is1750()) {
                    if (nIMessageRouterReturnStatus.getStatus() != -6) {
                        this.remove(nIMessageRouterConnection.getKey());
                    }
                } else {
                    this.remove(nIMessageRouterConnection.getKey());
                }
            }
        }
        return nIMessageRouterReturnStatus;
    }

    public void add(NIMessageRouterConnection nIMessageRouterConnection) {
        this.connectionTable.add(nIMessageRouterConnection);
    }

    public NIMessageRouterConnectionTable getConnectionTable() {
        return this.connectionTable;
    }

    private NIMessageRouterReturnStatus sendUpdate(NIRoutingTableEntry nIRoutingTableEntry, NIMessageRouterConnection nIMessageRouterConnection, NIMessage nIMessage) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus;
        block8: {
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
            int n = 2;
            boolean bl = false;
            if (NIMessageRouterMetaData.getEssServerName().compareTo("HMC1") == 0) {
                if (!nIRoutingTableEntry.isNodeUpdated() || nIMessage.getMessageHeader().getMessageType() == 10) {
                    if (nIRoutingTableEntry.getEssServerName().compareTo("HMC2") == 0) {
                        n = 7;
                    }
                    bl = true;
                }
            } else if (NIMessageRouterMetaData.getEssServerName().compareTo("HMC2") == 0 && nIRoutingTableEntry.getDomainGroupID().compareTo("HMC") != 0 && !nIRoutingTableEntry.isNodeUpdated()) {
                bl = true;
            }
            if (!bl) break block8;
            try {
                NIMessageRouterAddress nIMessageRouterAddress = new NIMessageRouterAddress(666, NIMessageRouterMetaData.getEssServerName());
                NIMessageRouterAddress nIMessageRouterAddress2 = new NIMessageRouterAddress(666, nIRoutingTableEntry.getEssServerName());
                NIMessageHeader nIMessageHeader = new NIMessageHeader(nIMessageRouterAddress, nIMessageRouterAddress2, n, 0);
                NIMessage nIMessage2 = new NIMessage(nIMessageHeader, new NIMessageRouterMessage(n, NIRoutingTable.getRoutingTable().getTableMap()));
                nIMessageRouterReturnStatus = nIMessageRouterConnection.writeMessage(nIMessage2);
                if (nIMessageRouterReturnStatus.getStatus() == 9) {
                    nIRoutingTableEntry.nodeUpdated();
                }
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
                logger.error("Unable to propagate routing changes to remote node  " + nIRoutingTableEntry.getEssServerName());
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-19);
            }
        }
        return nIMessageRouterReturnStatus;
    }

    protected synchronized void replace(NIMessageRouterConnection nIMessageRouterConnection) throws NIMessageRouterException {
        NIMessageRouterConnection nIMessageRouterConnection2 = this.connectionTable.get(nIMessageRouterConnection.getKey());
        if (nIMessageRouterConnection2 != null) {
            nIMessageRouterConnection2.close();
            if (NIAgentProperties.is1750()) {
                NIMessageRouterEstablishConnectionMonitor.getConnectionTable().remove(nIMessageRouterConnection2.getKey());
            }
        }
        this.add(nIMessageRouterConnection);
    }

    public synchronized NIMessageRouterConnection remove(String string) {
        NIMessageRouterConnection nIMessageRouterConnection = this.connectionTable.get(string);
        if (nIMessageRouterConnection != null) {
            logger.trace("Removing connection " + string);
            nIMessageRouterConnection = this.connectionTable.remove(string);
            if (NIAgentProperties.is1750()) {
                NIMessageRouterEstablishConnectionMonitor.getConnectionTable().stop(nIMessageRouterConnection.getKey());
            }
        }
        return nIMessageRouterConnection;
    }

    protected synchronized NIMessageRouterConnection remove(String string, boolean bl) {
        NIMessageRouterConnection nIMessageRouterConnection = this.connectionTable.get(string);
        if (nIMessageRouterConnection != null) {
            if (bl && nIMessageRouterConnection.isUsingPrimaryConnection()) {
                nIMessageRouterConnection = this.connectionTable.remove(string);
            } else if (!nIMessageRouterConnection.isUsingPrimaryConnection()) {
                nIMessageRouterConnection = this.connectionTable.remove(string);
            }
        }
        return nIMessageRouterConnection;
    }

    private NIMessageRouterReturnStatus checkBrokenSocket(NIRoutingTableEntry nIRoutingTableEntry, NIMessageRouterConnection nIMessageRouterConnection, NIMessage nIMessage, int n, boolean bl) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(n);
        if (n == -14 || n == -15 || n == -9) {
            if (nIMessageRouterConnection != null) {
                logger.warning("Stale socket found. Refreshing socket. " + n + " " + ((NIMessageRouterSocketConnection)nIMessageRouterConnection).getName());
                nIMessageRouterConnection.close();
                if (NIAgentProperties.is1750()) {
                    if (nIMessage.getMessageHeader().getMessageType() == 99) {
                        logger.warning("HB message will not retry.");
                        return nIMessageRouterReturnStatus;
                    }
                    if (nIRoutingTableEntry != null) {
                        nIRoutingTableEntry.updateNeeded();
                        nIMessageRouterReturnStatus = this.sendUpdate(nIRoutingTableEntry, nIMessageRouterConnection, nIMessage);
                    }
                    if (bl) {
                        if (nIRoutingTableEntry == null || nIMessageRouterReturnStatus.getStatus() == 9) {
                            nIMessageRouterReturnStatus = nIMessageRouterConnection.writeMessage(nIMessage);
                        } else {
                            logger.error("Update failed, so message is not sent " + ((NIMessageRouterSocketConnection)nIMessageRouterConnection).getName());
                        }
                    }
                } else {
                    nIMessageRouterReturnStatus = nIMessageRouterConnection.writeMessage(nIMessage);
                }
            }
            if (nIMessageRouterReturnStatus.getStatus() == 9) {
                logger.debug_general("Socket refreshed and message sent successful.");
            } else {
                logger.error("Unable to refresh socket.");
            }
        }
        return nIMessageRouterReturnStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NIMessageRouterReturnStatus writeMessage(NIMessage nIMessage) {
        NIMessageRouterConnection nIMessageRouterConnection = null;
        logger.debug_general("PCIX: SENDING MESSAGE through PCIX " + nIMessage);
        NIMessageRouterConnectionMonitor nIMessageRouterConnectionMonitor = this;
        synchronized (nIMessageRouterConnectionMonitor) {
            nIMessageRouterConnection = this.connectionTable.get(this.ALT_KONA);
            if (nIMessageRouterConnection == null) {
                logger.debug_general("PCIX: SENDING MESSAGE through PCIX " + nIMessage);
                String string = "192.0.2.0";
                boolean bl = NIMessageRouterMetaData.getEssServerName().endsWith("0");
                if (bl) {
                    string = "192.0.2.1";
                }
                InetAddress inetAddress = null;
                try {
                    inetAddress = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                logger.debug_general("PCIX: Start connection " + nIMessage);
                nIMessageRouterConnection = new NIMessageRouterSocketConnection(this.ALT_KONA, inetAddress, 1759, true);
                nIMessageRouterConnection.connect();
                this.add(nIMessageRouterConnection);
                logger.debug_general("PCIX: added connection");
            }
        }
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = nIMessageRouterConnection.writeMessage(nIMessage);
        nIMessageRouterReturnStatus = this.checkBrokenSocket(null, nIMessageRouterConnection, nIMessage, nIMessageRouterReturnStatus.getStatus(), true);
        if (nIMessageRouterReturnStatus.getStatus() != 9) {
            logger.error("Unable to send msg to another kona by PCIX");
            if (nIMessageRouterReturnStatus.getStatus() != -6) {
                this.remove(nIMessageRouterConnection.getKey());
            }
        }
        return nIMessageRouterReturnStatus;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

