/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIBroadcastMessage;
import com.ibm.storage.ess.ni.messageRouter.NIDomainGroupTable;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterThread;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class NIMessageRouterDiscoveryThread
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterDiscoveryThread == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterDiscoveryThread = NIMessageRouterDiscoveryThread.class$("com.ibm.storage.ess.ni.messageRouter.NIMessageRouterDiscoveryThread")) : class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterDiscoveryThread);
    private NIMessageRouterThread router;
    private InetAddress group = NIMessageRouterMetaData.getBroadcastInetAddress();
    private int port;
    private MulticastSocket s;
    private InetAddress ip;
    private boolean primaryIP = false;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterDiscoveryThread;

    public NIMessageRouterDiscoveryThread(InetAddress inetAddress, int n, boolean bl) throws UnknownHostException {
        super("NIMessageRouterDiscoveryThread - " + n);
        this.port = n;
        this.ip = inetAddress;
        this.primaryIP = bl;
        logger.trace("Name: " + this.getName() + "Thread" + this.group.toString() + n);
    }

    public void run() {
        try {
            this.s = new MulticastSocket(this.port);
            this.s.setInterface(this.ip);
            this.s.joinGroup(this.group);
            while (true) {
                byte[] byArray = new byte[1024];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                this.s.receive(datagramPacket);
                byArray = datagramPacket.getData();
                if (!this.processMessage(byArray)) {
                    logger.trace("[" + this.getName() + "] Can not read broadcast message  " + datagramPacket.getAddress().toString());
                }
                datagramPacket = null;
                byArray = null;
            }
        }
        catch (SocketException socketException) {
            logger.debug_general("[" + this.getName() + "] Socket Exception  " + socketException.getMessage() + "  Thread is terminating");
        }
        catch (IOException iOException) {
            logger.debug_general("[" + this.getName() + "] IO Exception  " + iOException.getMessage() + "  Thread is terminating");
        }
    }

    public void shutdown() {
        block2: {
            this.interrupt();
            if (this.s == null) break block2;
            try {
                this.s.close();
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
            }
        }
    }

    private boolean processMessage(byte[] byArray) {
        boolean bl;
        block5: {
            NIBroadcastMessage nIBroadcastMessage = null;
            bl = true;
            try {
                nIBroadcastMessage = new NIBroadcastMessage(byArray);
                if (!this.isValidStoragePlex(nIBroadcastMessage.getStoragePlexName())) {
                    logger.trace("[" + this.getName() + "] Node was not added : " + nIBroadcastMessage.getServerName() + " StoragePlex: " + nIBroadcastMessage.getStoragePlexName());
                    bl = false;
                    break block5;
                }
                NIRoutingTableEntry nIRoutingTableEntry = new NIRoutingTableEntry(nIBroadcastMessage);
                NIRoutingTableEntry nIRoutingTableEntry2 = NIRoutingTable.getRoutingTable().get(nIRoutingTableEntry.getKey());
                if (nIRoutingTableEntry2 == null) {
                    logger.debug_general(nIRoutingTableEntry.toString());
                    NIRoutingTable.getRoutingTable().add(nIRoutingTableEntry);
                    NIDomainGroupTable.getDomainGroupTable().add(nIRoutingTableEntry.getDomainGroupID(), nIBroadcastMessage.getServerName());
                    break block5;
                }
                NIRoutingTable.getRoutingTable().merge(nIRoutingTableEntry, nIRoutingTableEntry2, this.isPrimaryIP());
                NIDomainGroupTable.getDomainGroupTable().add(nIRoutingTableEntry.getDomainGroupID(), nIBroadcastMessage.getServerName());
            }
            catch (UnknownHostException unknownHostException) {
                logger.throwable((Throwable)unknownHostException);
                logger.warning("Can not create InetAddress from string in NIBroadcastMessage.");
                bl = false;
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
                bl = false;
            }
        }
        return bl;
    }

    private boolean isValidStoragePlex(String string) {
        boolean bl = false;
        if (NIMessageRouterMetaData.getStoragePlexName().length() == 0) {
            bl = true;
        } else if (NIMessageRouterMetaData.getStoragePlexName().equals(string)) {
            bl = true;
        } else if (NIMessageRouterMetaData.getStoragePlexName().equals("*")) {
            bl = true;
        }
        return bl;
    }

    private boolean isPrimaryIP() {
        return this.primaryIP;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

