/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterSocketConnection;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NIMessageRouterEstablishConnectionMonitor {
    private Map table = Collections.synchronizedMap(new HashMap());
    private static NIMessageRouterEstablishConnectionMonitor connectionTable = null;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterSocketConnection == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterSocketConnection = NIMessageRouterEstablishConnectionMonitor.class$("com.ibm.storage.ess.ni.messageRouter.NIMessageRouterSocketConnection")) : class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterSocketConnection);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterSocketConnection;

    private NIMessageRouterEstablishConnectionMonitor() {
        logger.debug_general("Message Router Establish Connection Monitor started");
    }

    public static synchronized NIMessageRouterEstablishConnectionMonitor getConnectionTable() {
        if (connectionTable == null) {
            connectionTable = new NIMessageRouterEstablishConnectionMonitor();
        }
        return connectionTable;
    }

    public void add(NIMessageRouterSocketConnection nIMessageRouterSocketConnection) {
        nIMessageRouterSocketConnection.setConnecting(true);
        NIMessageRouterEstablishSocketThread nIMessageRouterEstablishSocketThread = new NIMessageRouterEstablishSocketThread(nIMessageRouterSocketConnection);
        this.table.put(nIMessageRouterSocketConnection.getKey(), nIMessageRouterEstablishSocketThread);
        nIMessageRouterEstablishSocketThread.start();
    }

    public void remove(String string) {
        this.table.remove(string);
        logger.debug_general("Connection to " + string + " removed.");
    }

    public int size() {
        return this.table.size();
    }

    public Iterator iterator() {
        return this.table.values().iterator();
    }

    public boolean contains(String string) {
        return this.table.containsKey(string);
    }

    public void wakeup(String string) {
        block4: {
            NIMessageRouterEstablishSocketThread nIMessageRouterEstablishSocketThread = null;
            nIMessageRouterEstablishSocketThread = (NIMessageRouterEstablishSocketThread)this.table.get(string);
            if (nIMessageRouterEstablishSocketThread == null) break block4;
            NIMessageRouterSocketConnection nIMessageRouterSocketConnection = null;
            nIMessageRouterSocketConnection = this.get(string);
            if (nIMessageRouterSocketConnection != null && nIMessageRouterSocketConnection.getPrimarySocket() == null) {
                nIMessageRouterEstablishSocketThread.interrupt();
                try {
                    int n = 0;
                    while (n < 5000 && nIMessageRouterSocketConnection.getPrimarySocket() == null) {
                        Thread.sleep(250L);
                        n += 250;
                    }
                    logger.warning("Wakeup " + string + " found socket connected ? = " + (nIMessageRouterSocketConnection.getPrimarySocket() != null));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public NIMessageRouterSocketConnection get(String string) {
        NIMessageRouterEstablishSocketThread nIMessageRouterEstablishSocketThread = (NIMessageRouterEstablishSocketThread)this.table.get(string);
        if (nIMessageRouterEstablishSocketThread != null) {
            return nIMessageRouterEstablishSocketThread.getConnection();
        }
        return null;
    }

    public void stop(String string) {
        NIMessageRouterEstablishSocketThread nIMessageRouterEstablishSocketThread = (NIMessageRouterEstablishSocketThread)this.table.get(string);
        if (nIMessageRouterEstablishSocketThread != null) {
            logger.debug_general("Establisher stopping " + string);
            nIMessageRouterEstablishSocketThread.stopRunning();
            this.remove(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NIMessageRouterEstablishSocketThread
    extends Thread {
        NIMessageRouterSocketConnection connection;
        private boolean running;

        public NIMessageRouterEstablishSocketThread(NIMessageRouterSocketConnection nIMessageRouterSocketConnection) {
            super("Connect: " + nIMessageRouterSocketConnection.getKey() + " IP: " + nIMessageRouterSocketConnection.getEssServerIP().getHostAddress() + ":" + nIMessageRouterSocketConnection.getEssServerPort());
            this.running = true;
            this.connection = nIMessageRouterSocketConnection;
            logger.debug_general("Starting background thread [" + this.getName() + "]");
        }

        public void run() {
            Socket socket;
            this.running = true;
            do {
                long l = System.currentTimeMillis();
                logger.debug_general("Attempting connection [" + this.getName() + "]");
                socket = this.connection.getEssServerSocket();
                try {
                    if (socket != null || System.currentTimeMillis() - l >= 5000L) continue;
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.warning("Connection thread interrupted - " + this.running);
                }
            } while (socket == null && this.running);
            logger.debug_general("Connection thread done [" + this.getName() + "]");
            this.running = false;
        }

        public void stopRunning() {
            this.running = false;
            this.interrupt();
            this.connection.setConnecting(false);
            logger.debug_general("Stopping background thread [" + this.getName() + "]");
        }

        public NIMessageRouterSocketConnection getConnection() {
            return this.connection;
        }
    }
}

