/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageHandlerThread;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;

public class NIMessageRouterInboundThread
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterDiscoveryThread == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterDiscoveryThread = NIMessageRouterInboundThread.class$("com.ibm.storage.ess.ni.messageRouter.NIMessageRouterDiscoveryThread")) : class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterDiscoveryThread);
    private ServerSocket serverSocket = null;
    private Selector selector = null;
    private static final int SOCKET_CREATE_RETRY_SLEEP = 10000;
    private boolean running = false;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterDiscoveryThread;

    public NIMessageRouterInboundThread() {
        super("NIMessageRouterInboundThread");
        try {
            this.initialize();
        }
        catch (IOException iOException) {
            logger.error("Unable to initialize Inbound thread");
            logger.throwable((Throwable)iOException);
        }
    }

    public final void initialize() throws IOException {
        if (NIMessageRouterMetaData.isNonDiscoveryMode()) {
            this.serverSocket = NIMessageRouterMetaData.getSocketConnectionFactory().createNewServerSocket(NIMessageRouterMetaData.getEssServerPort());
        } else {
            this.selector = Selector.open();
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.configureBlocking(false);
            serverSocketChannel.socket().bind(new InetSocketAddress(NIMessageRouterMetaData.getPrimaryInetAddress(), NIMessageRouterMetaData.getEssServerPort()));
            serverSocketChannel.register(this.selector, 16);
            ServerSocketChannel serverSocketChannel2 = ServerSocketChannel.open();
            serverSocketChannel2.configureBlocking(false);
            serverSocketChannel2.socket().bind(new InetSocketAddress(NIMessageRouterMetaData.getSecondaryInetAddress(), NIMessageRouterMetaData.getEssBackupServerPort()));
            serverSocketChannel2.register(this.selector, 16);
        }
    }

    public void finalize() throws IOException {
        this.serverSocket.close();
    }

    public void run() {
        block3: {
            this.running = true;
            try {
                if (NIMessageRouterMetaData.areBackupNetworkInterfacesActive()) {
                    this.selectChannels();
                    break block3;
                }
                this.readServerSocket();
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
                logger.error("Exiting either because socket accept failed or unable to start thread.");
            }
        }
    }

    public void shutdown() {
        this.running = false;
        try {
            this.interrupt();
            this.finalize();
            NIMessageHandlerThread.shutdownAllHandlers();
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
        }
    }

    private void readServerSocket() throws IOException {
        while (NIMessageRouterMetaData.isEssServerUp() && this.running) {
            int n = 0;
            try {
                while (this.serverSocket == null || this.serverSocket.isClosed()) {
                    block8: {
                        try {
                            ++n;
                            this.serverSocket = NIMessageRouterMetaData.getSocketConnectionFactory().createNewServerSocket(NIMessageRouterMetaData.getEssServerPort());
                        }
                        catch (IOException iOException) {
                            if (n % 60 != 0) break block8;
                            logger.warning("Unable to create server socket: " + iOException.getMessage() + " " + n + " attempts");
                        }
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                logger.warning("Server socket create interrupted ");
            }
            try {
                Socket socket = this.serverSocket.accept();
                logger.debug_general("Incoming connection " + socket);
                NIMessageHandlerThread nIMessageHandlerThread = new NIMessageHandlerThread(socket);
                nIMessageHandlerThread.start();
            }
            catch (IOException iOException) {
                logger.error("Unable to accept incoming connection");
                logger.throwable((Throwable)iOException);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void selectChannels() throws IOException {
        if (this.selector != null) ** GOTO lbl22
        NIMessageRouterInboundThread.logger.error("Variable selector set to null.  InboundThread exiting");
        return;
lbl-1000:
        // 1 sources

        {
            this.selector.select();
            var1_1 = this.selector.selectedKeys().iterator();
            while (var1_1.hasNext()) {
                var2_2 = var1_1.next();
                var1_1.remove();
                if (!var2_2.isAcceptable()) continue;
                var3_3 = (ServerSocketChannel)var2_2.channel();
                try {
                    var4_4 = var3_3.accept();
                    if (var4_4 == null) continue;
                    var5_6 = var4_4.socket();
                    var6_7 = new NIMessageHandlerThread(var5_6);
                    var6_7.start();
                }
                catch (IOException var4_5) {
                    NIMessageRouterInboundThread.logger.error("Error accepting socket connection.");
                }
            }
lbl22:
            // 2 sources

            ** while (this.running)
        }
lbl23:
        // 1 sources

    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

