/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NIMessageRouterMetaDataFile {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouter == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouter = NIMessageRouterMetaDataFile.class$("com.ibm.storage.ess.ni.messageRouter.NIMessageRouter")) : class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouter);
    private String fileName = null;
    private BufferedWriter bufferedWriter = null;
    private BufferedReader bufferedReader = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouter;

    public NIMessageRouterMetaDataFile() throws Exception, NIMessageRouterException {
        this(false, null);
    }

    public NIMessageRouterMetaDataFile(String string) throws Exception, NIMessageRouterException {
        this(false, string);
    }

    public NIMessageRouterMetaDataFile(boolean bl) throws Exception, NIMessageRouterException {
        this(bl, null);
    }

    public NIMessageRouterMetaDataFile(boolean bl, String string) throws Exception, NIMessageRouterException {
        this.fileName = string == null ? new String("messageRouterMetaData.txt") : string;
        File file = new File(this.getMessageRouterMetaDataPathFileName());
        if (bl) {
            logger.debug_general("Metadata File deleted, and being recreated");
            file.delete();
            file.createNewFile();
        }
        if (!file.exists()) {
            throw new NIMessageRouterException("Startup Exception:  Message Router metadata file does not exist.");
        }
        if (!file.canRead()) {
            throw new NIMessageRouterException("Startup Exception:  Message Router metadata file can not be read.");
        }
        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, true)));
        this.bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
    }

    public void readData() throws IOException, UnknownHostException, NIMessageRouterException {
        String string = null;
        string = this.bufferedReader.readLine();
        if (string == null) {
            throw new NIMessageRouterException("Bad MR metadata file - NO server name set");
        }
        NIMessageRouterMetaData.setEssServerName(string);
        string = this.bufferedReader.readLine();
        if (string == null) {
            throw new NIMessageRouterException("Bad MR metadata file - NO primary IP set");
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        NIMessageRouterMetaData.setPrimaryInetAddress(inetAddress);
        string = this.bufferedReader.readLine();
        if (string == null) {
            throw new NIMessageRouterException("Bad MR metadata file - NO secondary IP set");
        }
        InetAddress inetAddress2 = InetAddress.getByName(string);
        NIMessageRouterMetaData.setSecondaryInetAddress(inetAddress2);
        string = this.bufferedReader.readLine();
        if (string == null) {
            throw new NIMessageRouterException("Bad MR metadata file - NO domain name set");
        }
        NIMessageRouterMetaData.setGroupDomainID(string);
        string = this.bufferedReader.readLine();
        if (string == null) {
            throw new NIMessageRouterException("Bad MR metadata file - NO storage plex value set");
        }
        NIMessageRouterMetaData.setStoragePlexName(string);
    }

    public void writeData() throws Exception {
        this.writeData(NIMessageRouterMetaData.getEssServerName(), NIMessageRouterMetaData.getPrimaryInetAddress(), NIMessageRouterMetaData.getSecondaryInetAddress(), NIMessageRouterMetaData.getGroupDomainID(), NIMessageRouterMetaData.getStoragePlexName());
    }

    public void writeData(String string, InetAddress inetAddress, InetAddress inetAddress2, String string2, String string3) throws Exception {
        this.bufferedWriter.write(string);
        this.bufferedWriter.newLine();
        this.bufferedWriter.write(inetAddress.getHostAddress());
        this.bufferedWriter.newLine();
        this.bufferedWriter.write(inetAddress2.getHostAddress());
        this.bufferedWriter.newLine();
        this.bufferedWriter.write(string2);
        this.bufferedWriter.newLine();
        this.bufferedWriter.write(string3);
    }

    public void close() throws Exception {
        this.bufferedWriter.close();
        this.bufferedReader.close();
    }

    private String getMessageRouterMetaDataPathFileName() {
        return this.fileName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

