/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIDomainGroup;
import com.ibm.storage.ess.ni.messageRouter.NIDomainGroupTable;
import com.ibm.storage.ess.ni.messageRouter.NIMessage;
import com.ibm.storage.ess.ni.messageRouter.NIMessageHeader;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterInputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.NIMessageState;
import com.ibm.storage.ess.ni.messageRouter.NIMessageTable;
import com.ibm.storage.ess.ni.messageRouter.NIProcessChannelTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.util.NICircularBufferOverflowException;
import com.ibm.storage.ess.ni.util.NICircularObjectBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;

public class NIMessageRouterOutputStream {
    private int processChannelID;
    private NICircularObjectBuffer outputStream;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableEntry == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableEntry = NIMessageRouterOutputStream.class$("com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry")) : class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableEntry);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableEntry;

    protected NIMessageRouterOutputStream(int n, int n2) {
        this.processChannelID = n2;
        this.outputStream = new NICircularObjectBuffer(n, false);
    }

    public NIMessageRouterReturnStatus send(NIMessageRouterAddress nIMessageRouterAddress, Object object) throws IOException {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus;
        block3: {
            nIMessageRouterReturnStatus = null;
            try {
                if (nIMessageRouterAddress == null) {
                    nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-5);
                    break block3;
                }
                nIMessageRouterReturnStatus = this.sendImplementation(nIMessageRouterAddress, 0, 0, object);
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
            }
        }
        return nIMessageRouterReturnStatus;
    }

    public synchronized NIMessageRouterReturnStatus writeObject(Object object) throws NICircularBufferOverflowException {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        if (object == null) {
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-4);
        } else {
            try {
                this.outputStream.write(object);
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
            }
            catch (IllegalStateException illegalStateException) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
            }
            catch (InterruptedException interruptedException) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
            }
        }
        return nIMessageRouterReturnStatus;
    }

    public synchronized NIMessageRouterReturnStatus send(NIMessageRouterAddress nIMessageRouterAddress) throws IOException {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus;
        block3: {
            nIMessageRouterReturnStatus = null;
            try {
                if (nIMessageRouterAddress == null) {
                    nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-5);
                    break block3;
                }
                nIMessageRouterReturnStatus = this.sendImplementation(nIMessageRouterAddress, 0, 0);
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
            }
        }
        return nIMessageRouterReturnStatus;
    }

    public synchronized NIMessageRouterReturnStatus send(NIMessageRouterAddress nIMessageRouterAddress, int n) throws IOException {
        return this.sendImplementation(nIMessageRouterAddress, n, 0);
    }

    public NIMessageRouterReturnStatus send(NIMessageRouterAddress nIMessageRouterAddress, int n, Object object) throws IOException {
        return this.sendImplementation(nIMessageRouterAddress, n, 0, object);
    }

    private synchronized NIMessageRouterReturnStatus sendImplementation(NIMessageRouterAddress nIMessageRouterAddress, int n, int n2) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        NIMessageRouterAddress nIMessageRouterAddress2 = new NIMessageRouterAddress(this.getProcessChannelID(), NIMessageRouterMetaData.getEssServerName());
        int n3 = this.outputStream.readLimit();
        if (nIMessageRouterAddress == null) {
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-5);
        } else if (n3 <= 0) {
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-4);
        } else {
            this.outputStream.close();
            NIMessageHeader nIMessageHeader = new NIMessageHeader(nIMessageRouterAddress2, nIMessageRouterAddress, n, n2);
            NIMessage nIMessage = new NIMessage(nIMessageHeader, null);
            nIMessageRouterReturnStatus = this.isLocalDestination(nIMessageRouterAddress) ? this.sendToLocalNode(nIMessageHeader, n3) : this.sendToRemoteNode(nIMessageRouterAddress, nIMessage, n3);
        }
        return nIMessageRouterReturnStatus;
    }

    private NIMessageRouterReturnStatus sendImplementation(NIMessageRouterAddress nIMessageRouterAddress, int n, int n2, Object object) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        NIMessageRouterAddress nIMessageRouterAddress2 = new NIMessageRouterAddress(this.getProcessChannelID(), NIMessageRouterMetaData.getEssServerName());
        if (nIMessageRouterAddress == null) {
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-5);
        } else {
            NIMessageHeader nIMessageHeader = new NIMessageHeader(nIMessageRouterAddress2, nIMessageRouterAddress, n, n2);
            NIMessage nIMessage = new NIMessage(nIMessageHeader, null);
            nIMessageRouterReturnStatus = this.isLocalDestination(nIMessageRouterAddress) ? this.sendToLocalNode(nIMessageHeader, object) : this.sendToRemoteNode(nIMessageRouterAddress, nIMessage, object);
        }
        return nIMessageRouterReturnStatus;
    }

    protected synchronized NIMessageRouterReturnStatus sendWait(NIMessageRouterAddress nIMessageRouterAddress) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        NIMessageState nIMessageState = new NIMessageState(this.getProcessChannelID());
        NIMessageTable.getMessageTable().add(nIMessageState);
        nIMessageRouterReturnStatus = this.sendImplementation(nIMessageRouterAddress, 0, nIMessageState.getMessageID());
        return nIMessageRouterReturnStatus;
    }

    protected synchronized Object readObject() throws Exception {
        return this.outputStream.read();
    }

    protected int getProcessChannelID() {
        return this.processChannelID;
    }

    protected synchronized void close() throws IOException {
    }

    private NIMessageRouterReturnStatus sendToRemoteNode(NIMessageRouterAddress nIMessageRouterAddress, NIMessage nIMessage, int n) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        try {
            Serializable serializable = (Serializable)this.outputStream.read();
            while (serializable != null) {
                nIMessage.setMessage(serializable);
                nIMessageRouterReturnStatus = this.sendRemoteMessage(nIMessageRouterAddress, nIMessage);
                --n;
                serializable = (Serializable)this.outputStream.read();
            }
            if (n != 0) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-7);
            }
        }
        catch (InterruptedException interruptedException) {
            logger.throwable((Throwable)interruptedException);
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-17);
        }
        catch (NIMessageRouterException nIMessageRouterException) {
            logger.error("NIMR Exception  " + nIMessageRouterException.getMRErrorMessage() + "  " + nIMessageRouterAddress);
            logger.throwable((Throwable)nIMessageRouterException);
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(nIMessageRouterException.getMRErrorValue());
        }
        this.outputStream.clear();
        return nIMessageRouterReturnStatus;
    }

    private NIMessageRouterReturnStatus sendToRemoteNode(NIMessageRouterAddress nIMessageRouterAddress, NIMessage nIMessage, Object object) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        try {
            nIMessage.setMessage((Serializable)object);
            nIMessageRouterReturnStatus = this.sendRemoteMessage(nIMessageRouterAddress, nIMessage);
        }
        catch (NIMessageRouterException nIMessageRouterException) {
            logger.error("NIMR Exception  " + nIMessageRouterException.getMRErrorMessage() + "  " + nIMessageRouterAddress);
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(nIMessageRouterException.getMRErrorValue());
        }
        return nIMessageRouterReturnStatus;
    }

    private NIMessageRouterReturnStatus sendRemoteMessage(NIMessageRouterAddress nIMessageRouterAddress, NIMessage nIMessage) throws NIMessageRouterException {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-6);
        NIRoutingTableEntry nIRoutingTableEntry = NIRoutingTable.getRoutingTable().get(nIMessageRouterAddress.getEssServerName());
        if (nIRoutingTableEntry == null) {
            throw new NIMessageRouterException(-3);
        }
        nIMessageRouterReturnStatus = NIMessageRouterConnectionMonitor.getConnectionMonitor().writeMessage(nIRoutingTableEntry, nIMessage);
        if (nIMessageRouterReturnStatus.getStatus() != 9 && nIMessage.getMessageHeader().getMessageType() != 99) {
            logger.warning("First attempt failed to send remote message to " + nIMessageRouterAddress + " message: " + nIMessage + ", failure status= " + nIMessageRouterReturnStatus.getStatus());
            if (NIMessageRouterMetaData.areBackupNetworkInterfacesActive()) {
                nIMessageRouterReturnStatus = NIMessageRouterConnectionMonitor.getConnectionMonitor().writeMessage(nIRoutingTableEntry, nIMessage);
                if (nIMessageRouterReturnStatus.getStatus() != 9) {
                    logger.warning("Second attempt failed to send remote message to " + nIMessageRouterAddress + " message: " + nIMessage + ", failure status= " + nIMessageRouterReturnStatus.getStatus());
                    nIMessageRouterReturnStatus = this.sendToAlternateNode(nIMessageRouterAddress, nIMessage, nIRoutingTableEntry);
                    if (nIMessageRouterReturnStatus.getStatus() != 9) {
                        logger.warning("Second alt node paths failed to " + nIMessageRouterAddress + " message: " + nIMessage + ", failure status= " + nIMessageRouterReturnStatus.getStatus());
                    }
                }
            } else {
                int n = nIMessage.getMessageHeader().getDestinationAddress().getProcessChannelID();
                if (n != 666) {
                    if (NIAgentProperties.getAgentType() == 4) {
                        boolean bl = nIMessageRouterAddress.getEssServerName().startsWith("HMC");
                        if (bl) {
                            String string = nIMessageRouterAddress.getEssServerName();
                            boolean bl2 = string.equals("HMC1");
                            String string2 = bl2 ? "HMC2" : "HMC1";
                            nIMessage.getMessageHeader().getDestinationAddress().setServerName(string2);
                            nIRoutingTableEntry = NIRoutingTable.getRoutingTable().get(string2);
                            if (nIRoutingTableEntry != null) {
                                nIMessageRouterReturnStatus = NIMessageRouterConnectionMonitor.getConnectionMonitor().writeMessage(nIRoutingTableEntry, nIMessage);
                            }
                            if (nIMessageRouterReturnStatus.getStatus() != 9) {
                                logger.warning("Unable to re-route " + nIMessage + " through alternate MC");
                                nIMessage.getMessageHeader().getDestinationAddress().setServerName(string);
                                nIMessageRouterReturnStatus = NIMessageRouterConnectionMonitor.getConnectionMonitor().writeMessage(nIMessage);
                                if (nIMessageRouterReturnStatus.getStatus() != 9) {
                                    logger.error(" Unable to send the data back through alternate Kona");
                                } else {
                                    logger.debug_general(" sent the response data back through alternate Kona");
                                }
                            }
                        }
                    } else if (NIAgentProperties.is1750() && NIAgentProperties.isMC() && !nIMessageRouterAddress.getEssServerName().startsWith("HMC")) {
                        String string = nIMessageRouterAddress.getEssServerName();
                        String string3 = string.endsWith("0") ? string.substring(0, string.length() - 1) + "1" : string.substring(0, string.length() - 1) + "0";
                        nIRoutingTableEntry = NIRoutingTable.getRoutingTable().get(string3);
                        if (nIRoutingTableEntry != null) {
                            nIMessageRouterReturnStatus = NIMessageRouterConnectionMonitor.getConnectionMonitor().writeMessage(nIRoutingTableEntry, nIMessage);
                            if (nIMessageRouterReturnStatus.getStatus() == 9) {
                                logger.debug_general("Message sent through alternate kona");
                            } else {
                                logger.warning("Unable to re-route through alternate kona.");
                            }
                        }
                    }
                }
            }
        }
        return nIMessageRouterReturnStatus;
    }

    private NIMessageRouterReturnStatus sendToAlternateNode(NIMessageRouterAddress nIMessageRouterAddress, NIMessage nIMessage, NIRoutingTableEntry nIRoutingTableEntry) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
        if (this.isDestinationNonLocalHMC(nIMessageRouterAddress)) {
            NIRoutingTableEntry nIRoutingTableEntry2 = this.getAlternateRoutingTableEntry(nIRoutingTableEntry);
            if (nIRoutingTableEntry2 == null) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-6);
            } else {
                logger.debug_general("Send message " + nIMessage + " to alternate HMC " + nIRoutingTableEntry2.getEssServerName());
                nIMessage.getMessageHeader().setDestinationAddress(nIRoutingTableEntry2.getEssServerName());
                nIMessageRouterReturnStatus = NIMessageRouterConnectionMonitor.getConnectionMonitor().writeMessage(nIRoutingTableEntry2, nIMessage);
            }
        }
        logger.debug_general("Send message " + nIMessage + " through alternate HMC, return status = " + nIMessageRouterReturnStatus.getStatus());
        return nIMessageRouterReturnStatus;
    }

    private NIRoutingTableEntry getAlternateRoutingTableEntry(NIRoutingTableEntry nIRoutingTableEntry) {
        NIDomainGroup nIDomainGroup = NIDomainGroupTable.getDomainGroupTable().get(nIRoutingTableEntry.getDomainGroupID());
        if (nIDomainGroup == null) {
            return null;
        }
        Enumeration enumeration = nIDomainGroup.enumeration();
        while (enumeration.hasMoreElements()) {
            NIRoutingTableEntry nIRoutingTableEntry2 = NIRoutingTable.getRoutingTable().get((String)enumeration.nextElement());
            if (nIRoutingTableEntry2.getEssServerName().compareTo(NIMessageRouterMetaData.getEssServerName()) == 0) continue;
            return nIRoutingTableEntry2;
        }
        return null;
    }

    private NIMessageRouterReturnStatus sendToLocalNode(NIMessageHeader nIMessageHeader, int n) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        try {
            NIMessageRouterChannel nIMessageRouterChannel = NIProcessChannelTable.getProcessChannelTable().get(nIMessageHeader.getDestinationAddress().getProcessChannelID());
            if (nIMessageRouterChannel == null) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-3);
            } else {
                NIMessageRouterInputStream nIMessageRouterInputStream = nIMessageRouterChannel.getNIMessageRouterInputStream();
                nIMessageRouterInputStream.open();
                Object object = this.outputStream.read();
                while (object != null) {
                    nIMessageRouterInputStream.writeObject(object);
                    object = this.outputStream.read();
                    --n;
                }
                if (n != 0) {
                    nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-7);
                }
            }
        }
        catch (NICircularBufferOverflowException nICircularBufferOverflowException) {
            logger.throwable((Throwable)nICircularBufferOverflowException);
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
        }
        catch (InterruptedException interruptedException) {
            logger.throwable((Throwable)interruptedException);
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-17);
        }
        this.outputStream.clear();
        return nIMessageRouterReturnStatus;
    }

    private NIMessageRouterReturnStatus sendToLocalNode(NIMessageHeader nIMessageHeader, Object object) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus;
        block4: {
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
            try {
                NIMessageRouterChannel nIMessageRouterChannel = NIProcessChannelTable.getProcessChannelTable().get(nIMessageHeader.getDestinationAddress().getProcessChannelID());
                if (nIMessageRouterChannel == null) {
                    nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-3);
                    break block4;
                }
                NIMessageRouterInputStream nIMessageRouterInputStream = nIMessageRouterChannel.getNIMessageRouterInputStream();
                nIMessageRouterInputStream.open();
                nIMessageRouterInputStream.writeObject(object);
            }
            catch (NICircularBufferOverflowException nICircularBufferOverflowException) {
                logger.throwable((Throwable)nICircularBufferOverflowException);
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
            }
            catch (InterruptedException interruptedException) {
                logger.throwable((Throwable)interruptedException);
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-17);
            }
        }
        return nIMessageRouterReturnStatus;
    }

    private boolean isLocalDestination(NIMessageRouterAddress nIMessageRouterAddress) {
        boolean bl = false;
        if (nIMessageRouterAddress.getEssServerName().length() == 0 || nIMessageRouterAddress.getEssServerName().compareTo(NIMessageRouterMetaData.getEssServerName()) == 0) {
            bl = true;
        } else if (NIMessageRouterMetaData.getGroupDomainID().compareTo("HMC") == 0 && nIMessageRouterAddress.getEssServerName().compareTo("HMC") == 0) {
            bl = true;
        }
        return bl;
    }

    private boolean isDestinationNonLocalHMC(NIMessageRouterAddress nIMessageRouterAddress) {
        boolean bl = false;
        if (!this.isLocalDestination(nIMessageRouterAddress) && NIMessageRouterMetaData.getGroupDomainID().compareTo("HMC") != 0) {
            if (nIMessageRouterAddress.getEssServerName().compareTo("HMC") == 0) {
                bl = true;
            } else {
                NIRoutingTableEntry nIRoutingTableEntry = NIRoutingTable.getRoutingTable().get(nIMessageRouterAddress.getEssServerName());
                if (nIRoutingTableEntry != null && nIRoutingTableEntry.getDomainGroupID().compareTo("HMC") != 0) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

