/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.olc;

import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIConfigResult;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.iou.NIEscrow;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseManager;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseSchemaHelper;
import com.ibm.storage.ess.ni.results.NIConfigCreatedResultImpl;
import com.ibm.storage.ess.ni.results.NIConfigQueryResultImpl;
import java.util.ArrayList;
import java.util.List;

public class NIOlcCommon {
    public static NIOlcCommon c = new NIOlcCommon();
    public static final String INVALID_ESSID = "invalid ess id";
    public static final String NOT_SUPPORTED = "This feature is not supported by the OLC";

    private NIOlcCommon() {
    }

    public NIConfigResult handleConfig(NIResourceID nIResourceID, NIEscrow nIEscrow, boolean bl) {
        return bl ? this.acceptConfig(nIResourceID, nIEscrow) : this.failConfig(nIResourceID, nIEscrow, 1L);
    }

    public NIConfigResult failConfig(NIResourceID nIResourceID, NIEscrow nIEscrow, long l) {
        nIEscrow.close(new NIConfigCreatedResultImpl(nIResourceID, false, l));
        return (NIConfigResult)((Object)nIEscrow.issueIou());
    }

    public NIConfigResult acceptConfig(NIResourceID nIResourceID, NIEscrow nIEscrow) {
        nIEscrow.close(new NIConfigCreatedResultImpl(nIResourceID, true, 0L));
        return (NIConfigResult)((Object)nIEscrow.issueIou());
    }

    public NIConfigResult failConfig(NIResourceID nIResourceID, long l) {
        return new NIConfigCreatedResultImpl(nIResourceID, false, l);
    }

    public NIConfigResult acceptConfig(NIResourceID nIResourceID) {
        return new NIConfigCreatedResultImpl(nIResourceID, true, 0L);
    }

    public NIConfigResult handleConfig(NIResourceID nIResourceID, boolean bl) {
        return bl ? this.acceptConfig(nIResourceID) : this.failConfig(nIResourceID, 2L);
    }

    public NIConfigQueryResult handleQuery(List list, NIEscrow nIEscrow) {
        nIEscrow.close(new NIConfigQueryResultImpl(list, true, 0L));
        return (NIConfigQueryResult)((Object)nIEscrow.issueIou());
    }

    public NIConfigQueryResult handleFailedQuery(long l, NIEscrow nIEscrow) {
        nIEscrow.close(new NIConfigQueryResultImpl(new ArrayList(), false, l));
        return (NIConfigQueryResult)((Object)nIEscrow.issueIou());
    }

    public static String getDatabase(NIESSID nIESSID) {
        if (nIESSID == null || nIESSID.getStorageFacility() == null || nIESSID.getStorageFacility().getStoragePlex() == null || nIESSID.getStorageFacility().getStoragePlex().getEnterprise() == null || nIESSID.getStorageFacility().getStoragePlex().getEnterprise().getDatabase() == null) {
            return INVALID_ESSID;
        }
        return nIESSID.getStorageFacility().getStoragePlex().getEnterprise().getDatabase();
    }

    public static NIOlcDatabaseSchemaHelper getDatabaseHelper(NIESSID nIESSID) {
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = null;
        String string = NIOlcCommon.getDatabase(nIESSID);
        if (!string.equals(INVALID_ESSID) && !NIOlcCommon.essExists(nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string), nIESSID)) {
            nIOlcDatabaseSchemaHelper.release();
            nIOlcDatabaseSchemaHelper = null;
        }
        return nIOlcDatabaseSchemaHelper;
    }

    public static String getRealDatabaseName(String string) {
        return string.substring(1);
    }

    private static boolean essExists(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NIESSID nIESSID) {
        List list = nIOlcDatabaseSchemaHelper.getEssByID(new NIESSID[]{nIESSID});
        return list.size() != 0;
    }
}

