/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.olc;

import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public abstract class NIOlcDatabaseHelper {
    public static final String CONSTRAINTS_ENABLED = "SET CONSTRAINTS ALL ENABLED";
    public static final String CONSTRAINTS_DISABLED = "SET CONSTRAINTS ALL DISABLED";
    protected static Map INSERT_DML = new HashMap();
    protected static Map UPDATE_DML = new HashMap();
    protected static Map SELECT_DML = new HashMap();
    protected static Map DELETE_DML = new HashMap();
    protected Map INSERT_PS = new HashMap();
    protected Map SELECT_PS = new HashMap();
    protected Map UPDATE_PS = new HashMap();
    protected Map DELETE_PS = new HashMap();
    protected Map INSERT_PS_MAP = new HashMap();
    protected Map SELECT_PS_MAP = new HashMap();
    protected Map UPDATE_PS_MAP = new HashMap();
    protected Map DELETE_PS_MAP = new HashMap();
    static int enumCounter = 0;
    protected static final Integer INSERT_PLEX = new Integer(enumCounter++);
    protected static final Integer INSERT_FACILITY = new Integer(enumCounter++);
    protected static final Integer INSERT_ESS = new Integer(enumCounter++);
    protected static final Integer INSERT_ARRAYSITE = new Integer(enumCounter++);
    protected static final Integer INSERT_IOPORT = new Integer(enumCounter++);
    protected static final Integer INSERT_ADDRGROUP = new Integer(enumCounter++);
    protected static final Integer INSERT_HOSTPORT = new Integer(enumCounter++);
    protected static final Integer INSERT_EXTENT_POOL = new Integer(enumCounter++);
    protected static final Integer INSERT_LSS = new Integer(enumCounter++);
    protected static final Integer INSERT_ARRAY = new Integer(enumCounter++);
    protected static final Integer INSERT_RANK = new Integer(enumCounter++);
    protected static final Integer INSERT_VOLUME_GROUP = new Integer(enumCounter++);
    protected static final Integer INSERT_ENCLOSURE = new Integer(enumCounter++);
    protected static final Integer INSERT_FRU = new Integer(enumCounter++);
    protected static final Integer UPDATE_PLEX = new Integer(enumCounter++);
    protected static final Integer UPDATE_FACILITY = new Integer(enumCounter++);
    protected static final Integer UPDATE_ESS = new Integer(enumCounter++);
    protected static final Integer UPDATE_ARRAYSITE = new Integer(enumCounter++);
    protected static final Integer UPDATE_IOPORT = new Integer(enumCounter++);
    protected static final Integer UPDATE_HOSTPORT = new Integer(enumCounter++);
    protected static final Integer UPDATE_EXTENT_POOL = new Integer(enumCounter++);
    protected static final Integer UPDATE_LSS = new Integer(enumCounter++);
    protected static final Integer UPDATE_ARRAY = new Integer(enumCounter++);
    protected static final Integer UPDATE_RANK = new Integer(enumCounter++);
    protected static final Integer UPDATE_ADDRGROUP = new Integer(enumCounter++);
    protected static final Integer UPDATE_VOLUME_GROUP = new Integer(enumCounter++);
    protected static final Integer UPDATE_LSSVOLUMESET = new Integer(enumCounter++);
    protected static final Integer SELECT_PLEX = new Integer(enumCounter++);
    protected static final Integer SELECT_PLEXES = new Integer(enumCounter++);
    protected static final Integer SELECT_FACILITY_A = new Integer(enumCounter++);
    protected static final Integer SELECT_FACILITY_B = new Integer(enumCounter++);
    protected static final Integer SELECT_FACILITY_C = new Integer(enumCounter++);
    protected static final Integer SELECT_FACILITY_D = new Integer(enumCounter++);
    protected static final Integer SELECT_ESS_A = new Integer(enumCounter++);
    protected static final Integer SELECT_ESS_B = new Integer(enumCounter++);
    protected static final Integer SELECT_ESS_C = new Integer(enumCounter++);
    protected static final Integer SELECT_ESS_D = new Integer(enumCounter++);
    protected static final Integer SELECT_ARRAYSITE_A = new Integer(enumCounter++);
    protected static final Integer SELECT_ARRAYSITE_B = new Integer(enumCounter++);
    protected static final Integer SELECT_IOPORT_A = new Integer(enumCounter++);
    protected static final Integer SELECT_IOPORT_B = new Integer(enumCounter++);
    protected static final Integer SELECT_ADDRGRP_A = new Integer(enumCounter++);
    protected static final Integer SELECT_ADDRGRP_B = new Integer(enumCounter++);
    protected static final Integer SELECT_LSS_A = new Integer(enumCounter++);
    protected static final Integer SELECT_LSS_B = new Integer(enumCounter++);
    protected static final Integer SELECT_LSS_C1 = new Integer(enumCounter++);
    protected static final Integer SELECT_LSS_C2 = new Integer(enumCounter++);
    protected static final Integer SELECT_ARRAY_A = new Integer(enumCounter++);
    protected static final Integer SELECT_ARRAY_B = new Integer(enumCounter++);
    protected static final Integer SELECT_RANK_A = new Integer(enumCounter++);
    protected static final Integer SELECT_RANK_B = new Integer(enumCounter++);
    protected static final Integer SELECT_RANK_C = new Integer(enumCounter++);
    protected static final Integer SELECT_SPOOL_A = new Integer(enumCounter++);
    protected static final Integer SELECT_SPOOL_B = new Integer(enumCounter++);
    protected static final Integer SELECT_SPOOL_C = new Integer(enumCounter++);
    protected static final Integer SELECT_VOLGRP_A = new Integer(enumCounter++);
    protected static final Integer SELECT_VOLGRP_B = new Integer(enumCounter++);
    protected static final Integer SELECT_VOLUMES_A = new Integer(enumCounter++);
    protected static final Integer SELECT_VOLUMES_D = new Integer(enumCounter++);
    protected static final Integer SELECT_VOLUMES_E1 = new Integer(enumCounter++);
    protected static final Integer SELECT_VOLUMES_E2 = new Integer(enumCounter++);
    protected static final Integer SELECT_VOLUMES_G = new Integer(enumCounter++);
    protected static final Integer SELECT_HOSTPORTS_A = new Integer(enumCounter++);
    protected static final Integer SELECT_HOSTPORTS_B = new Integer(enumCounter++);
    protected static final Integer SELECT_HOSTPORTS_C = new Integer(enumCounter++);
    protected static final Integer SELECT_HOSTPORTS_D = new Integer(enumCounter++);
    protected static final Integer SELECT_ENCLOSURES = new Integer(enumCounter++);
    protected static final Integer SELECT_ENCLOSURE_A = new Integer(enumCounter++);
    protected static final Integer SELECT_FRUS = new Integer(enumCounter++);
    protected static final Integer SELECT_LSSVOLUMESET = new Integer(enumCounter++);
    protected static final Integer DELETE_PLEX = new Integer(enumCounter++);
    protected static final Integer DELETE_FACILITY = new Integer(enumCounter++);
    protected static final Integer DELETE_ESS = new Integer(enumCounter++);
    protected static final Integer DELETE_HOSTPORT = new Integer(enumCounter++);
    protected static final Integer DELETE_EXTENT_POOL = new Integer(enumCounter++);
    protected static final Integer DELETE_LSS = new Integer(enumCounter++);
    protected static final Integer DELETE_ARRAY = new Integer(enumCounter++);
    protected static final Integer DELETE_RANK = new Integer(enumCounter++);
    protected static final Integer DELETE_ADDRGROUP = new Integer(enumCounter++);
    protected static final Integer DELETE_VOLUME_GROUP = new Integer(enumCounter++);
    protected static final Integer DELETE_FRU_BY_ESS = new Integer(enumCounter++);
    protected static final Integer DELETE_IOPORTS_BY_ESS = new Integer(enumCounter++);
    protected static final Integer DELETE_ENCLOSURE_BY_ESS = new Integer(enumCounter++);
    protected static final Integer DELETE_VOLUME_GROUP_BY_ESS = new Integer(enumCounter++);
    protected static final Integer DELETE_HOSTPORT_BY_ESS = new Integer(enumCounter++);
    protected static final Integer DELETE_LSS_BY_ESS = new Integer(enumCounter++);
    protected static final Integer DELETE_RANKS_BY_ESS = new Integer(enumCounter++);
    protected static final Integer DELETE_ADDRESSGROUPS_BY_ESS = new Integer(enumCounter++);
    protected static final Integer DELETE_ARRAYS_BY_ESS = new Integer(enumCounter++);
    protected static final Integer DELETE_ARRAYSITES_BY_ESS = new Integer(enumCounter++);
    protected static final Integer DELETE_EXTENTPOOLS_BY_ESS = new Integer(enumCounter++);
    protected Connection conn;
    protected Statement stmt;
    protected String strDatabase;
    protected int key;
    protected boolean available = true;

    protected NIOlcDatabaseHelper(Connection connection, String string) {
        this.conn = connection;
        try {
            this.conn.setTransactionIsolation(8);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.strDatabase = string;
        this.stmt = this.createStatement();
    }

    protected abstract boolean generateSchema();

    protected abstract void prepareAllStatements();

    public final void setConstraints(String string) {
        this.executeUpdate(this.stmt, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Connection connection = this.conn;
        synchronized (connection) {
            try {
                this.stmt.close();
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.stmt = null;
            this.conn = null;
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getDatabaseName() {
        return this.strDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement createStatement() {
        Statement statement = null;
        Connection connection = this.conn;
        synchronized (connection) {
            try {
                statement = this.conn.createStatement();
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String string) {
        PreparedStatement preparedStatement = null;
        Connection connection = this.conn;
        synchronized (connection) {
            try {
                return this.conn.prepareStatement(string, 1);
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(Statement statement, String string) {
        ResultSet resultSet = null;
        Connection connection = this.conn;
        synchronized (connection) {
            try {
                resultSet = string == null ? ((PreparedStatement)statement).executeQuery() : statement.executeQuery(string);
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
        }
        return resultSet;
    }

    public ResultSet executeQuery(Statement statement) {
        return this.executeQuery(statement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(Statement statement, String string) {
        int n = 0;
        Connection connection = this.conn;
        synchronized (connection) {
            try {
                n = string == null ? ((PreparedStatement)statement).executeUpdate() : statement.executeUpdate(string, 1);
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
                n = -1;
            }
        }
        return n;
    }

    public int executeUpdate(Statement statement) {
        return this.executeUpdate(statement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(Statement statement) {
        int n = -1;
        Connection connection = this.conn;
        synchronized (connection) {
            try {
                ResultSet resultSet = statement.getGeneratedKeys();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
        }
        this.key = n;
    }

    public int getKey() {
        return this.key;
    }

    public synchronized NIOlcDatabaseHelper getInstance() {
        while (!this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.available = false;
        this.cancelXA();
        return this;
    }

    public synchronized void release() {
        this.available = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginXA() {
        Connection connection = this.conn;
        synchronized (connection) {
            try {
                this.conn.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitXA() {
        boolean bl = true;
        Connection connection = this.conn;
        synchronized (connection) {
            try {
                this.conn.commit();
                this.conn.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelXA() {
        Connection connection = this.conn;
        synchronized (connection) {
            try {
                this.conn.rollback();
                this.conn.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
                return false;
            }
        }
        return true;
    }

    static {
        INSERT_DML.put(INSERT_PLEX, "INSERT INTO Plexes(object) VALUES(?)");
        INSERT_DML.put(INSERT_FACILITY, "INSERT INTO Facilities(plex_id,object) VALUES(?,?)");
        INSERT_DML.put(INSERT_ESS, "INSERT INTO ESS(facility_id,object) VALUES(?,?)");
        INSERT_DML.put(INSERT_ARRAYSITE, "INSERT INTO ArraySites(ess_id,object) VALUES(?,?)");
        INSERT_DML.put(INSERT_IOPORT, "INSERT INTO IOPorts(ess_id,object) VALUES(?,?)");
        INSERT_DML.put(INSERT_ADDRGROUP, "INSERT INTO AddressGroups(ess_id,object) VALUES(?,?)");
        INSERT_DML.put(INSERT_HOSTPORT, "INSERT INTO SCSIHostPorts(ess_id,object) VALUES(?,?)");
        INSERT_DML.put(INSERT_EXTENT_POOL, "INSERT INTO ExtentPools(ess_id,object) VALUES(?,?)");
        INSERT_DML.put(INSERT_LSS, "INSERT INTO LSS(ess_id, lss_id, object, volumes) VALUES(?, ?, ?, ?)");
        INSERT_DML.put(INSERT_ARRAY, "INSERT INTO Arrays(ess_id,object) VALUES(?,?)");
        INSERT_DML.put(INSERT_RANK, "INSERT INTO Ranks(ess_id,object) VALUES(?,?)");
        INSERT_DML.put(INSERT_VOLUME_GROUP, "INSERT INTO VolumeGroups(ess_id,object) VALUES(?,?)");
        INSERT_DML.put(INSERT_ENCLOSURE, "INSERT INTO StorageEnclosures(ess_id,object) VALUES(?,?)");
        INSERT_DML.put(INSERT_FRU, "INSERT INTO StorageDeviceFRUs(enclosure_id,object) VALUES(?,?)");
        UPDATE_DML.put(UPDATE_PLEX, "UPDATE Plexes SET object = ? WHERE plex_id=?");
        UPDATE_DML.put(UPDATE_FACILITY, "UPDATE Facilities SET object = ? WHERE plex_id=? AND CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID).equals(?)");
        UPDATE_DML.put(UPDATE_ESS, "UPDATE ESS SET object = ? WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        UPDATE_DML.put(UPDATE_ARRAYSITE, "UPDATE ArraySites SET object = ? WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIArraySiteID).equals(?)");
        UPDATE_DML.put(UPDATE_IOPORT, "UPDATE IOPorts SET object = ? WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIIOPortID).equals(?)");
        UPDATE_DML.put(UPDATE_HOSTPORT, "UPDATE SCSIHostPorts SET object = ? WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID).equals(?)");
        UPDATE_DML.put(UPDATE_EXTENT_POOL, "UPDATE ExtentPools SET object = ? WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIExtentPoolID).equals(?)");
        UPDATE_DML.put(UPDATE_LSS, "UPDATE LSS SET object = ? WHERE CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).equals(?)");
        UPDATE_DML.put(UPDATE_LSSVOLUMESET, "UPDATE LSS SET volumes = ? WHERE CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).equals(?)");
        UPDATE_DML.put(UPDATE_ARRAY, "UPDATE Arrays SET object = ? WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIArrayID).equals(?)");
        UPDATE_DML.put(UPDATE_RANK, "UPDATE Ranks SET object = ? WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIRankID).equals(?)");
        UPDATE_DML.put(UPDATE_ADDRGROUP, "UPDATE AddressGroups SET object = ? WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIAddressGroupID).equals(?)");
        UPDATE_DML.put(UPDATE_VOLUME_GROUP, "UPDATE VolumeGroups SET object = ? WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID).equals(?)");
        SELECT_DML.put(SELECT_PLEX, "SELECT object FROM Plexes WHERE plex_id=?");
        SELECT_DML.put(SELECT_PLEXES, "SELECT object FROM Plexes");
        SELECT_DML.put(SELECT_FACILITY_A, "SELECT object FROM Facilities WHERE plex_id=?");
        SELECT_DML.put(SELECT_FACILITY_B, "SELECT object FROM Facilities WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID).equals(?)");
        SELECT_DML.put(SELECT_FACILITY_C, "SELECT facility_id FROM Facilities WHERE CAST(Facilities.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID).equals(?)");
        SELECT_DML.put(SELECT_FACILITY_D, "SELECT object FROM Facilities");
        SELECT_DML.put(SELECT_ESS_A, "SELECT ESS.object FROM ESS, Facilities WHERE ESS.facility_id=Facilities.facility_id AND Facilities.plex_id=?");
        SELECT_DML.put(SELECT_ESS_B, "SELECT object FROM ESS WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        SELECT_DML.put(SELECT_ESS_C, "SELECT ESS.object FROM ESS, Facilities WHERE ESS.facility_id=Facilities.facility_id AND CAST(Facilities.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID).equals(?)");
        SELECT_DML.put(SELECT_ESS_D, "SELECT ess_id FROM ESS WHERE CAST(object.getID() as com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        SELECT_DML.put(SELECT_ARRAYSITE_A, "SELECT ArraySites.object FROM ArraySites, ESS WHERE ArraySites.ess_id=ESS.ess_id AND CAST(ESS.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        SELECT_DML.put(SELECT_ARRAYSITE_B, "SELECT object FROM ArraySites WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIArraySiteID).equals(?) AND CAST(object.getID() as com.ibm.storage.ess.ni.identifiers.NIArraySiteID).getESS().equals(?)");
        SELECT_DML.put(SELECT_IOPORT_A, "SELECT IOPorts.object FROM IOPorts, ESS WHERE IOPorts.ess_id=ESS.ess_id AND CAST(ESS.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        SELECT_DML.put(SELECT_IOPORT_B, "SELECT IOPorts.object FROM IOPorts WHERE CAST(IOPorts.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIIOPortID).equals(?) AND CAST(IOPorts.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIIOPortID).getESS().equals(?)");
        SELECT_DML.put(SELECT_ADDRGRP_A, "SELECT AddressGroups.object FROM AddressGroups, ESS WHERE AddressGroups.ess_id=ESS.ess_id AND CAST(ESS.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        SELECT_DML.put(SELECT_ADDRGRP_B, "SELECT object FROM AddressGroups WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIAddressGroupID).equals(?) AND CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIAddressGroupID).getESS().equals(?)");
        SELECT_DML.put(SELECT_LSS_A, "SELECT object FROM LSS WHERE CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).getESS().equals(?)");
        SELECT_DML.put(SELECT_LSS_B, "SELECT object FROM LSS WHERE CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).equals(?)");
        SELECT_DML.put(SELECT_LSSVOLUMESET, "SELECT LSS.volumes FROM LSS WHERE CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).equals(?)");
        SELECT_DML.put(SELECT_LSS_C1, "SELECT LSS.object FROM LSS WHERE CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).getESS().equals(?) AND LSS.object.getDeviceType() INSTANCEOF com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD");
        SELECT_DML.put(SELECT_LSS_C2, "SELECT LSS.object FROM LSS WHERE CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).getESS().equals(?) AND LSS.object.getDeviceType() INSTANCEOF com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB");
        SELECT_DML.put(SELECT_ARRAY_A, "SELECT Arrays.object FROM Arrays, ESS WHERE Arrays.ess_id=ESS.ess_id AND (CAST(ESS.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID)).equals(?)");
        SELECT_DML.put(SELECT_ARRAY_B, "SELECT object FROM Arrays WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIArrayID).equals(?)");
        SELECT_DML.put(SELECT_RANK_A, "SELECT Ranks.object FROM Ranks, ESS WHERE Ranks.ess_id=ESS.ess_id AND CAST(ESS.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        SELECT_DML.put(SELECT_RANK_B, "SELECT object FROM Ranks WHERE object.getExtentPoolID().equals(?)");
        SELECT_DML.put(SELECT_RANK_C, "SELECT object FROM Ranks WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIRankID).equals(?)");
        SELECT_DML.put(SELECT_SPOOL_A, "SELECT ExtentPools.object FROM ExtentPools, ESS WHERE ExtentPools.ess_id=ESS.ess_id AND CAST(ESS.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        SELECT_DML.put(SELECT_SPOOL_B, "SELECT object FROM ExtentPools WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIExtentPoolID).equals(?)");
        SELECT_DML.put(SELECT_SPOOL_C, "SELECT extentpool_id FROM ExtentPools WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIExtentPoolID).equals(?)");
        SELECT_DML.put(SELECT_VOLUMES_A, "SELECT volumes FROM LSS WHERE CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).getESS().equals(?)");
        SELECT_DML.put(SELECT_VOLUMES_D, "SELECT volumes FROM LSS WHERE CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).equals(?)");
        SELECT_DML.put(SELECT_VOLUMES_E1, "SELECT volumes FROM LSS WHERE CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).getESS().equals(?) AND LSS.object.getDeviceType() INSTANCEOF com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD");
        SELECT_DML.put(SELECT_VOLUMES_E2, "SELECT volumes FROM LSS WHERE CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).getESS().equals(?) AND LSS.object.getDeviceType() INSTANCEOF com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB");
        SELECT_DML.put(SELECT_VOLUMES_G, "SELECT volumes FROM LSS WHERE CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).getESS().equals(?) AND CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).getLSSGroupID = ? ");
        SELECT_DML.put(SELECT_HOSTPORTS_A, "SELECT SCSIHostPorts.object FROM SCSIHostPorts, ESS WHERE SCSIHostPorts.ess_id=ESS.ess_id AND CAST(ESS.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        SELECT_DML.put(SELECT_HOSTPORTS_B, "SELECT SCSIHostPorts.object FROM SCSIHostPorts, ESS WHERE SCSIHostPorts.object.getUserHostName() = ? AND (CAST(ESS.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID)).equals(?)");
        SELECT_DML.put(SELECT_HOSTPORTS_C, "SELECT SCSIHostPorts.object FROM SCSIHostPorts, ESS WHERE (CAST(SCSIHostPorts.object.getID() AS com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID)).equals(?) AND (CAST(ESS.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID)).equals(?)");
        SELECT_DML.put(SELECT_HOSTPORTS_D, "SELECT object FROM SCSIHostPorts WHERE (CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID)).getESS().equals(?) AND object.getWWPN()=?");
        SELECT_DML.put(SELECT_ENCLOSURES, "SELECT StorageEnclosures.object FROM StorageEnclosures, ESS WHERE StorageEnclosures.ess_id=ESS.ess_id AND CAST(ESS.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        SELECT_DML.put(SELECT_ENCLOSURE_A, "SELECT enclosure_id FROM StorageEnclosures WHERE object.getEnclosureNumber()=? AND CAST(object.getID().getESS() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        SELECT_DML.put(SELECT_FRUS, "SELECT StorageDeviceFRUs.object FROM StorageDeviceFRUs, StorageEnclosures, ESS WHERE StorageDeviceFRUs.enclosure_id=StorageEnclosures.enclosure_id AND StorageEnclosures.ess_id=ESS.ess_id AND CAST(ESS.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        SELECT_DML.put(SELECT_VOLGRP_A, "SELECT VolumeGroups.object FROM VolumeGroups, ESS WHERE VolumeGroups.ess_id=ESS.ess_id AND CAST(ESS.object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        SELECT_DML.put(SELECT_VOLGRP_B, "SELECT object FROM VolumeGroups WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID).equals(?)");
        DELETE_DML.put(DELETE_PLEX, "DELETE FROM Plexes WHERE plex_id=?");
        DELETE_DML.put(DELETE_FACILITY, "DELETE FROM Facilities WHERE plex_id=? AND CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID).equals(?)");
        DELETE_DML.put(DELETE_ESS, "DELETE FROM ESS WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        DELETE_DML.put(DELETE_HOSTPORT, "DELETE FROM SCSIHostPorts WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID).equals(?)");
        DELETE_DML.put(DELETE_EXTENT_POOL, "DELETE FROM ExtentPools WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIExtentPoolID).equals(?)");
        DELETE_DML.put(DELETE_LSS, "DELETE FROM LSS WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NILSSID).equals(?)");
        DELETE_DML.put(DELETE_ARRAY, "DELETE FROM Arrays WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIArrayID).equals(?)");
        DELETE_DML.put(DELETE_RANK, "DELETE FROM Ranks WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIRankID).equals(?)");
        DELETE_DML.put(DELETE_ADDRGROUP, "DELETE FROM AddressGroups WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIAddressGroupID).equals(?)");
        DELETE_DML.put(DELETE_VOLUME_GROUP, "DELETE FROM VolumeGroups WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID).equals(?)");
        DELETE_DML.put(DELETE_FRU_BY_ESS, "DELETE FROM StorageDeviceFrus WHERE CAST(object.getID().getESS() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        DELETE_DML.put(DELETE_ENCLOSURE_BY_ESS, "DELETE FROM StorageEnclosures WHERE CAST(object.getID().getESS() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        DELETE_DML.put(DELETE_VOLUME_GROUP_BY_ESS, "DELETE FROM VolumeGroups WHERE CAST(object.getID().getESS() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        DELETE_DML.put(DELETE_HOSTPORT_BY_ESS, "DELETE FROM SCSIHostPorts WHERE CAST(object.getID().getESS() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        DELETE_DML.put(DELETE_RANKS_BY_ESS, "DELETE FROM Ranks WHERE CAST(object.getID().getESS() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        DELETE_DML.put(DELETE_LSS_BY_ESS, "DELETE FROM LSS WHERE CAST(LSS.lss_id AS com.ibm.storage.ess.ni.identifiers.NILSSID).getESS().equals(?)");
        DELETE_DML.put(DELETE_IOPORTS_BY_ESS, "DELETE FROM IOPorts WHERE CAST(object.getID().getESS() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        DELETE_DML.put(DELETE_EXTENTPOOLS_BY_ESS, "DELETE FROM ExtentPools WHERE CAST(object.getID().getESS() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        DELETE_DML.put(DELETE_ARRAYSITES_BY_ESS, "DELETE FROM ArraySites WHERE CAST(object.getID().getESS() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        DELETE_DML.put(DELETE_ARRAYS_BY_ESS, "DELETE FROM Arrays WHERE CAST(object.getID().getESS() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
        DELETE_DML.put(DELETE_ADDRESSGROUPS_BY_ESS, "DELETE FROM AddressGroups WHERE CAST(object.getID().getESS() AS com.ibm.storage.ess.ni.identifiers.NIESSID).equals(?)");
    }
}

