/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.olc;

import com.ibm.storage.ess.ni.application.NIServicesInfo;
import com.ibm.storage.ess.ni.application.resource.NIArraySiteConfiguration;
import com.ibm.storage.ess.ni.application.resource.NIDDMPack;
import com.ibm.storage.ess.ni.application.resource.NIPortMask;
import com.ibm.storage.ess.ni.application.resource.NIResourceFactory;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupVolumeList;
import com.ibm.storage.ess.ni.application.resource.NIVolumeMap;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.identifiers.NIAddressGroupID;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIEnclosureID;
import com.ibm.storage.ess.ni.identifiers.NIEnterpriseID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NIFRUID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.identifiers.NIStoragePlexID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseManager;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseMasterHelper;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseSchemaHelper;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model3;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model6;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUTypeBS2000;
import com.ibm.storage.ess.ni.option.config.NIDataType;
import com.ibm.storage.ess.ni.option.config.NIDataType3380;
import com.ibm.storage.ess.ni.option.config.NIDataType3390;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock512;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Protected;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Unprotected;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB;
import com.ibm.storage.ess.ni.option.config.NIESSStateOnline;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.option.config.NIFabricTopology;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyFCArbitratedLoop;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyFicon;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyScsiFcp;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyScsiFcpFicon;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyUnknown;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import com.ibm.storage.ess.ni.option.config.NIRaidType10;
import com.ibm.storage.ess.ni.option.config.NIRaidType5;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupType;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeCopyServices;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconMixedMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520All;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Mask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMap256;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMixedMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeType;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDBase;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDCrossCUAlias;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDMap;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDSingleCuAlias;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockBase;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockMap;
import com.ibm.storage.ess.ni.resource.NIAddressGroupImpl;
import com.ibm.storage.ess.ni.resource.NIArrayImpl;
import com.ibm.storage.ess.ni.resource.NIArraySiteImpl;
import com.ibm.storage.ess.ni.resource.NIDDMPackImpl;
import com.ibm.storage.ess.ni.resource.NIESCONPortImpl;
import com.ibm.storage.ess.ni.resource.NIESSImpl;
import com.ibm.storage.ess.ni.resource.NIEnterpriseImpl;
import com.ibm.storage.ess.ni.resource.NIExtentPoolImpl;
import com.ibm.storage.ess.ni.resource.NIFibreChannelPortImpl;
import com.ibm.storage.ess.ni.resource.NIIOPortImpl;
import com.ibm.storage.ess.ni.resource.NILSSImpl;
import com.ibm.storage.ess.ni.resource.NILSSVolumeSetImpl;
import com.ibm.storage.ess.ni.resource.NIRankImpl;
import com.ibm.storage.ess.ni.resource.NISCSIHostPortImpl;
import com.ibm.storage.ess.ni.resource.NIStorageDeviceFRUImpl;
import com.ibm.storage.ess.ni.resource.NIStorageEnclosureImpl;
import com.ibm.storage.ess.ni.resource.NIStorageFacilityImpl;
import com.ibm.storage.ess.ni.resource.NIStoragePlexImpl;
import com.ibm.storage.ess.ni.resource.NIVolumeGroupImpl;
import com.ibm.storage.ess.ni.resource.NIVolumeImpl;
import com.ibm.storage.ess.ni.util.NIByteArray;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class NIOlcDatabaseXml
extends DefaultHandler {
    public final int NULL = -1;
    private Locator locator = null;
    private NIEnterpriseImpl curEnterprise;
    private ArrayList storagePlexIDs = new ArrayList();
    private ArrayList arrayRefs = new ArrayList();
    private ArrayList volumeRefs = new ArrayList();
    private NIStoragePlexID curStoragePlexID;
    private NIStorageFacilityImpl curStorageFacility;
    private NIESSID curEssID;
    private NIRankImpl curRank;
    private NIExtentPoolImpl curExtentPool;
    private NIVolumeGroupImpl curVolumeGroup;
    private String strDatabaseName;
    private NISCSIHostPortImpl curSCSIHost;
    private HashMap volumeExtentMap = new HashMap();
    private HashMap diskSerialMap = new HashMap();
    private HashMap lssVolumeSet = new HashMap();
    private NIOlcDatabaseMasterHelper masterHelper;
    private NIOlcDatabaseSchemaHelper dbHelper;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU;

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("Enterprise")) {
            this.createEnterprise(attributes);
        } else if (string3.equals("StoragePlex")) {
            this.createStoragePlex(attributes);
        } else if (string3.equals("StorageFacility")) {
            this.createStorageFacility(attributes);
        } else if (string3.equals("ESS")) {
            this.createESS(attributes);
        } else if (string3.equals("ArraySite")) {
            this.createArraySite(attributes);
        } else if (string3.equals("IOPort")) {
            this.createIOPort(attributes);
        } else if (string3.equals("LSS")) {
            this.createLSS(attributes);
        } else if (string3.equals("Array")) {
            this.createArray(attributes);
        } else if (string3.equals("Rank")) {
            this.createRank(attributes);
        } else if (string3.equals("ArrayRef")) {
            this.createArrayRef(attributes);
        } else if (string3.equals("ExtentPool")) {
            this.createExtentPool(attributes);
        } else if (string3.equals("Volume")) {
            this.createVolume(attributes);
        } else if (string3.equals("SCSIHostPort")) {
            this.createSCSIHostPort(attributes);
        } else if (string3.equals("StorageEnclosure")) {
            this.createStorageEnclosure(attributes);
        } else if (string3.equals("StorageDeviceFRU")) {
            this.createStorageDeviceFRU(attributes);
        } else if (string3.equals("VolumeGroup")) {
            this.createVolumeGroup(attributes);
        } else if (string3.equals("AddressGroup")) {
            this.createAddressGroup(attributes);
        } else if (string3.equals("VolumeRef")) {
            this.createVolumeRef(attributes);
        } else if (string3.equals("ExtentsByVol")) {
            this.createUsedExtentsHashMap(attributes);
        } else {
            System.out.print("tag not recognized");
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        Serializable serializable;
        Object object2;
        if (string3.equals("Enterprise")) {
            this.curEnterprise.setStoragePlexes(this.storagePlexIDs.toArray(new NIStoragePlexID[0]));
            this.masterHelper.modifyEnterprise(this.curEnterprise);
            object2 = this.diskSerialMap.keySet().iterator();
            while (object2.hasNext()) {
                serializable = (NIArraySiteID)object2.next();
                object = (ArrayList)this.dbHelper.getArraySitesByID(new NIArraySiteID[]{serializable});
                if (object.size() <= 0) continue;
                NIArraySiteImpl nIArraySiteImpl = (NIArraySiteImpl)object.get(0);
                ArrayList arrayList = (ArrayList)this.diskSerialMap.get(serializable);
                nIArraySiteImpl.setDiskSerialNumbers(arrayList.toArray(new String[0]));
                this.dbHelper.modifyArraySite(nIArraySiteImpl);
            }
            this.dbHelper.release();
            this.dbHelper.setConstraints("SET CONSTRAINTS ALL ENABLED");
        }
        if (string3.equals("Rank")) {
            this.curRank.setArrayIDs(this.arrayRefs.toArray(new NIArrayID[0]));
            this.curRank.setVolumeMap(this.volumeExtentMap);
            this.dbHelper.modifyRank(this.curRank);
            this.arrayRefs.clear();
            this.volumeExtentMap.clear();
        }
        if (string3.equals("ESS")) {
            object2 = this.lssVolumeSet.keySet().iterator();
            while (object2.hasNext()) {
                serializable = (NILSSID)object2.next();
                object = (NIVolumeID[])this.lssVolumeSet.get(serializable);
                this.dbHelper.modifyLSSVolumeSet((NILSSID)serializable, (NILSSVolumeSetImpl)object);
            }
            this.lssVolumeSet.clear();
        }
        if (string3.equals("StorageFacility")) {
            object2 = this.getDDMPacks().toArray(new NIDDMPackImpl[0]);
            this.curStorageFacility.setDDMPacks((NIDDMPack[])object2);
            if (this.curEssID.getType().equals("1750")) {
                serializable = new NIStorageFacilityID(this.curEssID, this.curStoragePlexID);
                this.curStorageFacility.setID((NIResourceID)serializable);
            }
            this.dbHelper.modifyStorageFacility(this.curStorageFacility);
        }
        if (string3.equals("VolumeGroup")) {
            object2 = this.curVolumeGroup.getType();
            serializable = null;
            object = this.volumeRefs.toArray(new NIVolumeID[0]);
            try {
                serializable = NIResourceFactory.newVolumeGroupVolumeList((NIVolumeID[])object, (NIVolumeGroupType)object2);
            }
            catch (NIParameterInvalidServerException nIParameterInvalidServerException) {
                serializable = NIResourceFactory.newVolumeGroupVolumeList((NIVolumeGroupType)object2);
                NIOlcLogger.severe("Failed to create the volume group list", nIParameterInvalidServerException);
            }
            this.curVolumeGroup.setVolumeGroupList((NIVolumeGroupVolumeList)serializable);
            this.dbHelper.modifyVolumeGroup(this.curVolumeGroup);
            this.volumeRefs.clear();
        }
    }

    public static boolean writeToXMLFile(NIEnterpriseID nIEnterpriseID, OutputStreamWriter outputStreamWriter) {
        String string;
        String string2 = string = "    ";
        String string3 = string2 + string;
        String string4 = string3 + string;
        String string5 = string4 + string;
        String string6 = string5 + string;
        boolean bl = true;
        String string7 = nIEnterpriseID.getDatabase();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string7);
        NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
        try {
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            outputStreamWriter.flush();
            NIEnterpriseImpl nIEnterpriseImpl = (NIEnterpriseImpl)nIOlcDatabaseMasterHelper.getEnterprise(nIEnterpriseID);
            outputStreamWriter.write("\n" + nIEnterpriseImpl.toXml());
            outputStreamWriter.flush();
            ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getStoragePlexes((NIEnterpriseID)nIEnterpriseImpl.getID());
            int n = 0;
            while (n < arrayList.size()) {
                NIStoragePlexImpl nIStoragePlexImpl = (NIStoragePlexImpl)arrayList.get(n);
                outputStreamWriter.write("\n" + string2 + nIStoragePlexImpl.toXml());
                outputStreamWriter.flush();
                ArrayList arrayList2 = (ArrayList)nIOlcDatabaseSchemaHelper.getFacilityByPlex((NIStoragePlexID)nIStoragePlexImpl.getID());
                int n2 = 0;
                while (n2 < arrayList2.size()) {
                    NIStorageFacilityImpl nIStorageFacilityImpl = (NIStorageFacilityImpl)arrayList2.get(n2);
                    outputStreamWriter.write("\n" + string3 + nIStorageFacilityImpl.toXml());
                    outputStreamWriter.flush();
                    ArrayList arrayList3 = (ArrayList)nIOlcDatabaseSchemaHelper.getEssByFacility((NIStorageFacilityID)nIStorageFacilityImpl.getID());
                    int n3 = 0;
                    while (n3 < arrayList3.size()) {
                        Serializable serializable;
                        Cloneable cloneable;
                        Object object;
                        Cloneable cloneable2;
                        Cloneable cloneable3;
                        Cloneable cloneable4;
                        Cloneable cloneable5;
                        Cloneable cloneable6;
                        Cloneable cloneable7;
                        NIESSImpl nIESSImpl = (NIESSImpl)arrayList3.get(n3);
                        outputStreamWriter.write("\n" + string4 + nIESSImpl.toXml());
                        outputStreamWriter.flush();
                        ArrayList arrayList4 = (ArrayList)nIOlcDatabaseSchemaHelper.getArraySitesByESS((NIESSID)nIESSImpl.getID());
                        int n4 = 0;
                        while (n4 < arrayList4.size()) {
                            cloneable7 = (NIArraySiteImpl)arrayList4.get(n4);
                            outputStreamWriter.write("\n" + string5 + ((NIArraySiteImpl)cloneable7).toXml());
                            outputStreamWriter.flush();
                            ++n4;
                        }
                        cloneable7 = (ArrayList)nIOlcDatabaseSchemaHelper.getPorts((NIESSID)nIESSImpl.getID());
                        int n5 = 0;
                        while (n5 < ((ArrayList)cloneable7).size()) {
                            cloneable6 = (NIIOPortImpl)((ArrayList)cloneable7).get(n5);
                            outputStreamWriter.write("\n" + string5 + ((NIIOPortImpl)cloneable6).toXml());
                            outputStreamWriter.flush();
                            ++n5;
                        }
                        cloneable6 = (ArrayList)nIOlcDatabaseSchemaHelper.getAddressGroupsByESS((NIESSID)nIESSImpl.getID());
                        int n6 = 0;
                        while (n6 < ((ArrayList)cloneable6).size()) {
                            cloneable5 = (NIAddressGroupImpl)((ArrayList)cloneable6).get(n6);
                            outputStreamWriter.write("\n" + string5 + ((NIAddressGroupImpl)cloneable5).toXml());
                            outputStreamWriter.flush();
                            ++n6;
                        }
                        cloneable5 = (ArrayList)nIOlcDatabaseSchemaHelper.getLogicalSubsystemsByESS((NIESSID)nIESSImpl.getID());
                        int n7 = 0;
                        while (n7 < ((ArrayList)cloneable5).size()) {
                            cloneable4 = (NILSSImpl)((ArrayList)cloneable5).get(n7);
                            outputStreamWriter.write("\n" + string5 + ((NILSSImpl)cloneable4).toXml());
                            outputStreamWriter.flush();
                            ++n7;
                        }
                        cloneable4 = (ArrayList)nIOlcDatabaseSchemaHelper.getArraysByESS((NIESSID)nIESSImpl.getID());
                        int n8 = 0;
                        while (n8 < ((ArrayList)cloneable4).size()) {
                            cloneable3 = (NIArrayImpl)((ArrayList)cloneable4).get(n8);
                            outputStreamWriter.write("\n" + string5 + ((NIArrayImpl)cloneable3).toXml());
                            outputStreamWriter.flush();
                            ++n8;
                        }
                        cloneable3 = (ArrayList)nIOlcDatabaseSchemaHelper.getRanksByESS((NIESSID)nIESSImpl.getID());
                        int n9 = 0;
                        while (n9 < ((ArrayList)cloneable3).size()) {
                            cloneable2 = (NIRankImpl)((ArrayList)cloneable3).get(n9);
                            outputStreamWriter.write("\n" + string5 + ((NIRankImpl)cloneable2).toXml());
                            outputStreamWriter.flush();
                            NIArrayID[] nIArrayIDArray = ((NIRankImpl)cloneable2).getArrayIDs();
                            int n10 = 0;
                            while (n10 < nIArrayIDArray.length) {
                                outputStreamWriter.write("\n" + string6 + "<ArrayRef arrayNumber=\"" + nIArrayIDArray[n10].getArrayNumber() + "\" />");
                                outputStreamWriter.flush();
                                ++n10;
                            }
                            HashMap hashMap = ((NIRankImpl)cloneable2).getVolumeMap();
                            object = hashMap.keySet().iterator();
                            while (object.hasNext()) {
                                NIVolumeID nIVolumeID = (NIVolumeID)object.next();
                                int n11 = (Integer)hashMap.get(nIVolumeID);
                                NILSSID nILSSID = nIVolumeID.getLSS();
                                outputStreamWriter.write("\n" + string6 + "<ExtentsByVol lssNumber=\"" + nILSSID.getLSSNumber() + "\" " + "numExtentsUsed=\"" + n11 + "\" " + "volumeNumber=\"" + nIVolumeID.getVolNumber() + "\" />");
                                outputStreamWriter.flush();
                            }
                            outputStreamWriter.write("\n" + string5 + "</Rank>");
                            outputStreamWriter.flush();
                            ++n9;
                        }
                        cloneable2 = (ArrayList)nIOlcDatabaseSchemaHelper.getExtentPoolsByESS((NIESSID)nIESSImpl.getID());
                        int n12 = 0;
                        while (n12 < ((ArrayList)cloneable2).size()) {
                            NIExtentPoolImpl nIExtentPoolImpl = (NIExtentPoolImpl)((ArrayList)cloneable2).get(n12);
                            outputStreamWriter.write("\n" + string5 + nIExtentPoolImpl.toXml());
                            outputStreamWriter.flush();
                            ++n12;
                        }
                        ArrayList arrayList5 = (ArrayList)nIOlcDatabaseSchemaHelper.getVolumesByESS((NIESSID)nIESSImpl.getID());
                        int n13 = 0;
                        while (n13 < arrayList5.size()) {
                            object = (NIVolumeImpl)arrayList5.get(n13);
                            outputStreamWriter.write("\n" + string5 + ((NIVolumeImpl)object).toXml());
                            outputStreamWriter.flush();
                            ++n13;
                        }
                        object = (ArrayList)nIOlcDatabaseSchemaHelper.getScsiHostPortsByESS((NIESSID)nIESSImpl.getID());
                        int n14 = 0;
                        while (n14 < ((ArrayList)object).size()) {
                            NISCSIHostPortImpl nISCSIHostPortImpl = (NISCSIHostPortImpl)((ArrayList)object).get(n14);
                            outputStreamWriter.write("\n" + string5 + nISCSIHostPortImpl.toXml());
                            outputStreamWriter.flush();
                            outputStreamWriter.write("\n" + string5 + "</SCSIHostPort>");
                            outputStreamWriter.flush();
                            ++n14;
                        }
                        ArrayList arrayList6 = (ArrayList)nIOlcDatabaseSchemaHelper.getStorageEnclosures((NIESSID)nIESSImpl.getID());
                        int n15 = 0;
                        while (n15 < arrayList6.size()) {
                            cloneable = (NIStorageEnclosureImpl)arrayList6.get(n15);
                            outputStreamWriter.write("\n" + string5 + ((NIStorageEnclosureImpl)cloneable).toXml());
                            outputStreamWriter.flush();
                            ArrayList arrayList7 = (ArrayList)nIOlcDatabaseSchemaHelper.getStorageDeviceFRUs((NIESSID)nIESSImpl.getID());
                            int n16 = 0;
                            while (n16 < arrayList7.size()) {
                                serializable = (NIStorageDeviceFRUImpl)arrayList7.get(n16);
                                if (((NIStorageEnclosureImpl)cloneable).getEnclosureNumber() == ((NIStorageDeviceFRUImpl)serializable).getEnclosureNumber()) {
                                    outputStreamWriter.write("\n" + string6 + ((NIStorageDeviceFRUImpl)serializable).toXml());
                                    outputStreamWriter.flush();
                                }
                                ++n16;
                            }
                            outputStreamWriter.write("\n" + string5 + "</StorageEnclosure>");
                            outputStreamWriter.flush();
                            ++n15;
                        }
                        cloneable = (ArrayList)nIOlcDatabaseSchemaHelper.getVolumeGroupsByESS((NIESSID)nIESSImpl.getID());
                        int n17 = 0;
                        while (n17 < ((ArrayList)cloneable).size()) {
                            NIVolumeGroupImpl nIVolumeGroupImpl = (NIVolumeGroupImpl)((ArrayList)cloneable).get(n17);
                            outputStreamWriter.write("\n" + string5 + nIVolumeGroupImpl.toXml());
                            outputStreamWriter.flush();
                            serializable = nIVolumeGroupImpl.getVolumeMap();
                            NIVolumeID[] nIVolumeIDArray = ((NIVolumeMap)serializable).toArray();
                            int n18 = 0;
                            while (n18 < nIVolumeIDArray.length) {
                                outputStreamWriter.write("\n" + string6 + "<VolumeRef volumeNumber=\"" + nIVolumeIDArray[n18].getVolNumber() + "\" lssNumber=\"" + nIVolumeIDArray[n18].getLSS().getLSSNumber() + "\" />");
                                outputStreamWriter.flush();
                                ++n18;
                            }
                            outputStreamWriter.write("\n" + string5 + "</VolumeGroup>");
                            outputStreamWriter.flush();
                            ++n17;
                        }
                        outputStreamWriter.write("\n" + string4 + "</ESS>");
                        outputStreamWriter.flush();
                        ++n3;
                    }
                    outputStreamWriter.write("\n" + string3 + "</StorageFacility>");
                    outputStreamWriter.flush();
                    ++n2;
                }
                outputStreamWriter.write("\n" + string2 + "</StoragePlex>");
                outputStreamWriter.flush();
                ++n;
            }
            outputStreamWriter.write("\n</Enterprise>");
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            NIOlcLogger.info("error writing xml file");
            bl = false;
        }
        nIOlcDatabaseSchemaHelper.release();
        return bl;
    }

    private boolean createEnterprise(Attributes attributes) {
        NIOlcLogger.info("creating enterprise in xml");
        boolean bl = true;
        boolean bl2 = true;
        this.strDatabaseName = "";
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        String string = attributesImpl.getValue("userName");
        String string2 = attributesImpl.getValue("userID");
        String string3 = attributesImpl.getValue("zPrivate");
        String string4 = attributesImpl.getValue("dateCreated");
        String string5 = attributesImpl.getValue("versionLastModified");
        String string6 = attributesImpl.getValue("versionCreated");
        bl = this.getBoolValue(string3);
        this.strDatabaseName = "$" + string;
        NIEnterpriseImpl nIEnterpriseImpl = (NIEnterpriseImpl)NIResourceFactory.newEnterprise(string, string2, bl);
        nIEnterpriseImpl.setDateCreated(string4);
        nIEnterpriseImpl.setVersionCreated(string6);
        nIEnterpriseImpl.setVersionLastModified(string5);
        nIEnterpriseImpl.setOlcVersion("1.0");
        this.masterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
        bl2 &= NIOlcDatabaseManager.dropDatabase(string);
        NIOlcDatabaseManager.removeDatabase(string);
        bl2 &= NIOlcDatabaseManager.dropDatabase(this.strDatabaseName);
        if (this.masterHelper.getEnterpriseByDatabase(string) != null) {
            bl2 &= this.masterHelper.deleteEnterpriseByDatabase(string);
        }
        this.curEnterprise = nIEnterpriseImpl;
        bl2 = this.masterHelper.insertEnterprise(nIEnterpriseImpl, string);
        this.dbHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(this.strDatabaseName);
        this.dbHelper.setConstraints("SET CONSTRAINTS ALL DISABLED");
        NIEnterpriseID nIEnterpriseID = new NIEnterpriseID(this.masterHelper.getKey(), this.strDatabaseName);
        nIEnterpriseImpl.setID(nIEnterpriseID);
        return bl2;
    }

    private boolean createStoragePlex(Attributes attributes) {
        NIStoragePlexID nIStoragePlexID;
        NIOlcLogger.info("creating storage plex in xml");
        boolean bl = false;
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("id"));
        String string = attributesImpl.getValue("userDescription");
        String string2 = attributesImpl.getValue("userName");
        String string3 = attributesImpl.getValue("serverAddress1");
        String string4 = attributesImpl.getValue("serverAddress2");
        String string5 = attributesImpl.getValue("online");
        bl = this.getBoolValue(string5);
        NIStoragePlexID nIStoragePlexID2 = new NIStoragePlexID(n, (NIEnterpriseID)this.curEnterprise.getID());
        NIStoragePlexImpl nIStoragePlexImpl = new NIStoragePlexImpl(nIStoragePlexID2, bl, string2, string);
        try {
            nIStoragePlexImpl.setServicesInfo(new NIServicesInfo(InetAddress.getByName(string3), InetAddress.getByName(string4)));
        }
        catch (UnknownHostException unknownHostException) {
            NIOlcLogger.severe("Could not resolve host name", unknownHostException);
        }
        boolean bl2 = this.dbHelper.insertStoragePlex(nIStoragePlexImpl);
        this.curStoragePlexID = nIStoragePlexID = new NIStoragePlexID(this.dbHelper.getKey(), (NIEnterpriseID)this.curEnterprise.getID());
        this.storagePlexIDs.add(nIStoragePlexID);
        nIStoragePlexImpl.setID(nIStoragePlexID);
        return bl2 &= this.dbHelper.modifyStoragePlex(nIStoragePlexImpl);
    }

    private boolean createStorageFacility(Attributes attributes) {
        NIOlcLogger.info("creating storage facility in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("numEthernet"));
        int n2 = this.getIntValue(attributesImpl.getValue("numFibreChannelShortWave"));
        int n3 = this.getIntValue(attributesImpl.getValue("numFibreChannelLongWave"));
        int n4 = this.getIntValue(attributesImpl.getValue("numESS"));
        int n5 = this.getIntValue(attributesImpl.getValue("numEscon"));
        long l = this.getLongValue(attributesImpl.getValue("wwnn"));
        String string = attributesImpl.getValue("model");
        String string2 = attributesImpl.getValue("type");
        String string3 = attributesImpl.getValue("userName");
        String string4 = attributesImpl.getValue("userDescription");
        String string5 = attributesImpl.getValue("sequence");
        NIStorageFacilityID nIStorageFacilityID = new NIStorageFacilityID(string2, "AZ", string5, l, this.curStoragePlexID);
        NIStorageFacilityImpl nIStorageFacilityImpl = new NIStorageFacilityImpl(nIStorageFacilityID, string, string3, string4, null);
        nIStorageFacilityImpl.setNumFibreChannelShortWave(n2);
        nIStorageFacilityImpl.setNumFibreChannelLongWave(n3);
        nIStorageFacilityImpl.setNumEthernet(n);
        nIStorageFacilityImpl.setNumESS(n4);
        nIStorageFacilityImpl.setNumEscon(n5);
        boolean bl = this.dbHelper.insertStorageFacility(nIStorageFacilityImpl, this.curStoragePlexID);
        this.curStorageFacility = nIStorageFacilityImpl;
        return bl;
    }

    private boolean createESS(Attributes attributes) {
        NIOlcLogger.info("creating ESS in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("imageNumber"));
        String string = attributesImpl.getValue("userDescription");
        String string2 = attributesImpl.getValue("userName");
        String string3 = attributesImpl.getValue("machineSignature");
        NIESSID nIESSID = new NIESSID((NIStorageFacilityID)this.curStorageFacility.getID(), n);
        NIESSImpl nIESSImpl = new NIESSImpl(nIESSID, string2, string, this.curStorageFacility.getModel());
        nIESSImpl.setState(NIESSStateOnline.Option);
        if (string3 != null && !string3.equals("")) {
            nIESSImpl.setMachineSignature(string3);
        }
        boolean bl = this.dbHelper.insertEss(nIESSImpl);
        this.curEssID = nIESSID;
        return bl;
    }

    private boolean createArraySite(Attributes attributes) {
        NIOlcLogger.info("creating arraySite in xml");
        String[] stringArray = new String[]{""};
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("number"));
        int n2 = this.getIntValue(attributesImpl.getValue("arrayNumber"));
        int n3 = this.getIntValue(attributesImpl.getValue("diskCapacity"));
        int n4 = this.getIntValue(attributesImpl.getValue("arrayPosition"));
        int n5 = this.getIntValue(attributesImpl.getValue("diskClass"));
        int n6 = this.getIntValue(attributesImpl.getValue("arraySiteStatus"));
        int n7 = this.getIntValue(attributesImpl.getValue("deviceAdapterPair"));
        int n8 = this.getIntValue(attributesImpl.getValue("diskRPM"));
        int n9 = this.getIntValue(attributesImpl.getValue("requiredSpares"));
        int n10 = this.getIntValue(attributesImpl.getValue("dualLoop"));
        long l = this.getLongValue(attributesImpl.getValue("diskInterfaceRate"));
        String string = attributesImpl.getValue("diskInterfaceType");
        NIArraySiteID nIArraySiteID = new NIArraySiteID(this.curEssID, n);
        NIArrayID nIArrayID = null;
        if (n2 != -1) {
            nIArrayID = new NIArrayID(this.curEssID, n2);
        }
        NIArraySiteImpl nIArraySiteImpl = new NIArraySiteImpl(nIArraySiteID, nIArrayID, stringArray, n7, n3, n8, string, l, n5, n9, n6, n4, n10);
        boolean bl = this.dbHelper.insertArraySite(nIArraySiteImpl);
        return bl;
    }

    private boolean createIOPort(Attributes attributes) {
        int n;
        NIOlcLogger.info("creating IOPort in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n2 = this.getIntValue(attributesImpl.getValue("id"));
        int n3 = this.getIntValue(attributesImpl.getValue("interfaceId"));
        int n4 = this.getIntValue(attributesImpl.getValue("state"));
        int n5 = this.getIntValue(attributesImpl.getValue("portSpeed"));
        long l = this.getLongValue(attributesImpl.getValue("wwpn"));
        String string = attributesImpl.getValue("portType");
        String string2 = attributesImpl.getValue("location");
        NIIOPortID nIIOPortID = new NIIOPortID(this.curEssID, n2);
        NIIOPortImpl nIIOPortImpl = null;
        if (string.equals("10")) {
            n = this.getIntValue(attributesImpl.getValue("destinationAddress"));
            int n6 = this.getIntValue(attributesImpl.getValue("addressGroupNumber"));
            int n7 = this.getIntValue(attributesImpl.getValue("volumeGroupNumber"));
            int n8 = this.getIntValue(attributesImpl.getValue("portGroupID"));
            n8 = n8 == -1 ? 0 : n8;
            NIVolumeGroupID nIVolumeGroupID = n7 == -1 ? null : new NIVolumeGroupID(this.curEssID, n7);
            NIAddressGroupID nIAddressGroupID = n6 == -1 ? null : new NIAddressGroupID(this.curEssID, n6);
            nIIOPortImpl = new NIESCONPortImpl(nIIOPortID, string2, Integer.parseInt(string), n5, n4, nIAddressGroupID, nIVolumeGroupID, n3, n8);
            ((NIESCONPortImpl)nIIOPortImpl).setDestinationAddress(n);
        } else if (string.equals("21") || string.equals("20") || string.equals("22")) {
            n = this.getIntValue(attributesImpl.getValue("destinationID"));
            int n9 = this.getIntValue(attributesImpl.getValue("volumeGroupNumber"));
            int n10 = this.getIntValue(attributesImpl.getValue("portMaskBitIndex"));
            String string3 = attributesImpl.getValue("topology");
            NIFabricTopology nIFabricTopology = null;
            try {
                nIFabricTopology = string3.equals("FCArbitratedLoop") ? NIFabricTopologyFCArbitratedLoop.Option : (string3.equals("Ficon") ? NIFabricTopologyFicon.Option : (string3.equals("ScsiFcp") ? NIFabricTopologyScsiFcp.Option : (string3.equals("ScsiFcpFicon") ? NIFabricTopologyScsiFcpFicon.Option : NIFabricTopologyUnknown.Option)));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            NIVolumeGroupID nIVolumeGroupID = n9 == -1 ? null : new NIVolumeGroupID(this.curEssID, n9);
            nIIOPortImpl = new NIFibreChannelPortImpl(nIIOPortID, string2, Integer.parseInt(string), n5, l, n4, 0, nIVolumeGroupID, n10, nIFabricTopology, n3);
            ((NIFibreChannelPortImpl)nIIOPortImpl).setDestinationID(n);
        }
        n = nIIOPortImpl != null ? (int)(this.dbHelper.insertIOPort(nIIOPortImpl) ? 1 : 0) : 0;
        return n != 0;
    }

    private boolean createAddressGroup(Attributes attributes) {
        NIOlcLogger.info("creating address group in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("number"));
        int n2 = this.getIntValue(attributesImpl.getValue("numConfiguredVolumes"));
        int n3 = this.getIntValue(attributesImpl.getValue("numLogicalSubsystem"));
        int n4 = this.getIntValue(attributesImpl.getValue("baseLogicalVolumeNumber"));
        int n5 = this.getIntValue(attributesImpl.getValue("numLogicalVolumeNumbers"));
        String string = attributesImpl.getValue("deviceType");
        NIDeviceType nIDeviceType = string.equals("FB") ? NIDeviceTypeFB.Option : NIDeviceTypeCKD.Option;
        NIAddressGroupID nIAddressGroupID = new NIAddressGroupID(this.curEssID, n);
        NIAddressGroupImpl nIAddressGroupImpl = new NIAddressGroupImpl(nIAddressGroupID, nIDeviceType, n4, n5, n3, n2);
        boolean bl = this.dbHelper.insertAddressGroup(nIAddressGroupImpl);
        return bl;
    }

    private boolean createLSS(Attributes attributes) {
        NIOlcLogger.info("creating LSS in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("number"));
        int n2 = this.getIntValue(attributesImpl.getValue("ssid"));
        int n3 = this.getIntValue(attributesImpl.getValue("addressGroupNumber"));
        int n4 = this.getIntValue(attributesImpl.getValue("configuredDevices"));
        String string = attributesImpl.getValue("deviceType");
        String string2 = attributesImpl.getValue("cuBaseType");
        if (n2 == -1) {
            n2 = 0;
        }
        NIDeviceType nIDeviceType = string.equals("FB") ? NIDeviceTypeFB.Option : NIDeviceTypeCKD.Option;
        NICKDBaseCUType nICKDBaseCUType = null;
        if (string2.equals("3990M3")) {
            nICKDBaseCUType = NICKDBaseCUType3990Model3.Option;
        } else if (string2.equals("3990M3TPF")) {
            nICKDBaseCUType = NICKDBaseCUType3990Model3.Option;
        } else if (string2.equals("3990M6")) {
            nICKDBaseCUType = NICKDBaseCUType3990Model6.Option;
        } else if (string2.equals("BS2000")) {
            nICKDBaseCUType = NICKDBaseCUTypeBS2000.Option;
        }
        NILSSID nILSSID = new NILSSID(this.curEssID, n, n2);
        NIAddressGroupID nIAddressGroupID = n == -1 ? null : new NIAddressGroupID(this.curEssID, n3);
        NILSSImpl nILSSImpl = (NILSSImpl)NIResourceFactory.newLSS(this.curEssID, n, n2, nIDeviceType, nICKDBaseCUType);
        nILSSImpl.setAddressGroupID(nIAddressGroupID);
        nILSSImpl.setConfiguredDevices(n4);
        this.lssVolumeSet.put(nILSSID, new NILSSVolumeSetImpl());
        boolean bl = this.dbHelper.insertLSS(nILSSImpl, new NILSSVolumeSetImpl());
        return bl;
    }

    private boolean createArray(Attributes attributes) {
        NIOlcLogger.info("creating array in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("number"));
        int n2 = this.getIntValue(attributesImpl.getValue("arraySite"));
        int n3 = this.getIntValue(attributesImpl.getValue("arraySite2"));
        int n4 = this.getIntValue(attributesImpl.getValue("diskRPM"));
        int n5 = this.getIntValue(attributesImpl.getValue("diskClass"));
        int n6 = this.getIntValue(attributesImpl.getValue("diskInterfaceRate"));
        int n7 = this.getIntValue(attributesImpl.getValue("diskCapacity"));
        int n8 = this.getIntValue(attributesImpl.getValue("rankNumber"));
        int n9 = this.getIntValue(attributesImpl.getValue("rankPosition"));
        int n10 = this.getIntValue(attributesImpl.getValue("dataState"));
        int n11 = this.getIntValue(attributesImpl.getValue("arrayStatus"));
        int n12 = this.getIntValue(attributesImpl.getValue("deviceAdapterPairID"));
        String string = attributesImpl.getValue("raidType");
        String string2 = attributesImpl.getValue("serialNumber");
        String string3 = attributesImpl.getValue("configuration");
        String string4 = attributesImpl.getValue("diskInterfaceType");
        int n13 = 0;
        int n14 = 0;
        if (string3.equals("3")) {
            n13 = 2;
            n14 = 0;
        } else if (string3.equals("4")) {
            n13 = 0;
            n14 = 0;
        } else if (string3.equals("6")) {
            n13 = 1;
            n14 = 1;
        } else if (string3.equals("7")) {
            n13 = 0;
            n14 = 1;
        }
        NIArraySiteConfiguration nIArraySiteConfiguration = null;
        NIArraySiteConfiguration[] nIArraySiteConfigurationArray = null;
        int n15 = n3 == -1 && ((NIStorageFacilityID)this.curStorageFacility.getID()).getType().equals("1750") ? 4 : 8;
        nIArraySiteConfiguration = new NIArraySiteConfiguration(n15, n13, n14);
        nIArraySiteConfigurationArray = new NIArraySiteConfiguration[]{nIArraySiteConfiguration};
        NIRaidType nIRaidType = string.equals("raid5") ? NIRaidType5.Option : NIRaidType10.Option;
        NIArraySiteID nIArraySiteID = n2 == -1 ? null : new NIArraySiteID(this.curEssID, n2);
        NIArraySiteID nIArraySiteID2 = n3 == -1 ? null : new NIArraySiteID(this.curEssID, n3);
        NIRankID nIRankID = n8 == -1 ? null : new NIRankID(this.curEssID, n8);
        NIArrayID nIArrayID = new NIArrayID(this.curEssID, n);
        NIArrayImpl nIArrayImpl = nIArraySiteID2 != null ? (NIArrayImpl)NIResourceFactory.newArray(new NIArraySiteID[]{nIArraySiteID, nIArraySiteID2}, nIRaidType) : (NIArrayImpl)NIResourceFactory.newArray(nIArraySiteID, nIRaidType);
        nIArrayImpl.setDeviceAdapterPairID(n12);
        nIArrayImpl.setDataState(n10);
        nIArrayImpl.setDiskCapacity(n7);
        nIArrayImpl.setDiskInterfaceRate(n6);
        nIArrayImpl.setDiskInterfaceType(string4);
        nIArrayImpl.setDiskRPM(n4);
        nIArrayImpl.setDiskClass(n5);
        nIArrayImpl.setID(nIArrayID);
        nIArrayImpl.setRankID(nIRankID);
        nIArrayImpl.setRankPosition(n9);
        nIArrayImpl.setSerialNumber(string2);
        nIArrayImpl.setArrayStatus(n11);
        nIArrayImpl.setArraySiteConfiguration(nIArraySiteConfigurationArray);
        boolean bl = this.dbHelper.insertArray(nIArrayImpl);
        return bl;
    }

    private boolean createRank(Attributes attributes) {
        NIOlcLogger.info("creating rank in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("number"));
        int n2 = this.getIntValue(attributesImpl.getValue("extentPoolNumber"));
        int n3 = this.getIntValue(attributesImpl.getValue("rankGroup"));
        int n4 = this.getIntValue(attributesImpl.getValue("dataState"));
        int n5 = this.getIntValue(attributesImpl.getValue("configurationState"));
        long l = this.getLongValue(attributesImpl.getValue("numWideArrays"));
        long l2 = this.getLongValue(attributesImpl.getValue("numNarrowArrays"));
        long l3 = this.getLongValue(attributesImpl.getValue("trackSize"));
        long l4 = this.getLongValue(attributesImpl.getValue("stripSize"));
        long l5 = this.getLongValue(attributesImpl.getValue("sizeOfStripe"));
        long l6 = this.getLongValue(attributesImpl.getValue("extentSize"));
        long l7 = this.getLongValue(attributesImpl.getValue("numUsedExtents"));
        long l8 = this.getLongValue(attributesImpl.getValue("numExtents"));
        String string = attributesImpl.getValue("rankSerial");
        String string2 = attributesImpl.getValue("extentType");
        String string3 = attributesImpl.getValue("raidType");
        NIExtentType nIExtentType = string2.equals("FB") ? NIExtentTypeFB.Option : NIExtentTypeCKD.Option;
        NIRaidType nIRaidType = string3.equals("raid5") ? NIRaidType5.Option : NIRaidType10.Option;
        NIArrayID[] nIArrayIDArray = new NIArrayID[]{new NIArrayID(this.curEssID, 0)};
        NIRankID nIRankID = new NIRankID(this.curEssID, n);
        NIExtentPoolID nIExtentPoolID = null;
        if (n2 != -1) {
            nIExtentPoolID = new NIExtentPoolID(this.curEssID, n2);
        }
        NIRankImpl nIRankImpl = (NIRankImpl)NIResourceFactory.newRank(nIArrayIDArray, nIExtentType);
        nIRankImpl.setConfigurationState(n5);
        nIRankImpl.setDataState(n4);
        nIRankImpl.setExtentPoolID(nIExtentPoolID);
        nIRankImpl.setExtentSize(l6);
        nIRankImpl.setID(nIRankID);
        nIRankImpl.setNumNarrowArrays(l2);
        nIRankImpl.setNumWideArrays(l);
        nIRankImpl.setRAIDType(nIRaidType);
        nIRankImpl.setRankGroup(n3);
        nIRankImpl.setRankSerial(string);
        nIRankImpl.setSizeOfStripe(l5);
        nIRankImpl.setStripSize(l4);
        nIRankImpl.setTrackSize(l3);
        nIRankImpl.setNumUsedExtents(l7);
        nIRankImpl.setNumExtents(l8);
        boolean bl = this.dbHelper.insertRank(nIRankImpl);
        this.curRank = nIRankImpl;
        return bl;
    }

    private boolean createExtentPool(Attributes attributes) {
        NIOlcLogger.info("creating extent pool in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("number"));
        int n2 = this.getIntValue(attributesImpl.getValue("numVolumes"));
        int n3 = this.getIntValue(attributesImpl.getValue("numRanks"));
        int n4 = this.getIntValue(attributesImpl.getValue("rankGroup"));
        long l = this.getLongValue(attributesImpl.getValue("numExtents"));
        float f = this.getFloatValue(attributesImpl.getValue("extentThreshold"));
        float f2 = this.getFloatValue(attributesImpl.getValue("extentLimit"));
        String string = attributesImpl.getValue("type");
        String string2 = attributesImpl.getValue("userName");
        NIExtentType nIExtentType = string.equals("FB") ? NIExtentTypeFB.Option : NIExtentTypeCKD.Option;
        NIExtentPoolID nIExtentPoolID = new NIExtentPoolID(this.curEssID, n);
        NIExtentPoolImpl nIExtentPoolImpl = (double)f2 < 1.0 ? (NIExtentPoolImpl)NIResourceFactory.newExtentPool(this.curEssID, n4, nIExtentType, f2, string2) : (NIExtentPoolImpl)NIResourceFactory.newExtentPool(this.curEssID, n4, nIExtentType, string2);
        nIExtentPoolImpl.setID(nIExtentPoolID);
        nIExtentPoolImpl.setExtentThreshold(f);
        nIExtentPoolImpl.setNumExtents(l);
        nIExtentPoolImpl.setNumRanks(n3);
        nIExtentPoolImpl.setNumVolumes(n2);
        boolean bl = this.dbHelper.insertExtentPool(nIExtentPoolImpl);
        this.curExtentPool = nIExtentPoolImpl;
        return bl;
    }

    private boolean createVolume(Attributes attributes) {
        NIVolumeImpl nIVolumeImpl;
        Serializable serializable;
        NIOlcLogger.info("creating volume in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("number"));
        int n2 = this.getIntValue(attributesImpl.getValue("lssNumber"));
        int n3 = this.getIntValue(attributesImpl.getValue("extentPoolNumber"));
        int n4 = this.getIntValue(attributesImpl.getValue("configState"));
        int n5 = this.getIntValue(attributesImpl.getValue("baseVolumeNumber"));
        int n6 = this.getIntValue(attributesImpl.getValue("mtm"));
        int n7 = this.getIntValue(attributesImpl.getValue("addressGroupNumber"));
        long l = this.getLongValue(attributesImpl.getValue("capacity"));
        String string = attributesImpl.getValue("userName");
        String string2 = attributesImpl.getValue("dataType");
        String string3 = attributesImpl.getValue("volumeType");
        NIVolumeType nIVolumeType = null;
        if (string3.equals("CKDBase")) {
            nIVolumeType = NIVolumeTypeCKDBase.Option;
        } else if (string3.equals("CKDCrossCUAlias")) {
            nIVolumeType = NIVolumeTypeCKDCrossCUAlias.Option;
        } else if (string3.equals("CKDSingleCUAlias")) {
            nIVolumeType = NIVolumeTypeCKDSingleCuAlias.Option;
        } else if (string3.equals("CKDMap")) {
            nIVolumeType = NIVolumeTypeCKDMap.Option;
        } else if (string3.equals("FBBase")) {
            nIVolumeType = NIVolumeTypeFixedBlockBase.Option;
        } else if (string3.equals("FBMap")) {
            nIVolumeType = NIVolumeTypeFixedBlockMap.Option;
        }
        NIDataType nIDataType = null;
        if (string2 != null) {
            if (string2.equals("3380")) {
                nIDataType = NIDataType3380.Option;
            } else if (string2.equals("3390")) {
                nIDataType = NIDataType3390.Option;
            } else if (string2.equals("512")) {
                nIDataType = NIDataTypeBlock512.Option;
            } else if (string2.equals("520Protected")) {
                nIDataType = NIDataTypeBlock520Protected.Option;
            } else if (string2.equals("520Unprotected")) {
                nIDataType = NIDataTypeBlock520Unprotected.Option;
            }
        }
        NIAddressGroupID nIAddressGroupID = n7 == -1 ? null : new NIAddressGroupID(this.curEssID, n7);
        NIExtentPoolID nIExtentPoolID = n3 == -1 ? (NIExtentPoolID)this.curExtentPool.getID() : new NIExtentPoolID(this.curEssID, n3);
        NILSSID nILSSID = new NILSSID(this.curEssID, n2);
        if (string3.indexOf("Alias") == -1) {
            serializable = new NIVolumeID(nILSSID, n);
            nIVolumeImpl = (NIVolumeImpl)NIResourceFactory.newVolume(nILSSID, n, string, nIExtentPoolID, nIDataType, nIVolumeType, l);
            nIVolumeImpl.setID((NIResourceID)serializable);
            nIVolumeImpl.setAlias(false);
        } else {
            serializable = new NIVolumeID(nILSSID, n5);
            nIVolumeImpl = (NIVolumeImpl)NIResourceFactory.newVolume(nILSSID, n, (NIVolumeID)serializable, nIVolumeType, string, null);
            nIVolumeImpl.setAlias(true);
            nIVolumeImpl.setCapacity(l);
        }
        nIVolumeImpl.setConfigState(n4);
        nIVolumeImpl.setAddressGroup(nIAddressGroupID);
        nIVolumeImpl.setVolumeType(nIVolumeType);
        nIVolumeImpl.setMTM(n6);
        serializable = (NILSSVolumeSetImpl)this.lssVolumeSet.get(nILSSID);
        boolean bl = true;
        if (serializable != null) {
            ((NILSSVolumeSetImpl)serializable).addVolume(nIVolumeImpl, 0, true);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean createSCSIHostPort(Attributes attributes) {
        Object object;
        NIOlcLogger.info("creating SCSI host port in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("id"));
        int n2 = this.getIntValue(attributesImpl.getValue("volumeGroupNumber"));
        int n3 = this.getIntValue(attributesImpl.getValue("portGroup"));
        long l = this.getHexValueAsLong(attributesImpl.getValue("wwpn"));
        String string = attributesImpl.getValue("userHostName");
        String string2 = attributesImpl.getValue("userHostDesc");
        String string3 = attributesImpl.getValue("portProfile");
        String string4 = attributesImpl.getValue("hostType");
        String string5 = attributesImpl.getValue("attachingPortTopology");
        String string6 = attributesImpl.getValue("portMask");
        int n4 = this.getIntValue(attributesImpl.getValue("addressDiscovery"));
        int n5 = this.getIntValue(attributesImpl.getValue("logicalBlockSize"));
        NISCSIHostPortID nISCSIHostPortID = new NISCSIHostPortID(this.curEssID, n);
        NIVolumeGroupID nIVolumeGroupID = null;
        if (n2 != -1) {
            nIVolumeGroupID = new NIVolumeGroupID(this.curEssID, n2);
        }
        NIPortMask nIPortMask = null;
        if (string6 != null) {
            object = NIByteArray.hexToByteArray(string6);
            nIPortMask = new NIPortMask(this.curEssID.getType(), (byte[])object);
        } else {
            nIPortMask = new NIPortMask(this.curEssID.getType());
            nIPortMask.setAllEnabled(true);
        }
        object = null;
        try {
            object = string5.equals("FCArbitratedLoop") ? (Object)NIFabricTopologyFCArbitratedLoop.Option : (string5.equals("Ficon") ? (Object)NIFabricTopologyFicon.Option : (string5.equals("ScsiFcp") ? (Object)NIFabricTopologyScsiFcp.Option : (string5.equals("ScsiFcpFicon") ? (Object)NIFabricTopologyScsiFcpFicon.Option : (Object)NIFabricTopologyUnknown.Option)));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        NISCSIHostPortImpl nISCSIHostPortImpl = (NISCSIHostPortImpl)NIResourceFactory.newSCSIHostPort(this.curEssID, l, string3, string, string2);
        nISCSIHostPortImpl.setVolumeGroup(nIVolumeGroupID);
        nISCSIHostPortImpl.setPortGroup(n3);
        nISCSIHostPortImpl.setID(nISCSIHostPortID);
        nISCSIHostPortImpl.setHostType(string4);
        nISCSIHostPortImpl.setAttachingPortTopology((NIFabricTopology)object);
        nISCSIHostPortImpl.setPortMask(nIPortMask);
        nISCSIHostPortImpl.setAddressDiscovery(n4);
        nISCSIHostPortImpl.setLogicalBlockSize(n5);
        boolean bl = this.dbHelper.insertSCSIHostPort(nISCSIHostPortImpl);
        this.curSCSIHost = nISCSIHostPortImpl;
        return bl;
    }

    private boolean createStorageEnclosure(Attributes attributes) {
        NIOlcLogger.info("creating storage enclosure in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("enclosureNumber"));
        int n2 = this.getIntValue(attributesImpl.getValue("interfaceAddress"));
        int n3 = this.getIntValue(attributesImpl.getValue("numStorageDevices"));
        int n4 = this.getIntValue(attributesImpl.getValue("numStorageDeviceSlots"));
        int n5 = this.getIntValue(attributesImpl.getValue("rackNumber"));
        String string = attributesImpl.getValue("serialNum");
        String string2 = attributesImpl.getValue("type");
        String string3 = attributesImpl.getValue("model");
        String string4 = attributesImpl.getValue("featureCode");
        String string5 = attributesImpl.getValue("location");
        int[] nArray = new int[4];
        if (attributesImpl.getValue("interfaceID").length() == 16) {
            nArray[0] = this.getHexValueAsInt(attributesImpl.getValue("interfaceID").substring(0, 3));
            nArray[1] = this.getHexValueAsInt(attributesImpl.getValue("interfaceID").substring(4, 7));
            nArray[2] = this.getHexValueAsInt(attributesImpl.getValue("interfaceID").substring(8, 11));
            nArray[3] = this.getHexValueAsInt(attributesImpl.getValue("interfaceID").substring(12, 15));
        } else {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 0;
        }
        NIEnclosureID nIEnclosureID = new NIEnclosureID(this.curEssID, string2, string3, string);
        NIStorageEnclosureImpl nIStorageEnclosureImpl = new NIStorageEnclosureImpl(nIEnclosureID, string5, n5, "", n, string4, nArray, n2, n4, n3);
        boolean bl = this.dbHelper.insertStorageEnclosure(nIStorageEnclosureImpl);
        return bl;
    }

    private boolean createStorageDeviceFRU(Attributes attributes) {
        List<String> list;
        NIOlcLogger.info("creating storage device fru in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("state"));
        int n2 = this.getIntValue(attributesImpl.getValue("deviceAdapterPairID"));
        int n3 = this.getIntValue(attributesImpl.getValue("diskCapacity"));
        int n4 = this.getIntValue(attributesImpl.getValue("diskRPM"));
        int n5 = this.getIntValue(attributesImpl.getValue("diskInterfaceRate"));
        int n6 = this.getIntValue(attributesImpl.getValue("diskUsage"));
        int n7 = this.getIntValue(attributesImpl.getValue("diskClass"));
        int n8 = this.getIntValue(attributesImpl.getValue("arraySiteNumber"));
        int n9 = this.getIntValue(attributesImpl.getValue("arraySitePosition"));
        int n10 = this.getIntValue(attributesImpl.getValue("rackNumber"));
        int n11 = this.getHexValueAsInt(attributesImpl.getValue("diskIdentifier"));
        int n12 = this.getIntValue(attributesImpl.getValue("fruEnclNumber"));
        int n13 = this.getIntValue(attributesImpl.getValue("dualLoop"));
        String string = attributesImpl.getValue("migrationDiskSerialNumber");
        String string2 = attributesImpl.getValue("location");
        String string3 = attributesImpl.getValue("sequenceNum");
        String string4 = attributesImpl.getValue("diskInterfaceType");
        String string5 = attributesImpl.getValue("diskSerialNumber");
        NIArraySiteID nIArraySiteID = new NIArraySiteID(this.curEssID, n8);
        NIFRUID nIFRUID = new NIFRUID(this.curEssID, "", "", string3, "", "", "", class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU == null ? (class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU = NIOlcDatabaseXml.class$("com.ibm.storage.ess.ni.application.resource.NIStorageDeviceFRU")) : class$com$ibm$storage$ess$ni$application$resource$NIStorageDeviceFRU);
        NIStorageDeviceFRUImpl nIStorageDeviceFRUImpl = new NIStorageDeviceFRUImpl(nIFRUID, string2, n10, n, n11, n12, n2, new int[0], n3, n4, string4, n5, n6, n7, n9, nIArraySiteID, string5);
        nIStorageDeviceFRUImpl.setMigrationDiskSerialNumber(string);
        nIStorageDeviceFRUImpl.setFRUEnclosureNumber(n12);
        nIStorageDeviceFRUImpl.setDualLoop(n13);
        if (this.diskSerialMap.containsKey(nIArraySiteID)) {
            list = (List)this.diskSerialMap.get(nIArraySiteID);
            list.add(string5);
        } else {
            list = new ArrayList<String>();
            ((ArrayList)list).add(string5);
            this.diskSerialMap.put(nIArraySiteID, list);
        }
        boolean bl = this.dbHelper.insertStorageDeviceFRU(nIStorageDeviceFRUImpl);
        return bl;
    }

    private boolean createVolumeGroup(Attributes attributes) {
        NIOlcLogger.info("creating volume group in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("number"));
        String string = attributesImpl.getValue("userName");
        String string2 = attributesImpl.getValue("type");
        NIVolumeGroupType nIVolumeGroupType = string2.equals("CopyServices") ? NIVolumeGroupTypeCopyServices.Option : (string2.equals("FiconEsconAll") ? NIVolumeGroupTypeFiconEsconAll.Option : (string2.equals("FiconEsconMask") ? NIVolumeGroupTypeFiconEsconMask.Option : (string2.equals("FiconEsconMixedMask") ? NIVolumeGroupTypeFiconEsconMixedMask.Option : (string2.equals("SCSI520All") ? NIVolumeGroupTypeSCSI520All.Option : (string2.equals("SCSI520Mask") ? NIVolumeGroupTypeSCSI520Mask.Option : (string2.equals("SCSIAll") ? NIVolumeGroupTypeSCSIAll.Option : (string2.equals("SCSIMap256") ? NIVolumeGroupTypeSCSIMap256.Option : (string2.equals("SCSIMask") ? NIVolumeGroupTypeSCSIMask.Option : NIVolumeGroupTypeSCSIMixedMask.Option))))))));
        NIVolumeGroupID nIVolumeGroupID = new NIVolumeGroupID(this.curEssID, n);
        NIVolumeGroupImpl nIVolumeGroupImpl = (NIVolumeGroupImpl)NIResourceFactory.newVolumeGroup(this.curEssID, string, nIVolumeGroupType);
        nIVolumeGroupImpl.setID(nIVolumeGroupID);
        boolean bl = this.dbHelper.insertVolumeGroup(nIVolumeGroupImpl);
        this.curVolumeGroup = nIVolumeGroupImpl;
        return bl;
    }

    private void createArrayRef(Attributes attributes) {
        NIOlcLogger.info("creating array ref in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("arrayNumber"));
        NIArrayID nIArrayID = new NIArrayID(this.curEssID, n);
        this.arrayRefs.add(nIArrayID);
    }

    private void createVolumeRef(Attributes attributes) {
        NIOlcLogger.info("creating volume ref in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = this.getIntValue(attributesImpl.getValue("volumeNumber"));
        int n2 = this.getIntValue(attributesImpl.getValue("lssNumber"));
        int n3 = this.getIntValue(attributesImpl.getValue("baseVolumeNumber"));
        NILSSID nILSSID = new NILSSID(this.curEssID, n2);
        NIVolumeID nIVolumeID = n3 == -1 ? new NIVolumeID(nILSSID, n) : new NIVolumeID(nILSSID, n, n3);
        this.volumeRefs.add(nIVolumeID);
    }

    private ArrayList getDDMPacks() {
        Serializable serializable;
        ArrayList arrayList = new ArrayList();
        List list = this.dbHelper.getEssByFacility((NIStorageFacilityID)this.curStorageFacility.getID());
        int n = 0;
        while (n < list.size()) {
            serializable = (NIESSID)((NIESSImpl)list.get(n)).getID();
            arrayList.addAll(this.dbHelper.getStorageDeviceFRUs((NIESSID)serializable));
            ++n;
        }
        serializable = new ArrayList();
        double d = -1.0;
        double d2 = -1.0;
        int n2 = -1;
        int n3 = 0;
        boolean bl = true;
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext() || listIterator.hasPrevious()) {
            NIStorageDeviceFRUImpl nIStorageDeviceFRUImpl = (NIStorageDeviceFRUImpl)(bl ? listIterator.next() : listIterator.previous());
            double d3 = nIStorageDeviceFRUImpl.getDiskCapacity();
            double d4 = nIStorageDeviceFRUImpl.getDiskRPM();
            int n4 = nIStorageDeviceFRUImpl.getDiskClass();
            if (d == -1.0) {
                d = d3;
                d2 = d4;
                n2 = n4;
            }
            if (d == d3 && d2 == d4 && n2 == n4) {
                ++n3;
                listIterator.remove();
            }
            if ((!bl || listIterator.hasNext()) && (bl || listIterator.hasPrevious())) continue;
            bl = !bl;
            ((ArrayList)serializable).add(new NIDDMPackImpl(d, d2, n3 / 16, n2));
            n2 = -1;
            d = d2 = (double)-1;
            n3 = 0;
        }
        return serializable;
    }

    private void createUsedExtentsHashMap(Attributes attributes) {
        NIOlcLogger.info("creating UsedExtentsHashMap in xml");
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        String string = attributesImpl.getValue("volumeNumber");
        String string2 = attributesImpl.getValue("lssNumber");
        String string3 = attributesImpl.getValue("numExtentsUsed");
        NILSSID nILSSID = new NILSSID(this.curEssID, Integer.parseInt(string2));
        NIVolumeID nIVolumeID = new NIVolumeID(nILSSID, Integer.parseInt(string));
        this.volumeExtentMap.put(nIVolumeID, Integer.valueOf(string3));
    }

    private int getIntValue(String string) {
        int n = string == null || string.length() == 0 ? -1 : Integer.parseInt(string);
        return n;
    }

    private int getHexValueAsInt(String string) {
        int n = string == null || string.length() == 0 ? -1 : Integer.parseInt(string, 16);
        return n;
    }

    private long getHexValueAsLong(String string) {
        long l = string == null || string.length() == 0 ? -1L : Long.parseLong(string, 16);
        return l;
    }

    private long getLongValue(String string) {
        long l = string == null || string.length() == 0 ? -1L : Long.parseLong(string);
        return l;
    }

    private boolean getBoolValue(String string) {
        boolean bl = string == null || string.length() == 0 ? false : string.equals("true");
        return bl;
    }

    private float getFloatValue(String string) {
        float f = string == null || string.length() == 0 ? -1.0f : Float.parseFloat(string);
        return f;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

