/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.olc.services;

import com.ibm.storage.ess.ni.application.NIServices;
import com.ibm.storage.ess.ni.application.resource.NIESS;
import com.ibm.storage.ess.ni.application.resource.NIEnterprise;
import com.ibm.storage.ess.ni.application.resource.NIOfflineStoragePlex;
import com.ibm.storage.ess.ni.application.resource.NIResource;
import com.ibm.storage.ess.ni.application.resource.NIStorageFacility;
import com.ibm.storage.ess.ni.application.resource.NIStoragePlex;
import com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIConfigResult;
import com.ibm.storage.ess.ni.application.results.NIResult;
import com.ibm.storage.ess.ni.application.results.NIXMLResult;
import com.ibm.storage.ess.ni.event.extensions.NIESSDeletedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIStorageFacilityDeletedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIStoragePlexCreatedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NIStoragePlexDeletedEventImpl;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIEnterpriseID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.identifiers.NIStoragePlexID;
import com.ibm.storage.ess.ni.iou.NIEscrow;
import com.ibm.storage.ess.ni.iou.NIEscrowFactory;
import com.ibm.storage.ess.ni.olc.NIOlcCommon;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseManager;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseMasterHelper;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseSchemaHelper;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseXml;
import com.ibm.storage.ess.ni.olc.NIOlcEventProcessor;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import com.ibm.storage.ess.ni.olc.services.NIOlcOfflineDomainService;
import com.ibm.storage.ess.ni.resource.NIEnterpriseImpl;
import com.ibm.storage.ess.ni.resource.NIStoragePlexImpl;
import com.ibm.storage.ess.ni.results.NIConfigQueryResultImpl;
import com.ibm.storage.ess.ni.results.NIResultImpl;
import com.ibm.storage.ess.ni.results.NIXMLResultImpl;
import com.ibm.storage.ess.ni.security.common.NIAuthenticationInfo;
import com.ibm.storage.ess.ni.services.NIEnterpriseService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NIOlcEnterpriseService
implements NIEnterpriseService {
    private static final NIOlcCommon c = NIOlcCommon.c;
    private static final String CLASS_NAME = "NIOlcEnterpriseService";
    private static final char TEMP_DB_PREFIX = '$';
    private static final String DB_HOME = System.getProperty("db2j.system.home");
    private ArrayList alEventsHolder = new ArrayList();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIConfigResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIXMLResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIResult;

    public NIConfigCreatedResult createEnterprise(NIEnterprise nIEnterprise) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIConfigCreatedResult nIConfigCreatedResult;
        NIOlcLogger.enter(CLASS_NAME, "createEnterprise");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
        String string = nIEnterprise.getUserName();
        String string2 = '$' + string;
        if (nIOlcDatabaseMasterHelper.getEnterpriseByDatabase(string) != null) {
            nIConfigCreatedResult = (NIConfigCreatedResult)c.failConfig(null, -1099689968L);
        } else {
            NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(string2);
            if (nIOlcDatabaseSchemaHelper == null) {
                nIConfigCreatedResult = (NIConfigCreatedResult)c.failConfig(null, 1L);
            } else {
                if (!nIOlcDatabaseMasterHelper.insertEnterprise(nIEnterprise, string)) {
                    NIOlcDatabaseManager.dropDatabase(string2);
                    nIConfigCreatedResult = (NIConfigCreatedResult)c.failConfig(null, 1L);
                } else {
                    NIEnterpriseID nIEnterpriseID = new NIEnterpriseID(nIOlcDatabaseMasterHelper.getKey(), string2);
                    ((NIEnterpriseImpl)nIEnterprise).setID(nIEnterpriseID);
                    boolean bl = nIOlcDatabaseMasterHelper.modifyEnterprise(nIEnterprise);
                    nIConfigCreatedResult = (NIConfigCreatedResult)c.handleConfig(nIEnterpriseID, bl);
                }
                nIOlcDatabaseSchemaHelper.release();
            }
        }
        NIOlcLogger.exit(CLASS_NAME, "createEnterprise");
        nIEscrow.close(nIConfigCreatedResult);
        return (NIConfigCreatedResult)((Object)nIEscrow.issueIou());
    }

    public NIConfigResult modifyEnterprise(NIEnterprise nIEnterprise) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "modifyEnterprise");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
        boolean bl = nIOlcDatabaseMasterHelper.modifyEnterprise(nIEnterprise);
        NIOlcLogger.exit(CLASS_NAME, "modifyEnterprise");
        return c.handleConfig(nIEnterprise.getID(), nIEscrow, bl);
    }

    public NIConfigQueryResult getEnterprises(String string) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getEnterprises");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
        ArrayList arrayList = nIOlcDatabaseMasterHelper.getEnterprises(string);
        int n = 0;
        while (n < arrayList.size()) {
            NIEnterprise nIEnterprise = (NIEnterprise)arrayList.get(n);
            if (NIOlcDatabaseManager.workingDatabaseExists('$' + ((NIEnterpriseID)nIEnterprise.getID()).getDatabase())) {
                ((NIEnterpriseImpl)nIEnterprise).setChangesPending(true);
            }
            ++n;
        }
        NIOlcLogger.exit(CLASS_NAME, "getEnterprises");
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getEnterprise(NIEnterpriseID nIEnterpriseID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getEnterprise");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
        ArrayList<NIEnterprise> arrayList = new ArrayList<NIEnterprise>();
        NIEnterprise nIEnterprise = nIOlcDatabaseMasterHelper.getEnterprise(nIEnterpriseID);
        if (NIOlcDatabaseManager.workingDatabaseExists(((NIEnterpriseID)nIEnterprise.getID()).getDatabase())) {
            ((NIEnterpriseImpl)nIEnterprise).setChangesPending(true);
        }
        arrayList.add(nIEnterprise);
        NIOlcLogger.exit(CLASS_NAME, "getEnterprise");
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIServices getServices(NIOfflineStoragePlex nIOfflineStoragePlex, NIAuthenticationInfo nIAuthenticationInfo) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getServices");
        NIOlcLogger.exit(CLASS_NAME, "getServices");
        throw new NIUnsupportedException();
    }

    public NIConfigCreatedResult openEnterprise(NIEnterpriseID nIEnterpriseID, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "openEnterprise");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        boolean bl2 = true;
        String string = nIEnterpriseID.getDatabase();
        String string2 = NIOlcCommon.getRealDatabaseName(string);
        NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
        if (NIOlcDatabaseManager.databaseExists(string2)) {
            if (NIOlcDatabaseManager.workingDatabaseExists(string)) {
                if (bl) {
                    bl2 &= NIOlcDatabaseManager.dropDatabase(string);
                } else {
                    return (NIConfigCreatedResult)c.failConfig(nIEnterpriseID, nIEscrow, -1099689977L);
                }
            }
            if (bl2 &= NIOlcDatabaseManager.backupDatabase(DB_HOME + string2, DB_HOME + string)) {
                NIOlcDatabaseManager.initConnection(string);
            }
        } else {
            return (NIConfigCreatedResult)c.failConfig(nIEnterpriseID, nIEscrow, -1099689978L);
        }
        NIEnterpriseID nIEnterpriseID2 = new NIEnterpriseID(nIEnterpriseID.getPrimaryKey(), string);
        NIOlcLogger.exit(CLASS_NAME, "openEnterprise");
        return (NIConfigCreatedResult)c.handleConfig(nIEnterpriseID2, nIEscrow, bl2);
    }

    public NIConfigCreatedResult saveEnterprise(NIEnterpriseID nIEnterpriseID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "saveEnterprise");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
        String string = NIOlcCommon.getRealDatabaseName(nIEnterpriseID.getDatabase());
        boolean bl = true;
        nIOlcDatabaseMasterHelper.beginXA();
        if (NIOlcDatabaseManager.databaseExists(string)) {
            bl &= NIOlcDatabaseManager.dropDatabase(string);
        }
        bl &= NIOlcDatabaseManager.backupDatabase(DB_HOME + nIEnterpriseID.getDatabase(), DB_HOME + string);
        NIEnterpriseImpl nIEnterpriseImpl = (NIEnterpriseImpl)nIOlcDatabaseMasterHelper.getEnterpriseByDatabase(string);
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String string2 = simpleDateFormat.format(calendar.getTime());
        nIEnterpriseImpl.setDateLastModified(string2);
        nIEnterpriseImpl.setVersionLastModified("1.0");
        if (bl &= (bl &= nIOlcDatabaseMasterHelper.modifyEnterprise(nIEnterpriseImpl)) ? nIOlcDatabaseMasterHelper.commitXA() : nIOlcDatabaseMasterHelper.cancelXA()) {
            NIOlcDatabaseManager.addDatabase(string);
        }
        NIOlcLogger.exit(CLASS_NAME, "saveEnterprise");
        return (NIConfigCreatedResult)c.handleConfig(nIEnterpriseID, nIEscrow, bl);
    }

    public NIConfigCreatedResult saveAsEnterprise(NIEnterpriseID nIEnterpriseID, String string, boolean bl) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "saveAsEnterprise");
        String string2 = NIOlcCommon.getRealDatabaseName(nIEnterpriseID.getDatabase());
        if (string2.equals(string)) {
            return this.saveEnterprise(nIEnterpriseID);
        }
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        NIConfigCreatedResult nIConfigCreatedResult = null;
        NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
        boolean bl2 = true;
        nIOlcDatabaseMasterHelper.beginXA();
        if (NIOlcDatabaseManager.databaseExists(string)) {
            if (bl) {
                bl2 &= NIOlcDatabaseManager.dropDatabase(string);
                bl2 &= nIOlcDatabaseMasterHelper.deleteEnterpriseByDatabase(string);
            } else {
                nIConfigCreatedResult = (NIConfigCreatedResult)c.failConfig(nIEnterpriseID, -1099689968L);
            }
        }
        if (nIConfigCreatedResult == null) {
            NIEnterpriseImpl nIEnterpriseImpl;
            NIEnterpriseImpl nIEnterpriseImpl2 = nIEnterpriseImpl = (NIEnterpriseImpl)nIOlcDatabaseMasterHelper.getEnterprise(nIEnterpriseID);
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            String string3 = simpleDateFormat.format(calendar.getTime());
            nIEnterpriseImpl2.setDateLastModified(string3);
            nIEnterpriseImpl2.setVersionLastModified("1.0");
            nIEnterpriseImpl2.setUserName(string);
            bl2 &= nIOlcDatabaseMasterHelper.modifyEnterprise(nIEnterpriseImpl2);
            NIXMLResult nIXMLResult = this.exportEnterpriseToXML(nIEnterpriseID);
            bl2 &= nIXMLResult.isSuccessful();
            NIOlcLogger.info("SaveAS:Export success=" + nIXMLResult.isSuccessful());
            NIOlcLogger.info("SaveAS:Beginning Import");
            NIXMLResult nIXMLResult2 = this.importEnterpriseFromXML(nIXMLResult.getXMLFile(), null);
            bl2 &= nIXMLResult2.isSuccessful();
            NIOlcLogger.info("SaveAS:Import success=" + nIXMLResult2.isSuccessful());
            NIEnterpriseID nIEnterpriseID2 = (NIEnterpriseID)nIXMLResult2.getResourceID();
            NIOlcDatabaseManager.dropDatabase(nIEnterpriseID2.getDatabase(), true);
            File file = new File(DB_HOME + nIEnterpriseID2.getDatabase());
            NIOlcLogger.info("SaveAS:Rename success=" + (bl2 &= file.renameTo(new File(DB_HOME + nIEnterpriseID2.getDatabase().substring(1)))));
            bl2 &= nIOlcDatabaseMasterHelper.modifyEnterprise(nIEnterpriseImpl);
            nIEnterpriseImpl2 = (NIEnterpriseImpl)nIOlcDatabaseMasterHelper.getEnterprise(nIEnterpriseID2);
            nIEnterpriseImpl2.setDateLastModified(string3);
            if (bl2 &= (bl2 &= nIOlcDatabaseMasterHelper.modifyEnterprise(nIEnterpriseImpl2)) ? nIOlcDatabaseMasterHelper.commitXA() : nIOlcDatabaseMasterHelper.cancelXA()) {
                NIOlcDatabaseManager.addDatabase(string);
            }
            nIConfigCreatedResult = (NIConfigCreatedResult)c.handleConfig(nIEnterpriseID2, bl2);
        }
        NIOlcLogger.exit(CLASS_NAME, "saveAsEnterprise");
        nIEscrow.close(nIConfigCreatedResult);
        return (NIConfigCreatedResult)((Object)nIEscrow.issueIou());
    }

    public NIConfigResult deleteEnterprise(NIEnterpriseID nIEnterpriseID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper;
        boolean bl;
        NIOlcLogger.enter(CLASS_NAME, "deleteEnterprise");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        String string = nIEnterpriseID.getDatabase();
        String string2 = NIOlcCommon.getRealDatabaseName(nIEnterpriseID.getDatabase());
        if (NIOlcDatabaseManager.workingDatabaseExists(string)) {
            NIOlcDatabaseManager.dropDatabase(string);
        }
        if (NIOlcDatabaseManager.databaseExists(string2)) {
            NIOlcDatabaseManager.dropDatabase(string2);
        }
        if (bl = (nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper()).deleteEnterprise(nIEnterpriseID)) {
            NIOlcDatabaseManager.removeDatabase(string2);
        }
        NIOlcLogger.exit(CLASS_NAME, "deleteEnterprise");
        NIConfigResult nIConfigResult = c.handleConfig(nIEnterpriseID, nIEscrow, bl);
        return nIConfigResult;
    }

    public NIXMLResult importEnterpriseFromXML(File file, NIEnterpriseID nIEnterpriseID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "importEnterpriseFromXML");
        boolean bl = true;
        long l = 0L;
        NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
        NIOlcDatabaseXml nIOlcDatabaseXml = new NIOlcDatabaseXml();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(file.getCanonicalFile(), (DefaultHandler)nIOlcDatabaseXml);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            bl = false;
            l = -1099689976L;
            NIOlcLogger.severe("Could not parse file.", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            bl = false;
            l = -1099689976L;
            NIOlcLogger.severe("SAX problem", sAXException);
        }
        catch (IOException iOException) {
            bl = false;
            l = -1099689976L;
            NIOlcLogger.severe("I/O Exception with InputStream.", iOException);
        }
        catch (Exception exception) {
            bl = false;
            l = -1099689976L;
            NIOlcLogger.severe("Unexpected error .", exception);
        }
        NIEnterpriseID nIEnterpriseID2 = new NIEnterpriseID(nIOlcDatabaseMasterHelper.getKey(), "");
        NIEnterprise nIEnterprise = nIOlcDatabaseMasterHelper.getEnterprise(nIEnterpriseID2);
        NIEnterpriseID nIEnterpriseID3 = null;
        if (nIEnterprise != null) {
            nIEnterpriseID3 = (NIEnterpriseID)nIEnterprise.getID();
        }
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIXMLResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIXMLResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIXMLResult")) : class$com$ibm$storage$ess$ni$application$results$NIXMLResult);
        nIEscrow.close(new NIXMLResultImpl(nIEnterpriseID3, file, bl, l));
        NIOlcLogger.exit(CLASS_NAME, "importEnterpriseFromXML");
        return (NIXMLResult)((Object)nIEscrow.issueIou());
    }

    public NIXMLResult exportEnterpriseToXML(NIEnterpriseID nIEnterpriseID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        Object object;
        NIOlcLogger.enter(CLASS_NAME, "exportEnterpriseToXML");
        boolean bl = true;
        File file = null;
        long l = 0L;
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd-HH_mm_ss");
        String string = System.getProperty("user.dir") + File.separator + "xml";
        String string2 = File.separator + "olc_" + simpleDateFormat.format(calendar.getTime()) + ".xml";
        if (NIOlcDatabaseManager.workingDatabaseExists(nIEnterpriseID.getDatabase())) {
            try {
                object = new File(string);
                if (!((File)object).exists()) {
                    ((File)object).mkdir();
                }
                file = new File(string + File.separator + string2);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                bl = NIOlcDatabaseXml.writeToXMLFile(nIEnterpriseID, outputStreamWriter);
            }
            catch (Exception exception) {
                bl = false;
                l = 2L;
                NIOlcLogger.info("error exporting");
                NIOlcLogger.severe("", exception);
            }
        } else if (NIOlcDatabaseManager.databaseExists(NIOlcCommon.getRealDatabaseName(nIEnterpriseID.getDatabase()))) {
            bl = false;
            l = -1099689975L;
        } else {
            bl = false;
            l = -1099689978L;
        }
        object = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIXMLResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIXMLResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIXMLResult")) : class$com$ibm$storage$ess$ni$application$results$NIXMLResult);
        object.close(new NIXMLResultImpl(nIEnterpriseID, file, bl, l));
        NIOlcLogger.exit(CLASS_NAME, "exportEnterpriseToXML");
        return (NIXMLResult)((Object)object.issueIou());
    }

    public NIConfigCreatedResult createStoragePlex(NIOfflineStoragePlex nIOfflineStoragePlex) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "createStoragePlex");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        NIStoragePlexImpl nIStoragePlexImpl = (NIStoragePlexImpl)nIOfflineStoragePlex;
        NIEnterpriseID nIEnterpriseID = ((NIStoragePlexID)nIStoragePlexImpl.getID()).getEnterprise();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(nIEnterpriseID.getDatabase());
        NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
        boolean bl = true;
        bl &= nIOlcDatabaseSchemaHelper.insertStoragePlex(nIStoragePlexImpl);
        this.alEventsHolder.add(new NIStoragePlexCreatedEventImpl(nIStoragePlexImpl));
        NIStoragePlexID nIStoragePlexID = new NIStoragePlexID(nIOlcDatabaseSchemaHelper.getKey(), nIEnterpriseID);
        nIStoragePlexImpl.setID(nIStoragePlexID);
        NIEnterpriseImpl nIEnterpriseImpl = (NIEnterpriseImpl)nIOlcDatabaseMasterHelper.getEnterprise(nIStoragePlexID.getEnterprise());
        nIEnterpriseImpl.addStoragePlex(nIStoragePlexID);
        nIOlcDatabaseMasterHelper.modifyEnterprise(nIEnterpriseImpl);
        if (bl &= nIOlcDatabaseSchemaHelper.modifyStoragePlex(nIStoragePlexImpl)) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIOlcLogger.exit(CLASS_NAME, "createStoragePlex");
        nIOlcDatabaseSchemaHelper.release();
        return (NIConfigCreatedResult)c.handleConfig(nIStoragePlexID, nIEscrow, bl);
    }

    public NIConfigQueryResult getStoragePlexes(NIEnterpriseID nIEnterpriseID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getStoragePlexes");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(nIEnterpriseID.getDatabase());
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getStoragePlexes(nIEnterpriseID);
        NIOlcLogger.exit(CLASS_NAME, "getStoragePlexes");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult isEnterpriseOpen(NIEnterpriseID nIEnterpriseID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "isEnterpriseOpen");
        Object var2_2 = null;
        boolean bl = NIOlcDatabaseManager.workingDatabaseExists(nIEnterpriseID.getDatabase());
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        nIEscrow.close(new NIConfigQueryResultImpl(new ArrayList(1), bl, 0L));
        NIOlcLogger.exit(CLASS_NAME, "isEnterpriseOpen");
        return (NIConfigQueryResult)((Object)nIEscrow.issueIou());
    }

    public NIResult closeEnterprise(NIEnterpriseID nIEnterpriseID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "closeEnterprise");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIResult")) : class$com$ibm$storage$ess$ni$application$results$NIResult);
        boolean bl = true;
        long l = 2L;
        if (NIOlcDatabaseManager.workingDatabaseExists(nIEnterpriseID.getDatabase())) {
            bl &= NIOlcDatabaseManager.dropDatabase(nIEnterpriseID.getDatabase());
            if (!NIOlcDatabaseManager.databaseExists(NIOlcCommon.getRealDatabaseName(nIEnterpriseID.getDatabase()))) {
                NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
                bl &= nIOlcDatabaseMasterHelper.deleteEnterprise(nIEnterpriseID);
            }
        }
        nIEscrow.close(new NIResultImpl(bl, l));
        NIOlcLogger.exit(CLASS_NAME, "closeEnterprise");
        return (NIResult)((Object)nIEscrow.issueIou());
    }

    public NIConfigResult deleteStoragePlex(NIStoragePlexID nIStoragePlexID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIResource nIResource;
        NIOlcLogger.enter(CLASS_NAME, "deleteStoragePlex");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcEnterpriseService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = (NIOlcDatabaseSchemaHelper)NIOlcDatabaseManager.getDatabaseHelper(nIStoragePlexID.getEnterprise().getDatabase());
        NIOlcDatabaseMasterHelper nIOlcDatabaseMasterHelper = NIOlcDatabaseManager.getMasterDatabaseHelper();
        boolean bl = true;
        nIOlcDatabaseSchemaHelper.beginXA();
        List list = nIOlcDatabaseSchemaHelper.getStoragePlex(nIStoragePlexID);
        if (list.size() > 0) {
            nIResource = (NIOfflineStoragePlex)list.get(0);
            List list2 = nIOlcDatabaseSchemaHelper.getFacilityByPlex((NIStoragePlexID)nIResource.getID());
            int n = 0;
            while (n < list2.size()) {
                NIStorageFacility nIStorageFacility = (NIStorageFacility)list2.get(n);
                NIStorageFacilityID nIStorageFacilityID = (NIStorageFacilityID)nIStorageFacility.getID();
                List list3 = nIOlcDatabaseSchemaHelper.getEssByFacility(nIStorageFacilityID);
                int n2 = 0;
                while (n2 < list3.size()) {
                    NIESS nIESS = (NIESS)list3.get(n2);
                    bl &= NIOlcOfflineDomainService.deleteESSImage(nIESS, nIOlcDatabaseSchemaHelper);
                    this.alEventsHolder.add(new NIESSDeletedEventImpl(nIESS));
                    ++n2;
                }
                bl &= nIOlcDatabaseSchemaHelper.deleteStorageFacility(nIStorageFacilityID);
                this.alEventsHolder.add(new NIStorageFacilityDeletedEventImpl(nIStorageFacility));
                ++n;
            }
            bl &= nIOlcDatabaseSchemaHelper.deleteStoragePlex(nIStoragePlexID);
            this.alEventsHolder.add(new NIStoragePlexDeletedEventImpl((NIStoragePlex)nIResource));
        } else {
            bl = false;
        }
        nIResource = (NIEnterpriseImpl)nIOlcDatabaseMasterHelper.getEnterprise(nIStoragePlexID.getEnterprise());
        ((NIEnterpriseImpl)nIResource).removeStoragePlex(nIStoragePlexID);
        nIOlcDatabaseMasterHelper.modifyEnterprise((NIEnterprise)nIResource);
        if (bl &= bl ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
            NIOlcEventProcessor.processEvents(this.alEventsHolder);
        }
        this.alEventsHolder.clear();
        NIOlcLogger.exit(CLASS_NAME, "deleteStoragePlex");
        nIOlcDatabaseSchemaHelper.release();
        return c.handleConfig(nIStoragePlexID, nIEscrow, bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

