/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.olc.services;

import com.ibm.storage.ess.ni.application.resource.NIHost;
import com.ibm.storage.ess.ni.application.resource.NIHostPort;
import com.ibm.storage.ess.ni.application.resource.NIPortMask;
import com.ibm.storage.ess.ni.application.resource.NISCSIHostPort;
import com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult;
import com.ibm.storage.ess.ni.application.results.NIConfigQueryResult;
import com.ibm.storage.ess.ni.application.results.NIConfigResult;
import com.ibm.storage.ess.ni.application.results.NIHostUserNamesResult;
import com.ibm.storage.ess.ni.application.results.NILoginDescriptor;
import com.ibm.storage.ess.ni.application.results.NIPortProfilesResult;
import com.ibm.storage.ess.ni.application.results.NIQueryUnknownWWPNResult;
import com.ibm.storage.ess.ni.constants.NIHostConstants;
import com.ibm.storage.ess.ni.event.extensions.NISCSIHostPortChangedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NISCSIHostPortCreatedEventImpl;
import com.ibm.storage.ess.ni.event.extensions.NISCSIHostPortDeletedEventImpl;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID;
import com.ibm.storage.ess.ni.iou.NIEscrow;
import com.ibm.storage.ess.ni.iou.NIEscrowFactory;
import com.ibm.storage.ess.ni.olc.NIOlcCommon;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseSchemaHelper;
import com.ibm.storage.ess.ni.olc.NIOlcEventProcessor;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import com.ibm.storage.ess.ni.resource.NISCSIHostPortImpl;
import com.ibm.storage.ess.ni.results.NIHostUserNamesResultImpl;
import com.ibm.storage.ess.ni.results.NIPortProfilesResultImpl;
import com.ibm.storage.ess.ni.results.NIQueryUnknownWWPNResultImpl;
import com.ibm.storage.ess.ni.services.NIHostConfigurationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class NIOlcHostConfigurationService
implements NIHostConfigurationService {
    private static final NIOlcCommon c = NIOlcCommon.c;
    private static final String CLASS_NAME = "NIOlcHostConfigurationService";
    private ArrayList alEventsHolder = new ArrayList();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIHostUserNamesResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIPortProfilesResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$results$NIConfigResult;

    private int _generatePortNumber(NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper, NIESSID nIESSID) {
        int n = 0;
        List list = nIOlcDatabaseSchemaHelper.getScsiHostPortsByESS(nIESSID);
        int n2 = list.size();
        if (n2 > 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n2);
            int n3 = 0;
            while (n3 < n2) {
                arrayList.add(new Integer(((NISCSIHostPortID)((NISCSIHostPort)list.get(n3)).getID()).getPortID()));
                ++n3;
            }
            while (arrayList.contains(new Integer(n))) {
                ++n;
            }
        }
        return n;
    }

    public NIHostUserNamesResult queryHostUserNames(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "queryHostUserNames");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIHostUserNamesResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIHostUserNamesResult = NIOlcHostConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIHostUserNamesResult")) : class$com$ibm$storage$ess$ni$application$results$NIHostUserNamesResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            NIHostUserNamesResultImpl nIHostUserNamesResultImpl = new NIHostUserNamesResultImpl(false, -1099689979L, new String[]{""});
            nIEscrow.close(nIHostUserNamesResultImpl);
            return (NIHostUserNamesResult)((Object)nIEscrow.issueIou());
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getScsiHostPortsByESS(nIESSID);
        int n = arrayList.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((NISCSIHostPort)arrayList.get(0)).getUserHostName();
            ++n2;
        }
        NIHostUserNamesResultImpl nIHostUserNamesResultImpl = new NIHostUserNamesResultImpl(true, 0L, stringArray);
        nIEscrow.close(nIHostUserNamesResultImpl);
        nIOlcDatabaseSchemaHelper.release();
        NIOlcLogger.exit(CLASS_NAME, "queryHostUserNames");
        return (NIHostUserNamesResult)((Object)nIEscrow.issueIou());
    }

    public NIPortProfilesResult queryPortProfiles(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "queryPortProfiles");
        Vector vector = NIHostConstants.PORT_PROFILES;
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIPortProfilesResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIPortProfilesResult = NIOlcHostConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIPortProfilesResult")) : class$com$ibm$storage$ess$ni$application$results$NIPortProfilesResult);
        NIPortProfilesResultImpl nIPortProfilesResultImpl = new NIPortProfilesResultImpl(vector.toArray(new String[0]), 0L);
        nIEscrow.close(nIPortProfilesResultImpl);
        NIOlcLogger.exit(CLASS_NAME, "queryPortProfiles");
        return (NIPortProfilesResult)((Object)nIEscrow.issueIou());
    }

    public NIConfigQueryResult queryHostPorts(NIESSID nIESSID, String string) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "queryHostPorts");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcHostConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getScsiHostPortsByESSUsername(nIESSID, string);
        nIOlcDatabaseSchemaHelper.release();
        NIOlcLogger.exit(CLASS_NAME, "queryHostPorts");
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getSCSIHostPorts(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getSCSIHostPorts");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcHostConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getScsiHostPortsByESS(nIESSID);
        nIOlcDatabaseSchemaHelper.release();
        NIOlcLogger.exit(CLASS_NAME, "getSCSIHostPorts");
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigQueryResult getSCSIHostPorts(NISCSIHostPortID[] nISCSIHostPortIDArray) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "getSCSIHostPorts");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult = NIOlcHostConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigQueryResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigQueryResult);
        NIESSID nIESSID = nISCSIHostPortIDArray[0].getESS();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return c.handleFailedQuery(-1099689979L, nIEscrow);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getScsiHostPortsByID(nISCSIHostPortIDArray);
        nIOlcDatabaseSchemaHelper.release();
        NIOlcLogger.exit(CLASS_NAME, "getSCSIHostPorts");
        return c.handleQuery(arrayList, nIEscrow);
    }

    public NIConfigCreatedResult createHostPort(NIHostPort nIHostPort) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "createHostPort");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult = NIOlcHostConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigCreatedResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigCreatedResult);
        long l = 1L;
        boolean bl = true;
        if (!(nIHostPort instanceof NISCSIHostPort)) {
            throw new NIUnsupportedException("hostPort parameter is not a NISCSIHostPort");
        }
        NISCSIHostPortImpl nISCSIHostPortImpl = (NISCSIHostPortImpl)nIHostPort;
        NIESSID nIESSID = ((NISCSIHostPortID)nISCSIHostPortImpl.getID()).getESS();
        NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
        if (nIOlcDatabaseSchemaHelper == null) {
            return (NIConfigCreatedResult)c.failConfig(nISCSIHostPortImpl.getID(), nIEscrow, -1099689979L);
        }
        ArrayList arrayList = (ArrayList)nIOlcDatabaseSchemaHelper.getScsiHostPortsByWWPN(nIESSID, nISCSIHostPortImpl.getWWPN());
        if (arrayList.size() > 0) {
            l = -1099689966L;
        } else {
            int n = this._generatePortNumber(nIOlcDatabaseSchemaHelper, nIESSID);
            NISCSIHostPortID nISCSIHostPortID = new NISCSIHostPortID(nIESSID, n);
            nISCSIHostPortImpl.setID(nISCSIHostPortID);
            if (nISCSIHostPortImpl.getPortMask() == null) {
                NIPortMask nIPortMask = new NIPortMask(nIESSID.getType());
                nIPortMask.setAllEnabled(true);
                nISCSIHostPortImpl.setPortMask(nIPortMask);
            }
            this.alEventsHolder.add(new NISCSIHostPortCreatedEventImpl(nISCSIHostPortImpl));
            if (bl &= (bl &= nIOlcDatabaseSchemaHelper.insertSCSIHostPort(nISCSIHostPortImpl)) ? nIOlcDatabaseSchemaHelper.commitXA() : nIOlcDatabaseSchemaHelper.cancelXA()) {
                NIOlcEventProcessor.processEvents(this.alEventsHolder);
            }
            this.alEventsHolder.clear();
        }
        nIOlcDatabaseSchemaHelper.release();
        NIConfigCreatedResult nIConfigCreatedResult = l != 1L ? (NIConfigCreatedResult)c.failConfig(nIHostPort.getID(), l) : (NIConfigCreatedResult)c.handleConfig(nIHostPort.getID(), bl);
        NIOlcLogger.exit(CLASS_NAME, "createHostPort");
        nIEscrow.close(nIConfigCreatedResult);
        return (NIConfigCreatedResult)((Object)nIEscrow.issueIou());
    }

    public NIConfigResult deleteHostPort(NIHostPortID nIHostPortID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIConfigResult nIConfigResult;
        NIOlcLogger.enter(CLASS_NAME, "deleteHostPort");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcHostConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        if (nIHostPortID == null || !(nIHostPortID instanceof NISCSIHostPortID)) {
            nIConfigResult = c.failConfig(nIHostPortID, 1L);
        } else {
            boolean bl = true;
            NIESSID nIESSID = nIHostPortID.getESS();
            NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
            if (nIOlcDatabaseSchemaHelper == null) {
                return c.failConfig(nIHostPortID, nIEscrow, -1099689979L);
            }
            List list = nIOlcDatabaseSchemaHelper.getScsiHostPortsByID(new NISCSIHostPortID[]{(NISCSIHostPortID)nIHostPortID});
            if (list.size() > 0) {
                bl = nIOlcDatabaseSchemaHelper.deleteScsiHostPort((NISCSIHostPortID)nIHostPortID);
                this.alEventsHolder.add(new NISCSIHostPortDeletedEventImpl((NISCSIHostPort)list.get(0)));
            }
            if (bl) {
                NIOlcEventProcessor.processEvents(this.alEventsHolder);
            }
            this.alEventsHolder.clear();
            nIOlcDatabaseSchemaHelper.release();
            nIConfigResult = c.handleConfig(nIHostPortID, bl);
        }
        NIOlcLogger.exit(CLASS_NAME, "deleteHostPort");
        nIEscrow.close(nIConfigResult);
        return (NIConfigResult)((Object)nIEscrow.issueIou());
    }

    public NIConfigResult modifyHostPort(NIHostPort nIHostPort) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIConfigResult nIConfigResult;
        NIOlcLogger.enter(CLASS_NAME, "modifyHostPort");
        NIEscrow nIEscrow = NIEscrowFactory.getRealIouEscrow(class$com$ibm$storage$ess$ni$application$results$NIConfigResult == null ? (class$com$ibm$storage$ess$ni$application$results$NIConfigResult = NIOlcHostConfigurationService.class$("com.ibm.storage.ess.ni.application.results.NIConfigResult")) : class$com$ibm$storage$ess$ni$application$results$NIConfigResult);
        if (!(nIHostPort instanceof NISCSIHostPort)) {
            nIConfigResult = c.failConfig(nIHostPort.getID(), 1L);
        } else {
            NISCSIHostPortImpl nISCSIHostPortImpl = (NISCSIHostPortImpl)nIHostPort;
            NISCSIHostPortImpl nISCSIHostPortImpl2 = (NISCSIHostPortImpl)nISCSIHostPortImpl.clone();
            NIESSID nIESSID = ((NISCSIHostPortID)nISCSIHostPortImpl2.getID()).getESS();
            NIOlcDatabaseSchemaHelper nIOlcDatabaseSchemaHelper = NIOlcCommon.getDatabaseHelper(nIESSID);
            if (nIOlcDatabaseSchemaHelper == null) {
                return c.failConfig(nIHostPort.getID(), nIEscrow, -1099689979L);
            }
            boolean bl = nIOlcDatabaseSchemaHelper.modifyScsiHostPort(nISCSIHostPortImpl2);
            this.alEventsHolder.add(new NISCSIHostPortChangedEventImpl(nISCSIHostPortImpl, nISCSIHostPortImpl2));
            if (bl) {
                NIOlcEventProcessor.processEvents(this.alEventsHolder);
            }
            this.alEventsHolder.clear();
            nIConfigResult = c.handleConfig(nIHostPort.getID(), bl);
            nIOlcDatabaseSchemaHelper.release();
        }
        NIOlcLogger.exit(CLASS_NAME, "modifyHostPort");
        nIEscrow.close(nIConfigResult);
        return (NIConfigResult)((Object)nIEscrow.issueIou());
    }

    public NIQueryUnknownWWPNResult queryUnknownWWPNs(NIESSID nIESSID, int n, int n2) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        NIOlcLogger.enter(CLASS_NAME, "queryUnknownWWPNs");
        NIQueryUnknownWWPNResultImpl nIQueryUnknownWWPNResultImpl = new NIQueryUnknownWWPNResultImpl(0, 0, true, new NILoginDescriptor[0], true, 0);
        NIOlcLogger.exit(CLASS_NAME, "queryUnknownWWPNs");
        return nIQueryUnknownWWPNResultImpl;
    }

    public NIConfigCreatedResult createHost(NIHost nIHost) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("This feature is not supported by the OLC");
    }

    public NIConfigResult deleteHost(NIHost nIHost) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("This feature is not supported by the OLC");
    }

    public NIConfigResult modifyHost(NIHost nIHost) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("This feature is not supported by the OLC");
    }

    public NIConfigQueryResult getHosts(NIESSID nIESSID) throws NIUnavailableServerException, NIServerException, NIUnsupportedException, NIUnauthorizedServerException {
        throw new NIUnsupportedException("This feature is not supported by the OLC");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

