/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.resource;

import com.ibm.storage.ess.ni.application.resource.NIUserAccount;
import com.ibm.storage.ess.ni.resource.NIResourceImpl;
import java.util.Date;
import java.util.Vector;

public class NIUserAccountImpl
extends NIResourceImpl
implements NIUserAccount,
Comparable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String password;
    private Vector previousPwds;
    private boolean passwordExpired;
    private int failedLogins;
    private Date lastAuthentication;
    private Date lastPasswordChange;
    private Vector userGroups;
    private boolean accountLocked;

    public NIUserAccountImpl(String string, String string2) {
        this(string, string2, null);
    }

    public NIUserAccountImpl(String string, String string2, String[] stringArray) {
        this.name = string;
        this.password = string2;
        this.failedLogins = 0;
        this.setUserGroups(stringArray);
        this.lastAuthentication = new Date();
        this.previousPwds = new Vector(4);
        this.setPassword(string2);
        this.accountLocked = false;
        this.passwordExpired = true;
    }

    public Date getLastAuthenticatedDate() {
        return (Date)this.lastAuthentication.clone();
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public int getNumFailedLogins() {
        return this.failedLogins;
    }

    public Date getPasswordChangedDate() {
        return (Date)this.lastPasswordChange.clone();
    }

    public String[] getUserGroups() {
        String[] stringArray = new String[this.userGroups.size()];
        this.userGroups.toArray(stringArray);
        return stringArray;
    }

    public boolean isAccountLocked() {
        return this.accountLocked;
    }

    public boolean isNewAccount() {
        return this.previousPwds.size() == 1;
    }

    public void setAccountLocked(boolean bl) {
        this.addChangedMethod("setAccountLocked");
        this.accountLocked = bl;
    }

    public void setName(String string) {
        this.addChangedMethod("setName");
        this.name = string;
    }

    public void setLastAuthenticatedDate(Date date) {
        this.addChangedMethod("setLastAuthenticatedDate");
        this.lastAuthentication = (Date)date.clone();
    }

    public void setNumFailedLogins(int n) {
        this.addChangedMethod("setNumFailedLogins");
        this.failedLogins = n;
    }

    public void setPassword(String string) {
        this.addChangedMethod("setPassword");
        this.password = string;
        if (this.previousPwds.size() == 4) {
            this.previousPwds.removeElementAt(0);
        }
        this.previousPwds.add(string);
        this.lastPasswordChange = new Date();
        this.passwordExpired = false;
    }

    public boolean isPasswordNew(String string) {
        boolean bl = true;
        int n = 0;
        while (n < this.previousPwds.size()) {
            bl &= !string.equals(this.previousPwds.elementAt(n));
            ++n;
        }
        return bl;
    }

    public boolean isPasswordExpired() {
        return this.passwordExpired;
    }

    public void setPasswordExpired() {
        this.addChangedMethod("setPasswordExpired");
        this.passwordExpired = true;
    }

    public void setUserGroups(String[] stringArray) {
        this.addChangedMethod("setUserGroups");
        this.userGroups = new Vector();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.addUserGroup(stringArray[n]);
                ++n;
            }
        } else {
            this.addUserGroup("Default");
        }
    }

    public boolean addUserGroup(String string) {
        boolean bl = false;
        if (!this.userGroups.contains(string)) {
            bl = true;
            this.userGroups.add(string);
            if (this.userGroups.size() > 1) {
                this.userGroups.remove("Default");
            }
        }
        return bl;
    }

    public boolean removeUserGroup(String string) {
        boolean bl = this.userGroups.remove(string);
        if (this.userGroups.size() == 0) {
            this.addUserGroup("Default");
        }
        return bl;
    }

    public int compareTo(Object object) {
        int n = object == null || !this.getClass().isInstance(object) ? -1 : this.name.compareTo(((NIUserAccount)object).getName());
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NIUserAccount: [");
        stringBuffer.append("name = " + this.name + ", ");
        stringBuffer.append("password = ******, ");
        stringBuffer.append("previousPwds = ******, ");
        stringBuffer.append("passwordExpired = " + this.passwordExpired + ", ");
        stringBuffer.append("failedLogins = " + this.failedLogins + ", ");
        stringBuffer.append("lastAuthentication = " + this.lastAuthentication + ", ");
        stringBuffer.append("lastPasswordChange = " + this.lastPasswordChange + ", ");
        stringBuffer.append("userGroups = " + this.userGroups + ", ");
        stringBuffer.append("accountLocked = " + this.accountLocked + "]");
        return stringBuffer.toString();
    }

    public Object clone() {
        NIUserAccountImpl nIUserAccountImpl = new NIUserAccountImpl(this.name, this.password, null);
        nIUserAccountImpl.name = this.name;
        nIUserAccountImpl.password = this.password;
        nIUserAccountImpl.previousPwds = this.previousPwds != null ? (Vector)this.previousPwds.clone() : null;
        nIUserAccountImpl.passwordExpired = this.passwordExpired;
        nIUserAccountImpl.failedLogins = this.failedLogins;
        nIUserAccountImpl.lastAuthentication = this.lastAuthentication != null ? (Date)this.lastAuthentication.clone() : null;
        nIUserAccountImpl.lastPasswordChange = this.lastAuthentication != null ? (Date)this.lastPasswordChange.clone() : null;
        nIUserAccountImpl.userGroups = this.userGroups != null ? (Vector)this.userGroups.clone() : null;
        nIUserAccountImpl.accountLocked = this.accountLocked;
        return nIUserAccountImpl;
    }
}

